/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.SiteMember;
import com.trs.components.wcm.content.persistent.SiteMembers;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class SiteMemberMgr {
    public void addSiteUser(WebSite webSite, User user) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(user, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label2", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        this.addSiteMember(webSite.getId(), user.getWCMType(), user.getId());
    }

    public void removeSiteUser(WebSite webSite, User user) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(user, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label2", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        this.removeSiteMember(webSite.getId(), user.getWCMType(), user.getId());
    }

    public void addSiteGroup(WebSite webSite, Group group) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(group, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u7ec4\u65e0\u6548!"));
        this.addSiteMember(webSite.getId(), group.getWCMType(), group.getId());
    }

    public void removeSiteGroup(WebSite webSite, Group group) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        this.assertNotNull(group, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u7ec4\u65e0\u6548!"));
        this.removeSiteMember(webSite.getId(), group.getWCMType(), group.getId());
    }

    public WebSites getUserSites(User user, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(user, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label4", "\u5f53\u524d\u7528\u6237\u65e0\u6548,\u65e0\u6cd5\u83b7\u53d6\u5176\u6240\u5728\u7ad9\u70b9\u96c6\u5408!"));
        String string = "Status=0";
        if (!user.isAdministrator()) {
            string = string + " and (CrUser='" + CMyString.filterForSQL(user.getName()) + "' OR " + this.getSelectSiteWhere(user) + ")";
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.mergeWith(wCMFilter);
        return WebSites.openWCMObjs(user, wCMFilter2);
    }

    private String getSelectSiteWhere(User user) throws WCMException {
        int n = user.getId();
        String string = "(ObjType=204 and ObjId=" + n + ")";
        String string2 = "Exists(\tselect b.SiteId from WCMSiteUser b where \t(" + string + "\t  or" + "\t  (ObjType=" + 203 + " and ObjId=2)" + "\t  or" + "\t  (ObjType=" + 203 + " and Exists(select UserId from WCMRoleUser where UserId=" + n + " and RoleId=b.ObjId))";
        Groups groups = user.getGroups();
        if (groups != null && !groups.isEmpty()) {
            int n2 = groups.size();
            for (int i = 0; i < n2; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                for (Group group2 = group.getParent(); group2 != null && groups.indexOf(group2.getId()) < 0; group2 = group2.getParent()) {
                    groups.addElement(group2.getId());
                }
            }
            string2 = string2 + " or (b.ObjType=201 and b.ObjId in(" + groups.getIdListAsString() + "))";
        }
        string2 = string2 + ")";
        return string2 + " and b.SiteId=WCMWebSite.SiteId )";
    }

    public Users getSiteUsers(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String string = "ISDELETED=0 AND EXISTS(SELECT ObjId FROM WCMsiteUser WHERE SiteId=? AND ObjType=204 AND WCMUser.UserId=WCMsiteUser.ObjId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.addSearchValues(webSite.getId());
        wCMFilter2.mergeWith(wCMFilter);
        Users users = new Users(this.getLoginUser());
        users.open(wCMFilter2);
        User user = null;
        int n = users.size();
        for (int i = 0; i < n; ++i) {
            user = (User)users.getAt(i);
            if (user != null && user.getName().indexOf("$") == -1) continue;
            users.remove(user, false);
        }
        return users;
    }

    public boolean isVisible(User user, WebSite webSite) throws WCMException {
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(webSite.getCrUserName())) {
            return true;
        }
        String string = "SiteId=? and " + this.getSelectSiteWhere(user);
        WCMFilter wCMFilter = new WCMFilter("WCMWEBSITE", string, "", "SiteId");
        wCMFilter.addSearchValues(webSite.getId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public boolean isVisible(CMSObj cMSObj, WebSite webSite) throws WCMException {
        if (cMSObj instanceof User) {
            return this.isVisible((User)cMSObj, webSite);
        }
        if (cMSObj instanceof Group) {
            return this.isBelongToSite((Group)cMSObj, webSite);
        }
        return this.isBelongToSite(cMSObj, webSite);
    }

    public boolean isBelongToSite(User user, WebSite webSite) throws WCMException {
        if (user == null || webSite == null) {
            return false;
        }
        return this.getSiteUser(webSite.getId(), user.getId(), user.getWCMType()) != null;
    }

    public boolean isBelongToSite(Group group, WebSite webSite) throws WCMException {
        boolean bl;
        if (group == null || webSite == null) {
            return false;
        }
        boolean bl2 = bl = this.getSiteUser(webSite.getId(), group.getId(), group.getWCMType()) != null;
        if (bl) {
            return true;
        }
        return this.isBelongToSite(group.getParent(), webSite);
    }

    public boolean isBelongToSite(Role role, WebSite webSite) throws WCMException {
        if (role == null || webSite == null) {
            return false;
        }
        return this.getSiteUser(webSite.getId(), role.getId(), role.getWCMType()) != null;
    }

    public boolean isBelongToSite(CMSObj cMSObj, WebSite webSite) throws WCMException {
        if (cMSObj == null || webSite == null) {
            return false;
        }
        return this.getSiteUser(webSite.getId(), cMSObj.getId(), cMSObj.getWCMType()) != null;
    }

    public Groups getSiteGroups(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String string = "EXISTS(SELECT ObjId FROM WCMSiteUser WHERE SiteId=" + webSite.getId() + " AND ObjType=" + 201 + " AND WCMGroup.GroupId=WCMSiteUser.ObjId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.mergeWith(wCMFilter);
        return Groups.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public Roles getSiteRoles(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(webSite, I18NMessage.get(SiteMemberMgr.class, "SiteMemberMgr.label1", "\u6307\u5b9a\u7684\u7ad9\u70b9\u65e0\u6548!"));
        String string = "EXISTS(SELECT ObjId FROM WCMSiteUser WHERE SiteId=? AND ObjType=203 AND WCMRole.RoleId=WCMSiteUser.ObjId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.addSearchValues(0, webSite.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Roles.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public void addSiteMember(int n, int n2, int n3) throws WCMException {
        SiteMember siteMember = this.getSiteUser(n, n3, n2);
        if (siteMember != null) {
            return;
        }
        siteMember = SiteMember.createNewInstance();
        siteMember.setSiteId(n);
        siteMember.setObjId(n3);
        siteMember.setObjType(n2);
        siteMember.save(this.getLoginUser());
    }

    public void removeSiteMember(int n, int n2, int n3) throws WCMException {
        SiteMember siteMember = this.getSiteUser(n, n3, n2);
        if (siteMember == null) {
            return;
        }
        siteMember.delete(this.getLoginUser());
    }

    private SiteMember getSiteUser(int n, int n2, int n3) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer("SITEID=");
        stringBuffer.append(n);
        stringBuffer.append(" AND ObjId=");
        stringBuffer.append(n2);
        stringBuffer.append(" AND ObjType=");
        stringBuffer.append(n3);
        WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "");
        wCMFilter.setMaxRowNumber(1);
        SiteMembers siteMembers = SiteMembers.openWCMObjs(this.getLoginUser(), wCMFilter);
        return !siteMembers.isEmpty() ? (SiteMember)siteMembers.getAt(0) : null;
    }

    private void assertNotNull(Object object, String string) throws WCMException {
        if (object == null) {
            throw new WCMException(10, string);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    SiteMembers getSiteMembers(int n, int n2) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SiteId=" + n + " AND ObjType=" + n2, "");
        return SiteMembers.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    public WebSites getWebSites(int n, int n2, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            string = "SiteOrder Desc";
        }
        WCMFilter wCMFilter = new WCMFilter("", "", string);
        if (!this.isAdmin(n, n2)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("exists(select 1 from ");
            stringBuffer.append("WCMSITEUSER");
            stringBuffer.append(" where objId=? and objType=?");
            stringBuffer.append(" and ");
            stringBuffer.append("WCMSITEUSER").append(".siteId");
            stringBuffer.append(" = ");
            stringBuffer.append("WCMWEBSITE").append(".siteId");
            stringBuffer.append(")");
            wCMFilter.setWhere(stringBuffer.toString());
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n);
            if (n == 204) {
                stringBuffer.append(" or exists(select 1 from ");
                stringBuffer.append("WCMSITEUSER");
                stringBuffer.append(" where objType=?");
                stringBuffer.append(" and objId in ");
                stringBuffer.append("(select groupid from WCMGrpUser where UserId=?)");
                stringBuffer.append(" and ");
                stringBuffer.append("WCMSITEUSER").append(".siteId");
                stringBuffer.append(" = ");
                stringBuffer.append("WCMWEBSITE").append(".siteId");
                stringBuffer.append(")");
                wCMFilter.addSearchValues(201);
                wCMFilter.addSearchValues(n2);
                stringBuffer.append(" or exists(select 1 from ");
                stringBuffer.append("WCMSITEUSER");
                stringBuffer.append(" where objType=?");
                stringBuffer.append(" and objId in ");
                stringBuffer.append("(select roleId from WCMRoleUser where UserId=?)");
                stringBuffer.append(" and ");
                stringBuffer.append("WCMSITEUSER").append(".siteId");
                stringBuffer.append(" = ");
                stringBuffer.append("WCMWEBSITE").append(".siteId");
                stringBuffer.append(")");
                wCMFilter.addSearchValues(203);
                wCMFilter.addSearchValues(n2);
            }
            wCMFilter.setWhere(stringBuffer.toString());
        }
        return WebSites.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private boolean isAdmin(int n, int n2) throws WCMException {
        switch (n) {
            case 203: {
                return n2 == 1;
            }
            case 204: {
                User user = User.findById(n2);
                return user != null && user.isAdministrator();
            }
        }
        return false;
    }
}

