/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.IContentSynMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ContentSynMgr
implements IContentSynMgr,
IObjectLCListenerOnAdd {
    private static Logger logger = Logger.getLogger(ContentSynMgr.class);
    private DocumentMgr m_currDocumentMgr = null;

    public void synContent(String string, Document document) throws WCMException {
        this.synContent(string, document, true);
    }

    public void synContent(String string, Document document, boolean bl) throws WCMException {
        int n = document.getChannelId();
        if (n <= 0) {
            return;
        }
        Channel channel = document.getChannel();
        if (channel == null) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("", "SRCCHANNEL=?", "");
        wCMFilter.addSearchValues(n);
        ChannelSyns channelSyns = ChannelSyns.openWCMObjs(null, wCMFilter);
        if (channelSyns.isEmpty()) {
            return;
        }
        string = string.toUpperCase();
        int n2 = channelSyns.size();
        for (int i = 0; i < n2; ++i) {
            ChannelSyn channelSyn = (ChannelSyn)channelSyns.getAt(i);
            this.synContent(string, channel, document, channelSyn, bl);
        }
    }

    private void synContent(String string, Channel channel, Document document, ChannelSyn channelSyn, boolean bl) throws WCMException {
        String string2;
        logger.debug((Object)("do syn[" + document + "] ...."));
        if (channelSyn == null) {
            return;
        }
        logger.debug((Object)("to channel[ID=" + channelSyn.getToChannelId() + "]"));
        CMyDateTime cMyDateTime = CMyDateTime.now();
        if (channelSyn.getStartTime().compareTo(cMyDateTime) > 0L || channelSyn.getEndTime().compareTo(cMyDateTime) < 0L) {
            return;
        }
        logger.debug((Object)"synContent.1");
        if (channelSyn.getDocStartTime().compareTo(document.getCrTime()) > 0L) {
            return;
        }
        logger.debug((Object)"synContent.2");
        String string3 = channelSyn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        string = string.toUpperCase();
        if (("," + string3 + ",").indexOf("," + string + ",") < 0) {
            return;
        }
        logger.debug((Object)"synContent.3");
        Channel channel2 = channelSyn.getToChannel();
        if (channel2 == null || channel2.isDeleted()) {
            return;
        }
        logger.debug((Object)"synContent.4");
        if (string.equals("MODIFY")) {
            string2 = channelSyn.getStatusIds();
            if (("," + string2 + ",").indexOf("," + document.getStatusId() + ",") < 0) {
                return;
            }
        }
        string2 = channelSyn.getWhereSql();
        if (!this.isMeetWith(document.getId(), string2)) {
            return;
        }
        int n = channelSyn.getTransmitType();
        Document document2 = this.transmitDocument(document, channel, channel2, n);
        if (!bl && this.isDoPublish(channelSyn, string)) {
            this.publishNewContent(channel2, document2);
        }
    }

    private void recordTransmited(int n, int n2) throws WCMException {
        DocumentSyn documentSyn = new DocumentSyn();
        documentSyn.setChannelId(n);
        documentSyn.setDocumentId(n2);
        documentSyn.insert();
    }

    private DocumentMgr getDocumentMgr() {
        if (this.m_currDocumentMgr != null) {
            return this.m_currDocumentMgr;
        }
        this.m_currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return this.m_currDocumentMgr;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        logger.debug((Object)("do syn[Type=" + baseObj.getWCMType() + "]......"));
        try {
            switch (baseObj.getWCMType()) {
                case 605: {
                    Document document = (Document)baseObj;
                    if (document.getStatusId() == 1028) {
                        return;
                    }
                    logger.debug((Object)("KindeId=" + document.getKindId()));
                    if (document.getKindId() == 0) {
                        this.synContent("NEW", document);
                    }
                    break;
                }
                default: {
                    if (baseObj instanceof CMSObjDefaultImpl && baseObj.getDbTableName().startsWith("WCMMetaTable")) {
                        this.synContent("NEW", (CMSObjDefaultImpl)baseObj);
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"Fail to syn content", throwable);
        }
    }

    public void synContent(String string, CMSObjDefaultImpl cMSObjDefaultImpl) throws WCMException {
        int n = cMSObjDefaultImpl.getPropertyAsInt("MetaDataId", 0);
        Document document = Document.findById(n, "DocId,DocStatus,DocType,DocKind,DocChannel,CrUser,CrTime,SiteId,DocRelTime,SrcSiteId,CRDEPT,DocVersion");
        if (document.getStatusId() == 1028) {
            return;
        }
        int n2 = cMSObjDefaultImpl.getPropertyAsInt("ChannelId", 0);
        if (n2 <= 0) {
            return;
        }
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("", "SRCCHANNEL=?", "");
        wCMFilter.addSearchValues(n2);
        ChannelSyns channelSyns = ChannelSyns.openWCMObjs(null, wCMFilter);
        if (channelSyns.isEmpty()) {
            return;
        }
        string = string.toUpperCase();
        int n3 = channelSyns.size();
        for (int i = 0; i < n3; ++i) {
            ChannelSyn channelSyn = (ChannelSyn)channelSyns.getAt(i);
            this.synContent(string, channel, cMSObjDefaultImpl, document, channelSyn);
        }
    }

    private void synContent(String string, Channel channel, CMSObjDefaultImpl cMSObjDefaultImpl, Document document, ChannelSyn channelSyn) throws WCMException {
        String string2;
        if (channelSyn == null) {
            return;
        }
        CMyDateTime cMyDateTime = CMyDateTime.now();
        if (channelSyn.getStartTime().compareTo(cMyDateTime) > 0L || channelSyn.getEndTime().compareTo(cMyDateTime) < 0L) {
            return;
        }
        if (channelSyn.getDocStartTime().compareTo(cMSObjDefaultImpl.getCrTime()) > 0L) {
            return;
        }
        String string3 = channelSyn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        string = string.toUpperCase();
        if (("," + string3 + ",").indexOf("," + string + ",") < 0) {
            return;
        }
        Channel channel2 = channelSyn.getToChannel();
        if (channel2 == null || channel2.isDeleted()) {
            return;
        }
        if (string.equals("MODIFY")) {
            string2 = channelSyn.getStatusIds();
            if (("," + string2 + ",").indexOf("," + document.getStatusId() + ",") < 0) {
                return;
            }
        }
        string2 = channelSyn.getWhereSql();
        if (!this.isMeetWith(document.getId(), string2)) {
            return;
        }
        int n = channelSyn.getTransmitType();
        Document document2 = this.transmitDocument(document, channel, channel2, n);
        if (this.isDoPublish(channelSyn, string)) {
            this.publishNewContent(channel2, document2);
        }
    }

    private void publishNewContent(Channel channel, Document document) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, iPublishFolder);
        boolean bl = false;
        try {
            bl = iPublishContent.validateCanDoPub();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            PublishServer.getInstance().publishContent(iPublishContent, 3);
        } else {
            logger.warn((Object)"Failed to publish on content syn.");
        }
    }

    private boolean isDoPublish(ChannelSyn channelSyn, String string) {
        if (!string.equals("PUBLISH")) {
            return false;
        }
        int n = channelSyn.getPropertyAsInt("OperAfter", 0);
        CMyBitsValue cMyBitsValue = new CMyBitsValue(n);
        return cMyBitsValue.getBit(0);
    }

    private Document copyMetaViewData(int n, Document document, Channel channel) throws WCMException {
        MetaViewData metaViewData = MetaViewData.findById(n);
        return this.copyMetaViewData(metaViewData, document, channel);
    }

    private Document copyMetaViewData(MetaViewData metaViewData, Document document, Channel channel) throws WCMException {
        boolean bl;
        Object object;
        Object object2;
        User user = ContextHelper.getLoginUser();
        int n = metaViewData.getMetaDataId();
        MetaViewData metaViewData2 = (MetaViewData)metaViewData.cloneToNewObj();
        MetaView metaView = metaViewData.getMetaView();
        metaViewData2.setMetaView(metaView);
        metaViewData2.setProperty("channelId", channel.getId());
        if (metaView.isMultiTable()) {
            Object object3;
            Object object4;
            object2 = "WCMMetaRelation" + metaView.getId();
            object = new CMSObjDefaultImpl((String)object2, "MetaDataId");
            boolean bl2 = ((BaseObj)object).loadById(n, null);
            if (bl2) {
                object4 = ((BaseObj)object).getProperties().keys();
                while (object4.hasMoreElements()) {
                    object3 = (String)object4.nextElement();
                    if (!((String)object3).startsWith("WCMMetaTable".toUpperCase())) continue;
                    metaViewData2.setProperty((String)object3, ((BaseObj)object).getProperty((String)object3));
                }
            }
            object4 = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            object3 = object4.getMetaViewFields(metaView.getId());
            for (MetaViewField metaViewField : ((HashMap)object3).values()) {
                if (metaViewField == null || metaViewField.isFromMainTable()) continue;
                metaViewData2.removeProperty(metaViewField.getName());
            }
        }
        metaViewData2.save(user);
        object2 = Document.findById(metaViewData2.getId(), "DocId,DocStatus,DocType,DocKind,DocChannel,DocVersion, CrUser,CrTime,SiteId");
        if (object2 != null && (bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false")))) {
            WCMProcessServiceHelper.startDocumentInFlow(user, (Document)object2, true);
        }
        if (metaViewData.getId() != metaViewData2.getId()) {
            object = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            ((AppendixMgr)object).copyAppendixes(document, (Document)object2);
        }
        return object2;
    }

    public void synContent(String string, MetaViewData metaViewData) throws WCMException {
        logger.debug((Object)"synContent.MetaViewData.1");
        Document document = metaViewData.getDocument();
        if (document.getStatusId() == 1028) {
            return;
        }
        int n = metaViewData.getChannelId();
        if (n <= 0) {
            return;
        }
        Channel channel = Channel.findById(n);
        if (channel == null) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.2");
        WCMFilter wCMFilter = new WCMFilter("", "SRCCHANNEL=?", "");
        wCMFilter.addSearchValues(n);
        ChannelSyns channelSyns = ChannelSyns.openWCMObjs(null, wCMFilter);
        if (channelSyns.isEmpty()) {
            return;
        }
        string = string.toUpperCase();
        int n2 = channelSyns.size();
        for (int i = 0; i < n2; ++i) {
            ChannelSyn channelSyn = (ChannelSyn)channelSyns.getAt(i);
            this.synContent(string, channel, metaViewData, document, channelSyn);
        }
    }

    private void synContent(String string, Channel channel, MetaViewData metaViewData, Document document, ChannelSyn channelSyn) throws WCMException {
        String string2;
        if (channelSyn == null) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.1");
        CMyDateTime cMyDateTime = CMyDateTime.now();
        if (channelSyn.getStartTime().compareTo(cMyDateTime) > 0L || channelSyn.getEndTime().compareTo(cMyDateTime) < 0L) {
            return;
        }
        if (channelSyn.getDocStartTime().compareTo(metaViewData.getCrTime()) > 0L) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.2");
        String string3 = channelSyn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        string = string.toUpperCase();
        if (("," + string3 + ",").indexOf("," + string + ",") < 0) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.3");
        Channel channel2 = channelSyn.getToChannel();
        if (channel2 == null || channel2.isDeleted()) {
            return;
        }
        int n = metaViewData.getPropertyAsInt("MetaDataId", 0);
        if (string.equals("MODIFY")) {
            string2 = channelSyn.getStatusIds();
            if (("," + string2 + ",").indexOf("," + document.getStatusId() + ",") < 0) {
                return;
            }
        }
        logger.debug((Object)"synContent.MetaViewData.syn.4");
        if (DocumentSyn.isSyned(channel2.getId(), n)) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.5");
        string2 = channelSyn.getWhereSql();
        if (!this.isMeetWith(n, string2)) {
            return;
        }
        DocumentMgr documentMgr = this.getDocumentMgr();
        Document document2 = document;
        int n2 = channelSyn.getTransmitType();
        switch (n2) {
            case 1: {
                document2 = this.copyMetaViewData(metaViewData, document, channel2);
                break;
            }
            case 2: {
                documentMgr.quoteTo(document, channel2);
                break;
            }
            case 3: {
                documentMgr.mirrorTo(document, channel2);
                break;
            }
            default: {
                logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + n2 + "]!"));
            }
        }
        logger.debug((Object)"synContent.MetaViewData.syn.6");
        if (this.isDoPublish(channelSyn, string)) {
            this.publishNewContent(channel2, document2);
        }
        logger.debug((Object)"synContent.MetaViewData.syn.7");
        this.recordTransmited(channel2.getId(), metaViewData.getMetaDataId());
    }

    private boolean isMeetWith(int n, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return true;
        }
        String string2 = "select 1 from WCMDocument where DocId=? and (" + string + ")";
        int n2 = DBManager.getDBManager().sqlExecuteIntQuery(string2, new int[]{n});
        return n2 == 1;
    }

    public void synContent(ChannelSyn channelSyn) throws WCMException {
        Channel channel = channelSyn.getSrcChannel();
        if (channel == null) {
            throw new WCMException("\u88ab\u540c\u6b65\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[\u680f\u76eeID=" + channelSyn.getSrcChannelId() + "]");
        }
        Channel channel2 = channelSyn.getToChannel();
        if (channel2 == null) {
            throw new WCMException("\u540c\u6b65\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01[\u680f\u76eeID=" + channelSyn.getToChannelId() + "]");
        }
        if (channel2.isDeleted()) {
            return;
        }
        CMyDateTime cMyDateTime = channelSyn.getDocStartTime();
        String string = channelSyn.getPropertyAsString("SynTypes", "NEW,").toUpperCase();
        String string2 = null;
        string2 = ("," + string + ",").indexOf("," + "MODIFY".toUpperCase() + ",") >= 0 ? channelSyn.getStatusIds() : (string.equals("PUBLISH".toUpperCase()) ? String.valueOf(10) : null);
        String string3 = channelSyn.getWhereSql();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("DocChannel=? and Modal=1 and CrTime>=? and ");
        if (CMyString.isEmpty(string2)) {
            stringBuffer.append("DocStatus>=1");
        } else {
            stringBuffer.append("DocStatus in (");
            stringBuffer.append(string2);
            stringBuffer.append(')');
        }
        stringBuffer.append(" and not exists(select 1 from WCMDOCSYN t where ");
        stringBuffer.append("t.ChnlId=? and t.DocId=WCMCHNLDOC.DocId)");
        if (!CMyString.isEmpty(string3)) {
            stringBuffer.append(" and (");
            stringBuffer.append(string3);
            stringBuffer.append(')');
        }
        WCMFilter wCMFilter = new WCMFilter("WCMCHNLDOC", "", "");
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.addSearchValues(channel.getId());
        wCMFilter.addSearchValues(cMyDateTime);
        wCMFilter.addSearchValues(channel2.getId());
        String string4 = "DocOrder desc";
        wCMFilter.setOrder(string4);
        wCMFilter.setSelect("RECID,DOCID");
        ChnlDocs chnlDocs = new ChnlDocs(null);
        chnlDocs.open(wCMFilter);
        if (chnlDocs.isEmpty()) {
            return;
        }
        int n = chnlDocs.size();
        int n2 = channelSyn.getTransmitType();
        String string5 = n2 == 1 ? "*" : "DOCID,DocTitle,DocType,DocKeyWords,DocStatus,DocKind,DocChannel,SiteId,SrcSiteId,CrDept,DocPeople,DocRelTime, DocSource,DocSourceName,CrUser,CrTime,ATTACHPIC";
        for (int i = n - 1; i >= 0; --i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) continue;
            int n3 = chnlDoc.getDocId();
            Document document = Document.findById(n3, string5);
            this.transmitDocument(document, channel, channel2, n2);
        }
    }

    private Document transmitDocument(Document document, Channel channel, Channel channel2, int n) throws WCMException {
        logger.debug((Object)"transmitDocument.....");
        DocumentMgr documentMgr = this.getDocumentMgr();
        if (DocumentSyn.isSyned(channel2.getId(), document.getId())) {
            return document;
        }
        logger.debug((Object)"transmitDocument.1");
        logger.debug((Object)("[TransmitType=" + n + "]"));
        Report report = null;
        Document document2 = document;
        switch (n) {
            case 1: {
                if (document.getKindId() > 0) {
                    document2 = this.copyMetaViewData(document.getId(), document, channel2);
                    break;
                }
                document2 = documentMgr.copyDocument(document, channel, channel2);
                break;
            }
            case 2: {
                logger.debug((Object)"transmitDocument.2");
                report = documentMgr.quoteTo(document, channel2);
                logger.debug((Object)"transmitDocument.3");
                break;
            }
            case 3: {
                report = documentMgr.mirrorTo(document, channel2);
                break;
            }
            default: {
                logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + n + "]!"));
            }
        }
        if (report != null) {
            logger.debug((Object)report);
        }
        this.recordTransmited(channel2.getId(), document.getId());
        return document2;
    }
}

