/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class ChnlDocLCListenerForRecordNotEntity
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof ChnlDoc)) {
            return;
        }
        String string = ConfigServer.getServer().getSysConfigValue("RECORD_NOT_ENTITY", "false");
        if (string.equalsIgnoreCase("false")) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (chnlDoc.getModal() == 1) {
            return;
        }
        this.add(chnlDoc.getDocument(), chnlDoc);
    }

    private void add(Document document, ChnlDoc chnlDoc) throws WCMException {
        User user = ContextHelper.getLoginUser();
        Channel channel = chnlDoc.getChannel();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("{").append(user.getName());
        stringBuffer.append(":").append(channel.getId());
        stringBuffer.append(":").append(channel.getName());
        stringBuffer.append("}");
        boolean bl = chnlDoc.getModal() == 2;
        String string = bl ? "DOCLINKTO" : "DOCMIRRORTO";
        String string2 = CMyString.showNull(document.getPropertyAsString(string));
        String string3 = string2 + stringBuffer.toString();
        String string4 = "update WCMDOCUMENT set " + string + "=? where " + "DOCID" + "=?";
        Object[] objectArray = new Object[]{string3, new Integer(document.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{string4}, objectArray);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof ChnlDoc)) {
            return;
        }
        String string = ConfigServer.getServer().getSysConfigValue("RECORD_NOT_ENTITY", "false");
        if (string.equalsIgnoreCase("false")) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (chnlDoc.getModal() == 1) {
            return;
        }
        this.delete(chnlDoc.getDocument(), chnlDoc);
    }

    private void delete(Document document, ChnlDoc chnlDoc) throws WCMException {
        boolean bl = chnlDoc.getModal() == 2;
        String string = bl ? "DOCLINKTO" : "DOCMIRRORTO";
        String string2 = document.getPropertyAsString(string);
        if (CMyString.isEmpty(string2)) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        int n = chnlDoc.getChannelId();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\\{").append(user.getName());
        stringBuffer.append(":").append(n);
        stringBuffer.append("[^\\}]+\\}");
        string2 = string2.replaceAll(stringBuffer.toString(), "");
        String string3 = "update WCMDOCUMENT set " + string + "=? where " + "DOCID" + "=?";
        Object[] objectArray = new Object[]{string2, new Integer(document.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{string3}, objectArray);
    }
}

