/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ChannelServiceProviderHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.common.publish.persistent.template.TempApdRel;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.IChannelImporterConverter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChannelImporter {
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final String FILEEXT_ZIP = "zip";
    private static final String FILEEXT_XML = "xml";
    private static final char CHAR_S = 'S';
    private static final String TAG_TEMPAPDS = "WCMTEMPAPPENDIXS";
    private static final String TAG_TEMPLATES = "WCMTEMPLATES";
    private static final String TAG_TEMPAPDRELS = "WCMTEMPAPDRELS";
    private static final String TAG_TEMPEMPLOYS = "WCMTEMPLATEEMPLOYS";
    private static final String TAG_FOLDERPUBCONFS = "WCMFOLDERPUBLISHCONFIGS";
    private static final String TAG_WCMPUBSTATUSCONFS = "WCMPUBSTATUSCONFIGS";
    private static final String TAG_CHILDCHANNELS = "WCMCHANNELS";
    private static final String TAG_CONTEXTFIELDS = "WCMCONTENTEXTFIELDS";
    private static final String TAG_EXTFIELDS = "WCMEXTFIELDS";
    private static final String TAG_TEMPLATEARGS = "WCMTEMPLATEARGUMENTS";
    private static Logger s_logger = Logger.getLogger(ChannelImporter.class);
    private ChannelMgr m_channelMgr = null;
    private XmlToObjConverter m_converter = null;
    private Reports m_reports;
    private final Map m_siteOrChnlIds = new HashMap();
    private Map m_templateIds = null;
    private boolean m_bCheckDataPathNecessary = true;
    private String m_sNewSiteName = null;
    private String m_sNewSiteDesc = null;
    private Map m_hTemplateInChannelMap = new HashMap();
    private static List implementors = null;

    public String getNewSiteDesc() {
        return this.m_sNewSiteDesc;
    }

    public void setNewSiteDesc(String string) {
        this.m_sNewSiteDesc = string;
    }

    public ChannelImporter() {
        this.m_converter = new XmlToObjConverter(1);
        this.m_channelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        this.registerConverter();
    }

    public Reports importFromFile(String string, String string2, BaseChannel baseChannel) throws WCMException {
        this.assertNotEmptyString(string);
        String string3 = CMyFile.extractFileExt(string);
        this.assertUnSupportFile(string3);
        String string4 = this.getFullName(string);
        if (string2 != null) {
            string2 = this.getFullName(string2);
        }
        this.m_reports = new Reports("");
        if (FILEEXT_XML.equalsIgnoreCase(string3)) {
            return this.importFromXml(string4, string2, baseChannel);
        }
        return this.importFromZip(string4, string2, baseChannel);
    }

    private Reports importFromZip(String string, String string2, BaseChannel baseChannel) throws WCMException {
        String string3 = CMyFile.extractFilePath(string) + "unzip" + System.currentTimeMillis();
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string3);
        cMyUnZipFile.addFileExtFilters(FILEEXT_XML);
        try {
            cMyUnZipFile.doUnZipAnd();
        }
        catch (CMyException cMyException) {
            s_logger.error((Object)"failed to unzip the file!", (Throwable)cMyException);
            throw new WCMException(200, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label1", "\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25!"), cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        if (arrayList == null) {
            throw new WCMException(10, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label2", "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u7ad9\u70b9/\u680f\u76ee\u4fe1\u606f\u7684xml\u6587\u4ef6!"));
        }
        String string4 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string4 = (String)arrayList.get(i);
            XmlObject[] xmlObjectArray = this.convertXmlFile(string4, string2);
            this.importSitesOrChnls(xmlObjectArray, baseChannel, string3);
        }
        CMyFile.deleteDir(string3);
        this.m_reports.setTitle(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label3", "\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u7ad9\u70b9/\u680f\u76ee"));
        return this.m_reports;
    }

    private void importSitesOrChnls(XmlObject[] xmlObjectArray, BaseChannel baseChannel, String string) throws WCMException {
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.m_bCheckDataPathNecessary = true;
            BaseChannel baseChannel2 = this.importSiteOrChnlInfo(xmlObjectArray[i], baseChannel, string);
            if (baseChannel2 == null) continue;
            nArray[i] = baseChannel2.getId();
        }
        this.m_reports.setResultIds(nArray);
    }

    private BaseChannel importSiteOrChnlInfo(XmlObject xmlObject, BaseChannel baseChannel, String string) throws WCMException {
        Object object;
        int n;
        BaseObj baseObj = xmlObject.getCurrentObj();
        if (baseObj == null || !(baseObj instanceof BaseChannel)) {
            throw new WCMException(1100, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label4", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,xml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u63cf\u8ff0\u6587\u4ef6!"));
        }
        baseObj.getId();
        BaseChannel baseChannel2 = (BaseChannel)baseObj;
        boolean bl = baseChannel2.isSite();
        if (this.isUnSupportImportMode(bl, baseChannel)) {
            String string2 = bl ? I18NMessage.get(ChannelImporter.class, "ChannelImporter.label5", "\u65e0\u6cd5\u5c06\u7ad9\u70b9\u5bfc\u5165\u5230\u7ad9\u70b9\u6216\u8005\u680f\u76ee\u5e95\u4e0b!") : I18NMessage.get(ChannelImporter.class, "ChannelImporter.label6", "\u65e0\u6cd5\u5c06\u680f\u76ee\u5bfc\u5165\u6210\u7ad9\u70b9,\u5fc5\u987b\u6307\u5b9a\u7236\u8282\u70b9(\u680f\u76ee/\u7ad9\u70b9)!");
            WCMException wCMException = new WCMException(10, string2);
            this.addFailedReports(baseChannel2, wCMException);
            return null;
        }
        if (!bl && this.isExcludeSiteType(n = ((BaseObj)(object = baseChannel.getSite())).getPropertyAsInt("SiteType", 0)) && !this.isNormChannel((Channel)baseChannel2)) {
            String string3 = I18NMessage.get(ChannelImporter.class, "ChannelImporter.label7", "\u975e\u6587\u5b57\u5e93\u7ad9\u70b9[") + ((WebSite)object).getName() + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label8", "]\u4e0d\u652f\u6301[");
            string3 = string3 + ((Channel)baseChannel2).getTypeDesc();
            string3 = string3 + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label9", "]\u7c7b\u578b\u7684\u680f\u76ee\uff01");
            this.addFailedReports(baseChannel2, new WCMDatainvalidException(string3));
            return null;
        }
        try {
            baseChannel2.setNextId();
            this.changeNameIfNescessary(bl, baseChannel2, baseChannel);
        }
        catch (Throwable throwable) {
            this.addFailedReports(baseChannel2, throwable);
            return null;
        }
        if (!bl) {
            try {
                ((Channel)baseChannel2).setParent(baseChannel);
                ((Channel)baseChannel2).setSite(baseChannel.getSite());
                ((Channel)baseChannel2).setOrder(1);
            }
            catch (Throwable throwable) {
                this.addFailedReports(baseChannel2, throwable);
                return null;
            }
        } else {
            ((WebSite)baseChannel2).setOrder(1);
        }
        try {
            object = bl ? "SITEID" : "CHANNELID";
            String string4 = baseChannel2.getPropertyAsString((String)object);
            baseChannel2.removeProperty(PROPERTY_CRTIME);
            baseChannel2.removeProperty(PROPERTY_CRUSER);
            this.m_channelMgr.save(baseChannel2);
            this.m_siteOrChnlIds.put(this.makeSiteOrChnlIdMapKey(string4, baseChannel2.getWCMType()), new Integer(baseChannel2.getId()));
            ChannelServiceProviderHelper.createRelatedEmployes(string4, baseChannel2);
        }
        catch (Throwable throwable) {
            n = throwable instanceof Error && throwable.getMessage().indexOf(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label10", "\u6ce8\u518c\u7801")) >= 0 ? 1 : 0;
            this.addFailedReports(baseChannel2, n != 0 ? new Error(throwable.getMessage()) : throwable);
            return null;
        }
        this.importFolderPubConfs(xmlObject.getChild(TAG_FOLDERPUBCONFS), (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel2));
        PorterUtil.doImports(baseChannel2, xmlObject, null);
        if (bl && string != null) {
            object = this.importTempAppendixs(xmlObject.getChild(TAG_TEMPAPDS), string, baseChannel2.getSiteId());
            this.m_templateIds = this.importTemplates((Map)object, xmlObject.getChild(TAG_TEMPLATES), baseChannel2.getId());
        }
        this.importTemplateArgs(baseChannel2, xmlObject.getChild(TAG_TEMPLATEARGS));
        try {
            object = bl ? baseChannel2 : baseChannel2.getSite();
            this.importChildChannels(xmlObject.getChild(TAG_CHILDCHANNELS), baseChannel2, (BaseChannel)object);
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label11", "\u5bfc\u5165\u5b50\u680f\u76ee\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label12", "\u5bfc\u5165") + baseChannel2 + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label13", "\u7684\u5b50\u680f\u76ee\u5931\u8d25!"), throwable);
        }
        this.importTempEmploys(xmlObject.getChild(TAG_TEMPEMPLOYS), baseChannel2.getId(), this.m_templateIds);
        this.importChildChannelsTempEmploys(xmlObject.getChild(TAG_CHILDCHANNELS), this.m_templateIds);
        this.importPubStatusConfs(xmlObject.getChild(TAG_WCMPUBSTATUSCONFS), baseChannel2.getWCMType(), baseChannel2.getId());
        this.importContExtFields(xmlObject.getChild(TAG_CONTEXTFIELDS), baseChannel2);
        this.m_reports.addSucessedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label14", "\u6210\u529f\u5bfc\u5165[") + baseChannel2 + "].");
        return baseChannel2;
    }

    private boolean isExcludeSiteType(int n) {
        int[] nArray = new int[]{1, 2};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isNormChannel(Channel channel) {
        return channel.getType() == 0;
    }

    private String makeSiteOrChnlIdMapKey(String string, int n) {
        return n + ":" + string;
    }

    private boolean isUnSupportImportMode(boolean bl, BaseChannel baseChannel) {
        if (bl) {
            return baseChannel != null;
        }
        return baseChannel == null;
    }

    private Map importTempAppendixs(XmlObject[] xmlObjectArray, String string, int n) {
        HashMap hashMap = new HashMap(xmlObjectArray.length);
        String string2 = "";
        try {
            string2 = FilesMan.getFilesMan().getTemplateAppendixPath(103, n, 0, true);
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)"failed to get the template appendix directory!", throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label15", "\u83b7\u53d6\u6a21\u677f\u9644\u4ef6\u7684\u6587\u4ef6\u76ee\u5f55\u5931\u8d25\uff01"), throwable);
            return hashMap;
        }
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importTempApdInfo(hashMap, xmlObjectArray[i], string, string2, n);
        }
        return hashMap;
    }

    private void importTempApdInfo(Map map, XmlObject xmlObject, String string, String string2, int n) {
        TempAppendix tempAppendix = null;
        try {
            tempAppendix = (TempAppendix)xmlObject.getCurrentObj();
            String string3 = tempAppendix.getPropertyAsString("TEMPAPPENDIXID");
            tempAppendix.setRoot(103, n);
            tempAppendix.removeProperty(PROPERTY_CRTIME);
            tempAppendix.setFlag(0);
            tempAppendix.save(this.getLoginUser());
            map.put(string3, new Integer(tempAppendix.getId()));
            String string4 = string + tempAppendix.getFile();
            String string5 = string2 + tempAppendix.getFile();
            this.processApdFile(string4, string5);
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label16", "\u5bfc\u5165\u6a21\u677f\u9644\u4ef6\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label17", "\u5bfc\u5165\u6a21\u677f\u9644\u4ef6\u5931\u8d25:") + tempAppendix, throwable);
        }
    }

    private void processApdFile(String string, String string2) {
        try {
            if (!CMyFile.fileExists(string2)) {
                if (!CMyFile.fileExists(string)) {
                    String string3 = CMyFile.extractFileName(string);
                    s_logger.warn((Object)("missing template appendix file[" + string3 + "]!"));
                    this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label18", "\u7f3a\u5c11\u6a21\u677f\u9644\u4ef6[{0}]"), new String[]{string3}), null);
                    return;
                }
                CMyFile.copyFile(string, string2);
            }
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)"failed to copy a template appendix file", throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label19", "\u62f7\u8d1d\u6a21\u677f\u9644\u4ef6\u5bf9\u5e94\u7684\u6587\u4ef6[") + string + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), throwable);
        }
    }

    private Map importTemplates(Map map, XmlObject[] xmlObjectArray, int n) {
        HashMap hashMap = new HashMap(xmlObjectArray.length);
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importTemplateInfo(hashMap, xmlObjectArray[i], map, n);
        }
        this.parseImportedTemplates(hashMap.values());
        return hashMap;
    }

    private void parseImportedTemplates(Collection collection) {
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        Integer[] integerArray = new Integer[collection.size()];
        collection.toArray(integerArray);
        Template template = null;
        for (int i = 0; i < integerArray.length; ++i) {
            int n = integerArray[i];
            try {
                template = Template.findById(n);
            }
            catch (WCMException wCMException) {
                continue;
            }
            if (template == null) continue;
            templateParseMgr.notifyTemplateAdded(template);
        }
    }

    private void importTemplateInfo(Map map, XmlObject xmlObject, Map map2, int n) {
        Template template = null;
        try {
            template = (Template)xmlObject.getCurrentObj();
            int n2 = template.getFolderType();
            int n3 = template.getFolderId();
            String string = String.valueOf(n3);
            Integer n4 = (Integer)this.m_siteOrChnlIds.get(this.makeSiteOrChnlIdMapKey(string, n2));
            String string2 = template.getPropertyAsString("TEMPID");
            if (n4 != null) {
                n3 = n4;
            } else {
                if (n2 == 101) {
                    ArrayList<String> arrayList = (ArrayList<String>)this.m_hTemplateInChannelMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        this.m_hTemplateInChannelMap.put(string, arrayList);
                    }
                    arrayList.add(string2);
                }
                n3 = n;
                n2 = 103;
            }
            template.setFolder(n2, n3, 103, n);
            template.removeProperty(PROPERTY_CRTIME);
            template.removeProperty(PROPERTY_CRUSER);
            template.setParsed(false);
            template.setApdModified(true);
            this.processContent(template);
            template.save(this.getLoginUser());
            int n5 = template.getId();
            map.put(string2, new Integer(n5));
            this.importTempApdRels(xmlObject.getChild(TAG_TEMPAPDRELS), n5, map2);
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label21", "\u5bfc\u5165\u6a21\u677f\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label22", "\u5bfc\u5165\u6a21\u677f\u5931\u8d25:") + template, throwable);
        }
    }

    private void processContent(Template template) throws WCMException {
        String[] stringArray;
        String string = template.getText();
        String[] stringArray2 = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        int n = stringArray2.length > (stringArray = PublishServerConfigMapper.getTemplateTagSrcAttributeNames()).length ? stringArray.length : stringArray2.length;
        HtmlElementFinder htmlElementFinder = null;
        for (int i = 0; i < n; ++i) {
            HtmlElement htmlElement = null;
            String string2 = stringArray2[i];
            String string3 = stringArray[i];
            String string4 = null;
            htmlElementFinder = new HtmlElementFinder(string);
            while ((htmlElement = htmlElementFinder.findNextElement(string2, true)) != null) {
                string4 = htmlElement.getAttributeValue(string3);
                if (!CMyString.isEmpty(string4)) {
                    htmlElement.removeAttribute("OLDID");
                    if (htmlElement.removeAttribute("RELATED")) {
                        htmlElement.setAttribute(string3, CMyFile.extractFileName(string4, "/"));
                    }
                }
                htmlElementFinder.putElement(htmlElement);
            }
            string = htmlElementFinder.getContent();
        }
        template.setText(string);
    }

    private void importTempApdRels(XmlObject[] xmlObjectArray, int n, Map map) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importTempApdRelInfo(xmlObjectArray[i], n, map);
        }
    }

    private void importTempApdRelInfo(XmlObject xmlObject, int n, Map map) {
        TempApdRel tempApdRel = null;
        try {
            tempApdRel = (TempApdRel)xmlObject.getCurrentObj();
            tempApdRel.setTemplateId(n);
            int n2 = tempApdRel.getTempAppendixId();
            Integer n3 = (Integer)map.get(String.valueOf(n2));
            tempApdRel.setTempAppendixId(n3);
            tempApdRel.removeProperty(PROPERTY_CRTIME);
            tempApdRel.save();
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label23", "\u5bfc\u5165\u6a21\u677f\u4e0e\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label24", "\u5bfc\u5165\u6a21\u677f[") + n + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label25", "]\u4e0e\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25!"), throwable);
        }
    }

    private void importTempEmploys(XmlObject[] xmlObjectArray, int n, Map map) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importTempEmployInfo(xmlObjectArray[i], n, map);
        }
    }

    private void importTempEmployInfo(XmlObject xmlObject, int n, Map map) {
        TemplateEmploy templateEmploy = null;
        try {
            templateEmploy = (TemplateEmploy)xmlObject.getCurrentObj();
            int n2 = templateEmploy.getEmployerType();
            templateEmploy.setEmployer(n2, n);
            int n3 = templateEmploy.getTemplateId();
            int n4 = templateEmploy.getTemplateType();
            if (map != null) {
                Integer n5 = (Integer)map.get(String.valueOf(n3));
                templateEmploy.setTemplate(n4, n5);
            } else {
                Template template = templateEmploy.getTemplate();
                if (template == null || !template.isAccessibleFrom((IPublishFolder)PublishElementFactory.lookupElement(n2, n)) || template.getType() != templateEmploy.getTemplateType()) {
                    return;
                }
            }
            templateEmploy.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label26", "\u5bfc\u5165\u6a21\u677f\u5173\u7cfb\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label27", "\u5bfc\u5165\u6a21\u677f\u5173\u7cfb\u5931\u8d25!"), throwable);
        }
    }

    private void importFolderPubConfs(XmlObject[] xmlObjectArray, IPublishFolder iPublishFolder) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importFolderPubConfInfo(xmlObjectArray[i], iPublishFolder);
        }
    }

    private void importFolderPubConfInfo(XmlObject xmlObject, IPublishFolder iPublishFolder) {
        FolderPublishConfig folderPublishConfig = null;
        try {
            folderPublishConfig = (FolderPublishConfig)xmlObject.getCurrentObj();
            folderPublishConfig.setFolder(iPublishFolder.getType(), iPublishFolder.getId());
            folderPublishConfig.removeProperty(PROPERTY_CRTIME);
            this.changeDataPathIfNecessary(folderPublishConfig, iPublishFolder);
            folderPublishConfig.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label28", "\u5bfc\u5165\u53d1\u5e03\u5c5e\u6027\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label29", "\u5bfc\u5165[") + folderPublishConfig + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), throwable);
        }
    }

    private void changeDataPathIfNecessary(FolderPublishConfig folderPublishConfig, IPublishFolder iPublishFolder) throws Throwable {
        if (!this.m_bCheckDataPathNecessary) {
            return;
        }
        String string = folderPublishConfig.getDataPath();
        if (!this.existsDataPath(iPublishFolder, string)) {
            return;
        }
        String string2 = string = string.replaceAll("(_\\d+)+", "");
        int n = iPublishFolder.getId();
        while (this.existsDataPath(iPublishFolder, string2)) {
            string2 = string + "_" + n;
            ++n;
        }
        folderPublishConfig.setDataPath(string2);
        this.m_bCheckDataPathNecessary = false;
    }

    private boolean existsDataPath(IPublishFolder iPublishFolder, String string) throws WCMException {
        Object object;
        String string2 = "DataPath='" + CMyString.filterForSQL(string) + "' AND ";
        if (103 == iPublishFolder.getType()) {
            string2 = string2 + " FolderType=103";
        } else {
            object = iPublishFolder.getParent();
            int n = 0;
            if (103 != object.getType()) {
                n = object.getId();
            }
            string2 = string2 + " EXISTS(SELECT WCMChannel.ChannelId from WCMChannel where ParentId=" + n + " AND WCMChannel.ChannelId=WCMFolderPublishConfig.FolderId)";
        }
        object = new WCMFilter("WCMFOLDERPUBLISHCONFIG", string2, "");
        ((WCMFilter)object).setMaxRowNumber(1);
        FolderPublishConfigs folderPublishConfigs = new FolderPublishConfigs(this.getLoginUser());
        folderPublishConfigs.open((WCMFilter)object);
        return !folderPublishConfigs.isEmpty();
    }

    private void importPubStatusConfs(XmlObject[] xmlObjectArray, int n, int n2) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importPubStatusConfInfo(xmlObjectArray[i], n, n2);
        }
    }

    private void importPubStatusConfInfo(XmlObject xmlObject, int n, int n2) {
        WCMPubStatusConfig wCMPubStatusConfig = null;
        try {
            wCMPubStatusConfig = (WCMPubStatusConfig)xmlObject.getCurrentObj();
            wCMPubStatusConfig.setFolderType(n, n2);
            wCMPubStatusConfig.removeProperty(PROPERTY_CRTIME);
            wCMPubStatusConfig.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label30", "\u5bfc\u5165\u53d1\u5e03\u72b6\u6001\u8bbe\u7f6e\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label31", "\u5bfc\u5165\u53d1\u5e03\u72b6\u6001\u8bbe\u7f6e[") + wCMPubStatusConfig + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label20", "]\u5931\u8d25"), throwable);
        }
    }

    private void importChildChannels(XmlObject[] xmlObjectArray, BaseChannel baseChannel, BaseChannel baseChannel2) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importChildChnlInfo(xmlObjectArray[i], baseChannel, baseChannel2);
        }
    }

    private void importChildChnlInfo(XmlObject xmlObject, BaseChannel baseChannel, BaseChannel baseChannel2) {
        Channel channel = null;
        try {
            channel = (Channel)xmlObject.getCurrentObj();
            String string = channel.getPropertyAsString("CHANNELID");
            channel.setParent(baseChannel);
            WebSite webSite = baseChannel.getSite();
            int n = webSite.getPropertyAsInt("SiteType", 0);
            if (this.isExcludeSiteType(n) && !this.isNormChannel(channel)) {
                String string2 = I18NMessage.get(ChannelImporter.class, "ChannelImporter.label7", "\u975e\u6587\u5b57\u5e93\u7ad9\u70b9[") + webSite.getName() + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label8", "]\u4e0d\u652f\u6301[");
                string2 = string2 + channel.getTypeDesc();
                string2 = string2 + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label9", "]\u7c7b\u578b\u7684\u680f\u76ee\uff01");
                this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label42", "\u5bfc\u5165\u5b50\u5bf9\u8c61[{0}]\u5931\u8d25\uff01"), new String[]{channel.toString()}), new WCMDatainvalidException(string2));
                return;
            }
            if (baseChannel2 != null && baseChannel2.isSite()) {
                channel.setSite(baseChannel2.getId());
            }
            channel.setNextId();
            this.changeNameIfNescessary(false, channel, baseChannel2);
            channel.removeProperty(PROPERTY_CRTIME);
            channel.removeProperty(PROPERTY_CRUSER);
            this.m_channelMgr.save(channel);
            this.processTemplateFolderIfNeed(string, channel.getId());
            this.m_siteOrChnlIds.put(this.makeSiteOrChnlIdMapKey(string, 101), new Integer(channel.getId()));
            this.importFolderPubConfs(xmlObject.getChild(TAG_FOLDERPUBCONFS), (IPublishFolder)PublishElementFactory.makeElementFrom(channel));
            this.importPubStatusConfs(xmlObject.getChild(TAG_WCMPUBSTATUSCONFS), channel.getWCMType(), channel.getId());
            this.importContExtFields(xmlObject.getChild(TAG_CONTEXTFIELDS), channel);
            this.importTemplateArgs(channel, xmlObject.getChild(TAG_TEMPLATEARGS));
            this.importChildChannels(xmlObject.getChild(TAG_CHILDCHANNELS), channel, baseChannel2);
            ChannelServiceProviderHelper.createRelatedEmployes(string, (BaseChannel)channel);
            PorterUtil.doImports(channel, xmlObject, null);
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)I18NMessage.get(ChannelImporter.class, "ChannelImporter.label33", "\u5bfc\u5165\u5b50\u5bf9\u8c61\u5931\u8d25"), throwable);
            this.m_reports.addWarnedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label42", "\u5bfc\u5165\u5b50\u5bf9\u8c61[{0}]\u5931\u8d25\uff01"), new String[]{channel.toString()}), throwable);
        }
    }

    private void processTemplateFolderIfNeed(String string, int n) {
        if (this.m_templateIds == null || this.m_templateIds.isEmpty()) {
            return;
        }
        List list = (List)this.m_hTemplateInChannelMap.remove(string);
        if (list == null || list.isEmpty()) {
            return;
        }
        User user = this.getLoginUser();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)list.get(i);
            Integer n3 = (Integer)this.m_templateIds.get(string2);
            if (n3 == null) continue;
            try {
                Template template = Template.findByKey(n3);
                template.setFolder(101, n);
                template.save(user);
                continue;
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
    }

    private void importTemplateArgs(BaseChannel baseChannel, XmlObject[] xmlObjectArray) {
        if (xmlObjectArray == null || xmlObjectArray.length == 0) {
            return;
        }
        TemplateArgument templateArgument = null;
        boolean bl = this.m_templateIds != null && !this.m_templateIds.isEmpty();
        IPublishFolder iPublishFolder = null;
        int n = baseChannel.getWCMType();
        int n2 = baseChannel.getId();
        if (!bl) {
            try {
                iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n3 = xmlObjectArray.length;
        for (int i = 0; i < n3; ++i) {
            try {
                Object object;
                templateArgument = (TemplateArgument)xmlObjectArray[i].getCurrentObj();
                templateArgument.setEmployer(n, n2);
                int n4 = templateArgument.getTemplateId();
                if (bl) {
                    object = (Integer)this.m_templateIds.get(String.valueOf(n4));
                    if (object == null) continue;
                    templateArgument.setTemplateId((Integer)object);
                    templateArgument.save();
                    continue;
                }
                object = Template.findById(n4);
                if (object == null || !((Template)object).isAccessibleFrom(iPublishFolder)) continue;
                templateArgument.save();
                continue;
            }
            catch (Throwable throwable) {
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.error((Object)"Failed to import template arguments.", throwable);
            }
        }
    }

    private void changeNameIfNescessary(boolean bl, BaseChannel baseChannel, BaseChannel baseChannel2) throws Throwable {
        if (bl) {
            if (!CMyString.isEmpty(this.m_sNewSiteName)) {
                ((WebSite)baseChannel).setName(this.m_sNewSiteName);
                ((WebSite)baseChannel).setDesc(this.m_sNewSiteName);
            }
            if (!CMyString.isEmpty(this.m_sNewSiteDesc)) {
                ((WebSite)baseChannel).setDesc(this.m_sNewSiteDesc);
            }
            this.changeSiteName(baseChannel);
        } else {
            this.changeChnlName(baseChannel, baseChannel2);
        }
    }

    private void changeSiteName(BaseChannel baseChannel) throws Throwable {
        String string = baseChannel.getName();
        if (!this.existsSiteName(string)) {
            return;
        }
        String string2 = string = string.replaceAll("(_\\d+)+", "");
        int n = baseChannel.getId();
        while (this.existsSiteName(string2)) {
            string2 = string + "_" + n;
            ++n;
        }
        baseChannel.setName(string2);
    }

    private boolean existsSiteName(String string) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("", "SiteName='" + CMyString.filterForSQL(string) + "'", "");
        wCMFilter.setMaxRowNumber(1);
        WebSites webSites = WebSites.openWCMObjs(User.getSystem(), wCMFilter);
        return !webSites.isEmpty();
    }

    private void changeChnlName(BaseChannel baseChannel, BaseChannel baseChannel2) throws Throwable {
        String string = baseChannel.getName();
        if (!this.existsChnlName(string, baseChannel2)) {
            return;
        }
        String string2 = string = string.replaceAll("(_\\d+)+", "");
        int n = baseChannel.getId();
        while (this.existsChnlName(string2, baseChannel2)) {
            string2 = string + "_" + n;
            ++n;
        }
        baseChannel.setName(string2);
    }

    private boolean existsChnlName(String string, BaseChannel baseChannel) {
        return Channel.findByName(baseChannel.getSiteId(), string) != null;
    }

    private void importContExtFields(XmlObject[] xmlObjectArray, BaseChannel baseChannel) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importContExtFieldInfo(xmlObjectArray[i], baseChannel);
        }
    }

    private void importContExtFieldInfo(XmlObject xmlObject, BaseChannel baseChannel) {
        ContentExtField contentExtField = null;
        try {
            ExtendedField extendedField = this.importExtFieldInfo(xmlObject.getChild(TAG_EXTFIELDS)[0]);
            contentExtField = (ContentExtField)xmlObject.getCurrentObj();
            if (extendedField != null) {
                contentExtField.setProperty("EXTFIELDID", extendedField.getId());
            }
            contentExtField.setObjId(baseChannel.getId());
            contentExtField.setObjType(baseChannel.getWCMType());
            contentExtField.save(this.getLoginUser());
        }
        catch (Throwable throwable) {
            this.m_reports.addWarnedReport(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label29", "\u5bfc\u5165[") + baseChannel + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label35", "]\u7684") + "[" + contentExtField + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label34", "]\u5931\u8d25!"), throwable);
        }
    }

    private ExtendedField importExtFieldInfo(XmlObject xmlObject) throws WCMException {
        ExtendedField extendedField = (ExtendedField)xmlObject.getCurrentObj();
        String string = extendedField.getName();
        ExtendedField extendedField2 = this.findExtFieldByName(string, extendedField.getTableName());
        if (extendedField2 != null) {
            if (extendedField2.equals(extendedField)) {
                return extendedField2;
            }
            this.changeExtFieldNameIfNecessary(extendedField);
        }
        extendedField.save(this.getLoginUser());
        return extendedField;
    }

    private void changeExtFieldNameIfNecessary(ExtendedField extendedField) throws WCMException {
        String string = extendedField.getName();
        int n = 0;
        while (this.findExtFieldByName(string, extendedField.getTableName()) != null) {
            string = string + n;
        }
        extendedField.setName(string);
    }

    private ExtendedField findExtFieldByName(String string, String string2) throws WCMException {
        if (CMyString.isEmpty(string2)) {
            throw new WCMException(1100, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label36", "\u6269\u5c55\u5b57\u6bb5\u5224\u91cd\u5931\u8d25,\u6269\u5c55\u5b57\u6bb5[") + string + I18NMessage.get(ChannelImporter.class, "ChannelImporter.label37", "]\u6ca1\u6709\u6307\u5b9a\u6240\u5c5e\u8868\u540d!"));
        }
        WCMFilter wCMFilter = new WCMFilter("WCMEXTFIELD", "FIELDNAME=? AND TableName='" + string2.toUpperCase() + "'", "");
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(0, string);
        ExtendedFields extendedFields = ExtendedFields.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (extendedFields.isEmpty()) {
            return null;
        }
        return (ExtendedField)extendedFields.getAt(0);
    }

    private Reports importFromXml(String string, String string2, BaseChannel baseChannel) throws WCMException {
        XmlObject[] xmlObjectArray = this.convertXmlFile(string, string2);
        this.importSitesOrChnls(xmlObjectArray, baseChannel, null);
        this.m_reports.setTitle(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label38", "\u4eceXML\u6587\u4ef6\u4e2d\u5bfc\u5165\u7ad9\u70b9/\u680f\u76ee\u4fe1\u606f!"));
        return this.m_reports;
    }

    private void importChildChannelsTempEmploys(XmlObject[] xmlObjectArray, Map map) {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importChildChannelsTempEmploys(xmlObjectArray[i].getChild(TAG_CHILDCHANNELS), map);
            String string = xmlObjectArray[i].getCurrentObj().getPropertyAsString("CHANNELID");
            int n = Integer.parseInt(string);
            this.importTempEmploys(xmlObjectArray[i].getChild(TAG_TEMPEMPLOYS), n, map);
        }
    }

    private XmlObject[] convertXmlFile(String string, String string2) throws WCMException {
        try {
            XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, string2, null);
            return xmlObjectArray;
        }
        catch (Throwable throwable) {
            s_logger.debug((Object)"failed to convert xml to object!", throwable);
            throw new WCMException(150, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label39", "\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u63cf\u8ff0xml\u6587\u4ef6"), throwable);
        }
    }

    private void assertNotEmptyString(String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label40", "\u65e0\u6548\u7684\u6587\u4ef6\u540d!"));
        }
    }

    private void assertUnSupportFile(String string) throws WCMException {
        if (!FILEEXT_XML.equalsIgnoreCase(string) && !FILEEXT_ZIP.equalsIgnoreCase(string)) {
            throw new WCMException(1200, I18NMessage.get(ChannelImporter.class, "ChannelImporter.label41", "\u53ea\u652f\u6301\u4eceXML/ZIP\u6587\u4ef6\u4e2d\u5bfc\u5165!"));
        }
    }

    private String getFullName(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string2 = filesMan.mapFilePath(string, 0);
            string = string2 + string;
        }
        return string;
    }

    public static List getImplementors() throws Exception {
        String string = IChannelImporterConverter.class.getName();
        if (implementors == null) {
            Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(string);
            implementors = new ArrayList();
            while (iterator != null && iterator.hasNext()) {
                String string2 = (String)iterator.next();
                implementors.add(Class.forName(string2).newInstance());
            }
        }
        return implementors;
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("WCMWEBSITE", WebSite.class);
        this.m_converter.registPersistentObj("WCMCHANNEL", Channel.class);
        this.m_converter.registPersistentObj("WCMTEMPLATEEMPLOY", TemplateEmploy.class);
        this.m_converter.registPersistentObj("WCMFOLDERPUBLISHCONFIG", FolderPublishConfig.class);
        this.m_converter.registPersistentObj("WCMPUBSTATUSCONFIG", WCMPubStatusConfig.class);
        this.m_converter.registPersistentObj("WCMTEMPLATE", Template.class);
        this.m_converter.registPersistentObj("WCMTEMPAPDREL", TempApdRel.class);
        this.m_converter.registPersistentObj("WCMTEMPAPPENDIX", TempAppendix.class);
        this.m_converter.registPersistentObj("WCMCONTENTEXTFIELD", ContentExtField.class);
        this.m_converter.registPersistentObj("WCMEXTFIELD", ExtendedField.class);
        this.m_converter.registPersistentObj("WCMTEMPLATEARGUMENT", TemplateArgument.class);
        try {
            List list = ChannelImporter.getImplementors();
            for (IChannelImporterConverter iChannelImporterConverter : list) {
                iChannelImporterConverter.registerConverter(this.m_converter);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addFailedReports(BaseChannel baseChannel, Throwable throwable) {
        this.m_reports.addFailedReport(CMyString.format(I18NMessage.get(ChannelImporter.class, "ChannelImporter.label43", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Object[]{baseChannel}), throwable);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String getNewSiteName() {
        return this.m_sNewSiteName;
    }

    public void setNewSiteName(String string) {
        this.m_sNewSiteName = string;
    }
}

