/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AutoDocBakMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class AutoTransmitMgr {
    private static Logger m_oLogger = Logger.getLogger(AutoDocBakMgr.class);

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label1", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }

    private void assertNotNull(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label2", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    public ChannelSyn save(ChannelSyn channelSyn) throws WCMException {
        this.assertNotNull(channelSyn);
        this.validate(channelSyn);
        channelSyn.save(this.getLoginUser());
        return channelSyn;
    }

    public DocumentSyn saveDocumentSyn(DocumentSyn documentSyn) throws WCMException {
        this.assertNotNull(documentSyn);
        documentSyn.save(this.getLoginUser());
        return documentSyn;
    }

    public void delete(ChannelSyn channelSyn) throws WCMException {
        if (channelSyn == null) {
            return;
        }
        if (!channelSyn.canEdit(this.getLoginUser())) {
            throw new WCMException(200006, CMyString.format(I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label3", "\u914d\u7f6e\u4fe1\u606f\u6682\u65f6\u88ab [{0}] \u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002"), new String[]{this.getLoginUser().toString()}));
        }
        channelSyn.delete(this.getLoginUser());
    }

    public void deleteDocumentSyn(DocumentSyn documentSyn) throws WCMException {
        if (documentSyn == null) {
            return;
        }
        if (!documentSyn.canEdit(this.getLoginUser())) {
            throw new WCMException(200006, CMyString.format(I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label4", "TransmittedDoc\u5bf9\u8c61\u6682\u65f6\u88ab [{0}] \u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002"), new String[]{this.getLoginUser().toString()}));
        }
        documentSyn.delete(this.getLoginUser());
    }

    public ChannelSyns getChannelSyns(Channel channel, WCMFilter wCMFilter) throws WCMException {
        return this.getChannelSyns(channel, wCMFilter, false);
    }

    public ChannelSyns getChannelSyns(Channel channel, WCMFilter wCMFilter, boolean bl) throws WCMException {
        this.assertNotNull(channel);
        WCMFilter wCMFilter2 = new WCMFilter("", bl ? "ToChannel=?" : "SRCCHANNEL=?", "CHANNELSYNID desc");
        wCMFilter2.addSearchValues(0, channel.getId());
        wCMFilter2.mergeWith(wCMFilter);
        ChannelSyns channelSyns = new ChannelSyns(this.getLoginUser());
        try {
            channelSyns.open(wCMFilter2);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)wCMException.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label5", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), wCMException);
        }
        return channelSyns;
    }

    public ChannelSyns getRelatedChannelSyns(Channel channel, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(channel);
        int n = channel.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "SRCCHANNEL=" + n + " OR TOCHANNEL=" + n, "CHANNELSYNID desc");
        wCMFilter2.mergeWith(wCMFilter);
        ChannelSyns channelSyns = new ChannelSyns(this.getLoginUser());
        try {
            channelSyns.open(wCMFilter2);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)wCMException.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label5", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), wCMException);
        }
        return channelSyns;
    }

    private boolean validate(ChannelSyn channelSyn) throws WCMException {
        this.assertNotNull(channelSyn);
        return this.validate(channelSyn.getSrcChannel(), channelSyn.getToChannel());
    }

    private boolean validate(Channel channel, Channel channel2) throws WCMException {
        this.assertNotNull(channel);
        this.assertNotNull(channel2);
        if (channel == channel2) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label6", "\u9891\u9053\u4e0d\u80fd\u5206\u53d1\u7ed9\u81ea\u5df1\uff01"));
        }
        ChannelSyns channelSyns = this.getChannelSyns(channel2, null);
        if (channelSyns == null || channelSyns.isEmpty()) {
            return true;
        }
        ChannelSyn channelSyn = null;
        Channel channel3 = null;
        for (int i = 0; i < channelSyns.size(); ++i) {
            channelSyn = (ChannelSyn)channelSyns.getAt(i);
            channel3 = channelSyn.getToChannel();
            if (channel3 == channel) {
                throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label7", "\u64cd\u4f5c\u5931\u8d25\uff01\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u6709\u8bef\uff0c\u9891\u9053\u6784\u6210\u56de\u8def\uff01"));
            }
            this.validate(channel, channel3);
        }
        return true;
    }

    private WCMFilter constructSynChannelsFilter(Channel channel, String string, String string2) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label8", "\u5f53\u524d\u9891\u9053\u65e0\u6548,\u65e0\u6cd5\u53d6\u5f97\u7ed9\u5b83\u5206\u53d1\u6587\u6863\u7684\u9891\u9053"));
        }
        String string3 = "WCMCHANNELSYN." + string + "=" + channel.getId();
        String string4 = string2 + " as " + "CHANNELID";
        return new WCMFilter("WCMCHANNELSYN", string3, "", string4);
    }

    public Channels getSynSrcChannels(Channel channel) throws WCMException {
        WCMFilter wCMFilter = this.constructSynChannelsFilter(channel, "ToChannel", "SrcChannel");
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Channels getSynToChannels(Channel channel) throws WCMException {
        WCMFilter wCMFilter = this.constructSynChannelsFilter(channel, "SrcChannel", "ToChannel");
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }
}

