/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocStatHandler4UserDept;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HitsStatHandler4UserDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfUser = new HashMap();
    private int[] filterDocIds = null;
    private boolean bFilterByDocument = false;

    public HitsStatHandler4UserDept() {
    }

    public HitsStatHandler4UserDept(int[] nArray) {
        this.filterDocIds = nArray;
        this.bFilterByDocument = true;
    }

    public void visitStatItem(ResultSet resultSet, int n) throws WCMException {
        try {
            int n2 = resultSet.getInt(1);
            if (n2 == 0) {
                return;
            }
            int n3 = resultSet.getInt(2);
            if (this.bFilterByDocument) {
                if (this.filterDocIds == null) {
                    return;
                }
                boolean bl = false;
                for (int i = 0; i < this.filterDocIds.length; ++i) {
                    if (n3 != this.filterDocIds[i]) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            String string = resultSet.getString(3);
            Groups groups = this.makeCurrRelGroups(string);
            int n4 = groups.size();
            for (int i = 0; i < n4; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                String string2 = group.getId() + "";
                int n5 = this.getValue(n, string2);
                this.setValue(n, string2, n5 += n2);
                this.addMajorObject(string2);
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    private Groups makeCurrRelGroups(String string) throws WCMException {
        Groups groups = (Groups)this.m_hRelGroupsOfUser.get(string);
        if (groups != null) {
            return groups;
        }
        groups = new Groups(null);
        User user = User.findByName(string);
        if (user == null) {
            return groups;
        }
        Groups groups2 = user.getGroups();
        int n = groups2.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups2.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                groups.addElement(group2);
            }
        }
        this.m_hRelGroupsOfUser.put(user.getKey(), groups);
        return groups;
    }
}

