/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaViewFieldGroupMgr;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class MetaViewFieldGroupServiceProvider
implements ISelfDefinedServiceProvider {
    private IMetaViewFieldGroupMgr m_oMetaViewFieldGroupMgr = (IMetaViewFieldGroupMgr)DreamFactory.createObjectById("IMetaViewFieldGroupMgr");

    public Reports deleteMetaViewFieldGroups(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label2", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5220\u9664\u5b57\u6bb5\u5206\u7ec4\uff01"));
        }
        String string = methodContext.getValue("MetaViewFieldGroupIds");
        MetaViewFieldGroups metaViewFieldGroups = MetaViewFieldGroups.findByIds(user, string);
        Reports reports = new Reports(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label8", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4"));
        int n = metaViewFieldGroups.size();
        for (int i = 0; i < n; ++i) {
            MetaViewFieldGroup metaViewFieldGroup = (MetaViewFieldGroup)metaViewFieldGroups.getAt(i);
            if (metaViewFieldGroup == null) continue;
            try {
                this.m_oMetaViewFieldGroupMgr.delete(user, metaViewFieldGroup);
                reports.addSucessedReport(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label9", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4[") + metaViewFieldGroup.getGroupName() + "][" + I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label9", "\u5220\u9664\u5b57\u6bb5\u5206\u7ec4[") + metaViewFieldGroup.getGroupName() + "][" + I18NMessage.get(MetaViewFieldGroupServiceProvider.class, "MetaViewFieldGroupServiceProvider.label6", "]\u5931\u8d25\uff01"), exception);
            }
        }
        return reports;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }
}

