/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MetaDataCenterServiceProviderForZJH
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(MetaDataCenterServiceProviderForZJH.class);

    public MetaViewData saveMetaViewDataOfGov(MethodContext methodContext) throws Throwable {
        return this.saveMetaViewData(methodContext);
    }

    public MetaViewData saveMetaViewData(MethodContext methodContext) throws Throwable {
        Object object;
        CMSObj cMSObj;
        String string;
        User user = this.getLoginUser();
        int n = methodContext.getValue("SiteId", 3);
        Channel channel = Channel.findByName(n, string = methodContext.getValue("ChannelName"));
        if (channel == null) {
            logger.warn((Object)("\u6307\u5b9a\u7684\u680f\u76ee[Name=" + string + "]\u5728\u7ad9\u70b9[ID=" + n + "]\u4e2d\u4e0d\u5b58\u5728\uff01"));
            channel = this.findChannelById(methodContext.getValue("ChannelId", 2386));
        }
        if (!AuthServer.hasRight(user, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01");
        }
        MetaView metaView = this.findViewById(methodContext.getValue("ViewId", 0));
        MetaViewData metaViewData = new MetaViewData(metaView);
        MetaDataCenterServiceProviderForZJH.setViewDataProperties(methodContext, metaViewData);
        metaViewData.setProperty("ChannelId", channel.getId());
        IMetaDataDefCacheMgr iMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        HashMap hashMap = iMetaDataDefCacheMgr.getMetaViewFields(metaView.getId());
        Set set = hashMap.keySet();
        for (String string2 : set) {
            String string3;
            cMSObj = (MetaViewField)hashMap.get(string2);
            if (((MetaViewField)cMSObj).getType() != 10 || (string3 = metaViewData.getPropertyAsString(string2)) == null || (string3 = string3.trim()).length() == 0) continue;
            object = this.convertToClassIds(((MetaViewField)cMSObj).getClassId(), string3);
            metaViewData.setProperty(string2, object);
        }
        metaViewData.save(user);
        String string4 = ConfigServer.getServer().getSysConfigValue("DOCADD_INTO_FLOW", "true");
        boolean bl = "true".equalsIgnoreCase(string4);
        if (bl) {
            cMSObj = Document.findById(metaViewData.getId());
            try {
                WCMProcessServiceHelper.startDocumentInFlow(user, (Document)cMSObj, methodContext);
            }
            catch (Throwable throwable) {
                object = new ServiceInvocationException("\u867d\u7136\u5df2\u6210\u529f\u65b0\u589e\u6587\u6863[" + ((Document)cMSObj).getTitle() + "-" + cMSObj.getId() + "]\uff0c\u4f46\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01", throwable);
                ((ServiceInvocationException)object).setErrorCode("17080");
                throw object;
            }
        }
        return metaViewData;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=" + n + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int n) throws WCMException {
        MetaView metaView = MetaView.findById(n);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=" + n + "]");
        }
        return metaView;
    }

    public static MetaViewData setViewDataProperties(MethodContext methodContext, MetaViewData metaViewData) throws WCMException {
        Map map = methodContext.getParams();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v instanceof String) {
                metaViewData.setProperty(string, v.toString().trim());
                continue;
            }
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                metaViewData.setProperty(string, stringArray == null || stringArray.length == 0 ? null : stringArray[0].trim());
                continue;
            }
            metaViewData.setProperty(string, v);
        }
        return metaViewData;
    }

    private String convertToClassIds(int n, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        WCMFilter wCMFilter = new WCMFilter("", "", "", String.valueOf("CLASSINFOID"));
        String[] stringArray = string.split(";");
        StringBuffer stringBuffer = new StringBuffer(stringArray.length * 2 + 20);
        stringBuffer.append("RootId=? and CName in(");
        wCMFilter.addSearchValues(n);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() == 0) continue;
            int n2 = stringArray[i].lastIndexOf(92);
            if (n2 >= 0) {
                String[] stringArray2 = stringArray[i].split("\\\\");
                int n3 = n;
                for (int j = 0; j < stringArray2.length && (CMyString.isEmpty(stringArray2[j]) || (n3 = this.queryClassId(n3, stringArray2[j])) != 0); ++j) {
                }
                if (n3 <= 0) continue;
                return String.valueOf(n3);
            }
            bl = true;
            stringBuffer.append("?,");
            wCMFilter.addSearchValues(stringArray[i]);
        }
        if (!bl) {
            return "";
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append(")");
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.setMaxRowNumber(stringArray.length);
        StringBuffer stringBuffer2 = new StringBuffer(stringArray.length * 2);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos == null || classInfos.isEmpty()) {
            return "";
        }
        stringBuffer2.append(classInfos.getIdAt(0));
        return stringBuffer2.toString();
    }

    private int queryClassId(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=? and CName=?", "", String.valueOf("CLASSINFOID"));
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(string);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, wCMFilter);
        if (classInfos == null || classInfos.isEmpty()) {
            return 0;
        }
        return classInfos.getIdAt(0);
    }
}

