/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.web.FieldTemplate;
import com.trs.components.metadata.web.HTMLMaker;
import com.trs.components.metadata.web.HTMLMakerFactory;
import com.trs.components.metadata.web.impl.FieldTemplateFactory;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserViewField
extends TagParserContentBase {
    private static Logger logger = Logger.getLogger(WCMTagParserViewField.class);
    private static final int FULL_FIELD_NAME = 1;
    private static final int ENUM_VALUE = 2;
    private static final int _HTML = 3;
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        if (this.m_host != null) {
            return this.m_host;
        }
        CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
        if (cMSObj instanceof MetaViewField) {
            return cMSObj;
        }
        MetaView metaView = null;
        if (cMSObj instanceof Document) {
            object = (Document)cMSObj;
            metaView = MetaView.findById(((Document)object).getKindId());
            if (metaView == null) {
                throw new WCMException("\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=" + ((BaseObj)object).getId() + ",ViewId=" + ((Document)object).getKindId() + "]");
            }
        } else if (cMSObj instanceof MetaView) {
            metaView = (MetaView)cMSObj;
        }
        if (metaView != null) {
            object = publishTagContext.getAttribute("id");
            if (CMyString.isEmpty((String)object)) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label1", "\u4f7f\u7528\u573a\u666f\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684\u5b57\u6bb5\u540d\u79f0[id]\u5c5e\u6027"));
            }
            return this.m_oDataDefCacheMgr.getMetaViewField(metaView.getId(), (String)object);
        }
        return null;
    }

    protected String[] parseHostNormalProperty(String string, PublishTagContext publishTagContext) throws WCMException {
        CMSObj cMSObj = this.findHost(publishTagContext);
        if (cMSObj == null || !(cMSObj instanceof MetaViewField)) {
            return null;
        }
        String string2 = "";
        string2 = string.charAt(0) == '#' ? cMSObj.getAttributeValue(string.substring(1)) : cMSObj.getPropertyAsString(string);
        boolean bl = publishTagContext.getAttribute("DoubleFilter", false);
        String string3 = publishTagContext.getAttribute("filterForHTML");
        String string4 = publishTagContext.getAttribute("filterForJs");
        String string5 = publishTagContext.getAttribute("filterForJava");
        if ("true".equalsIgnoreCase(string4) || "1".equals(string4)) {
            string2 = CMyString.filterForJs(string2);
            if (bl) {
                string2 = CMyString.filterForJs(string2);
            }
        } else if ("true".equalsIgnoreCase(string3) || "1".equals(string3)) {
            string2 = CMyString.filterForHTMLValue(string2);
            if (bl) {
                string2 = CMyString.filterForHTMLValue(string2);
            }
        } else if ("true".equalsIgnoreCase(string5) || "1".equals(string5)) {
            string2 = CMyString.filterForJava(string2);
            if (bl) {
                string2 = CMyString.filterForJava(string2);
            }
        }
        return new String[]{string2};
    }

    protected String[] parseHostSpecialProperty(int n, PublishTagContext publishTagContext) throws WCMException {
        CMSObj cMSObj = this.findHost(publishTagContext);
        if (cMSObj == null || !(cMSObj instanceof MetaViewField)) {
            return null;
        }
        MetaViewField metaViewField = (MetaViewField)cMSObj;
        MetaView metaView = MetaView.findById(metaViewField.getViewId());
        if (metaView == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return new String[]{metaView.getTrueTableName() + "." + metaViewField.getName()};
            }
            case 2: {
                String string = metaViewField.getEnmValue();
                if (publishTagContext.getAttribute("filterForJs", false)) {
                    return new String[]{CMyString.filterForJs(string)};
                }
                String string2 = CMyString.filterForHTMLValue(string);
                String string3 = publishTagContext.getAttribute("filterForHTML");
                if (!"false".equalsIgnoreCase(string3) && !"0".equals(string3)) {
                    return new String[]{CMyString.filterForHTMLValue(string2)};
                }
                return new String[]{string2};
            }
            case 3: {
                return new String[]{this.buildFieldHtml(publishTagContext)};
            }
        }
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("FULLFIELDNAME", 1);
        this.registerHostSpecialProperty("ENMVALUE", 2);
        this.registerHostSpecialProperty("_HTML", 3);
    }

    public TagBeanInfo getBeanInfo() {
        return null;
    }

    private String buildFieldHtml(PublishTagContext publishTagContext) throws WCMException {
        TagDocument tagDocument;
        CMSObj cMSObj = this.findHost(publishTagContext);
        if (cMSObj == null || !(cMSObj instanceof MetaViewField)) {
            return null;
        }
        MetaViewField metaViewField = (MetaViewField)cMSObj;
        HTMLMaker hTMLMaker = HTMLMakerFactory.getHTMLMaker(metaViewField.getType());
        hTMLMaker.setViewField(metaViewField);
        String string = this.getTemplateType(publishTagContext);
        FieldTemplate fieldTemplate = FieldTemplateFactory.getFieldTemplate(string);
        hTMLMaker.setFieldTemplate(fieldTemplate);
        String string2 = hTMLMaker.makeHTML();
        try {
            tagDocument = TagDocumentReader.read(string2);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label2", "\u8bfb\u53d6\u89c6\u56fe\u5b57\u6bb5[") + metaViewField + I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label3", "]\u6a21\u677f\u5931\u8d25"), exception);
        }
        if (tagDocument == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label2", "\u8bfb\u53d6\u89c6\u56fe\u5b57\u6bb5[") + metaViewField + I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label3", "]\u6a21\u677f\u5931\u8d25"));
        }
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, null);
        IPublishElement iPublishElement = PublishElementFactory.makeElementFrom(metaViewField);
        PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, publishTaskContext);
        PublishTagContext publishTagContext2 = new PublishTagContext(publishPageContext);
        String[] stringArray = TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext2);
        return stringArray[0];
    }

    private String getTemplateType(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("type");
        if (string == null) {
            for (TagItem tagItem = publishTagContext.getTagItem().getParent(); tagItem != null && ((string = tagItem.getAttribute("type")) == null || !"TRS_VIEWFIELDS".equals(tagItem.getName()) && !"TRS_XVIEWFIELDGROUPFIELDS".equals(tagItem.getName())); tagItem = tagItem.getParent()) {
            }
        }
        return string != null ? string : "addedit";
    }
}

