/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.parser.HTMLContentParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.util.RelativeURLHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnzip;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserViewData
extends TagParserContentBase {
    private static Logger logger = Logger.getLogger(WCMTagParserViewData.class);
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private static final int CHNL_DESC = 100;
    private static final int CHNL_NAME = 200;
    private static final int HOME_SITE = 201;
    private static final int HOME_SITENAME = 202;
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);

    public String[] parseSubItems(PublishTagContext publishTagContext) throws WCMException {
        TagItem tagItem = publishTagContext.getTagItem();
        List list = tagItem.getChildren();
        PublishTagContext publishTagContext2 = new PublishTagContext(publishTagContext, tagItem);
        publishTagContext2.setUpperHost(PublishElementFactory.makeElementFrom(this.m_host));
        return TagParseHelper.parseItems(list, publishTagContext2);
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.m_host = this.findHost(publishTagContext);
        if (this.m_host == null) {
            return null;
        }
        if (publishTagContext.getAttribute("ParseIFNotNull") == null) {
            TagItem tagItem = publishTagContext.getTagItem();
            boolean bl = WCMTagParserViewData.containsTagItemChild(tagItem);
            if (bl) {
                return this.parseSubItems(publishTagContext);
            }
            return this.parsePropety(publishTagContext);
        }
        String[] stringArray = this.parsePropety(publishTagContext);
        if (!publishTagContext.getAttribute("ParseIFNotNull", false)) {
            return stringArray;
        }
        if (stringArray == null || stringArray.length == 1 && CMyString.isEmpty(stringArray[0])) {
            return null;
        }
        TagItem tagItem = publishTagContext.getTagItem();
        List list = tagItem.getChildren();
        return TagParseHelper.parseItems(list, publishTagContext);
    }

    private String[] parsePropety(PublishTagContext publishTagContext) throws WCMException {
        MetaViewData metaViewData = (MetaViewData)this.m_host;
        String string = publishTagContext.getAttribute("Field");
        MetaViewField metaViewField = this.m_oDataDefCacheMgr.getMetaViewField(metaViewData.getMetaView().getId(), string);
        int n = -1;
        if (metaViewField != null) {
            n = metaViewField.getType();
        }
        switch (n) {
            case 8: {
                return this.generateAppendix(publishTagContext);
            }
            case 12: 
            case 16: {
                return this.parseHtmlContent(metaViewData.getPropertyAsString(string), publishTagContext);
            }
            case 10: {
                return this.makeClassInfo(publishTagContext, metaViewData, string);
            }
            case 3: 
            case 4: {
                return this.parseText(publishTagContext, metaViewData.getPropertyAsString(string));
            }
            case 18: {
                String string2 = metaViewData.getPropertyAsString(string);
                if (string2 == null || (string2 = string2.trim()).length() <= 0) {
                    return null;
                }
                string2 = RelativeURLHelper.makeLinkValue(publishTagContext, string2);
                return this.parseProperty(string2, publishTagContext);
            }
        }
        return super.parse(publishTagContext);
    }

    private String[] parseText(PublishTagContext publishTagContext, String string) throws WCMException {
        if (string == null || !publishTagContext.getAttribute("WML", false)) {
            return super.parse(publishTagContext);
        }
        return this.makeWmlContent(publishTagContext, string);
    }

    private String[] makeWmlContent(PublishTagContext publishTagContext, String string) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getPageElement();
        if (!(iPublishElement instanceof IPublishContent)) {
            return super.parse(publishTagContext);
        }
        int n = publishTagContext.getAttribute("PAGENUM", 900);
        if (n <= 0) {
            return super.parse(publishTagContext);
        }
        String string2 = PublishPathCompass.makeDetailPageFileName((IPublishContent)iPublishElement);
        String string3 = publishTagContext.getPageContext().getTemplate().getOutputFileExt();
        ArrayList<String> arrayList = new ArrayList<String>(5);
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n2 = 1;
        int n3 = 3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string4 = null;
        char[] cArray = string.toCharArray();
        char c2 = '\u0000';
        for (char c2 : cArray) {
            int n7 = n4 = c2 <= '\u007f' ? n2 : n3;
            if ((n6 += n4) > n) {
                string4 = TagParseHelper.formatTextIfNeeded(publishTagContext, stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(string4);
                stringBuffer.append("<br />");
                stringBuffer.append(WCMTagParserViewData.makeCurrNavContent(string2, string3, n5, true));
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                ++n5;
                n6 = n4;
            }
            stringBuffer.append(c2);
        }
        int n8 = 0;
        try {
            string4 = publishTagContext.getPageContext().getExtraAttribute("PAGVAR_WMLIMGCOUNT");
            n8 = Integer.parseInt(string4) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringBuffer.length() > 0) {
            string4 = TagParseHelper.formatTextIfNeeded(publishTagContext, stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append(string4);
            if (n5 > 0 || n8 > n5) {
                stringBuffer.append("<br />");
                stringBuffer.append(WCMTagParserViewData.makeCurrNavContent(string2, string3, n5, n8 > n5));
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        stringBuffer.setLength(0);
        n8 -= n5;
        while (--n8 >= 0) {
            stringBuffer.append("<br />");
            stringBuffer.append(WCMTagParserViewData.makeCurrNavContent(string2, string3, ++n5, n8 > 0));
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String makeCurrNavContent(String string, String string2, int n, boolean bl) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            string3 = null;
            string3 = n == 1 ? string + "." + string2 : string + "_" + (n - 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + "\">&lt;&lt;" + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label1", "\u4e0a\u4e00\u9875") + "</a>");
            stringBuffer.append("&nbsp;&nbsp;");
        }
        if (bl) {
            string3 = string + "_" + (n + 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + "\">" + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label2", "\u4e0b\u4e00\u9875") + "&gt;&gt;</a>");
        }
        return stringBuffer.toString();
    }

    private String[] makeClassInfo(PublishTagContext publishTagContext, MetaViewData metaViewData, String string) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(null, metaViewData.getPropertyAsString(string));
        if (classInfos.isEmpty()) {
            return null;
        }
        String string2 = publishTagContext.getAttribute("ClassField");
        if (CMyString.isEmpty(string2)) {
            string2 = "CNAME";
        }
        boolean bl = publishTagContext.getAttribute("FullPath", false);
        String string3 = publishTagContext.getAttribute("SEPERATOR");
        if (CMyString.isEmpty(string3)) {
            string3 = "\\";
        }
        boolean bl2 = publishTagContext.getAttribute("DisplayParentName", false);
        StringBuffer stringBuffer = new StringBuffer();
        int n = classInfos.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            if (bl) {
                object = classInfo.getPropertyAsString(string2);
                ClassInfo classInfo2 = ClassInfo.findById(classInfo.getParentId());
                while (classInfo2 != null) {
                    object = classInfo2.getPropertyAsString(string2) + string3 + (String)object;
                    if ((classInfo2 = ClassInfo.findById(classInfo2.getParentId())) != null && !classInfo2.isRoot()) continue;
                }
                stringBuffer.append((String)object);
            } else if (bl2) {
                object = ClassInfo.findById(classInfo.getParentId());
                if (object != null && ((ClassInfo)object).isRoot()) {
                    object = classInfo;
                }
                stringBuffer.append(object == null ? classInfo.getPropertyAsString(string2) : ((BaseObj)object).getPropertyAsString(string2));
            } else {
                stringBuffer.append(classInfo.getPropertyAsString(string2));
            }
            stringBuffer.append(";");
        }
        if (stringBuffer.length() <= 0) {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return new String[]{stringBuffer.toString()};
    }

    protected String[] parseHostNormalProperty(String string, PublishTagContext publishTagContext) throws WCMException {
        MetaViewData metaViewData = (MetaViewData)this.m_host;
        boolean bl = publishTagContext.getAttribute("isLabel", true);
        String string2 = publishTagContext.getAttribute("Delim");
        Object object = string.charAt(0) == '#' ? this.m_host.getAttributeValue(string.substring(1)) : (!bl || this.m_host.getProperty(string) instanceof CMyDateTime ? this.m_host.getProperty(string) : metaViewData.getRealProperty(string, string2));
        if (object == null) {
            return null;
        }
        return this.parseProperty(object, publishTagContext);
    }

    protected String[] parseHostSpecialProperty(int n, PublishTagContext publishTagContext) {
        if (this.m_host == null) {
            logger.error((Object)(publishTagContext.getTagItem() + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label3", "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173MetaViewData\u6ca1\u6709\u627e\u5230\uff01")));
            return null;
        }
        try {
            Channel channel = ((MetaViewData)this.m_host).getChannel();
            switch (n) {
                case 100: {
                    String string = channel.getDesc();
                    if (string == null || (string = string.trim()).length() <= 0) {
                        string = channel.getName();
                    }
                    return this.parseProperty(string, publishTagContext);
                }
                case 200: {
                    String string = channel.getName();
                    return this.parseProperty(string, publishTagContext);
                }
                case 201: 
                case 202: {
                    return this.parseHomeSite(channel, publishTagContext, n);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLDESC", 100);
        this.registerHostSpecialProperty("CHNLNAME", 200);
        this.registerHostSpecialProperty("HOMESITE", 201);
        this.registerHostSpecialProperty("HOMESITENAME", 202);
    }

    public TagBeanInfo getBeanInfo() {
        return null;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        if (this.m_host != null) {
            return this.m_host;
        }
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        CMSObj cMSObj = iPublishElement.getSubstance();
        if (cMSObj instanceof MetaViewData) {
            return cMSObj;
        }
        if (cMSObj instanceof Document) {
            MetaView metaView = this.getMetaViewCachedByTagContext(publishTagContext, (Document)cMSObj);
            return this.getViewDataCachedByTagContext(publishTagContext, cMSObj, metaView);
        }
        if (cMSObj instanceof MetaViewField && publishTagContext.getPageElement().getSubstance() instanceof Document) {
            CMSObj cMSObj2;
            int n = 1;
            int n2 = 100;
            for (PublishTagContext publishTagContext2 = publishTagContext.getParent(); publishTagContext2 != null; publishTagContext2 = publishTagContext2.getParent()) {
                if (n > n2) {
                    logger.error((Object)(n + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label4", "\u6b21\u90fd\u6ca1\u6709\u627e\u5230UppserHost\u662fViewDAta")));
                    break;
                }
                ++n;
                cMSObj2 = publishTagContext2.getUpperHost().getSubstance();
                if (!(cMSObj2 instanceof MetaViewData)) continue;
                return cMSObj2;
            }
            cMSObj2 = publishTagContext.getPageElement().getSubstance();
            MetaView metaView = this.getMetaViewCachedByTagContext(publishTagContext, (Document)cMSObj2);
            return this.getViewDataCachedByTagContext(publishTagContext, cMSObj2, metaView);
        }
        throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label5", "TRS_ViewData\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u5f53\u524d\u573a\u666f\u4e0b\uff01[UpperHost=") + cMSObj.getClassName(true) + "]");
    }

    private MetaView getMetaViewCachedByTagContext(PublishTagContext publishTagContext, Document document) throws WCMException {
        MetaView metaView = MetaView.findById(document.getKindId());
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label6", "\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=") + document.getId() + ",ViewId=" + document.getKindId() + "]");
        }
        return metaView;
    }

    private MetaViewData getViewDataCachedByTagContext(PublishTagContext publishTagContext, CMSObj cMSObj, MetaView metaView) throws WCMException {
        String string;
        MetaViewData metaViewData;
        HashMap<String, MetaViewData> hashMap = publishTagContext.getExtraAttributes();
        if (hashMap == null) {
            hashMap = new HashMap<String, MetaViewData>(1);
            publishTagContext.setExtraAttributes(hashMap);
        }
        if ((metaViewData = (MetaViewData)hashMap.get(string = "Curr.ViewData." + cMSObj.getId())) != null) {
            return metaViewData;
        }
        metaViewData = new MetaViewData(metaView);
        String string2 = this.getSelectFields(metaView.getTrueTableName(), "TRS_VIEWDATA", publishTagContext);
        metaViewData.loadById(cMSObj.getId(), string2);
        hashMap.put(string, metaViewData);
        return metaViewData;
    }

    private String[] generateAppendix(PublishTagContext publishTagContext) throws WCMException {
        String string;
        boolean bl;
        String string2 = publishTagContext.getAttribute("Field");
        String string3 = this.m_host.getPropertyAsString(string2);
        if (CMyString.isEmpty(string3)) {
            return new String[]{""};
        }
        if (!FilesMan.isValidFile(string3 = CMyFile.extractFileName(string3), "P0") && !FilesMan.isValidFile(string3, "W0")) {
            publishTagContext.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + string3 + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label8", "]\u4e0d\u662f\u6709\u6548\u7684WCM\u6587\u4ef6\uff01"), this.m_tagItem.toString());
            return new String[]{"NotValidFileName"};
        }
        String string4 = FileHelper.makeAbsoluteFilePathOfImage(string3, publishTagContext.getAttribute("InWidth", 0));
        string3 = CMyFile.extractFileName(string4);
        File file = new File(string4);
        if (!file.exists()) {
            if (!publishTagContext.isPreview()) {
                publishTagContext.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + string3 + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label9", "]\u4e0d\u5b58\u5728\uff01[AbsoluteFile=") + string4 + "]", this.m_tagItem.toString());
            }
            return new String[]{"NotExistFile"};
        }
        if (publishTagContext.getAttribute("ReturnFileSize", false)) {
            return new String[]{FileHelper.convertFileSize(file.length())};
        }
        IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        String string5 = publishPathCompass.getLocalPath(iPublishContent, bl = publishTagContext.isPreview());
        if (!CMyFile.fileExists(string5 + string3)) {
            String string6;
            PublishSyncGlobalTuner.insureLocalPathExists(string5);
            string = publishTagContext.getAttributeTrim("UnZipPathField");
            String string7 = CMyFile.extractFileExt(string3);
            if (!CMyString.isEmpty(string) && "ZIP".equalsIgnoreCase(string7) && !CMyString.isEmpty(string6 = this.m_host.getPropertyAsString(string))) {
                try {
                    this.doUnZipAndDistribute(publishTagContext, string3, string6);
                    return new String[]{string6};
                }
                catch (Exception exception) {
                    throw new WCMException("Fail to unzip [" + string4 + "]!", exception);
                }
            }
            try {
                CMyFile.copyFile(string4, string5 + string3);
                if (!bl) {
                    publishTagContext.getFileDistributeShip().distributeFile(string4, iPublishContent, null, true);
                }
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label10", "\u5206\u53d1\u6587\u4ef6\u5931\u8d25\uff01[UpperHost=") + publishTagContext.getUpperHost().getInfo() + "][FileName=" + string3 + "]", exception);
            }
        }
        string = WCMAppendixGenerator.makeAppendixURL(publishTagContext, iPublishContent, string3);
        return new String[]{string};
    }

    private void doUnZipAndDistribute(PublishTagContext publishTagContext, String string, String string2) throws Exception {
        Object object;
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = filesMan.mapFilePath(string, 0);
        string3 = CMyString.setStrEndWith(string3, File.separatorChar);
        String string4 = string3 + string2 + File.separatorChar;
        boolean bl = publishTagContext.isPreview();
        String string5 = publishTagContext.getPathCompass().getLocalPath(publishTagContext.getPageFolder(), bl);
        String string6 = publishTagContext.getPathCompass().getLocalPath(publishTagContext.getUpperHost(), bl);
        if (new File(string6 + string).exists()) {
            return;
        }
        String string7 = string3 + CMyFile.excludeFileExt(string) + File.separatorChar;
        CMyUnzip cMyUnzip = new CMyUnzip();
        cMyUnzip.addStrictFile(ConfigServer.getServer().getInitProperty("FILE_UPLOAD_ALLOW_SUFFIX") + ",shtml,shtm");
        cMyUnzip.setZipFile(string3 + string);
        cMyUnzip.unzip(string7, true);
        File file = new File(string4);
        if (file.exists()) {
            object = string4.substring(0, string4.length() - 1) + "_" + System.currentTimeMillis() + File.separatorChar;
            file.renameTo(new File((String)object));
            file = new File(string4);
        }
        object = new File(string7);
        File file2 = object;
        File[] fileArray = ((File)object).listFiles();
        if (fileArray.length == 1 && fileArray[0].isDirectory()) {
            file2 = fileArray[0];
        }
        if (!file2.renameTo(file)) {
            throw new Exception("Fail rename " + file2.getAbsolutePath() + " to " + string4);
        }
        try {
            CMyFile.copyFileDir(string4, string5, true);
            if (!bl) {
                this.distributePath(publishTagContext, publishTagContext.getPageFolder(), string4, string2);
            }
            CMyFile.copyFile(string3 + string, string6 + string, true);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label10", "\u5206\u53d1\u6587\u4ef6\u5931\u8d25\uff01[UpperHost=") + publishTagContext.getUpperHost().getInfo() + "][FileName=" + string + "]", exception);
        }
    }

    private void distributePath(PublishTagContext publishTagContext, IPublishElement iPublishElement, String string, String string2) throws WCMException {
        File[] fileArray = new File(string).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isFile()) {
                publishTagContext.getFileDistributeShip().distributeFile(file.getAbsolutePath(), iPublishElement, string2, false);
                continue;
            }
            String string3 = string2;
            string3 = CMyString.isEmpty(string3) ? "" : string3 + '/';
            string3 = string3 + file.getName();
            this.distributePath(publishTagContext, iPublishElement, file.getAbsolutePath(), string3);
        }
    }

    private String[] parseHtmlContent(String string, PublishTagContext publishTagContext) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        if (publishTagContext.getAttribute("WML", false) && publishTagContext.getAttribute("PAGENUM", 0) > 0) {
            String string2 = string.replaceAll("<{1}[^>]{1,}>{1}", "");
            return this.parseText(publishTagContext, string2);
        }
        String string3 = null;
        try {
            string3 = new HTMLContentParseHelper().makeHTMLContentParsed(publishTagContext, string);
            if (publishTagContext.getAttribute("NUM", 0) > 0) {
                string3 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string3);
            }
            if (publishTagContext.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(string3);
            }
            return new String[]{string3};
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label11", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), exception);
        }
    }

    private static boolean containsTagItemChild(TagItem tagItem) {
        List list = tagItem.getChildren();
        if (list == null) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e == null || !(e instanceof TagItem)) continue;
            return true;
        }
        return false;
    }

    private String[] parseHomeSite(Channel channel, PublishTagContext publishTagContext, int n) throws WCMException {
        if (channel == null) {
            return null;
        }
        WebSite webSite = channel.getSite();
        if (webSite == null) {
            return null;
        }
        String string = n == 201 ? webSite.getDesc() : webSite.getName();
        try {
            String string2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
            string2 = TagParseHelper.formatTextIfNeeded(publishTagContext, string2);
            if (publishTagContext.getAttribute("AUTOLINK", false)) {
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(webSite);
                string2 = TagParseHelper.addAutoLink(iPublishFolder.getRootDomain(), string2, string, publishTagContext);
            }
            return new String[]{string2};
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label11", "\u89e3\u6790 ") + channel + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label15", " \u7684\u6240\u5c5e\u7ad9\u70b9\u5931\u8d25!"), exception);
        }
    }

    private TagItem findObjectsTagItem(TagItem tagItem) {
        if (tagItem == null) {
            return null;
        }
        String string = tagItem.getName().toUpperCase();
        if (string.equals("TRS_RECORD") || string.equals("TRS_EXISTSDATA") || string.equals("TRS_NOTEXISTSDATA") || string.equals("TRS_CONDITION")) {
            return this.findObjectsTagItem(tagItem.getParent());
        }
        return tagItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String string, String string2, PublishTagContext publishTagContext) {
        if (publishTagContext.getPageElement() instanceof IPublishContent) {
            return "*";
        }
        TagItem tagItem = this.findObjectsTagItem(publishTagContext.getTagItem().getParent());
        if (tagItem == null) {
            return "*";
        }
        String string3 = (string + ".SELECT").toUpperCase();
        String string4 = tagItem.getExtraAttributeValue(string3);
        if (string4 == null) {
            TagItem tagItem2 = tagItem;
            synchronized (tagItem2) {
                string4 = tagItem.getExtraAttributeValue(string3);
                if (string4 == null) {
                    string4 = this.makeSelectFields(string, string2, tagItem, publishTagContext);
                    tagItem.setExtraAttribute(string3, string4);
                }
            }
        }
        return string4;
    }

    private String makeSelectFields(String string, String string2, TagItem tagItem, PublishTagContext publishTagContext) {
        ArrayList arrayList = FIELDS_DEFAULT_LIST_OF_METADATA;
        String string3 = (String)arrayList.get(0);
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            string3 = string3 + "," + arrayList.get(i);
        }
        ArrayList arrayList2 = TagParseHelper.makeSelectFields(tagItem, string2);
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            String string4 = (String)arrayList2.get(i);
            if (arrayList.indexOf(string4) >= 0) continue;
            try {
                if (dBManager.getFieldInfo(string, string4) == null) {
                    publishTagContext.addWarning(string2 + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label16", "\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string4 + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label17", "]\u5728") + string + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label18", "\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label19", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string4 + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label20", "]\u4ece") + string + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label21", "\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string3 = string3 + "," + string4;
        }
        return string3;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
    }
}

