/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class InfoViewSerial {
    private int m_nNextSerial;
    private int m_nMaxSerial;
    private int m_nInfoViewId;
    private int m_nBaseSerial;
    private String m_sPeriodPart;
    private static final int CACHE_SIZE = 5;
    public static final int SERIAL_PERIOD_DAY = 0;
    public static final int SERIAL_PERIOD_MONTH = 1;
    public static final int SERIAL_PERIOD_YEAR = 2;
    public static final int SERIAL_PERIOD_FORERVER = -1;
    private final String INSERT_SQL = "INSERT INTO WCMInfoviewSerial(PeriodPart,InfoViewId,NextSerial,BaseSerial) VALUES(?,?,?,?)";
    private final String UPDATE_SQL = "UPDATE WCMInfoviewSerial SET NextSerial=? WHERE PeriodPart=? AND InfoViewId=?";
    private final String SELECT_SQL = "SELECT NextSerial FROM WCMInfoviewSerial WHERE PeriodPart=? AND InfoViewId=?";

    InfoViewSerial(int n, int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("The BaseSerial must be larger than zero!");
        }
        this.m_nInfoViewId = n;
        this.m_nBaseSerial = n3;
        this.m_sPeriodPart = this.getPeriodPart(n2);
        this.m_nNextSerial = 0;
        this.m_nMaxSerial = 0;
    }

    private String getPeriodPart(int n) {
        CMyDateTime cMyDateTime = CMyDateTime.now();
        String string = null;
        switch (n) {
            case 0: {
                string = cMyDateTime.toString("yyyyMMdd");
                break;
            }
            case 1: {
                string = cMyDateTime.toString("yyyyMM");
                break;
            }
            case 2: {
                string = cMyDateTime.toString("yyyy");
                break;
            }
            case -1: {
                string = "Forerver";
                break;
            }
            default: {
                string = cMyDateTime.toString("yyyyMM");
            }
        }
        return string;
    }

    public synchronized Integer getNextSerial() throws WCMException {
        if (this.m_nNextSerial == this.m_nMaxSerial) {
            this.reloadSerial();
        }
        return new Integer(this.m_nNextSerial++);
    }

    /*
     * Loose catch block
     */
    private void reloadSerial() throws WCMException {
        DBManager dBManager;
        Connection connection;
        block11: {
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            connection = null;
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("SELECT NextSerial FROM WCMInfoviewSerial WHERE PeriodPart=? AND InfoViewId=?");
            preparedStatement.setString(1, this.m_sPeriodPart);
            preparedStatement.setInt(2, this.m_nInfoViewId);
            preparedStatement.executeQuery();
            ResultSet resultSet = preparedStatement.getResultSet();
            boolean bl = false;
            if (resultSet != null && resultSet.next()) {
                this.m_nNextSerial = resultSet.getInt(1);
                resultSet.close();
            } else {
                this.m_nNextSerial = this.m_nBaseSerial;
                bl = true;
            }
            this.m_nMaxSerial = this.m_nNextSerial + 5;
            if (bl) {
                preparedStatement2 = connection.prepareStatement("INSERT INTO WCMInfoviewSerial(PeriodPart,InfoViewId,NextSerial,BaseSerial) VALUES(?,?,?,?)");
                preparedStatement2.setString(1, this.m_sPeriodPart);
                preparedStatement2.setInt(2, this.m_nInfoViewId);
                preparedStatement2.setInt(3, this.m_nMaxSerial);
                preparedStatement2.setInt(4, this.m_nBaseSerial);
            } else {
                preparedStatement2 = connection.prepareStatement("UPDATE WCMInfoviewSerial SET NextSerial=? WHERE PeriodPart=? AND InfoViewId=?");
                preparedStatement2.setInt(1, this.m_nMaxSerial);
                preparedStatement2.setString(2, this.m_sPeriodPart);
                preparedStatement2.setInt(3, this.m_nInfoViewId);
            }
            preparedStatement2.executeUpdate();
            connection.commit();
            Object var8_8 = null;
            this.freeStatment(preparedStatement);
            this.freeStatment(preparedStatement2);
            try {
                connection.setAutoCommit(true);
                break block11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block11;
                catch (SQLException sQLException) {
                    throw new WCMException("Reload SerialNum failed!", sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.freeStatment(preparedStatement);
                this.freeStatment(preparedStatement2);
                try {
                    connection.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dBManager.freeConnection(connection);
                throw throwable;
            }
        }
        dBManager.freeConnection(connection);
    }

    private void freeStatment(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("[SerialNum:");
        stringBuffer.append("InfoViewId=").append(this.m_nInfoViewId).append(";");
        stringBuffer.append("NextSerial=").append(this.m_nNextSerial).append(";");
        stringBuffer.append("PeriodPart=").append(this.m_sPeriodPart).append(";");
        stringBuffer.append("BaseSerial=").append(this.m_nBaseSerial);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            InfoViewSerial infoViewSerial = new InfoViewSerial(1, 1, 10);
            for (int i = 0; i < 8; ++i) {
                System.out.println(infoViewSerial.getNextSerial());
            }
            InfoViewSerial infoViewSerial2 = new InfoViewSerial(1, -1, 1);
            for (int i = 0; i < 7; ++i) {
                System.out.println(infoViewSerial2.getNextSerial());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

