/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.CDBText;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;

public class InfoViewData
extends CMSObj {
    public static final int OBJ_TYPE = 3013;
    private String m_sIdFieldName = null;
    private InfoView m_oInfoView = null;
    private Channel m_oDocChannel = null;
    private int m_nInfoViewDataId = 0;
    private HashMap m_hPublicCache = null;
    private Hashtable m_hChnlDocProperties = new Hashtable(1);

    public InfoViewData() {
        this.m_bCheckPropertyValid = false;
    }

    public String getDbTableName() {
        return InfoViewConstants.makeTrueTableName(this.getInfoViewId());
    }

    public int getDocChannelId() {
        int n = Math.abs(this.getPropertyAsInt("ChannelId", 0));
        return n;
    }

    public Channel getDocChannel() throws WCMException {
        if (this.m_oDocChannel == null) {
            this.m_oDocChannel = Channel.findById(this.getDocChannelId());
        }
        return this.m_oDocChannel;
    }

    public String getIdFieldName() {
        return this.m_sIdFieldName == null ? InfoViewConstants.getIdFieldName(this.getDbTableName()) : this.m_sIdFieldName;
    }

    public void setIdFieldName(String string) {
        this.m_sIdFieldName = string;
    }

    public int getWCMType() {
        return 3013;
    }

    public boolean isValid() {
        return true;
    }

    public static final InfoViewData findById(InfoView infoView, int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        InfoViewData infoViewData = new InfoViewData();
        infoViewData.setInfoViewId(infoView.getId());
        infoViewData.setId(n);
        if (infoViewData.loadFromDB()) {
            return infoViewData;
        }
        return null;
    }

    public static final InfoViewData createNewInstance() throws WCMException {
        return (InfoViewData)BaseObj.createNewInstance(InfoViewData.class);
    }

    public static final InfoViewData createNewInstance(int n, int n2) throws WCMException {
        InfoViewData infoViewData = (InfoViewData)BaseObj.createNewInstance(InfoViewData.class);
        infoViewData.setInfoViewId(n);
        infoViewData.setDocumentId(n2);
        return infoViewData;
    }

    public static final InfoViewData findByKey(Object object) throws WCMException {
        return (InfoViewData)BaseObj.findByKey(InfoViewData.class, object);
    }

    public int getInfoViewId() {
        return this.getPropertyAsInt("InfoViewId", 0);
    }

    public void setInfoViewId(int n) throws WCMException {
        this.setProperty("InfoViewId", n);
    }

    public void setDocumentId(int n) throws WCMException {
        this.setProperty("DocumentId", n);
    }

    public void setChannelId(int n) throws WCMException {
        this.setProperty("ChannelId", n);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("ChannelId", 0);
    }

    public Channel getChannel() throws WCMException {
        int n = this.getChannelId();
        return Channel.findById(n);
    }

    public Document getDocument() throws WCMException {
        return Document.findById(this.getDocumentId());
    }

    public int getDocumentId() {
        return this.getPropertyAsInt("DocumentId", 0);
    }

    public static InfoViewData findById(int n) throws WCMException {
        Document document = Document.findById(n);
        if (document == null) {
            return null;
        }
        return InfoViewData.findByDocument(document);
    }

    public static InfoViewData findByDocument(Document document) throws WCMException {
        int n = document.getFlag();
        InfoViewData infoViewData = new InfoViewData();
        infoViewData.setInfoViewId(n);
        infoViewData.setIdFieldName("DocumentId");
        infoViewData.setId(document.getId());
        if (infoViewData.loadFromDB()) {
            infoViewData.setIdFieldName(null);
            infoViewData.setId(infoViewData.getPropertyAsInt(infoViewData.getIdFieldName(), 0));
            return infoViewData;
        }
        return null;
    }

    public static InfoViewData findById2(int n, int n2) throws WCMException {
        InfoViewData infoViewData = new InfoViewData();
        infoViewData.setInfoViewId(n);
        infoViewData.setIdFieldName("DocumentId");
        infoViewData.setId(n2);
        if (infoViewData.loadFromDB()) {
            infoViewData.setIdFieldName(null);
            infoViewData.setId(infoViewData.getPropertyAsInt(infoViewData.getIdFieldName(), 0));
            return infoViewData;
        }
        return null;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getInfoViewDataId() {
        if (this.m_nInfoViewDataId != 0) {
            return this.m_nInfoViewDataId;
        }
        return this.getPropertyAsInt("DocumentId", 0);
    }

    public void setInfoViewDataId(int n) {
        this.m_nInfoViewDataId = n;
    }

    public InfoViewData(InfoView infoView, HashMap hashMap) {
        this.m_hPublicCache = hashMap;
        this.m_bCheckPropertyValid = false;
        this.m_oInfoView = infoView;
    }

    public void cloneDocumentProperties(InfoViewData infoViewData) {
        this.m_hProperties = infoViewData.getProperties(false);
    }

    public String getChnlDocProperty(String string) {
        Object v = this.m_hChnlDocProperties.get(string.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public int getChnlDocProperty(String string, int n) {
        Number number = (Number)this.m_hChnlDocProperties.get(string.toUpperCase());
        if (number == null) {
            return n;
        }
        return number.intValue();
    }

    public final void readChnlDocPropertyFromRs(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws WCMException {
        try {
            if (resultSet == null) {
                return;
            }
            Object object = null;
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData != null ? resultSetMetaData : resultSet.getMetaData();
            int n = resultSetMetaData2.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData2.getColumnLabel(i).toUpperCase();
                if (string.equalsIgnoreCase("DOCID")) {
                    this.setInfoViewDataId(resultSet.getInt(i));
                    continue;
                }
                object = null;
                switch (resultSetMetaData2.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (resultSetMetaData2.getScale(i) <= 0) {
                            long l = resultSet.getLong(i);
                            if (resultSet.wasNull()) break;
                            object = new Long(l);
                            break;
                        }
                        if (resultSet.wasNull()) break;
                        BigDecimal bigDecimal = new BigDecimal(resultSet.getDouble(i));
                        bigDecimal = bigDecimal.setScale(resultSetMetaData2.getScale(i), 4);
                        if (resultSet.wasNull()) break;
                        object = bigDecimal;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long l = resultSet.getLong(i);
                        if (resultSet.wasNull()) break;
                        object = new Long(l);
                        break;
                    }
                    case 12: {
                        object = resultSet.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        object = new CMyDateTime();
                        ((CMyDateTime)object).setDateTimeWithRs(resultSet, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        object = new CDBText(this.getDBManager().getDBType());
                        ((CDBText)object).readFromRs(resultSet, i);
                        break;
                    }
                    case 8: {
                        double d = resultSet.getDouble(i);
                        if (resultSet.wasNull()) break;
                        object = new Double(d);
                        break;
                    }
                    default: {
                        object = resultSet.getObject(i);
                    }
                }
                if (object == null) continue;
                this.setChnlDocProperty(string, object);
            }
            this.id = this.getChnlDocProperty("RECID", 0);
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", sQLException);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", cMyException);
        }
        catch (Exception exception) {
            throw new WCMException(0, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08" + this.getClass().getName() + ".readChnlDocPropertyFromRs).", exception);
        }
    }

    public void setChnlDocProperty(String string, Object object) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.put(string.toUpperCase(), object);
    }

    public String toString() {
        try {
            return "[InfoViewId=" + this.getInfoViewId() + ",Id=" + this.getId() + ",DocumentId=" + this.getDocumentId() + ",ChannelId=" + this.getChannelId() + "]";
        }
        catch (Exception exception) {
            return I18NMessage.get(InfoViewData.class, "InfoViewData.label1", "\u8d44\u6e90\u5e93\u6570\u636e");
        }
    }
}

