/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract.manifest;

import com.trs.components.infoview.extract.manifest.CalculatedField;
import com.trs.components.infoview.extract.manifest.DocumentSchema;
import com.trs.components.infoview.extract.manifest.FileProperty;
import com.trs.components.infoview.extract.manifest.PackageFile;
import com.trs.components.infoview.extract.manifest.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Manifest {
    private Element m_oRootElement;
    private HashMap m_oAllViews;
    private List m_oAllViewsInOrder;
    private View m_oDefaultView;
    private HashMap m_oAllFiles;
    private HashMap m_oCalculations;
    private HashMap m_oSchemaMapURI;
    private DocumentSchema m_oRootSchema;
    private String m_sFileNewCaption;
    private String m_sFileNewTemplate;

    private void prepare(Document document) {
        this.m_oRootElement = document.getRootElement();
    }

    public void build(Document document) {
        this.prepare(document);
        this.buildPackage();
        this.buildViews();
        this.buildCalculations();
        this.buildDocumentSchemas();
        this.buildCaptionTemplate();
    }

    private void buildViews() {
        this.m_oAllViews = new HashMap();
        this.m_oAllViewsInOrder = new ArrayList();
        Element element = this.m_oRootElement.element("views");
        String string = element.attributeValue("default");
        Iterator iterator = element.elementIterator("view");
        while (iterator.hasNext()) {
            View view = new View().build((Element)iterator.next());
            this.m_oAllViews.put(view.getName(), view);
            this.m_oAllViewsInOrder.add(view);
            String string2 = view.getTransform();
            PackageFile packageFile = (PackageFile)this.m_oAllFiles.get(string2);
            FileProperty fileProperty = packageFile.getFileProperty("viewWidth");
            if (fileProperty == null) continue;
            view.setViewWidth(fileProperty.getValue());
        }
        this.m_oDefaultView = (View)this.m_oAllViews.get(string);
        this.m_oDefaultView.setDefaultView(true);
    }

    public HashMap getAllViews() {
        return this.m_oAllViews;
    }

    public List getAllViewsInOrder() {
        return this.m_oAllViewsInOrder;
    }

    public View getDefaultView() {
        return this.m_oDefaultView;
    }

    private void buildCalculations() {
        Element element = this.m_oRootElement.element("calculations");
        if (element == null) {
            return;
        }
        this.m_oCalculations = new HashMap();
        Iterator iterator = element.elementIterator("calculatedField");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            CalculatedField calculatedField = new CalculatedField().build(element2);
            this.m_oCalculations.put(calculatedField.getTarget(), calculatedField);
            this.m_oCalculations.put(calculatedField.getRelativeTarget(), calculatedField);
        }
    }

    public CalculatedField getCalculatedField(String string) {
        if (this.m_oCalculations == null) {
            return null;
        }
        return (CalculatedField)this.m_oCalculations.get(string);
    }

    private void buildPackage() {
        Element element = this.m_oRootElement.element("package");
        if (element == null) {
            return;
        }
        Element element2 = element.element("files");
        if (element2 == null) {
            return;
        }
        this.m_oAllFiles = new HashMap();
        Iterator iterator = element2.elementIterator();
        while (iterator.hasNext()) {
            PackageFile packageFile = new PackageFile().build((Element)iterator.next());
            this.m_oAllFiles.put(packageFile.getName(), packageFile);
        }
    }

    private void buildDocumentSchemas() {
        Element element = this.m_oRootElement.element("documentSchemas");
        if (element == null) {
            return;
        }
        DocumentSchema documentSchema = null;
        this.m_oSchemaMapURI = new HashMap();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            String string;
            PackageFile packageFile;
            FileProperty fileProperty;
            Element element2 = (Element)iterator.next();
            documentSchema = new DocumentSchema().build(element2);
            this.m_oSchemaMapURI.put(documentSchema.getXSDFile(), documentSchema);
            if (documentSchema.isRootSchema()) {
                this.m_oRootSchema = documentSchema;
            }
            if ((fileProperty = (packageFile = (PackageFile)this.m_oAllFiles.get(string = documentSchema.getXSDFile())).getFileProperty("rootElement")) != null) {
                documentSchema.setRootElement(fileProperty.getValue());
            }
            if ((fileProperty = packageFile.getFileProperty("namespace")) == null) continue;
            documentSchema.setNamespace(fileProperty.getValue());
        }
        if (this.m_oRootSchema == null && this.m_oSchemaMapURI.size() == 1) {
            this.m_oRootSchema = documentSchema;
        }
    }

    public HashMap getAllSchemas() {
        return this.m_oSchemaMapURI;
    }

    public DocumentSchema getRootSchema() {
        return this.m_oRootSchema;
    }

    public String getRootSchemaURI() {
        return this.m_oRootSchema.getXSDURI();
    }

    private void buildCaptionTemplate() {
        Element element = this.m_oRootElement.element("fileNew");
        if (element == null) {
            return;
        }
        Element element2 = element.element("initialXmlDocument");
        if (element2 == null) {
            return;
        }
        this.m_sFileNewCaption = element2.attributeValue("caption");
        this.m_sFileNewTemplate = element2.attributeValue("href");
    }

    public String getFileNewCaption() {
        return this.m_sFileNewCaption;
    }

    public String getFileNewTemplate() {
        return this.m_sFileNewTemplate;
    }
}

