/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.extract.XSLTViewBuilder;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class XSLTViewConstrainter {
    private InfoView m_oInfoView;
    private InfoViewView m_oInfoViewView;
    String m_sXSLPrefix;
    private List m_lstViewFields = null;
    private List m_lstViewGroups = null;

    public void init(InfoView infoView, InfoViewView infoViewView) throws WCMException {
        this.init(infoView, infoViewView, null, null);
    }

    public void init(InfoView infoView, InfoViewView infoViewView, List list, List list2) throws WCMException {
        this.m_oInfoView = infoView;
        this.m_oInfoViewView = infoViewView;
        this.m_sXSLPrefix = this.m_oInfoViewView.getXSLPrefix();
        this.m_lstViewFields = list2 == null ? this.m_oInfoView.allFields() : list2;
        this.m_lstViewGroups = list == null ? this.m_oInfoView.allGroups() : list;
    }

    public boolean rebuild(Document document) throws WCMException {
        boolean bl = false;
        bl = this.reformFields(document);
        bl = this.reformGroups(document) || bl;
        return bl;
    }

    private boolean reformFields(Document document) throws WCMException {
        if (this.m_lstViewFields == null) {
            return false;
        }
        Element element = document.getRootElement();
        if (element == null) {
            return false;
        }
        Iterator iterator = element.elementIterator("template");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            for (InfoViewField infoViewField : this.m_lstViewFields) {
                String string = infoViewField.getXPath();
                if (string == null) continue;
                for (Element element3 : element2.selectNodes("//*[@trs_temp_id=\"" + string + "\"]")) {
                    this.reformHTMLElement(element3, infoViewField);
                }
            }
        }
        return true;
    }

    private boolean reformGroups(Document document) {
        if (this.m_lstViewGroups == null) {
            return false;
        }
        String string = "//*/@trs_obj_type";
        List list = document.selectNodes(string);
        if (list == null) {
            return false;
        }
        HashMap<String, InfoViewGroup> hashMap = new HashMap<String, InfoViewGroup>();
        for (InfoViewGroup infoViewGroup : this.m_lstViewGroups) {
            hashMap.put(String.valueOf(infoViewGroup.getId()), infoViewGroup);
        }
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Element element;
            String string2;
            InfoViewGroup infoViewGroup;
            Attribute attribute = (Attribute)iterator.next();
            if (!XSLTViewBuilder.TYPE_DATA_SECTION.equals(attribute.getValue()) || (infoViewGroup = (InfoViewGroup)hashMap.get(string2 = (element = attribute.getParent()).attributeValue("trs_obj_id"))) == null) continue;
            String string3 = infoViewGroup.isPublicFill() ? "1" : "0";
            element.addAttribute("trs_obj_publish", string3);
            bl = true;
        }
        return bl;
    }

    private void reformHTMLElement(Element element, InfoViewField infoViewField) throws WCMException {
        Object object;
        if (infoViewField == null) {
            return;
        }
        String string = element.attributeValue("xctname");
        if (string == null) {
            return;
        }
        element.addAttribute("title", CMyString.filterForXsltValue(infoViewField.getDesc()));
        String string2 = null;
        if (!infoViewField.isNillable()) {
            element.addAttribute("not_null", "1");
            string2 = "required:true";
        } else {
            Attribute attribute;
            object = element.attribute("not_null");
            if (object != null) {
                element.remove(object);
            }
            if ((attribute = element.attribute("validation")) != null) {
                element.remove(attribute);
            }
        }
        if (string2 == null) {
            string2 = infoViewField.getDataControl();
        } else {
            object = infoViewField.getDataControl();
            if (!CMyString.isEmpty((String)object)) {
                string2 = (String)object + "," + string2;
            }
        }
        element.addAttribute("default_value", CMyString.filterForXsltValue(CMyString.showNull(infoViewField.getDefaultValue())));
        element.addAttribute("gateway_binding", CMyString.filterForXsltValue(CMyString.showNull(infoViewField.getGateWayBinding())));
        element.addAttribute("trs_readonly_field", Integer.toString(infoViewField.isReadOnly() ? 1 : 0));
        element.addAttribute("trs_backreadonly_field", Integer.toString(infoViewField.isBackReadOnly() ? 1 : 0));
        element.addAttribute("trs_backshow_field", Integer.toString(infoViewField.isBackShowAble() ? 1 : 0));
        if (!CMyString.isEmpty(string2)) {
            element.addAttribute("validation", CMyString.filterForXsltValue(string2));
        }
        element.addAttribute("data_pattern", CMyString.filterForXsltValue(CMyString.showNull(infoViewField.getDataPattern())));
        element.addAttribute("data_type", CMyString.filterForXsltValue(CMyString.showNull(infoViewField.getDataTypeAsString())));
    }
}

