/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.trsad;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.trsad.ADFiles;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;

public class ADCom
extends CMSObj {
    public static final int OBJ_TYPE = 2024;
    public static final String DB_TABLE_NAME = "XWCMADCOM";
    public static final String DB_ID_NAME = "ADCOMID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 2024;
    }

    public String getComName() {
        return this.getPropertyAsString("COMNAME");
    }

    public boolean setComName(String string) throws WCMException {
        return this.setProperty("COMNAME", string);
    }

    public String getComUrl() {
        return this.getPropertyAsString("COMSITE");
    }

    public boolean setComUrl(String string) throws WCMException {
        return this.setProperty("COMSITE", string);
    }

    public String getComContact() {
        return this.getPropertyAsString("COMCONTACT");
    }

    public boolean setComContact(String string) throws WCMException {
        return this.setProperty("COMCONTACT", string);
    }

    public String getComTel() {
        return this.getPropertyAsString("COMTEL");
    }

    public boolean setComTel(String string) throws WCMException {
        return this.setProperty("COMTEL", string);
    }

    public String getComAddress() {
        return this.getPropertyAsString("COMADDRESS");
    }

    public boolean setComAddress(String string) throws WCMException {
        return this.setProperty("COMADDRESS", string);
    }

    public String getComDesc() {
        return this.getPropertyAsString("COMDESC");
    }

    public boolean setComDesc(String string) throws WCMException {
        return this.setProperty("COMDESC", string);
    }

    public String getComCruser() {
        return this.getPropertyAsString("COMCRUSER");
    }

    public boolean setComCruser(String string) throws WCMException {
        return this.setProperty("COMCRUSER", string);
    }

    public CMyDateTime getComCrtime() {
        return (CMyDateTime)this.getProperty("COMCRTIME");
    }

    public boolean setComCrtime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("COMCRTIME", cMyDateTime);
    }

    public String getComEmail() {
        return this.getPropertyAsString("COMEMAIL");
    }

    public boolean setComEmail(String string) throws WCMException {
        return this.setProperty("COMEMAIL", string);
    }

    public int getComPeople() {
        return this.getPropertyAsInt("COMPEOPLE", 0);
    }

    public boolean setComPeople(int n) throws WCMException {
        return this.setProperty("COMPEOPLE", n);
    }

    public String getComZipcode() {
        return this.getPropertyAsString("COMZIPCODE");
    }

    public boolean setComZipcode(String string) throws WCMException {
        return this.setProperty("COMZIPCODE", string);
    }

    public String getComZone() {
        return this.getPropertyAsString("COMZONE");
    }

    public boolean setComZone(String string) throws WCMException {
        return this.setProperty("COMZONE", string);
    }

    public String getComZo() {
        return this.getPropertyAsString("COMZO");
    }

    public boolean setComZo(String string) throws WCMException {
        return this.setProperty("COMZO", string);
    }

    public String getComMobile() {
        return this.getPropertyAsString("COMMOBILE");
    }

    public boolean setComMobile(String string) throws WCMException {
        return this.setProperty("COMMOBILE", string);
    }

    public int getComPubN() {
        return this.getPropertyAsInt("COMPUBN", 0);
    }

    public boolean setComPubN(int n) throws WCMException {
        return this.setProperty("COMPUBN", n);
    }

    public String getComConTit() {
        return this.getPropertyAsString("COMCONTIT");
    }

    public boolean setComConTit(String string) throws WCMException {
        return this.setProperty("COMCONTIT", string);
    }

    public ADFiles getADFiles() throws WCMException {
        ADFiles aDFiles = new ADFiles(User.getSystem());
        aDFiles.open(new WCMFilter("", "ADFILEID=" + this.getId(), ""));
        return aDFiles;
    }

    public int delete(User user) throws WCMException {
        String string = "";
        try {
            string = "delete XWCMADFile where  ADCOMPANY=" + this.getId();
            super.getDBManager().sqlExecuteUpdate(string);
        }
        catch (Exception exception) {
            throw new WCMException(1000, "\u5220\u9664\u7528\u6237\u4e2a\u6027\u5316\u5b9a\u5236\u7684\u9891\u9053\u5931\u8d25\uff08Channel.delete\uff09", exception);
        }
        return super.delete(user);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("COMSITE") == null) {
                throw new WCMException(1106, I18NMessage.get(ADCom.class, "ADCom.label1", "\u5c5e\u6027ComUrl\u6ca1\u6709\u8bbe\u7f6e(ADCOM.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ADCom.class, "ADCom.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ADCOM.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("COMNAME") == null) {
                this.setComName("");
            }
            if (this.getAllProperty().get("COMZO") == null) {
                this.setComZo("");
            }
            if (this.getAllProperty().get("COMZONE") == null) {
                this.setComZone("");
            }
            super.insert(user);
        }
    }
}

