/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TemplateLCListenerVisualTemplate
implements IObjectLCListenerOnBeforeAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(TemplateLCListenerVisualTemplate.class);
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)(<trs_widget[^>]+)id=[\"'](\\d+)[\"']([^>]*>)");
    private static IWidgetInstanceMgr m_oWidgetInstMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
    private static final int NORMAL_TEMPLATE = 0;
    private static final int CLONE_INSTANCE = 2;
    private static final int UPDATE_TEMPLATE_ID = 4;

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Template)) {
            return;
        }
        Template template = (Template)baseObj;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        int n2 = template.getId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        stringBuffer.append("XWCMWIDGETINSTPARAMETER");
        stringBuffer.append(" where WidgetInstId in ( select WidgetInstanceId from ");
        stringBuffer.append("XWCMWIDGETINSTANCE");
        stringBuffer.append(" where templateid=").append(n2);
        stringBuffer.append(")");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.info((Object)"\u5220\u9664\u4e13\u9898\u540e\uff0c\u6267\u884c\u5220\u9664\u8d44\u6e90\u5b9e\u4f8b\u53d8\u91cf\u7684sql\u51fa\u9519", (Throwable)exception);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("delete from ");
        stringBuffer2.append("XWCMWIDGETINSTANCE");
        stringBuffer2.append(" where TEMPLATEID=");
        stringBuffer2.append(n2);
        try {
            DBManager.getDBManager().sqlExecuteUpdate(stringBuffer2.toString());
        }
        catch (Exception exception) {
            logger.info((Object)"\u5220\u9664\u4e13\u9898\u540e\uff0c\u6267\u884c\u5220\u9664\u8d44\u6e90\u5b9e\u4f8b\u7684sql\u51fa\u9519", (Throwable)exception);
        }
    }

    public void notifyOnBeforeAddObj(BaseObj baseObj) throws WCMException {
        logger.debug((Object)"buildRelationBetweenTempAndWidget...");
        if (!(baseObj instanceof Template)) {
            return;
        }
        Template template = (Template)baseObj;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        if (baseObj.getId() == 0) {
            baseObj.setNextId();
        }
        switch (this.guessMode(template)) {
            case 4: {
                this.updateWidgetInstanceTemplate(template);
                break;
            }
            case 2: {
                String string = this.cloneWidgetInstanceAndUpdateTemplateText(template);
                template.setText(string);
                break;
            }
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        this.notifyOnBeforeAddObj(baseObj);
    }

    private int guessMode(Template template) {
        String string = template.getFinalPropertyAsString("TempText");
        if (CMyString.isEmpty(string)) {
            return 0;
        }
        try {
            TagDocument tagDocument = TagDocumentReader.read(string);
            Iterator iterator = tagDocument.findItems("TRS_WIDGET");
            if (!iterator.hasNext()) {
                return 0;
            }
            TagItem tagItem = (TagItem)iterator.next();
            String string2 = tagItem.getAttribute("id");
            if (CMyString.isEmpty(string2)) {
                logger.error((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u51fa\u73b0\u4e86\u6ca1\u6709\u9884\u671f\u7684\u60c5\u51b5\uff0c\u8fd9\u79cd\u60c5\u51b5\u662f\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\uff1a[\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7f6e\u6807TRS_Widget\u7684\u5b9e\u4f8bid\u7adf\u7136\u6ca1\u6709\u51fa\u73b0]");
                return 0;
            }
            WidgetInstance widgetInstance = WidgetInstance.findById(Integer.parseInt(string2));
            if (widgetInstance == null) {
                logger.error((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u51fa\u73b0\u4e86\u6ca1\u6709\u9884\u671f\u7684\u60c5\u51b5\uff0c\u8fd9\u79cd\u60c5\u51b5\u662f\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\uff1a[\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7f6e\u6807TRS_Widget\u7684\u5b9e\u4f8bid\u5bf9\u5e94\u7684\u5bf9\u8c61\u7adf\u7136\u4e0d\u5b58\u5728]");
                return 0;
            }
            if (widgetInstance.getTemplateId() == 0) {
                return 4;
            }
            if (widgetInstance.getTemplateId() != template.getId()) {
                return 2;
            }
        }
        catch (Exception exception) {
            logger.info((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u83b7\u53d6\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u7f6e\u6807TRS_WIDGET\u51fa\u73b0\u9519\u8bef", (Throwable)exception);
        }
        return 0;
    }

    private String cloneWidgetInstanceAndUpdateTemplateText(Template template) throws WCMException {
        String string = template.getFinalPropertyAsString("TEMPTEXT");
        if (CMyString.isEmpty(string)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        User user = ContextHelper.getLoginUser();
        Matcher matcher = m_oInstancePattern.matcher(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            n2 = matcher.start();
            stringBuffer.append(string.substring(n3, n2));
            n3 = matcher.end();
            stringBuffer.append(matcher.group(1));
            n = Integer.parseInt(matcher.group(2));
            WidgetInstance widgetInstance = WidgetInstance.findById(n);
            widgetInstance = m_oWidgetInstMgr.clone(widgetInstance);
            widgetInstance.setTemplateId(template.getId());
            widgetInstance.save(user);
            stringBuffer.append("id=\"").append(widgetInstance.getId()).append("\"");
            stringBuffer.append(matcher.group(3));
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    private void updateWidgetInstanceTemplate(Template template) {
        Object object;
        String string = template.getFinalPropertyAsString("TempText");
        if (CMyString.isEmpty(string)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            object = TagDocumentReader.read(string);
            Iterator iterator = ((TagDocument)object).findItems("TRS_WIDGET");
            while (iterator.hasNext()) {
                TagItem tagItem = (TagItem)iterator.next();
                stringBuffer.append("?,");
                stringBuffer2.append(tagItem.getIntAttribute("id", 0)).append(",");
            }
        }
        catch (Exception exception) {
            logger.info((Object)"\u4fdd\u5b58\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u83b7\u53d6\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u7f6e\u6807TRS_WIDGET\u51fa\u73b0\u9519\u8bef", (Throwable)exception);
        }
        if (stringBuffer.length() <= 0) {
            return;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer2.setLength(stringBuffer2.length() - 1);
        object = new StringBuffer();
        ((StringBuffer)object).append("update ").append("XWCMWIDGETINSTANCE");
        ((StringBuffer)object).append(" set templateid=? ");
        ((StringBuffer)object).append(" where ").append("WIDGETINSTANCEID");
        ((StringBuffer)object).append(" in (");
        ((StringBuffer)object).append(stringBuffer);
        ((StringBuffer)object).append(")");
        stringBuffer2.insert(0, template.getId() + ",");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{((StringBuffer)object).toString()}, CMyString.splitToInt(stringBuffer2.toString(), ","));
        }
        catch (WCMException wCMException) {
            logger.info((Object)"\u4fdd\u5b58\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u6267\u884csql\u66f4\u65b0\u5efa\u7acb\u6a21\u677f\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u7684\u5173\u8054\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)wCMException);
        }
    }
}

