/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleMgr;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.ISystemContentStyleMgr;
import com.trs.components.common.publish.widget.ISystemResourceStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleMgr;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;

public class StyleCenterMgr
implements IStyleCenterMgr {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int STYLE_IS_PRIVATE = 1;
    public static final int STYLE_NOT_IS_PRIVATE = 0;
    public static final int PAGE_OTHERSTYLE_WCMTYPE = 1;
    private static final String CSSFLAG = "$CssFlag$";
    private static final String SEP_RESOURCESTYLE_START = "/*============ \u8d44\u6e90\u53ef\u9009\u98ce\u683c $CssFlag$ start =========*/";
    private static final String SEP_RESOURCESTYLE_END = "/*============ \u8d44\u6e90\u53ef\u9009\u98ce\u683c   $CssFlag$ end =========*/";
    private static final String SEP_CONTENTSTYLE_START = "/*============ \u5185\u5bb9\u53ef\u9009\u98ce\u683c   $CssFlag$ start =========*/";
    private static final String SEP_CONTENTSTYLE_END = "/*============ \u5185\u5bb9\u53ef\u9009\u98ce\u683c   $CssFlag$ end =========*/";
    private static final String SEP_CUSTOMSTYLE = "/*============ \u81ea\u5b9a\u4e49\u98ce\u683c  =========*/";
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
    private IResourceStyleMgr m_oResourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
    private IContentStyleMgr m_oContentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public File getStyleFile(PageStyle pageStyle) throws WCMException {
        return null;
    }

    public String findStyleImageDir(PageStyle pageStyle) throws WCMException {
        if (pageStyle == null) {
            return StylePathHelper.getStyleCommonDir() + "default" + File.separator;
        }
        return StylePathHelper.getStyleCommonDir() + pageStyle.getStyleName() + File.separator;
    }

    public String createStyleFile(User user, PageStyle pageStyle) throws Exception {
        String string;
        if (pageStyle == null) {
            return "";
        }
        if (user == null) {
            user = this.getLoginUser();
        }
        String string2 = pageStyle.getStyleName();
        String string3 = StylePathHelper.getStyleCssDir();
        if (!new File(string3).exists()) {
            CMyFile.makeDir(string3, true);
        }
        if (new File(string = string3 + string2 + ".css").exists()) {
            String string4 = string3 + string2 + "bak" + ".css";
            CMyFile.copyFile(string, string4, false);
        }
        this.writeCssFile(pageStyle, string);
        this.m_oPageStyleMgr.save(user, pageStyle);
        return string2 + ".css";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeCssFile(PageStyle pageStyle, String string) {
        block14: {
            FileOutputStream fileOutputStream = null;
            Writer writer = null;
            fileOutputStream = new FileOutputStream(string);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            this.makeCssContent(pageStyle, writer);
            Object var7_5 = null;
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block14;
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_6 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                            writer.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void makeCssContent(PageStyle pageStyle, Writer writer) throws IOException, WCMException {
        writer.write(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        ResourceStyles resourceStyles = this.m_oResourceStyleMgr.query(pageStyle, null);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle == null) continue;
            writer.write(CMyString.replaceStr(SEP_RESOURCESTYLE_START, CSSFLAG, resourceStyle.getCssFlag()) + LINE_SEPARATOR);
            writer.write(this.m_oResourceStyleMgr.makeCssContent(resourceStyle));
            writer.write(CMyString.replaceStr(SEP_RESOURCESTYLE_END, CSSFLAG, resourceStyle.getCssFlag()) + LINE_SEPARATOR);
        }
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, null);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            writer.write(CMyString.replaceStr(SEP_CONTENTSTYLE_START, CSSFLAG, contentStyle.getCssFlag()) + LINE_SEPARATOR);
            writer.write(this.m_oContentStyleMgr.makeCssContent(contentStyle));
            writer.write(CMyString.replaceStr(SEP_CONTENTSTYLE_END, CSSFLAG, contentStyle.getCssFlag()) + LINE_SEPARATOR);
        }
        writer.write(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
        writer.write(LINE_SEPARATOR + SEP_CUSTOMSTYLE + LINE_SEPARATOR);
        writer.write(pageStyle.getCustomStyle());
    }

    public String export(PageStyle pageStyle) throws Exception {
        if (pageStyle == null) {
            return "";
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "css");
        String string2 = filesMan.mapFilePath(string, 0);
        String string3 = string2 + string;
        String string4 = pageStyle.getStyleName();
        String string5 = StylePathHelper.getStyleCssDir();
        String string6 = string5 + string4 + ".css";
        if (!new File(string6).exists()) {
            this.createStyleFile(this.getLoginUser(), pageStyle);
        }
        CMyFile.copyFile(string6, string2, false);
        File file = new File(string2 + string4 + ".css");
        File file2 = new File(string3);
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
        return string;
    }

    public void importCssFile(PageStyle pageStyle, String string) throws Exception {
        if (pageStyle == null || CMyString.isEmpty(string)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0);
        String string3 = string2 + string;
        String string4 = string2 + pageStyle.getStyleName() + ".css";
        File file = new File(string4);
        if (file.exists()) {
            file.delete();
        }
        File file2 = new File(string3);
        file2.renameTo(file);
        String string5 = StylePathHelper.getStyleCssDir();
        if (!new File(string5).exists()) {
            CMyFile.makeDir(string5, true);
        }
        CMyFile.copyFile(file.getAbsolutePath(), string5, false);
        pageStyle.setIsImport(1);
        this.m_oPageStyleMgr.save(this.getLoginUser(), pageStyle);
    }

    public void createImgesDir(PageStyle pageStyle) throws WCMException {
        String string = this.findStyleImageDir(pageStyle);
        if (new File(string).exists()) {
            return;
        }
        if (!string.equals("")) {
            CMyFile.makeDir(string, false);
        }
    }

    public void copySystemStyle(User user, PageStyle pageStyle) throws Exception {
        ISystemResourceStyleMgr iSystemResourceStyleMgr = (ISystemResourceStyleMgr)DreamFactory.createObjectById("ISystemResourceStyleMgr");
        iSystemResourceStyleMgr.copyFor(user, pageStyle);
        ISystemContentStyleMgr iSystemContentStyleMgr = (ISystemContentStyleMgr)DreamFactory.createObjectById("ISystemContentStyleMgr");
        iSystemContentStyleMgr.copyFor(user, pageStyle);
    }

    public void saveStyleThumb(String string) throws Exception {
    }

    public void delStyleThumb(String string) throws Exception {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0) + string;
        CMyFile.deleteFile(string2);
    }

    public void copyToAllPageSylte(ResourceStyle resourceStyle) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId>0", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(wCMFilter);
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            this.m_oResourceStyleMgr.copy(this.getLoginUser(), pageStyle, resourceStyle);
            try {
                this.createStyleFile(this.getLoginUser(), pageStyle);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void copyToAllPageSylte(ContentStyle contentStyle) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "PageStyleId>0", "");
        PageStyles pageStyles = this.m_oPageStyleMgr.query(wCMFilter);
        for (int i = 0; i < pageStyles.size(); ++i) {
            PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
            if (pageStyle == null) continue;
            this.m_oContentStyleMgr.copy(this.getLoginUser(), pageStyle, contentStyle);
            try {
                this.createStyleFile(this.getLoginUser(), pageStyle);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String makePreviewCssContent(ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            return "";
        }
        int n = contentStyle.getPageStyleId();
        PageStyle pageStyle = PageStyle.findById(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        stringBuffer.append(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
        if (pageStyle != null) {
            stringBuffer.append(CMyString.showNull(pageStyle.getCustomStyle()));
        }
        stringBuffer.append(this.m_oContentStyleMgr.makeCssContent(contentStyle));
        return stringBuffer.toString();
    }

    public String makePreviewCssContent(ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            return "";
        }
        int n = resourceStyle.getPageStyleId();
        PageStyle pageStyle = PageStyle.findById(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        stringBuffer.append(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
        if (pageStyle != null) {
            stringBuffer.append(CMyString.showNull(pageStyle.getCustomStyle()));
        }
        stringBuffer.append(this.m_oResourceStyleMgr.makeCssContent(resourceStyle));
        return stringBuffer.toString();
    }

    public String previewStyle(PageStyle pageStyle, String string, String string2, StyleItems styleItems, String string3) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_oPageStyleMgr.makeBaseStyleContent(pageStyle));
        if (pageStyle != null) {
            stringBuffer.append(this.m_oPageStyleMgr.makePageOtherStyleContent(pageStyle));
            stringBuffer.append(pageStyle.getCustomStyle());
        }
        if (string3 != null && !string3.trim().equals("")) {
            stringBuffer.append(StyleHelper.makeCustomCssContent(string, string3));
        } else {
            String string4 = StyleHelper.getCssTemplateFilePath() + string2;
            String string5 = "";
            try {
                string5 = CMyFile.readFile(string4, "UTF-8");
            }
            catch (CMyException cMyException) {
                cMyException.printStackTrace();
            }
            if (string5 == null) {
                throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + string2);
            }
            if (string5.trim().equals("")) {
                return "";
            }
            stringBuffer.append(StyleHelper.makeCSSContent(string, string5, styleItems));
        }
        return stringBuffer.toString();
    }

    public HashMap findCssFlagUsedStyles(PageStyle pageStyle, BaseStyle baseStyle, String string) throws WCMException {
        ResourceStyleMgr resourceStyleMgr = new ResourceStyleMgr();
        ResourceStyles resourceStyles = resourceStyleMgr.findByCssFlagAndPageStyle(string, pageStyle);
        ContentStyleMgr contentStyleMgr = new ContentStyleMgr();
        ContentStyles contentStyles = contentStyleMgr.findByCssFlagAndPageStyle(string, pageStyle);
        if (baseStyle != null) {
            if (pageStyle == null) {
                HashMap<String, CMSBaseObjs> hashMap = new HashMap<String, CMSBaseObjs>();
                hashMap.put("ResourceStyles", new ResourceStyles(this.getLoginUser()));
                hashMap.put("ContentStyles", new ContentStyles(this.getLoginUser()));
                return hashMap;
            }
            if (baseStyle instanceof ResourceStyle) {
                resourceStyles.remove(baseStyle, false);
            }
            if (baseStyle instanceof ContentStyle) {
                contentStyles.remove(baseStyle, false);
            }
        }
        HashMap<String, CMSBaseObjs> hashMap = new HashMap<String, CMSBaseObjs>();
        hashMap.put("ResourceStyles", resourceStyles);
        hashMap.put("ContentStyles", contentStyles);
        return hashMap;
    }

    public HashMap findStyleNameUsedStyles(PageStyle pageStyle, BaseStyle baseStyle, String string) throws WCMException {
        ResourceStyleMgr resourceStyleMgr = new ResourceStyleMgr();
        ResourceStyles resourceStyles = resourceStyleMgr.findByStyleNameAndPageStyle(string, pageStyle);
        ContentStyleMgr contentStyleMgr = new ContentStyleMgr();
        ContentStyles contentStyles = contentStyleMgr.findByStyleNameAndPageStyle(string, pageStyle);
        if (baseStyle != null) {
            if (pageStyle == null) {
                HashMap<String, CMSBaseObjs> hashMap = new HashMap<String, CMSBaseObjs>();
                hashMap.put("ResourceStyles", new ResourceStyles(this.getLoginUser()));
                hashMap.put("ContentStyles", new ContentStyles(this.getLoginUser()));
                return hashMap;
            }
            if (baseStyle instanceof ResourceStyle) {
                resourceStyles.remove(baseStyle, false);
            }
            if (baseStyle instanceof ContentStyle) {
                contentStyles.remove(baseStyle, false);
            }
        }
        HashMap<String, CMSBaseObjs> hashMap = new HashMap<String, CMSBaseObjs>();
        hashMap.put("ResourceStyles", resourceStyles);
        hashMap.put("ContentStyles", contentStyles);
        return hashMap;
    }

    public void resetStyle(BaseStyle baseStyle) throws WCMException {
        int n;
        Object object;
        if (baseStyle == null) {
            throw new WCMException("\u4f20\u9012\u7684\u98ce\u683c\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        int n2 = 0;
        BaseStyle baseStyle2 = null;
        if (baseStyle instanceof ResourceStyle) {
            object = (ResourceStyle)baseStyle;
            n2 = ((ResourceStyle)object).getPageStyleId();
            n = ((ResourceStyle)object).getSrcResourceStyleId();
            baseStyle2 = ResourceStyle.findById(n);
        }
        if (baseStyle instanceof ContentStyle) {
            object = (ContentStyle)baseStyle;
            n2 = ((ContentStyle)object).getPageStyleId();
            n = ((ContentStyle)object).getSrcContentStyleId();
            baseStyle2 = ContentStyle.findById(n);
        }
        if (baseStyle2 == null) {
            throw new WCMException("\u83b7\u53d6\u5f53\u524d\u98ce\u683c[id\uff1a" + baseStyle.getId() + "\uff1btype\uff1a" + (baseStyle.getWCMType() == 1004807208 ? "\u8d44\u6e90\u98ce\u683c" : "\u5185\u5bb9\u98ce\u683c") + "]\u5bf9\u5e94\u7684\u7cfb\u7edf\u7ea7\u522b\u7684\u98ce\u683c\u5931\u8d25\uff01");
        }
        this.m_oStyleItemMgr.delete(this.getLoginUser(), baseStyle);
        object = this.m_oStyleItemMgr.queryStyleItems(baseStyle2, null);
        for (n = 0; n < ((BaseObjs)object).size(); ++n) {
            StyleItem styleItem = (StyleItem)((BaseObjs)object).getAt(n);
            if (styleItem == null) continue;
            StyleItem styleItem2 = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(this.getLoginUser(), baseStyle, styleItem2);
        }
        baseStyle.setStyleThumb(baseStyle2.getStyleThumb());
        baseStyle.setTemplate(baseStyle2.getTemplate());
        if (baseStyle instanceof ResourceStyle) {
            ((ResourceStyle)baseStyle).setCustomStyle(((ResourceStyle)baseStyle2).getCustomStyle());
        }
        if (baseStyle instanceof ContentStyle) {
            ((ContentStyle)baseStyle).setCustomStyle(((ContentStyle)baseStyle2).getCustomStyle());
        }
        baseStyle.save(this.getLoginUser());
        PageStyle pageStyle = PageStyle.findById(n2);
        try {
            if (n2 > 0 && pageStyle != null) {
                this.createStyleFile(this.getLoginUser(), pageStyle);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setResourceStylePrivate(ResourceStyle resourceStyle) throws WCMException {
        if (resourceStyle == null) {
            return;
        }
        if (resourceStyle.getPageStyleId() != 0) {
            return;
        }
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter("", "SRCRESOURCESTYLEID=?", "");
        wCMFilter.addSearchValues(resourceStyle.getId());
        ResourceStyles resourceStyles = ResourceStyles.openWCMObjs(user, wCMFilter);
        for (int i = 0; i < resourceStyles.size(); ++i) {
            ResourceStyle resourceStyle2 = (ResourceStyle)resourceStyles.getAt(i);
            if (resourceStyle2 == null || resourceStyle2.getIsPrivate() == 1) continue;
            resourceStyle2.setIsPrivate(1);
            resourceStyle2.save(user);
        }
    }

    public void setResoruceStylePrivate(ContentStyle contentStyle) throws WCMException {
        if (contentStyle == null) {
            return;
        }
        if (contentStyle.getPageStyleId() != 0) {
            return;
        }
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter("", "SRCCONTENTSTYLEID=?", "");
        wCMFilter.addSearchValues(contentStyle.getId());
        ContentStyles contentStyles = ContentStyles.openWCMObjs(user, wCMFilter);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle2 = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle2 == null || contentStyle2.getIsPrivate() == 1) continue;
            contentStyle2.setIsPrivate(0);
            contentStyle2.save(user);
        }
    }
}

