/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import java.util.HashMap;

public abstract class PublishContentImplBase
implements IPublishContent {
    protected IPublishFolder m_folder = null;
    protected IPublishFolder m_realHome = null;
    protected Template m_oDetailTemplate = null;
    protected int m_nDetailTemplateType;

    public boolean isFolder() {
        return false;
    }

    public IPublishFolder getFolder() {
        return this.m_folder;
    }

    public void setFolder(IPublishFolder iPublishFolder) {
        this.m_folder = iPublishFolder;
        this.m_oDetailTemplate = null;
        this.m_realHome = null;
    }

    public String getEncoding() throws WCMException {
        return this.m_folder.getEncoding();
    }

    public IPublishFolder getRealHome() throws WCMException {
        if (this.m_realHome == null) {
            if (Math.abs(this.getModal()) == 3) {
                this.m_realHome = this.m_folder;
                if (this.m_realHome == null) {
                    throw new WCMException(1100, "Current folder where this content lies required (call setFolder())!");
                }
            } else {
                this.m_realHome = this.getOriginalHome();
                if (this.m_realHome == null) {
                    throw new WCMException(1100, "Original home folder of content not found!");
                }
            }
        }
        return this.m_realHome;
    }

    public HashMap getTemplateArguments() throws WCMException {
        IPublishFolder iPublishFolder = this.getFolder();
        if (iPublishFolder == null) {
            return null;
        }
        return iPublishFolder.getTemplateArguments();
    }

    public Template getDetailTemplate() {
        if (this.m_oDetailTemplate == null) {
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            Template template = null;
            try {
                template = templateEmployMgr.getDetailTemplate(this, this.getDetailTemplateType());
            }
            catch (Exception exception) {
                throw new RuntimeException(I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label1", "\u83b7\u53d6\u6a21\u677f[") + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label2", "]\u5931\u8d25!"), exception);
            }
            if (template == null) {
                if (this.m_folder == null) {
                    throw new RuntimeException("[" + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label3", "]\u6ca1\u6709\u8bbe\u7f6e\u6240\u5c5e\u680f\u76ee"));
                }
                try {
                    template = this.getModal() == 2 ? this.getOriginalHome().getDetailTemplate() : this.m_folder.getDetailTemplate();
                }
                catch (WCMException wCMException) {
                    throw new RuntimeException(I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label4", "\u83b7\u53d6[") + this.getInfo() + I18NMessage.get(PublishContentImplBase.class, "PublishContentImplBase.label5", "]\u7684Modal\u53d1\u751f\u5f02\u5e38!"), wCMException);
                }
            }
            this.m_oDetailTemplate = template;
        }
        return this.m_oDetailTemplate;
    }

    public int getDetailTemplateType() {
        if (this.m_nDetailTemplateType <= 0) {
            this.m_nDetailTemplateType = 2;
        }
        return this.m_nDetailTemplateType;
    }

    public void setDetailTemplateType(int n) {
        this.m_nDetailTemplateType = n;
    }

    public String getInfo() {
        return this.getSubstance().toString();
    }

    public boolean canDoPreview() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPublishContent)) {
            return false;
        }
        IPublishContent iPublishContent = (IPublishContent)object;
        return this.getType() == iPublishContent.getType() && this.getId() == iPublishContent.getId();
    }

    public int getId() {
        if (this.getSubstance() == null) {
            return 0;
        }
        return this.getSubstance().getId();
    }

    public boolean isLink() {
        return false;
    }

    public String getLinkUrl() {
        return null;
    }

    public int getModal() throws WCMException {
        return 1;
    }

    public boolean validateCanDoPub() throws WCMException {
        return true;
    }

    public boolean isValidElement() {
        return true;
    }

    public CMyDateTime getCreatedTime() {
        return this.getSubstance().getCrTime();
    }

    public boolean isFile() {
        return false;
    }

    public String getFileName() {
        return null;
    }

    public FileNamedStyle getFileNamedStyle() {
        return PublishServerConfigMapper.getDetailFileNamedStyle("CommonFileNamedStyle");
    }
}

