/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ImgRec;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.template.CSSResourceProcessor;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TempApdRel;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateMgr {
    private static final String ATTRIBUTE_IGNOREAPD = "IGNOREAPD";
    private static final String ATTRIBUTE_RELATED = "RELATED";
    private static final String ATTRIBUTE_OLDID = "OLDID";
    private static final String ATTRIBUTE_OLDSRC = "OLDSRC";
    private static final char CHAR_QUOTE = '\"';
    private static Logger s_logger = Logger.getLogger(TemplateMgr.class);
    private TemplateParseMgr m_parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
    private Reports m_oReports;

    public Template save(Template template, String string, boolean bl, int n) throws WCMException {
        return this.save(template, new HashMap(), bl, n, true);
    }

    public Template save(Template template, HashMap hashMap, boolean bl, int n, boolean bl2) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label1", "\u5f53\u524d\u6a21\u677f\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4fdd\u5b58!"));
        }
        this.validate(template);
        try {
            boolean bl3 = template.isAddMode();
            boolean bl4 = !bl3 && template.isChangeProperty("TEMPTEXT");
            this.prepareSave(template, hashMap, bl, n);
            if (bl4) {
                template.setParsed(false);
            }
            template.save(ContextHelper.getLoginUser());
            if (bl2) {
                if (bl3) {
                    this.m_parseMgr.notifyTemplateAdded(template);
                } else if (bl4) {
                    this.m_parseMgr.notifyTemplateModified(template);
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label22", "\u4fdd\u5b58\u6a21\u677f\u5931\u8d25."), exception);
        }
        return template;
    }

    public boolean delete(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        template.clearAppendixes();
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        templateEmployMgr.clearEmploysOfTemplate(template);
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        templateParseMgr.notifyTemplateDeleted(template);
        ICacheMgr iCacheMgr = (ICacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        iCacheMgr.notifyOnDelObj(template, 3);
        return template.delete(ContextHelper.getLoginUser()) == 1;
    }

    public String preview(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label2", "\u65e0\u6548\u7684\u6a21\u677f\u5bf9\u8c61,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String string = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 1, true);
        return template.getTextWithImgFilter(string, true);
    }

    public TempAppendixes getTempAppendixesInRoot(int n, int n2, WCMFilter wCMFilter) throws WCMException {
        try {
            String string = "ROOTID=" + n2 + " AND ROOTTYPE=" + n;
            WCMFilter wCMFilter2 = new WCMFilter("", string, "");
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            TempAppendixes tempAppendixes = new TempAppendixes(ContextHelper.getLoginUser());
            tempAppendixes.open(wCMFilter2);
            return tempAppendixes;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query and fetch template appendixes in the folder root!", exception);
        }
    }

    public Templates getManagedTemplates(IPublishFolder iPublishFolder, int n, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        try {
            Object object;
            Object object2;
            IPublishElements iPublishElements;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = iPublishFolder.getType();
            int n3 = iPublishFolder.getId();
            if (iPublishFolder.isRoot() && bl) {
                stringBuffer.append("ROOTTYPE= ?");
                stringBuffer.append(" AND ROOTID= ?");
            } else {
                stringBuffer.append("FOLDERTYPE= ?");
                stringBuffer.append(" AND FOLDERID= ?");
            }
            if (n != -1) {
                stringBuffer.append(" AND TEMPTYPE= ?");
            }
            WCMFilter wCMFilter2 = new WCMFilter("", stringBuffer.toString(), "");
            wCMFilter2.addSearchValues(n2);
            wCMFilter2.addSearchValues(n3);
            if (n != -1) {
                wCMFilter2.addSearchValues(n);
            }
            stringBuffer.setLength(0);
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            Templates templates = new Templates(ContextHelper.getLoginUser());
            templates.open(wCMFilter2);
            if (bl && !iPublishFolder.isRoot() && (iPublishElements = iPublishFolder.getChildren()) != null) {
                for (int i = 0; i < iPublishElements.size(); ++i) {
                    object2 = (IPublishFolder)iPublishElements.get(i);
                    if (object2.isDeleted() || (object = this.getManagedTemplates((IPublishFolder)object2, n, wCMFilter, true)) == null || ((BaseObjs)object).isEmpty()) continue;
                    templates.addWith((BaseObjs)object);
                    ((BaseObjs)object).clear();
                }
            }
            if (iPublishFolder.isRoot() && bl) {
                for (int i = templates.size() - 1; i >= 0; --i) {
                    object2 = (Template)templates.getAt(i);
                    if (object2 == null) {
                        templates.removeAt(i, false);
                        continue;
                    }
                    object = ((Template)object2).getFolder();
                    if (object != null && !object.isDeleted()) continue;
                    templates.removeAt(i, false);
                }
            }
            return templates;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query and fetch the managed templates in folder!", exception);
        }
    }

    public Templates getOptionalTemplates(IPublishFolder iPublishFolder, int n, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid folder required!");
        }
        try {
            Templates templates = this.getManagedTemplates(iPublishFolder, n, wCMFilter, false);
            if (bl && !iPublishFolder.isRoot()) {
                for (IPublishFolder iPublishFolder2 = iPublishFolder.getParent(); iPublishFolder2 != null; iPublishFolder2 = iPublishFolder2.getParent()) {
                    Templates templates2 = this.getManagedTemplates(iPublishFolder2, n, wCMFilter, false);
                    if (templates2 == null || templates2.isEmpty()) continue;
                    templates.addWith(templates2);
                    templates2.clear();
                }
            }
            return templates;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query and fetch the optional templates in folder!", exception);
        }
    }

    public Reports redistributeAppendixes(IPublishFolder iPublishFolder, boolean bl) throws WCMException {
        int n = -1;
        Templates templates = this.getManagedTemplates(iPublishFolder, n, null, bl);
        return this.redistributeAppendixes(templates);
    }

    public Reports redistributeAppendixes(Templates templates) {
        Reports reports = new Reports("");
        if (templates == null || templates.size() <= 0) {
            reports.setTitle(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label3", "\u4e0d\u5b58\u5728\u9700\u8981\u91cd\u65b0\u5206\u53d1\u9644\u4ef6\u7684\u6a21\u677f\u3002"));
            reports.addWarnedReport(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label4", "\u4e0d\u5b58\u5728\u9700\u8981\u91cd\u65b0\u5206\u53d1\u9644\u4ef6\u7684\u6a21\u677f"), null);
            return reports;
        }
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            try {
                this.m_parseMgr.uploadAppendixes(template, true);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label5", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f[{0}]\u7684\u9644\u4ef6\u6210\u529f"), new Object[]{template}));
                continue;
            }
            catch (Exception exception) {
                s_logger.error((Object)("redistribute appendixes failed for template:" + template), (Throwable)exception);
                reports.addFailedReport(CMyString.format(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label7", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f[{0}]\u7684\u9644\u4ef6\u5931\u8d25"), new Object[]{template}), exception);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label8", "\u91cd\u65b0\u5206\u53d1\u6a21\u677f\u9644\u52a0\u6210\u529f\uff01\n"));
        stringBuffer.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label9", "\u6210\u529f\u5206\u53d1["));
        stringBuffer.append(reports.getSucessedReporter().size());
        stringBuffer.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label10", "]\u4e2a\u6a21\u677f\uff1b\u6709["));
        stringBuffer.append(reports.getFailedReporter().size());
        stringBuffer.append(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label11", "]\u4e2a\u6a21\u677f\u5931\u8d25\u3002"));
        reports.setTitle(stringBuffer.toString());
        templates.clear();
        return reports;
    }

    public void updateNestedTemplateName(Templates templates, String string, String string2) throws WCMException {
        if (templates == null || templates.size() <= 0) {
            return;
        }
        if (string == null || (string = string.trim()).length() <= 0) {
            throw new IllegalArgumentException("Source template name is null.");
        }
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            throw new IllegalArgumentException("Target template name is null.");
        }
        for (int i = 0; i < templates.size(); ++i) {
            TagItem tagItem;
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            TagDocument tagDocument = null;
            try {
                tagDocument = this.m_parseMgr.parse(template);
            }
            catch (Exception exception) {
                s_logger.info((Object)("Template[" + template + "] has parse error:"), (Throwable)exception);
                continue;
            }
            boolean bl = false;
            Iterator iterator = tagDocument.findItems("TRS_TEMPLATE");
            while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
                if (!string.equals(tagItem.getAttribute("TEMPNAME"))) continue;
                tagItem.setAttribute("TEMPNAME", string2);
                bl = true;
            }
            if (!bl) continue;
            template.setText(tagDocument.toString());
            template.save();
        }
    }

    private void validate(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label12", "\u6a21\u677f\u4e3a\u7a7a\uff01"));
        }
        if (template.getName() == null || template.getName().trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label13", "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff01"));
        }
        if (template.getRootId() == 0) {
            throw new WCMException(1106, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label14", "\u6a21\u677f\u6240\u5c5e\u7ad9\u70b9\u6ca1\u6709\u8bbe\u7f6e\uff01"));
        }
    }

    private Template prepareSave(Template template, HashMap hashMap, boolean bl, int n) throws Exception {
        if (template == null) {
            throw new WCMException(20, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label15", "\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (template.getName() == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label16", "\u6a21\u677f\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        template = this.processContent(template, hashMap, bl, n);
        this.setDefaultTypeIfNecessary(template);
        return template;
    }

    private void setDefaultTypeIfNecessary(Template template) throws WCMException {
        if (template.isAddMode() && template.getProperty("TEMPTYPE") == null) {
            template.setType(Template.guessTypeByName(template.getName()));
        }
    }

    private Template processContent(Template template, HashMap hashMap, boolean bl, int n) throws Exception {
        if (!bl) {
            return template;
        }
        if (!template.isAddMode() && template.getNewProperty("TEMPTEXT") == null) {
            return template;
        }
        Template template2 = template;
        String string = this.getNewContent(template2, hashMap, n);
        template2.setProperty("TEMPTEXT", new CDBText(DBManager.getDBManager().getDBTypeAsInt(), string));
        return template2;
    }

    private String getNewContent(Template template, HashMap hashMap, int n) throws Exception {
        if (template.isAddMode()) {
            template.setNextId();
        }
        if ("XML".equalsIgnoreCase(template.getFinalPropertyAsString("TEMPEXT", "htm"))) {
            return this.getContent(template);
        }
        String[] stringArray = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] stringArray2 = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        String string = this.getContent(template);
        if (stringArray == null || stringArray2 == null) {
            return string;
        }
        String string2 = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        HashMap hashMap2 = new HashMap(5, 1.0f);
        boolean[] blArray = new boolean[1];
        HtmlElementFinder htmlElementFinder = null;
        int n2 = stringArray.length > stringArray2.length ? stringArray2.length : stringArray.length;
        for (int i = 0; i < n2; ++i) {
            htmlElementFinder = new HtmlElementFinder(string);
            HtmlElement htmlElement = null;
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            while ((htmlElement = htmlElementFinder.findNextElement(string3, true)) != null) {
                String string5 = htmlElement.getAttributeValue(string4);
                if (!CMyString.isEmpty(string5) && htmlElement.getAttribute(ATTRIBUTE_IGNOREAPD) == null) {
                    Object object;
                    String string6;
                    int n3 = string5.lastIndexOf(92);
                    if (n3 < 0) {
                        n3 = string5.lastIndexOf(47);
                    }
                    String string7 = string5.substring(n3 + 1);
                    ImgRec imgRec = (ImgRec)hashMap2.get(string5);
                    if (imgRec != null) {
                        this.setElementAttribute(htmlElement, string4, imgRec);
                    } else if (this.isExistsTemplateApdRelation(template.getId(), htmlElement, string4)) {
                        this.putNewHTMLRecord(hashMap2, string5, Integer.parseInt(htmlElement.getAttributeValue(ATTRIBUTE_OLDID)), htmlElement.getAttributeValue(ATTRIBUTE_OLDSRC));
                        if (n == 1 && !CMyString.isEmpty(string6 = (String)hashMap.get(string7.toLowerCase()))) {
                            CMyFile.copyFile(string6, string2 + string7);
                            blArray[0] = true;
                            object = htmlElement.getAttributeValue("type");
                            if ("link".equals(string3.toLowerCase()) && "text/css".equalsIgnoreCase((String)object)) {
                                this.processCSSFile(string7, template, hashMap, n, hashMap2, blArray);
                            }
                        }
                    } else {
                        this.removeExtraAttributes(htmlElement);
                        string6 = (String)hashMap.get(CMyFile.extractFileName(string5, null).toLowerCase());
                        object = null;
                        object = CMyString.isEmpty(string6) ? this.processAppendix(template, string5, null, string2, n, blArray) : this.processAppendix(template, string5, CMyFile.extractFilePath(string6), string2, n, blArray);
                        if (object == null) {
                            htmlElement.setAttribute(string4, string5);
                        } else {
                            String string8 = htmlElement.getAttributeValue("type");
                            if ("link".equals(string3.toLowerCase()) && "text/css".equalsIgnoreCase(string8)) {
                                this.processCSSFile(string7, template, hashMap, n, hashMap2, blArray);
                            }
                            String string9 = ((TempAppendix)object).getFile();
                            htmlElement.setAttribute(ATTRIBUTE_OLDSRC, string9, '\"');
                            htmlElement.setAttribute(ATTRIBUTE_OLDID, String.valueOf(((BaseObj)object).getId()), '\"');
                            htmlElement.setAttribute(string4, string9, '\"');
                            htmlElement.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
                            this.putNewHTMLRecord(hashMap2, string5, ((BaseObj)object).getId(), string9);
                        }
                    }
                }
                htmlElementFinder.putElement(htmlElement);
            }
            string = htmlElementFinder.getContent();
        }
        this.delTempApdRel(template, hashMap2);
        if (blArray[0]) {
            template.setApdModified(true);
        }
        if (htmlElementFinder == null) {
            return string;
        }
        return htmlElementFinder.getContent();
    }

    private void processCSSFile(String string, Template template, HashMap hashMap, int n, HashMap hashMap2, boolean[] blArray) throws WCMException, CMyException {
        String string2 = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
        CSSResourceProcessor cSSResourceProcessor = new CSSResourceProcessor();
        String string3 = string2 + string;
        if (!CMyFile.fileExists(string3)) {
            return;
        }
        String string4 = CharsetDetector.detect(string3);
        String string5 = null;
        try {
            string5 = CMyFile.readFile(string3, string4);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label17", "\u8bfb\u53d6\u6837\u5f0f\u6587\u4ef6\u5931\u8d25\uff01[File=") + string + "]", exception);
        }
        String string6 = cSSResourceProcessor.processConent(string5, hashMap, string2);
        if (string6 == null) {
            return;
        }
        String[] stringArray = cSSResourceProcessor.getRelateFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            TempAppendix tempAppendix;
            String string7 = stringArray[i];
            String string8 = string2;
            if (!hashMap.isEmpty() && hashMap.containsKey(string7.toLowerCase())) {
                string8 = CMyFile.extractFilePath((String)hashMap.get(string7.toLowerCase()));
            }
            if ((tempAppendix = this.processAppendix(template, string7, string8, string2, n, blArray)) == null) continue;
            this.putNewHTMLRecord(hashMap2, string7, tempAppendix.getId(), string7);
        }
        CMyFile.writeFile(string2 + string, string6, string4);
    }

    private void removeExtraAttributes(HtmlElement htmlElement) {
        htmlElement.removeAttribute(ATTRIBUTE_RELATED);
        htmlElement.removeAttribute(ATTRIBUTE_OLDSRC);
        htmlElement.removeAttribute(ATTRIBUTE_OLDID);
    }

    private void putNewHTMLRecord(HashMap hashMap, String string, int n, String string2) {
        ImgRec imgRec = new ImgRec();
        imgRec.oldId = n;
        imgRec.pubSrc = imgRec.oldSrc = string2;
        hashMap.put(string, imgRec);
    }

    private boolean isExistsTemplateApdRelation(int n, HtmlElement htmlElement, String string) throws WCMException {
        int n2;
        String string2 = htmlElement.getAttributeValue(ATTRIBUTE_OLDSRC);
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            return false;
        }
        try {
            n2 = Integer.parseInt(htmlElement.getAttributeValue(ATTRIBUTE_OLDID));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string3 = TemplateMgr.extractFileName(htmlElement.getAttributeValue(string), null);
        if (!string2.equalsIgnoreCase(string3)) {
            return false;
        }
        TempAppendix tempAppendix = TempAppendix.findById(n2);
        if (tempAppendix == null || !tempAppendix.getFile().equals(string3)) {
            return false;
        }
        DBManager dBManager = DBManager.getDBManager();
        String string4 = "select TempId from WCMTempApdRel where TempId=? and AppendixId=?";
        return dBManager.sqlExecuteIntQuery(string4, new int[]{n, n2}) > 0;
    }

    private TempAppendix processAppendix(Template template, String string, String string2, String string3, int n, boolean[] blArray) throws WCMException {
        File file;
        if (!this.isValidRes(string)) {
            return null;
        }
        String string4 = this.getFullFileNameFrom(string, string2);
        if ((string4 = this.copyAppendixFile(string4, string3, n)) == null) {
            string4 = TemplateMgr.extractFileName(string, null);
        }
        if (!(file = new File(string3 + string4)).exists() || file.isDirectory()) {
            return null;
        }
        TempAppendix tempAppendix = this.getTemplateAppendix(template.getRootType(), template.getRootId(), string4);
        boolean bl = false;
        if (tempAppendix == null) {
            tempAppendix = template.addAppendix(ContextHelper.getLoginUser(), string4, false);
            bl = true;
        } else {
            boolean bl2 = bl = !this.hasTempApdRel(template, tempAppendix);
        }
        if (bl) {
            this.addTempApdRel(template, tempAppendix);
            if (!blArray[0]) {
                blArray[0] = true;
            }
        }
        return tempAppendix;
    }

    private boolean isValidRes(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return false;
        }
        if (string.indexOf(46) < 0) {
            return false;
        }
        return !FileHelper.isForbidFileExt(string);
    }

    private String copyAppendixFile(String string, String string2, int n) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        if (this.isFromHttp(string)) {
            return this.copyAppendixFileViaHttp(string, string2, n);
        }
        return this.copyAppendixFileFromLocal(string, string2, n);
    }

    private String copyAppendixFileFromLocal(String string, String string2, int n) throws WCMException {
        if (!CMyFile.fileExists(string)) {
            s_logger.warn((Object)(string + " not exists!"));
            return null;
        }
        String string3 = CMyFile.extractFileName(string);
        if ((string3 = this.processFileNameIfNecessary(string3, string2, n)) != null) {
            try {
                CMyFile.copyFile(string, string2 + string3);
            }
            catch (CMyException cMyException) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.error((Object)("failed to copy a local file[" + string + "]!"), (Throwable)cMyException);
                }
                s_logger.warn((Object)("failed to copy a local file[" + string + "]!"));
            }
        }
        return string3;
    }

    private String copyAppendixFileViaHttp(String string, String string2, int n) throws WCMException {
        String string3 = CMyFile.extractHttpFileName(string);
        if ((string3 = this.processFileNameIfNecessary(string3, string2, n)) != null) {
            try {
                CMy3WLib.getFile(string, string2 + string3);
            }
            catch (CMyException cMyException) {
                s_logger.error((Object)("failed to get the file via http[" + string + "]"), (Throwable)cMyException);
            }
        }
        return string3;
    }

    private String processFileNameIfNecessary(String string, String string2, int n) throws WCMException {
        if (CMyFile.fileExists(string2 + string)) {
            switch (n) {
                case 1: {
                    return string;
                }
                case 3: {
                    return this.getNewFileName(string, string2);
                }
                case 2: {
                    return null;
                }
                case 4: {
                    throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label18", "\u5b58\u5728\u540c\u540d\u7684\u6587\u4ef6[") + string + "]");
                }
            }
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label19", "\u65e0\u6548\u7684\u9644\u4ef6\u5904\u7406\u7c7b\u578b!"));
        }
        return string;
    }

    private String getNewFileName(String string, String string2) {
        int n = string.indexOf(".");
        String string3 = string.substring(0, n);
        String string4 = string.substring(n, string.length());
        int n2 = 1;
        while (CMyFile.fileExists(string2 + string)) {
            string = string3 + "_" + n2 + string4;
            ++n2;
        }
        return string;
    }

    private String getFullFileNameFrom(String string, String string2) {
        if (this.isFromHttp(string)) {
            return string;
        }
        if (this.isAbsoluteFile(string) || CMyString.isEmpty(string2)) {
            return string;
        }
        if (this.isAbsoluteFile(string2)) {
            return string2;
        }
        if (File.separator != "/") {
            string = CMyString.replaceStr(string, "/", File.separator);
        }
        return string2 + CMyFile.extractFileName(string);
    }

    private boolean isAbsoluteFile(String string) {
        if (CMyString.isEmpty(string)) {
            return false;
        }
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    private void setElementAttribute(HtmlElement htmlElement, String string, ImgRec imgRec) {
        htmlElement.setAttribute(ATTRIBUTE_OLDSRC, imgRec.oldSrc, '\"');
        if (imgRec.oldId > 0) {
            htmlElement.setAttribute(ATTRIBUTE_OLDID, String.valueOf(imgRec.oldId), '\"');
        }
        htmlElement.setAttribute(string, imgRec.pubSrc, '\"');
        htmlElement.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
    }

    private String getContent(Template template) {
        String string = "";
        string = template.isAddMode() ? template.getText() : template.getNewPropertyAsString("TEMPTEXT");
        return string;
    }

    private void delTempApdRel(Template template, HashMap hashMap) {
        String string = this.getUsedPicIds(hashMap);
        this.delTempApdRel(template, string);
    }

    private String getUsedPicIds(HashMap hashMap) {
        String string = "";
        if (hashMap != null) {
            for (ImgRec imgRec : hashMap.values()) {
                string = string + String.valueOf(imgRec.oldId) + ",";
            }
            hashMap.clear();
        }
        return string.length() > 1 ? string.substring(0, string.length() - 1) : null;
    }

    private boolean isFromHttp(String string) {
        return string.toLowerCase().indexOf("http:") >= 0;
    }

    private TempAppendix getTemplateAppendix(int n, int n2, String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        String string2 = "ROOTID=" + n2 + " AND ROOTTYPE=" + n + " AND APDFILE='" + CMyString.filterForSQL(string) + "'";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        TempAppendixes tempAppendixes = TempAppendixes.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (tempAppendixes == null || tempAppendixes.isEmpty()) {
            return null;
        }
        return (TempAppendix)tempAppendixes.getAt(0);
    }

    private boolean hasTempApdRel(Template template, TempAppendix tempAppendix) throws WCMException {
        if (template == null || tempAppendix == null) {
            throw new WCMException(10, I18NMessage.get(TemplateMgr.class, "TemplateMgr.label20", "\u6a21\u677f\u6216\u9644\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\uff01"));
        }
        try {
            String string = "select count(*) from WCMTempApdRel  where tempid=" + template.getId() + " and appendixid=" + tempAppendix.getId();
            return DBManager.getDBManager().sqlExecuteIntQuery(string) >= 1;
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(TemplateMgr.class, "TemplateMgr.label21", "\u67e5\u8be2\u6a21\u677f\u548c\u6a21\u677f\u9644\u4ef6\u662f\u5426\u5b58\u5728\u5173\u8054\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01") + exception.toString()));
            return false;
        }
    }

    private boolean addTempApdRel(Template template, TempAppendix tempAppendix) throws WCMException {
        TempApdRel tempApdRel = new TempApdRel();
        tempApdRel.setTemplateId(template.getId());
        tempApdRel.setTempAppendixId(tempAppendix.getId());
        tempApdRel.insert();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int delTempApdRel(Template template, String string) {
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        Statement statement = null;
        int[] nArray = CMyString.splitToInt(string, ",");
        try {
            connection = dBManager.getConnection();
            String string2 = "select APPENDIXID,RECID from WCMTEMPAPDREL where TEMPID=?";
            statement = connection.prepareStatement(string2);
            statement.setInt(1, template.getId());
            ResultSet resultSet = statement.executeQuery();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            while (resultSet.next()) {
                if (this.isUsedApd(nArray, resultSet.getInt(1))) continue;
                hashMap.put(new Integer(resultSet.getInt(1)), new Integer(resultSet.getInt(2)));
            }
            resultSet.close();
            statement.close();
            if (hashMap.isEmpty()) {
                int n = 0;
                return n;
            }
            int n = hashMap.size();
            string2 = "delete from WCMTEMPAPDREL where RECID=?";
            statement = connection.prepareStatement(string2);
            Iterator<Object> iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                statement.setInt(1, (Integer)iterator.next());
                statement.executeUpdate();
            }
            statement.close();
            string2 = "select count(RECID) from WCMTEMPAPDREL where APPENDIXID=?";
            statement = connection.prepareStatement(string2);
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                statement.setInt(1, (Integer)iterator.next());
                resultSet = statement.executeQuery();
                if (resultSet.next() && resultSet.getInt(1) > 0) {
                    iterator.remove();
                }
                resultSet.close();
            }
            statement.close();
            if (hashMap.isEmpty()) {
                int n2 = n;
                return n2;
            }
            string2 = "delete from WCMTEMPAPPENDIX where TEMPAPPENDIXID=?";
            statement = connection.prepareStatement(string2);
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                statement.setInt(1, (Integer)iterator.next());
                statement.executeUpdate();
            }
            int n3 = n;
            return n3;
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isUsedApd(int[] nArray, int n) {
        if (nArray.length == 0) {
            return false;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private static String extractFileName(String string, String string2) {
        int n = -1;
        if (string2 == null) {
            n = string.lastIndexOf(File.separatorChar);
            if (n < 0) {
                n = string.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            n = string.lastIndexOf(string2);
        }
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String processTemplateAppendixes(Template template, String string, int n) throws Exception {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        String[] stringArray = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] stringArray2 = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        if (stringArray == null || stringArray2 == null) {
            return string;
        }
        String string2 = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
        string2 = CMyString.setStrEndWith(string2, File.separatorChar);
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        IPublishFolder iPublishFolder = template.getRoot();
        String string3 = CMyString.setStrEndWith(publishPathCompass.getPreviewLocalPath(iPublishFolder), File.separatorChar);
        String string4 = CMyString.setStrEndWith(publishPathCompass.getPublishLocalPath(iPublishFolder), File.separatorChar);
        String[] stringArray3 = new String[]{string3 + "images" + File.separatorChar, string4 + "images" + File.separatorChar};
        HashMap hashMap = new HashMap(5, 1.0f);
        HashMap hashMap2 = new HashMap();
        boolean[] blArray = new boolean[1];
        HtmlElementFinder htmlElementFinder = null;
        int n2 = stringArray.length > stringArray2.length ? stringArray2.length : stringArray.length;
        boolean bl = this.addImgSrcIfNeed(stringArray, stringArray2);
        if (bl) {
            stringArray = this.appendToArray(stringArray, "IMG");
            stringArray2 = this.appendToArray(stringArray2, "SRC");
            ++n2;
        }
        for (int i = 0; i < n2; ++i) {
            htmlElementFinder = new HtmlElementFinder(string);
            HtmlElement htmlElement = null;
            String string5 = stringArray[i];
            String string6 = stringArray2[i];
            while ((htmlElement = htmlElementFinder.findNextElement(string5, true)) != null) {
                String string7;
                String string8 = htmlElement.getAttributeValue(string6);
                if (!(CMyString.isEmpty(string8) || htmlElement.getAttribute(ATTRIBUTE_IGNOREAPD) != null || bl && "IMG".equalsIgnoreCase(string5) && "SRC".equalsIgnoreCase(string6) && CMyString.isEmpty(string7 = htmlElement.getAttributeValue("uploadpic")))) {
                    String string9;
                    String string10;
                    int n3 = string8.lastIndexOf(92);
                    if (n3 < 0) {
                        n3 = string8.lastIndexOf(47);
                    }
                    String string11 = string8.substring(n3 + 1);
                    ImgRec imgRec = (ImgRec)hashMap.get(string8);
                    if (imgRec != null) {
                        this.setElementAttribute(htmlElement, string6, imgRec);
                    } else if (this.isExistsTemplateApdRelation(template.getId(), htmlElement, string6)) {
                        this.putNewHTMLRecord(hashMap, string8, Integer.parseInt(htmlElement.getAttributeValue(ATTRIBUTE_OLDID)), htmlElement.getAttributeValue(ATTRIBUTE_OLDSRC));
                        if (n == 1) {
                            string10 = (String)hashMap2.get(string11.toLowerCase());
                            CMyFile.copyFile(string10, string2 + string11);
                            blArray[0] = true;
                            string9 = htmlElement.getAttributeValue("type");
                            if ("link".equals(string5.toLowerCase()) && "text/css".equalsIgnoreCase(string9)) {
                                this.processCSSFile(string11, template, hashMap2, n, hashMap, blArray);
                            }
                        }
                    } else {
                        Object object;
                        this.removeExtraAttributes(htmlElement);
                        string10 = htmlElement.getAttributeValue("uploadpic");
                        if (!CMyString.isEmpty(string10)) {
                            string9 = FilesMan.getFilesMan().mapFilePath(string10, 0);
                            object = CMyString.setStrEndWith(string9, File.separatorChar) + string10;
                            CMyFile.copyFile((String)object, string2 + string10);
                            string8 = string10;
                        }
                        string9 = (String)hashMap2.get(CMyFile.extractFileName(string8, null).toLowerCase());
                        object = null;
                        object = CMyString.isEmpty(string9) ? this.processAppendix(template, string8, null, string2, n, blArray) : this.processAppendix(template, string8, CMyFile.extractFilePath(string9), string2, n, blArray);
                        this.copyAppendixToDirs(string2, string8, stringArray3);
                        if (object == null) {
                            htmlElement.setAttribute(string6, string8);
                        } else {
                            String string12 = htmlElement.getAttributeValue("type");
                            if ("link".equals(string5.toLowerCase()) && "text/css".equalsIgnoreCase(string12)) {
                                this.processCSSFile(string11, template, hashMap2, n, hashMap, blArray);
                            }
                            String string13 = ((TempAppendix)object).getFile();
                            htmlElement.setAttribute(ATTRIBUTE_OLDSRC, string13, '\"');
                            htmlElement.setAttribute(ATTRIBUTE_OLDID, String.valueOf(((BaseObj)object).getId()), '\"');
                            htmlElement.setAttribute(string6, string13, '\"');
                            htmlElement.setAttribute(ATTRIBUTE_RELATED, "1", '\"');
                            this.putNewHTMLRecord(hashMap, string8, ((BaseObj)object).getId(), string13);
                        }
                    }
                }
                htmlElementFinder.putElement(htmlElement);
            }
            string = htmlElementFinder.getContent();
        }
        if (blArray[0]) {
            template.setApdModified(true);
        }
        if (htmlElementFinder == null) {
            return string;
        }
        return htmlElementFinder.getContent();
    }

    private boolean addImgSrcIfNeed(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length > stringArray2.length ? stringArray2.length : stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            if (!"img".equalsIgnoreCase(string) || !"src".equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    private void copyAppendixToDirs(String string, String string2, String[] stringArray) throws CMyException {
        String string3 = CMyString.replaceStr(string2, "/", File.separator);
        string3 = CMyString.replaceStr(string3, "\\", File.separator);
        string3 = CMyFile.extractFileName(string3);
        String string4 = string + string3;
        for (int i = 0; i < stringArray.length; ++i) {
            if (CMyFile.fileExists(stringArray[i] + string3)) continue;
            stringArray[i] = CMyString.setStrEndWith(stringArray[i], File.separatorChar);
            CMyFile.copyFile(string4, stringArray[i] + string3);
        }
    }

    public String getTextWithImgFilter(Template template, String string, boolean bl) throws WCMException {
        int n;
        if (string == null || string.length() == 0) {
            return "";
        }
        String[] stringArray = new String[]{FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 1, true)};
        String[] stringArray2 = PublishServerConfigMapper.getTemplateTagsHavingSrc();
        String[] stringArray3 = PublishServerConfigMapper.getTemplateTagSrcAttributeNames();
        if (stringArray2 == null || stringArray3 == null) {
            return string;
        }
        boolean bl2 = this.addImgSrcIfNeed(stringArray2, stringArray3);
        int n2 = n = stringArray2.length > stringArray3.length ? stringArray3.length : stringArray2.length;
        if (bl2) {
            stringArray2 = this.appendToArray(stringArray2, "IMG");
            stringArray3 = this.appendToArray(stringArray3, "SRC");
            ++n;
        }
        int n3 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                HtmlElement htmlElement;
                String string2 = stringArray2[i];
                String string3 = stringArray3[i];
                HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string);
                while ((htmlElement = htmlElementFinder.findNextElement(string2, true)) != null) {
                    String string4;
                    if (bl) {
                        htmlElement.removeAttribute("ignoreapd");
                    }
                    if ((string4 = htmlElement.getAttributeValue(ATTRIBUTE_OLDSRC)) != null) {
                        String string5 = stringArray[n3++];
                        string4 = string5 + string4;
                        if (n3 >= stringArray.length) {
                            n3 = 0;
                        }
                        htmlElement.setAttribute(string3, string4);
                        if (bl) {
                            htmlElement.removeAttribute(ATTRIBUTE_OLDSRC);
                            htmlElement.removeAttribute(ATTRIBUTE_OLDID);
                            htmlElement.removeAttribute(ATTRIBUTE_RELATED);
                        }
                    }
                    htmlElementFinder.putElement(htmlElement);
                }
                string = htmlElementFinder.getContent();
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(Template.class, "Template.label21", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6a21\u677f\u6b63\u6587\u5185\u5bb9\u5931\u8d25"), exception);
        }
    }

    private String[] appendToArray(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(new String[]{string}, 0, stringArray2, n, 1);
        return stringArray2;
    }

    public Reports copyVisualTempToChnls(Channels channels, Template template) throws WCMException {
        int n;
        Object object;
        if (template == null || !template.getPropertyAsBoolean("VISUAL", false)) {
            throw new WCMException("\u6e90\u6a21\u677f\u4e3a\u7a7a\uff0c\u6216\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u662f\u53ef\u89c6\u5316\u6a21\u677f\u3002");
        }
        if (channels == null) {
            throw new WCMException("\u8981\u521b\u5efa\u6a21\u677f\u7684\u680f\u76ee\u4e3a\u7a7a\u3002");
        }
        this.m_oReports = new Reports("");
        int n2 = 0;
        Channel channel = new Channel();
        String string = "";
        for (int i = 0; i < channels.size(); ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            try {
                n2 = channel.getId();
                IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, n2);
                object = (Template)template.cloneToNewObj();
                ((Template)object).setName(this.getNewTempName((Template)object));
                ((Template)object).setFolder((IPublishFolder)iPublishElement);
                this.copyWidgetInstances(template, (Template)object);
                n = ((BaseObj)object).getId();
                User user = this.getLoginUser();
                WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
                wCMFolderPublishConfig.setFolderType(101, n2);
                wCMFolderPublishConfig.setDataPath(n2 + "");
                wCMFolderPublishConfig.canEdit(user);
                if (template.getType() == 1) {
                    wCMFolderPublishConfig.setOutlineTemplateId(n + "");
                    wCMFolderPublishConfig.save(user);
                } else {
                    wCMFolderPublishConfig.setDetailTemplateId(n);
                    wCMFolderPublishConfig.save(user);
                }
                this.m_oReports.addSucessedReport("\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u521b\u5efa\u6a21\u677f\u6210\u529f\uff01");
                if (CMyString.isEmpty(string)) {
                    string = n + "";
                    continue;
                }
                string = string + "," + n;
                continue;
            }
            catch (Throwable throwable) {
                this.m_oReports.addFailedReport("\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u521b\u5efa\u6bcd\u677f\u5931\u8d25\uff01", throwable);
                throw new WCMException("\u7c7b\u4f3c\u521b\u5efa\u6a21\u677f\u51fa\u73b0\u5f02\u5e38", throwable);
            }
        }
        this.m_oReports.setTitle("\u7c7b\u4f3c\u521b\u5efa\u53ef\u89c6\u5316\u6a21\u677f");
        String[] stringArray = string.split(",");
        object = new int[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            if (CMyString.isEmpty(stringArray[n])) {
                stringArray[n] = "0";
            }
            object[n] = Integer.parseInt(stringArray[n]);
        }
        this.m_oReports.setResultIds((int[])object);
        return this.m_oReports;
    }

    private String getNewTempName(Template template) throws WCMException {
        String string = template.getName();
        String string2 = string = template.getName().replaceAll("(_\\d+)+", "");
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select max(tempid) from wcmtemplate", new int[0]);
        while (this.existsTempName(string2, template.getRootId(), template.getRootType())) {
            string2 = string + "_" + ++n;
        }
        return string2;
    }

    private boolean existsTempName(String string, int n, int n2) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATE", "TEMPNAME=? and ROOTID=? and ROOTTYPE=?", "", "");
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        return DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter) > 0;
    }

    private void copyWidgetInstances(Template template, Template template2) throws Exception {
        Object object;
        String[] stringArray;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        IWidgetInstParameterMgr iWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
        TagDocument tagDocument = TagDocumentReader.read(template.getText());
        Iterator iterator = tagDocument.findItems("TRS_WIDGET");
        int n = 0;
        while (iterator.hasNext()) {
            TagItem tagItem = (TagItem)iterator.next();
            stringBuffer.append("?,");
            n = tagItem.getIntAttribute("id", 0);
            stringArray = WidgetInstance.findById(n);
            if (stringArray == null) continue;
            object = (WidgetInstance)stringArray.cloneToNewObj();
            ((CMSObj)object).save(this.getLoginUser());
            Map map = iWidgetInstParameterMgr.getParameters((WidgetInstance)stringArray);
            iWidgetInstParameterMgr.addParameters((WidgetInstance)object, map);
            stringBuffer2.append(((BaseObj)object).getId()).append(",");
        }
        if (stringBuffer.length() <= 0) {
            return;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer2.setLength(stringBuffer2.length() - 1);
        tagDocument = TagDocumentReader.read(template2.getText());
        iterator = tagDocument.findItems("TRS_WIDGET");
        int n2 = 0;
        stringArray = stringBuffer2.toString().split(",");
        while (iterator.hasNext()) {
            object = (TagItem)iterator.next();
            ((TagItem)object).setAttribute("id", stringArray[n2]);
            ++n2;
        }
        template2.setText(tagDocument.toString());
        template2.save(this.getLoginUser());
        object = new StringBuffer();
        ((StringBuffer)object).append("update ").append("XWCMWIDGETINSTANCE");
        ((StringBuffer)object).append(" set templateid=? ");
        ((StringBuffer)object).append(" where ").append("WIDGETINSTANCEID");
        ((StringBuffer)object).append(" in (");
        ((StringBuffer)object).append(stringBuffer);
        ((StringBuffer)object).append(")");
        int n3 = template2.getId();
        stringBuffer2.insert(0, n3 + ",");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{((StringBuffer)object).toString()}, CMyString.splitToInt(stringBuffer2.toString(), ","));
        }
        catch (WCMException wCMException) {
            s_logger.info((Object)"\u7c7b\u4f3c\u521b\u5efa\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u6267\u884csql\u66f4\u65b0\u5efa\u7acb\u6a21\u677f\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u7684\u5173\u8054\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)wCMException);
            this.m_oReports.addWarnedReport("\u53ef\u89c6\u5316\u6a21\u677f\u3010" + template2 + "\u3011\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u5173\u8054\u65f6\u51fa\u9519\uff01", wCMException);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

