/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class TemplateArgumentCacheMgr
implements ICacheMgr {
    private static Logger s_logger = Logger.getLogger(TemplateArgumentCacheMgr.class);
    private LRUCacheContainer m_oArgumentCache = new LRUCacheContainer();

    public boolean init() throws WCMException {
        this.m_oArgumentCache.setMaxSize(512);
        return true;
    }

    public boolean reinit() throws WCMException {
        return false;
    }

    public void clear() {
        s_logger.debug((Object)"to clear Template Argument Cache...");
        this.m_oArgumentCache.clear();
        s_logger.debug((Object)"Template Argument Cache is cleared!");
    }

    public String getArgument(IPublishElement iPublishElement, String string) throws WCMException {
        return this.getArgument(iPublishElement.getType(), iPublishElement.getId(), string);
    }

    public String getArgument(int n, int n2, String string) throws WCMException {
        HashMap hashMap = this.getArguments(n, n2);
        if (hashMap != null) {
            return (String)hashMap.get(string);
        }
        return null;
    }

    public HashMap getArguments(IPublishElement iPublishElement) throws WCMException {
        return this.getArguments(iPublishElement.getType(), iPublishElement.getId());
    }

    public HashMap getArguments(int n, int n2) throws WCMException {
        HashMap hashMap = this.getFromCache(n, n2);
        if (hashMap != null) {
            return hashMap;
        }
        return this.loadFromDB(n, n2);
    }

    private HashMap getFromCache(int n, int n2) {
        return (HashMap)this.m_oArgumentCache.get((Object)this.makeHashKey(n, n2));
    }

    private synchronized HashMap loadFromDB(int n, int n2) throws WCMException {
        HashMap hashMap = this.getFromCache(n, n2);
        if (hashMap != null) {
            return hashMap;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("EMPLOYERTYPE=").append(n);
        stringBuffer.append(" and EMPLOYERID=").append(n2);
        WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "");
        TemplateArguments templateArguments = TemplateArguments.createNewInstance(User.getSystem());
        templateArguments.open(wCMFilter);
        hashMap = templateArguments.toHashMapForCache();
        this.m_oArgumentCache.put((Object)this.makeHashKey(n, n2), (Object)hashMap);
        return hashMap;
    }

    private Key makeHashKey(int n, int n2) {
        return new Key(n, n2);
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(baseObj, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label1", "\u65b0\u589e")));
            return;
        }
        TemplateArgument templateArgument = (TemplateArgument)baseObj;
        HashMap hashMap = this.getArguments(templateArgument.getEmployerType(), templateArgument.getEmployerId());
        if (hashMap != null) {
            hashMap.put(templateArgument.getCacheKey(), templateArgument.getArgumentValue());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(baseObj, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label2", "\u5220\u9664")));
            return;
        }
        TemplateArgument templateArgument = (TemplateArgument)baseObj;
        HashMap hashMap = this.getArguments(templateArgument.getEmployerType(), templateArgument.getEmployerId());
        if (hashMap != null) {
            hashMap.remove(templateArgument.getCacheKey());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(baseObj, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label3", "\u4fee\u6539")));
            return;
        }
        TemplateArgument templateArgument = (TemplateArgument)baseObj;
        HashMap hashMap = this.getArguments(templateArgument.getEmployerType(), templateArgument.getEmployerId());
        if (hashMap != null) {
            hashMap.put(templateArgument.getCacheKey(), templateArgument.getNewProperty("ARGUMENTVALUE"));
        }
    }

    private String getListenerTypeErrorMsg(Object object, String string) {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("Listener[");
        stringBuffer.append(this.getClass());
        stringBuffer.append(I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label4", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61["));
        stringBuffer.append(object.getClass());
        stringBuffer.append(I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label5", "]\u7684"));
        stringBuffer.append(string);
        stringBuffer.append('\uff01');
        return stringBuffer.toString();
    }

    private class Key {
        private int m_iType;
        private int m_iId;

        private Key(int n, int n2) {
            this.m_iType = n;
            this.m_iId = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                if (object == this) {
                    return true;
                }
                Key key = (Key)object;
                if (key.m_iType == this.m_iType && key.m_iId == this.m_iId) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.m_iId;
        }
    }
}

