/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class TagParserNewIcon
implements ITagParser {
    private static final Logger s_logger = Logger.getLogger(TagParserNewIcon.class);
    private static final long TIME_UNIT_MINITE = 60000L;
    private static final long TIME_UNIT_HOUR = 3600000L;
    private static final long TIME_UNIT_DAY = 86400000L;
    private static final long TIME_UNIT_WEEK = 604800000L;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_NEWICON");
            tagBeanInfo.setDesc("TRS_NEWICON");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("CRTIME");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TIME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("today");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        long l;
        long l2;
        CMyDateTime cMyDateTime;
        CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
        String string = publishTagContext.getAttribute("FIELD");
        if (string == null || string.length() <= 0) {
            string = "CRTIME";
        }
        if ((cMyDateTime = cMSObj.getPropertyAsDateTime(string)) == null) {
            return null;
        }
        long l3 = cMyDateTime.getTimeInMillis();
        if (l3 > (l2 = System.currentTimeMillis())) {
            s_logger.error((Object)(I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label1", "\u5bf9\u8c61[") + cMyDateTime + I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label2", "]\u7684[") + string + I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label3", "]\u65f6\u95f4\u53d1\u751f\u5728\u672a\u6765:") + new Timestamp(l3)));
            return null;
        }
        String string2 = publishTagContext.getAttribute("TIME");
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            string2 = "day";
        }
        if (l3 > (l = this.getCompareTime(string2))) {
            return TagParseHelper.parseItems(publishTagContext.getTagItem().getChildren(), publishTagContext);
        }
        return null;
    }

    public void clear() {
    }

    private long getCompareTime(String string) {
        if (Character.isDigit(string.charAt(0))) {
            boolean bl = true;
            long l = 0L;
            int n = string.charAt(string.length() - 1);
            if (n <= 57 && n >= 48) {
                n = 32;
            }
            switch (n) {
                case 32: {
                    bl = false;
                    l = 60000L;
                    break;
                }
                case 77: 
                case 109: {
                    l = 60000L;
                    break;
                }
                case 72: 
                case 104: {
                    l = 3600000L;
                    break;
                }
                case 68: 
                case 100: {
                    l = 86400000L;
                    break;
                }
                case 87: 
                case 119: {
                    l = 604800000L;
                    break;
                }
                default: {
                    l = 60000L;
                }
            }
            if (bl) {
                string = string.substring(0, string.length() - 1);
            }
            return System.currentTimeMillis() - l * Long.parseLong(string);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if ("month".equals(string)) {
            calendar.set(5, 1);
            return calendar.getTimeInMillis();
        }
        if ("week".equals(string)) {
            calendar.set(7, 1);
            return calendar.getTimeInMillis();
        }
        if ("week1".equals(string)) {
            calendar.set(7, 2);
            return calendar.getTimeInMillis();
        }
        return calendar.getTimeInMillis();
    }
}

