/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.domain.distribute.PublishDistributionCacheMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import org.apache.log4j.Logger;

public class PublishDistributionMgr {
    private static final Logger s_logger = Logger.getLogger(PublishDistributionMgr.class);
    public static int MAXTARGETS_EACHFOLDER = 2;
    private PublishDistributionCacheMgr m_oCache;

    public static final IFileDistristributor makeDistristributor(PublishDistribution publishDistribution) throws WCMException {
        PublishDistributionTargetType publishDistributionTargetType = null;
        String string = publishDistribution.getTargetType();
        publishDistributionTargetType = PublishServerConfigMapper.lookupDistributionTargetTypeByName(string);
        if (publishDistributionTargetType == null) {
            throw new WCMException(1100, "Unknown publish distribution target type [" + string + "]!");
        }
        IFileDistristributor iFileDistristributor = publishDistributionTargetType.createDistributor();
        try {
            iFileDistristributor.setTargetRoot(publishDistribution);
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to create file distributors!", exception);
        }
        return iFileDistristributor;
    }

    public PublishDistributionMgr() {
        try {
            this.m_oCache = (PublishDistributionCacheMgr)DreamFactory.createObjectById("PublishDistributionCacheMgr");
            MAXTARGETS_EACHFOLDER = PublishServerConfigMapper.getDistributionConfig().getMaxTargetsEachFolder();
            s_logger.info((Object)("load config: MAXTARGETS_EACHFOLDER=" + MAXTARGETS_EACHFOLDER));
        }
        catch (Exception exception) {
            s_logger.error((Object)"Failed to load publish distribution config!", (Throwable)exception);
        }
    }

    public void save(PublishDistribution publishDistribution) throws WCMException {
        if (publishDistribution == null) {
            throw new WCMException(10, "Valid distribution required!");
        }
        if (publishDistribution.isAddMode()) {
            String string = "SELECT COUNT(*) FROM " + publishDistribution.getDbTableName() + " WHERE FolderId=" + publishDistribution.getFolderId() + " AND FolderType=" + publishDistribution.getFolderType();
            int n = DBManager.getDBManager().sqlExecuteIntQuery(string);
            if (n >= MAXTARGETS_EACHFOLDER) {
                throw new WCMException(1100, I18NMessage.get(PublishDistributionMgr.class, "PublishDistributionMgr.label1", "\u5206\u53d1\u76ee\u6807\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u7684\u6700\u5927\u6570[") + MAXTARGETS_EACHFOLDER + I18NMessage.get(PublishDistributionMgr.class, "PublishDistributionMgr.label2", "],\u4e0d\u80fd\u518d\u6dfb\u52a0\u5206\u53d1\u8bbe\u7f6e!"));
            }
        }
        publishDistribution.save(ContextHelper.getLoginUser());
    }

    public void delete(PublishDistribution publishDistribution) throws WCMException {
        if (publishDistribution == null) {
            throw new WCMException(10, "Valid distribution required!");
        }
        publishDistribution.delete(ContextHelper.getLoginUser());
    }

    public PublishDistributions getDistributionsOf(IPublishFolder iPublishFolder, boolean bl, WCMFilter wCMFilter) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        try {
            String string = "FOLDERID=" + iPublishFolder.getId() + " AND FOLDERTYPE=" + iPublishFolder.getType();
            if (bl) {
                string = string + " AND ENABLED=1";
            }
            PublishDistributions publishDistributions = new PublishDistributions(ContextHelper.getLoginUser(), MAXTARGETS_EACHFOLDER, 1);
            WCMFilter wCMFilter2 = new WCMFilter("", string, "");
            wCMFilter2.mergeWith(wCMFilter);
            publishDistributions.open(wCMFilter2);
            return publishDistributions;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the publish distribution settings!", exception);
        }
    }
}

