/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.FileDistributorImpUnion;
import com.trs.components.common.publish.domain.distribute.PublishDistributionCacheMgr;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class FileDistributeShip
implements IClearable {
    private static final Logger s_logger = Logger.getLogger(FileDistributeShip.class);
    private boolean m_zAsyncMode;
    private boolean m_zBatchMode;
    private Map m_oDistributorsCache;
    private PublishDistributionCacheMgr m_oDistributionCache;
    private PublishPathCompass m_pathCompass = null;
    private Comparator compartor = new Comparator(){

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return file.getName().compareTo(file2.getName());
        }
    };

    public FileDistributeShip() {
        this(null);
    }

    public FileDistributeShip(PublishPathCompass publishPathCompass) {
        this.m_oDistributorsCache = new HashMap();
        this.m_pathCompass = publishPathCompass;
        this.m_oDistributionCache = (PublishDistributionCacheMgr)DreamFactory.createObjectById("PublishDistributionCacheMgr");
    }

    public boolean getAsyncMode() {
        return this.m_zAsyncMode;
    }

    public void setAsyncMode(boolean bl) {
        this.m_zAsyncMode = bl;
    }

    public boolean getBatchMode() {
        return this.m_zBatchMode;
    }

    public void setBatchMode(boolean bl) {
        if (bl && this.m_oDistributorsCache == null) {
            this.m_oDistributorsCache = new HashMap();
        }
        this.m_zBatchMode = bl;
    }

    public void clear() {
        if (this.m_oDistributorsCache != null) {
            if (this.m_zBatchMode) {
                for (FileDistributorImpUnion fileDistributorImpUnion : this.m_oDistributorsCache.values()) {
                    if (fileDistributorImpUnion == null) continue;
                    this.m_oDistributionCache.removeChangeListener(fileDistributorImpUnion);
                }
            }
            this.m_oDistributorsCache.clear();
            this.m_oDistributorsCache = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDistributorImpUnion getRootDistributorUnion(IPublishFolder iPublishFolder) throws WCMException {
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        if (!this.m_zBatchMode) {
            return this.m_oDistributionCache.getDistributorUnion(iPublishFolder2);
        }
        String string = PublishDistributionCacheMgr.makeCaheKey(iPublishFolder2.getType(), iPublishFolder2.getId());
        FileDistributorImpUnion fileDistributorImpUnion = (FileDistributorImpUnion)this.m_oDistributorsCache.get(string);
        if (fileDistributorImpUnion == null) {
            Map map = this.m_oDistributorsCache;
            synchronized (map) {
                fileDistributorImpUnion = (FileDistributorImpUnion)this.m_oDistributorsCache.get(string);
                if (fileDistributorImpUnion == null && (fileDistributorImpUnion = this.m_oDistributionCache.getDistributorUnion(iPublishFolder2)) != null) {
                    this.m_oDistributionCache.addChangeListener(fileDistributorImpUnion);
                    this.m_oDistributorsCache.put(string, fileDistributorImpUnion);
                }
            }
        }
        return fileDistributorImpUnion;
    }

    private String getFullDataPath(IPublishElement iPublishElement) throws WCMException {
        if (this.m_pathCompass == null) {
            return PublishPathCompass.calFullDataPath(iPublishElement, false);
        }
        return this.m_pathCompass.getFullDataPath(iPublishElement, false);
    }

    public int distributeFile(String string, IPublishElement iPublishElement) throws WCMException {
        return this.distributeFile(string, iPublishElement, null);
    }

    public int distributeFile(String string, IPublishElement iPublishElement, String string2) throws WCMException {
        return this.distributeFile(string, iPublishElement, string2, false);
    }

    public int distributeFile(String string, IPublishElement iPublishElement, String string2, boolean bl) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        try {
            FileDistributorImpUnion fileDistributorImpUnion;
            IPublishFolder iPublishFolder;
            String string3 = this.getFullDataPath(iPublishElement);
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                string3 = string3 + CMyString.setStrEndWith(string2, '/');
            }
            if ((iPublishFolder = iPublishElement.getFolder()) == null) {
                s_logger.warn((Object)("can't find folder of:" + iPublishElement.getInfo()));
                if (iPublishElement instanceof IPublishContent) {
                    s_logger.info((Object)"PublishContent instance,use originalhome!");
                    iPublishFolder = ((IPublishContent)iPublishElement).getRealHome();
                }
            }
            if ((fileDistributorImpUnion = this.getRootDistributorUnion(iPublishFolder)) == null) {
                int n = 0;
                return n;
            }
            fileDistributorImpUnion.distributeFile(string, string3, bl);
            int n = fileDistributorImpUnion.size();
            return n;
        }
        catch (Exception exception) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label4", "\u5206\u53d1[{0}]\u4e0a\u7684\u6587\u4ef6[{1}]\u5931\u8d25\uff01"), new String[]{iPublishElement.getInfo(), string}), exception);
        }
        finally {
            debugTimer.stop();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("distribute the file [" + string + "] of [" + iPublishElement.getInfo() + "] use [" + debugTimer.getTime() + "]ms"));
            }
        }
    }

    public void distributeFileDir(String string, IPublishElement iPublishElement, String string2, boolean bl) throws WCMException {
        File file = new File(string);
        if (!(file.exists() && file.canRead() && file.isDirectory())) {
            return;
        }
        File[] fileArray = file.listFiles();
        Arrays.sort(fileArray, this.compartor);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.distributeFileDir(file2.getAbsolutePath(), iPublishElement, string2, bl);
                continue;
            }
            this.distributeFile(file2.getAbsolutePath(), iPublishElement, string2, bl);
        }
    }

    public int withdrawFolder(IPublishFolder iPublishFolder) throws WCMException {
        try {
            FileDistributorImpUnion fileDistributorImpUnion = this.getRootDistributorUnion(iPublishFolder);
            if (fileDistributorImpUnion == null) {
                return 0;
            }
            fileDistributorImpUnion.withdrawPath(this.getFullDataPath(iPublishFolder));
            return fileDistributorImpUnion.size();
        }
        catch (Exception exception) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label1", "\u64a4\u9500\u53d1\u5e03[{0}]\u5931\u8d25\uff01"), new String[]{iPublishFolder.getInfo()}), exception);
        }
    }

    public int withdrawFolder(IPublishFolder iPublishFolder, List list) throws WCMException {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        try {
            FileDistributorImpUnion fileDistributorImpUnion = this.getRootDistributorUnion(iPublishFolder);
            if (fileDistributorImpUnion == null) {
                return 0;
            }
            int n = 0;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                String string = (String)list.get(i);
                if (File.separatorChar != '/') {
                    string = string.replace(File.separatorChar, '/');
                }
                fileDistributorImpUnion.withdrawPath(string);
                n += fileDistributorImpUnion.size();
            }
            return n;
        }
        catch (Exception exception) {
            throw new WCMException(236, "Failed to withdraw the " + iPublishFolder.getInfo(), exception);
        }
    }

    public int withdrawFile(String string, IPublishElement iPublishElement) throws WCMException {
        return this.withdrawFile(string, iPublishElement, this.getFullDataPath(iPublishElement));
    }

    public int withdrawFile(String string, IPublishElement iPublishElement, String string2) throws WCMException {
        try {
            IPublishFolder iPublishFolder = iPublishElement.getFolder();
            FileDistributorImpUnion fileDistributorImpUnion = this.getRootDistributorUnion(iPublishFolder);
            if (fileDistributorImpUnion == null) {
                return 0;
            }
            fileDistributorImpUnion.withdrawFile(string, string2);
            return fileDistributorImpUnion.size();
        }
        catch (Exception exception) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label2", "\u5220\u9664[{0}]\u5931\u8d25\uff01"), new String[]{string}), exception);
        }
    }

    public int renameFile(IPublishFolder iPublishFolder, String string, String string2) throws WCMException {
        return this.renameFile(iPublishFolder, string, string2, this.getFullDataPath(iPublishFolder));
    }

    public int renameFile(IPublishFolder iPublishFolder, String string, String string2, String string3) throws WCMException {
        try {
            FileDistributorImpUnion fileDistributorImpUnion = this.getRootDistributorUnion(iPublishFolder);
            if (fileDistributorImpUnion == null) {
                return 0;
            }
            fileDistributorImpUnion.renameFile(string, string2, string3);
            return fileDistributorImpUnion.size();
        }
        catch (Exception exception) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label3", "\u4e3a{0}\u8def\u5f84{1}\u7684\u6587\u4ef6{2}\u91cd\u547d\u540d\u4e3a{3}\u5931\u8d25\uff01"), new String[]{iPublishFolder.getInfo(), string3, string, string2}), exception);
        }
    }
}

