/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.config;

import com.trs.components.common.publish.config.persistent.TargetTypeConfig;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.AttributesString;

public class PublishDistributionTargetType {
    private String m_sName;
    private String m_sDesc;
    private String m_sDistributorClassName;
    private AttributesString m_parameters;
    private Class m_classDistributor = null;

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, "Valid name required!");
        }
        this.m_sName = string;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String string) {
        this.m_sDesc = string;
    }

    public String getDistributorClassName() {
        return this.m_sDistributorClassName;
    }

    public void setParameters(String string) {
        if (this.m_parameters == null) {
            this.m_parameters = new AttributesString(string);
        } else {
            this.m_parameters.setAttributes(string);
        }
    }

    public AttributesString getParameters() {
        return this.m_parameters;
    }

    public void setDistributorClassName(String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, "Distributor class name required!");
        }
        if (this.m_classDistributor != null && this.m_sDistributorClassName.equals(string)) {
            return;
        }
        this.m_sDistributorClassName = string;
        try {
            this.m_classDistributor = Class.forName(string);
        }
        catch (Exception exception) {
            throw new WCMException(11, "Invalid distributor class: " + string, exception);
        }
    }

    public IFileDistristributor createDistributor() throws WCMException {
        try {
            return (IFileDistristributor)this.m_classDistributor.newInstance();
        }
        catch (Exception exception) {
            throw new WCMException(11, "Failed to create distributor instance for " + this.m_sDistributorClassName, exception);
        }
    }

    public void fromConfigElement(TargetTypeConfig targetTypeConfig) throws WCMException {
        if (targetTypeConfig == null) {
            throw new WCMException(10, "Valid CMyXMLElement object required!");
        }
        try {
            this.setName(targetTypeConfig.getName());
            this.setDesc(targetTypeConfig.getDesc());
            this.setDistributorClassName(targetTypeConfig.getDistributor());
            this.setParameters(targetTypeConfig.getParameters());
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to read from CMyXMLElement.", exception);
        }
    }

    public String toString() {
        return "Name=" + this.m_sName + "&Desc=" + this.m_sDesc + "&Distributor=" + this.m_sDistributorClassName + "&Parameters=" + this.m_parameters.toString();
    }
}

