/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.MsgQueues;
import com.trs.components.common.message.MsgReceiver;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.tools.TextFilter;
import java.util.HashMap;
import java.util.Map;

public class Message
extends CMSObj {
    private static final int MBODY_MAX_LENGTH = 1000;
    public static final int OBJ_TYPE = 309;
    public static final String DB_TABLE_NAME = "WCMMESSAGE";
    public static final String DB_ID_NAME = "MSGID";
    public static final int FLAG_UNKOWN = -1;
    public static final int FLAG_NODELETE = 0;
    public static final int FLAG_DELETE = 1;
    public static final int FLAG_CALLBOARD = 2;
    public static final int MESSAGE_STATE_NODELETE = 0;
    public static final int MESSAGE_STATE_DELETE = 1;
    public static final int MESSAGE_STATE_CALLBOARD = 2;
    public static final int TYPE_NORM = 1;
    public static final int TYPE_PUBLISH = 2;
    public static final int TYPE_WORKFLOW = 3;
    private Map m_hReceivers;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 309;
    }

    public String getTitle() {
        return (String)this.getProperty("TITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        return this.setProperty("TITLE", string);
    }

    public String getBody() {
        String string = (String)this.getProperty("MBODY");
        return string != null ? string : this.getPropertyAsString("BIGMBODY");
    }

    public boolean setBody(String string) throws WCMException {
        CDBText cDBText = new CDBText(this.getDBManager().getDBType());
        if (this.isBigBody(string)) {
            cDBText.setText(string);
            return this.setProperty("BIGMBODY", cDBText);
        }
        cDBText.setText("");
        this.setProperty("BIGMBODY", cDBText);
        return this.setProperty("MBODY", string);
    }

    private boolean isBigBody(String string) {
        return string.getBytes().length > 1000;
    }

    public CMyDateTime getValidTime() {
        return (CMyDateTime)this.getProperty("VALID");
    }

    public boolean setValidTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(1102, I18NMessage.get(Message.class, "Message.label1", "\u65e0\u6548\u7684\u65e5\u671f\u5bf9\u8c61(Message.setValidTime)"));
        }
        return this.setProperty("VALID", cMyDateTime);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public int getFlag() {
        return this.getPropertyAsInt("FLAG", -1);
    }

    public boolean setFlag(int n) throws WCMException {
        if (n != 1 && n != 0 && n != 2) {
            throw new WCMException(10, I18NMessage.get(Message.class, "Message.label2", "Flag\u503c\u65e0\u6548(Message.setFlag)"));
        }
        return this.setProperty("FLAG", n);
    }

    public boolean isValid() throws WCMException {
        String string = this.getFinalPropertyAsString("BIGMBODY");
        if (CMyString.isEmpty(string)) {
            string = this.getFinalPropertyAsString("MBODY");
        }
        if (!CMyString.isEmpty(string)) {
            string = TextFilter.stripText(string, true);
            this.setBody(string);
        }
        if (this.isAddMode()) {
            if (this.getAllProperty().get("TITLE") == null) {
                throw new WCMException(1106, I18NMessage.get(Message.class, "Message.label3", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Message.isValid)"));
            }
            if (this.m_hReceivers == null) {
                throw new WCMException(1106, I18NMessage.get(Message.class, "Message.label4", "\u6ca1\u6709\u8bbe\u7f6e\u6d88\u606f\u7684\u63a5\u6536\u8005!"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Message.class, "Message.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Message.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            if (this.isBigBody(this.getBody())) {
                this.setBody(this.getBody());
                this.removeProperty("MBODY");
            }
            super.insert(user);
            this.saveReceivers();
        }
    }

    public int delete(User user) throws WCMException {
        String[] stringArray = new String[1];
        try {
            stringArray[0] = "delete from wcmMsgQueue where MsgId=" + this.getId();
            this.getDBManager().sqlExecuteUpdate(stringArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label6", "\u5220\u9664MsgQueue\u6570\u636e\u5931\u8d25\uff08Message.delete\uff09"), exception);
        }
        return super.delete(user);
    }

    public MsgQueues getMsgQueues(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "MsgId=" + this.getId(), "");
        MsgQueues msgQueues = new MsgQueues(user);
        try {
            msgQueues.open(wCMFilter);
            return msgQueues;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label7", "\u53d6\u6240\u53d1\u6d88\u606f\u7684\u4f20\u9012\u4fe1\u606f\u961f\u5217\u65f6\u51fa\u9519(Message.getMsgQueues)"), wCMException);
        }
    }

    public boolean isQueue(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("wcmMsgQueue", "MsgId=" + this.getId(), "", "QueueId");
        MsgQueues msgQueues = new MsgQueues(user);
        try {
            msgQueues.open(wCMFilter);
            boolean bl = !msgQueues.isEmpty();
            msgQueues.clear();
            return bl;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Message.class, "Message.label8", "\u5224\u65ad\u6d88\u606f\u662f\u5426\u5728\u961f\u5217\u4e2d\u65f6\u51fa\u9519(Message.isQueue)"), wCMException);
        }
    }

    public String getSendType() {
        return this.getPropertyAsString("SENDTYPE");
    }

    public boolean setSendTypes(String string) throws WCMException {
        return this.setProperty("SENDTYPE", string);
    }

    public boolean setSendTypes(String[] stringArray) throws WCMException {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) != -1) continue;
            string = string + "," + stringArray[i];
        }
        return this.setProperty("SENDTYPE", string);
    }

    public boolean setDeletedBySender() throws WCMException {
        return this.setProperty("DELETEDBYSENDER", 1L);
    }

    boolean isDeletedBySender() {
        return this.getPropertyAsBoolean("DELETEDBYSENDER", false);
    }

    public static final Message findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Message)BaseObj.findById(Message.class, n);
    }

    public static final Message createNewInstance() throws WCMException {
        return (Message)BaseObj.createNewInstance(Message.class);
    }

    public static final Message findByKey(Object object) throws WCMException {
        return (Message)BaseObj.findByKey(Message.class, object);
    }

    public void setReceivers(int n, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Integer n2 = new Integer(n);
        if (this.m_hReceivers == null) {
            this.m_hReceivers = new HashMap();
        }
        this.m_hReceivers.put(n2, string);
    }

    public Users getReceivers() throws WCMException {
        Object object;
        String string;
        User user = User.getSystem();
        Users users = Users.createNewInstance(user);
        WCMFilter wCMFilter = null;
        String string2 = null;
        if (this.isAddMode()) {
            String string3;
            string = this.getReceiverIds(204);
            if (string != null && string.length() > 0) {
                users.addWith(Users.findByIds(user, string));
            }
            if ((object = this.getReceiverIds(201)) != null && ((String)object).length() > 0) {
                string2 = "EXISTS(SELECT UserId FROM WCMGrpUser WHERE GroupId in(" + (String)object + ") AND WCMUser.UserId=WCMGrpUser.UserId)";
                wCMFilter = new WCMFilter("", string2, "");
                users.addWith(Users.openWCMObjs(user, wCMFilter));
            }
            if ((string3 = this.getReceiverIds(203)) != null && string3.length() > 0) {
                string2 = null;
                if (!string3.equals(String.valueOf(2))) {
                    string2 = "EXISTS(SELECT UserId FROM WCMRoleUser WHERE RoleId in(" + string3 + ") AND WCMUser.UserId=WCMRoleUser.UserId)";
                }
                wCMFilter = new WCMFilter("", string2, "");
                wCMFilter.setWhere(string2);
                users.addWith(Users.openWCMObjs(user, wCMFilter));
            }
        } else {
            string2 = "EXISTS(SELECT UserId FROM WCMGrpUser WHERE EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 201 + " AND WCMGrpUser.GroupId=WCMMsgReceiver.ReceiverId) AND WCMUser.UserId=WCMGrpUser.UserId)";
            wCMFilter = new WCMFilter("", string2, "");
            users.addWith(Users.openWCMObjs(user, wCMFilter));
            string2 = "EXISTS(SELECT UserId FROM WCMRoleUser WHERE EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 203 + " AND WCMRoleUser.RoleId=WCMMsgReceiver.ReceiverId) AND WCMUser.UserId=WCMRoleUser.UserId)";
            wCMFilter.setWhere(string2);
            users.addWith(Users.openWCMObjs(user, wCMFilter));
            string2 = "EXISTS(SELECT ReceiverId FROM WCMMsgReceiver WHERE MsgId=" + this.getId() + " AND ReceiverType=" + 204 + " AND WCMUser.UserId=WCMMsgReceiver.ReceiverId)";
            wCMFilter.setWhere(string2);
            users.addWith(Users.openWCMObjs(user, wCMFilter));
        }
        string = users.getIdListAsString();
        object = new WCMFilter("", "IsDeleted=0 and Status=30 and UserId in (" + string + ")", "");
        users = new Users(user);
        users.open((WCMFilter)object);
        return users;
    }

    private void saveReceivers() throws WCMException {
        this.setReceiverUsers();
        this.setReceiverGroups();
        this.setReceiverRoles();
    }

    private void setReceiverRoles() throws WCMException {
        String string = this.getReceiverIds(203);
        if (string == null || string.length() == 0) {
            return;
        }
        Roles roles = Roles.findByIds(User.getSystem(), string);
        for (int i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null) continue;
            this.saveReceiver(role.getId(), role.getWCMType(), role.getName());
        }
    }

    private void setReceiverGroups() throws WCMException {
        String string = this.getReceiverIds(201);
        if (string == null || string.length() == 0) {
            return;
        }
        Groups groups = Groups.findByIds(User.getSystem(), string);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            this.saveReceiver(group.getId(), group.getWCMType(), group.getName());
        }
    }

    private void setReceiverUsers() throws WCMException {
        String string = this.getReceiverIds(204);
        if (string == null || string.length() == 0) {
            return;
        }
        Users users = Users.findByIds(User.getSystem(), string);
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            this.saveReceiver(user.getId(), user.getWCMType(), user.getName());
        }
    }

    private String getReceiverIds(int n) {
        if (this.m_hReceivers == null) {
            return null;
        }
        return (String)this.m_hReceivers.get(new Integer(n));
    }

    private void saveReceiver(int n, int n2, String string) throws WCMException {
        MsgReceiver msgReceiver = MsgReceiver.createNewInstance();
        msgReceiver.setMsgId(this.getId());
        msgReceiver.setReceiverId(n);
        msgReceiver.setReceiverType(n2);
        msgReceiver.setReceiverName(string);
        msgReceiver.insert();
    }
}

