/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import org.apache.log4j.Logger;

public class TempPathCleaner
extends BaseStatefulScheduleWorker {
    private static Logger s_logger = Logger.getLogger(TempPathCleaner.class);
    private String sFlag;
    private String sPathToClean;
    private int nExpireTime;

    protected boolean analyzeParams() {
        try {
            String string;
            this.sFlag = this.getArgAsString("FLAG");
            this.sPathToClean = CMyString.showNull(this.getArgAsString("PATH"));
            this.nExpireTime = Integer.parseInt(this.getArgAsString("EXPIRE"));
            if (this.nExpireTime <= 0) {
                this.nExpireTime = 1;
            }
            if (this.sFlag == null || this.sFlag.length() == 0) {
                string = ConfigServer.getServer().getInitProperty("WCM_PATH");
            } else {
                string = FilesMan.getFilesMan().getPathConfigValue(this.sFlag, 0);
                if (string == null) {
                    s_logger.error((Object)(I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label1", "\u6307\u5b9a\u7684\u76ee\u5f55\u7c7b\u578b[") + this.sFlag + I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label2", "]\u4e0d\u5bf9\uff01")));
                    return false;
                }
            }
            this.sPathToClean = string + this.sPathToClean;
            if (File.separatorChar != '\\') {
                this.sPathToClean.replace('\\', File.separatorChar);
            }
            this.sPathToClean = CMyString.replaceStr(this.sPathToClean, File.separator + File.separator, File.separator);
            return true;
        }
        catch (Exception exception) {
            s_logger.error((Object)("sFlag=[" + this.sFlag + "] sPathToClean=[" + this.sPathToClean + "] nExpireTime=[" + this.nExpireTime + "]anaylzeParams Exception "), (Throwable)exception);
            return false;
        }
    }

    private void cleanPath(File file, long l) throws WCMException {
        if (file == null) {
            return;
        }
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (file2.lastModified() > l) continue;
                    CMyFile.deleteDir(file2);
                }
            } else if (file.lastModified() <= l) {
                file.delete();
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label3", "\u6e05\u7406\u6307\u5b9a\u76ee\u5f55(") + file.getAbsolutePath() + I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label4", ")\u65f6\u5931\u8d25(TempPathCleaner.cleanPath)"), exception);
        }
    }

    protected void execute() {
        if (!this.analyzeParams()) {
            s_logger.error((Object)I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label5", "\u6e05\u9664\u76ee\u5f55\u7684\u8c03\u5ea6\u5206\u6790\u53c2\u6570\u5931\u8d25\uff01"));
            return;
        }
        try {
            File file = new File(this.sPathToClean);
            if (!file.exists()) {
                s_logger.error((Object)(I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label6", "\u6307\u5b9a\u9700\u8981\u7ef4\u62a4\u7684\u76ee\u5f55[") + this.sPathToClean + I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label7", "]\u4e0d\u5b58\u5728\uff01")));
                return;
            }
            s_logger.info((Object)(I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label8", "\u7ef4\u62a4\u76ee\u5f55[") + this.sPathToClean + I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label9", "]\u4e2d\u8fc7\u671f\u6587\u4ef6\uff01")));
            CMyDateTime cMyDateTime = CMyDateTime.now();
            cMyDateTime.dateAdd(3, -this.nExpireTime);
            this.cleanPath(file, cMyDateTime.getTimeInMillis());
            s_logger.info((Object)I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label10", "==* [\u7ef4\u62a4\u76ee\u5f55\u8fc7\u671f\u6587\u4ef6]\u4efb\u52a1\u5df2\u5b8c\u6210 *=="));
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label11", "\u5b9a\u65f6\u6e05\u9664[") + this.sPathToClean + I18NMessage.get(TempPathCleaner.class, "TempPathCleaner.label12", "]\u5931\u8d25!")), (Throwable)exception);
            return;
        }
    }
}

