/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.message.MessageServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class EventLCListenerForRemind
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!this.isListening(baseObj)) {
            return;
        }
        Event event = (Event)baseObj;
        int n2 = event.getRemindMsgId();
        if (n2 <= 0) {
            return;
        }
        MessageServer.delete(this.getLoginUser(), "" + n2);
        String string = CMyString.filterForSQL(I18NMessage.get(EventLCListenerForRemind.class, "EventLCListenerForRemind.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + n2 + "]");
        Schedule schedule = this.findByName(string);
        if (schedule != null) {
            schedule.delete(this.getLoginUser());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!this.isListening(baseObj)) {
            return;
        }
        Event event = (Event)baseObj;
        int n2 = event.getRemindMsgId();
        if (n2 <= 0) {
            return;
        }
        boolean bl = event.isChangeProperty("ESTART");
        boolean bl2 = event.isChangeProperty("AHEADREMDTIME");
        if (!bl2 && !bl) {
            return;
        }
        int n3 = 0;
        n3 = bl2 ? event.getNewPropertyAsInt("AHEADREMDTIME", 0) : event.getAheadRemindTime();
        CMyDateTime cMyDateTime = null;
        cMyDateTime = bl ? (CMyDateTime)event.getNewProperty("ESTART") : event.getStartTime();
        CMyDateTime cMyDateTime2 = (CMyDateTime)cMyDateTime.clone();
        try {
            cMyDateTime2 = cMyDateTime2.dateAdd(5, n3 * -1);
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
        }
        String string = CMyString.filterForSQL(I18NMessage.get(EventLCListenerForRemind.class, "EventLCListenerForRemind.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + n2 + "]");
        Schedule schedule = this.findByName(string);
        if (schedule != null) {
            schedule.canEdit(this.getLoginUser());
            schedule.setExeTime(cMyDateTime2);
            schedule.save(this.getLoginUser());
        }
    }

    private boolean isListening(BaseObj baseObj) {
        return baseObj != null && baseObj instanceof Event;
    }

    private Schedule findByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SCHNAME='" + string + "'", "");
        wCMFilter.setMaxRowNumber(1);
        Schedules schedules = Schedules.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (schedules.isEmpty()) {
            return null;
        }
        return (Schedule)schedules.getAt(0);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

