/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowdocLog;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.process.element.FlowContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FlowingDocLogger {
    public static final int ACTION_FLAG_NORMAL = 0;
    public static final int ACTION_FLAG_PREPROCESS = 1;
    private static Logger logger = Logger.getLogger(FlowingDocLogger.class);

    private FlowingDocLogger() {
    }

    public static void info(FlowContext flowContext, String string) {
        try {
            IFlowContent iFlowContent = flowContext.getFlowContent();
            FlowDoc flowDoc = flowContext.getCurrFlowDoc();
            if (flowDoc == null || iFlowContent == null) {
                return;
            }
            if (iFlowContent instanceof FlowContentDocumentImpl) {
                FlowingDocLogger.logDocument(flowContext, string, iFlowContent, flowDoc);
            } else if (iFlowContent.getClass().getName().equals("com.trs.components.wcm.process.element.FlowContentApplyFormImpl")) {
                FlowingDocLogger.logApplyForm(flowContext, string, iFlowContent, flowDoc);
            }
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
    }

    private static void logDocument(FlowContext flowContext, String string, IFlowContent iFlowContent, FlowDoc flowDoc) {
        try {
            Document document = ((FlowContentDocumentImpl)iFlowContent).getDocument();
            if (document == null) {
                return;
            }
            String string2 = string;
            FlowNodeBranch flowNodeBranch = flowContext.getBranch();
            if (string2 == null && flowNodeBranch != null && flowNodeBranch.isOperationMarkEnable()) {
                string2 = flowNodeBranch.getOperationMark();
            }
            FlowdocLog flowdocLog = new FlowdocLog();
            if (!CMyString.isEmpty(string2)) {
                flowdocLog.setActionDesc(string2);
            }
            if (flowNodeBranch != null) {
                flowdocLog.setBranchId(flowNodeBranch.getId());
            }
            flowdocLog.setActionFlag(FlowingDocLogger.getActionFlag(string));
            flowdocLog.setFlowdocId(flowDoc.getId());
            flowdocLog.setStarting(flowContext.isStarting());
            User user = flowContext.getPostUser();
            if (user != null) {
                flowdocLog.setPostUser(user.getName());
            }
            flowdocLog.setObjId(document.getId());
            flowdocLog.setObjType(605);
            flowdocLog.setChannelId(document.getChannelId());
            Groups groups = null;
            Group group = null;
            if (user != null && !(groups = user.getGroups()).isEmpty() && (group = (Group)groups.getAt(0)) != null) {
                flowdocLog.setUserGroupId(group.getId());
            }
            flowdocLog.save(ContextHelper.getLoginUser());
        }
        catch (Throwable throwable) {
            logger.warn((Object)(I18NMessage.get(FlowingDocLogger.class, "FlowingDocLogger.label1", "\u8bb0\u5f55\u5de5\u4f5c\u6d41\u8f6c\u7684\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff01") + throwable.getMessage()));
        }
    }

    private static void logApplyForm(FlowContext flowContext, String string, IFlowContent iFlowContent, FlowDoc flowDoc) {
        try {
            String string2 = string;
            FlowNodeBranch flowNodeBranch = flowContext.getBranch();
            if (string2 == null && flowNodeBranch != null && flowNodeBranch.isOperationMarkEnable()) {
                string2 = flowNodeBranch.getOperationMark();
            }
            FlowdocLog flowdocLog = new FlowdocLog();
            if (!CMyString.isEmpty(string2)) {
                flowdocLog.setActionDesc(string2);
            }
            if (flowNodeBranch != null) {
                flowdocLog.setBranchId(flowNodeBranch.getId());
            }
            flowdocLog.setActionFlag(FlowingDocLogger.getActionFlag(string));
            flowdocLog.setFlowdocId(flowDoc.getId());
            flowdocLog.setStarting(flowContext.isStarting());
            User user = flowContext.getPostUser();
            if (user != null) {
                flowdocLog.setPostUser(user.getName());
            }
            flowdocLog.setObjId(iFlowContent.getId());
            flowdocLog.setObjType(iFlowContent.getType());
            flowdocLog.setChannelId(0);
            Groups groups = null;
            Group group = null;
            if (user != null && !(groups = user.getGroups()).isEmpty() && (group = (Group)groups.getAt(0)) != null) {
                flowdocLog.setUserGroupId(group.getId());
            }
            flowdocLog.save(ContextHelper.getLoginUser());
        }
        catch (Throwable throwable) {
            logger.warn((Object)(I18NMessage.get(FlowingDocLogger.class, "FlowingDocLogger.label1", "\u8bb0\u5f55\u5de5\u4f5c\u6d41\u8f6c\u7684\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff01") + throwable.getMessage()));
        }
    }

    private static int getActionFlag(String string) {
        if (CMyString.isEmpty(string)) {
            return 0;
        }
        return 1;
    }
}

