/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.OperType;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public final class OperTypeHelper {
    private static final Integer UNKNOWN = new Integer(0);
    private static final HashMap ADD_OPS = new HashMap(20, 0.5f);
    private static final HashMap MODIFY_OPS = new HashMap(20, 0.5f);
    private static final HashMap DELETE_OPS = new HashMap(20, 0.5f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAddOp(BaseObj baseObj) {
        Class<?> clazz = baseObj.getClass();
        Integer n = (Integer)ADD_OPS.get(clazz.getName());
        if (n == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                n = OperTypeHelper.find("\u65b0\u5efa" + OperTypeHelper.getTypeName(baseObj));
                if (n != UNKNOWN) {
                    ADD_OPS.put(clazz.getName(), n);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModifyOp(BaseObj baseObj) {
        Class<?> clazz = baseObj.getClass();
        Integer n = (Integer)MODIFY_OPS.get(clazz.getName());
        if (n == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                n = OperTypeHelper.find("\u4fee\u6539" + OperTypeHelper.getTypeName(baseObj));
                if (n != UNKNOWN) {
                    MODIFY_OPS.put(clazz.getName(), n);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeleteOp(BaseObj baseObj) {
        Class<?> clazz = baseObj.getClass();
        Integer n = (Integer)DELETE_OPS.get(clazz.getName());
        if (n == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                n = OperTypeHelper.find("\u5220\u9664" + OperTypeHelper.getTypeName(baseObj));
                if (n != UNKNOWN) {
                    DELETE_OPS.put(clazz.getName(), n);
                }
            }
        }
        return n;
    }

    private static String getTypeName(BaseObj baseObj) {
        String string = WCMTypes.getObjName(baseObj.getWCMType(), true);
        if ("\u672a\u77e5".equals(string) || "unknown".equals(string.toLowerCase())) {
            string = baseObj.getClassName(false);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer find(String string) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = "select OPERTYPEID from WCMOPERTYPE where NAME=?";
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Integer n = new Integer(resultSet.getInt(1));
                return n;
            }
        }
        catch (Exception exception) {
            Integer n = UNKNOWN;
            return n;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
        try {
            OperType operType = new OperType();
            operType.setName(string);
            operType.setDesc(string);
            operType.setProperty("CRUSER", "system");
            operType.setProperty("CRTIME", CMyDateTime.now());
            operType.save();
            return new Integer(operType.getId());
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    protected void finalize() throws Throwable {
        ADD_OPS.clear();
        MODIFY_OPS.clear();
        DELETE_OPS.clear();
        super.finalize();
    }
}

