/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.Locker;
import com.trs.cms.content.LockerMgr;
import com.trs.cms.content.WCMHandler;
import com.trs.cms.content.WCMObjsHandler;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WCMObjHelper {
    private static Logger logger = Logger.getLogger(WCMObjHelper.class);

    public static CMSObj toWCMObj(String string, CMSObj cMSObj) throws WCMException {
        if (string == null || string.length() <= 0) {
            return null;
        }
        Reader reader = null;
        try {
            WCMHandler wCMHandler = new WCMHandler(cMSObj);
            reader = WCMObjHelper.getReader(CMyString.filterForJDOM(string));
            WCMObjHelper.parseXMLFile(new InputSource(reader), wCMHandler, false);
            CMSObj cMSObj2 = wCMHandler.getWCMObj();
            cMSObj2.removeProperty(cMSObj2.getIdFieldName());
            cMSObj2.removeProperty("CRUSER");
            cMSObj2.removeProperty("CRTIME");
            CMSObj cMSObj3 = cMSObj2;
            return cMSObj3;
        }
        catch (Exception exception) {
            throw new WCMException(1104, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label1", "\u8bbe\u7f6e\u5bf9\u8c61[") + cMSObj.getClassName(false) + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label2", "]\u5bf9\u8c61ID[") + cMSObj.getId() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label3", "]\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static CMSObj toWCMObj(String string, User user, int n, Class clazz) throws WCMException {
        if (string == null || string.length() <= 0) {
            return null;
        }
        CMSObj cMSObj = null;
        try {
            cMSObj = (CMSObj)BaseObj.createNewInstance(clazz);
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label4", "\u4ea7\u751f\u6307\u5b9a\u5bf9\u8c61[") + clazz.getName() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label5", "]\u7684\u5b9e\u4f8b\u5931\u8d25\uff01"), exception);
        }
        if (n > 0) {
            cMSObj = WCMObjHelper.findAndLockWCMObj(user, cMSObj, n);
        }
        try {
            return WCMObjHelper.toWCMObj(string, cMSObj);
        }
        catch (WCMException wCMException) {
            if (!cMSObj.isAddMode()) {
                cMSObj.cancelUpdate(user);
            }
            throw wCMException;
        }
    }

    public static List toWCMObjList(String string, CMSObj cMSObj, User user) throws Exception {
        if (string == null || string.length() <= 0) {
            return null;
        }
        WCMObjsHandler wCMObjsHandler = new WCMObjsHandler(cMSObj);
        WCMObjHelper.parseXMLFile(new InputSource(WCMObjHelper.getReader(string)), wCMObjsHandler, false);
        List list = wCMObjsHandler.getWCMObjList();
        BaseObj baseObj = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            baseObj = (BaseObj)list.get(i);
            if (baseObj.getProperty(baseObj.getIdFieldName()) == null) continue;
            int n = baseObj.getPropertyAsInt(baseObj.getIdFieldName(), 0);
            if (n > 0) {
                CMSObj cMSObj2 = WCMObjHelper.findAndLockWCMObj(user, baseObj, n);
                cMSObj2.setNewProperties(baseObj.getProperties());
                list.remove(i);
                list.add(i, cMSObj2);
                baseObj = cMSObj2;
            }
            baseObj.removeProperty(baseObj.getIdFieldName());
        }
        return list;
    }

    private static void parseXMLFile(InputSource inputSource, DefaultHandler defaultHandler, boolean bl) throws WCMException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.newSAXParser().parse(inputSource, defaultHandler);
        }
        catch (SAXException sAXException) {
            throw new WCMException(150, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label6", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff01") + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.debug((Object)("ParserConfigurationException:" + parserConfigurationException.getMessage()));
        }
        catch (IOException iOException) {
            logger.debug((Object)("IOException:" + iOException.getMessage()));
        }
    }

    public static String toIdsString(List list) {
        return WCMObjHelper.toIdsString(list, ",");
    }

    public static String toIdsString(List list, String string) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(list.size() * (20 + string.length()));
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BaseObj baseObj = (BaseObj)list.get(i);
            if (baseObj == null) continue;
            stringBuffer.append(baseObj.getId());
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - string.length());
        }
        return stringBuffer.toString();
    }

    public static String concatProperties(BaseObjs baseObjs, String string) {
        return WCMObjHelper.concatProperties(baseObjs, string, ",");
    }

    public static String concatProperties(BaseObjs baseObjs, String string, String string2) {
        if (baseObjs == null || baseObjs.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(baseObjs.size() * (20 + string2.length()));
        int n = baseObjs.size();
        for (int i = 0; i < n; ++i) {
            String string3;
            BaseObj baseObj = baseObjs.getAt(i);
            if (baseObj == null || CMyString.isEmpty(string3 = baseObj.getPropertyAsString(string))) continue;
            stringBuffer.append(string3);
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - string2.length());
        }
        return stringBuffer.toString();
    }

    public static void unlock(int n, int n2, User user) throws WCMException, CMyException {
        LockerMgr lockerMgr = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        Locker locker = lockerMgr.getLocker(n, n2, false);
        if (locker == null) {
            return;
        }
        if (locker.lockUserIs(user)) {
            lockerMgr.removeLocker(n, n2);
            return;
        }
        throw new WCMException("[" + user + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label7", "]\u4e0d\u80fd\u89e3\u9501[") + locker.getLockUser() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label8", "]\u9501\u5b9a\u7684\u5bf9\u8c61[Type=") + n + ",Id=" + n2 + "]");
    }

    private static CMSObj findAndLockWCMObj(User user, BaseObj baseObj, int n) throws WCMException {
        CMSObj cMSObj = (CMSObj)BaseObj.findById(baseObj.getClass(), n);
        if (cMSObj == null) {
            throw new WCMException(200006, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label9", "\u7c7b\u578b\u4e3a[") + baseObj.getClassName(false) + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label10", "],ID\u4e3a[") + n + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label11", "]\u7684\u5bf9\u8c61\u6ca1\u6709\u627e\u5230!"));
        }
        if (!cMSObj.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label12", "\u5bf9\u8c61\u5df2\u7ecf\u88ab\u7528\u6237[") + cMSObj.getLockerUserName() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label13", "]\u9501\u5b9a\uff01\u4e0d\u80fd\u88ab\u4fee\u6539"));
        }
        return cMSObj;
    }

    private static Reader getReader(String string) {
        return new StringReader(string);
    }
}

