/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.LockManager;
import com.trs.cms.content.Locker;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class LockerMgr {
    private static Logger s_logger = Logger.getLogger(LockerMgr.class);
    protected Hashtable hLockers = new Hashtable();
    private boolean m_bClusterStarted = true;

    public LockerMgr() {
        TRSWCMClusterServer tRSWCMClusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        this.m_bClusterStarted = tRSWCMClusterServer.getContext() != null && tRSWCMClusterServer.getContext().getConfig().isEnabled();
    }

    public Locker getLocker(CMSObj cMSObj, boolean bl) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLocker(cMSObj, bl);
        }
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            return null;
        }
        return this.getLocker(cMSObj.getWCMType(), cMSObj.getId(), bl);
    }

    public Locker getLocker(int n, int n2, boolean bl) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLocker(n, n2, bl);
        }
        try {
            Hashtable hashtable = this.getLockersOfType(n, bl);
            if (hashtable == null) {
                return null;
            }
            Integer n3 = new Integer(n2);
            Locker locker = (Locker)hashtable.get(n3);
            if (locker == null && bl) {
                locker = new Locker();
                hashtable.put(n3, locker);
            }
            return locker;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Locker removeLocker(CMSObj cMSObj) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().removeLocker(cMSObj);
        }
        if (cMSObj == null || this.hLockers == null) {
            return null;
        }
        return this.removeLocker(cMSObj.getWCMType(), cMSObj.getId());
    }

    public Locker removeLocker(int n, int n2) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().removeLocker(n, n2);
        }
        try {
            if (this.hLockers == null) {
                return null;
            }
            Hashtable hashtable = this.getLockersOfType(n, false);
            if (hashtable == null) {
                return null;
            }
            return (Locker)hashtable.remove(new Integer(n2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLockedObjIds(int n) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLockedObjIds(n);
        }
        Hashtable hashtable = this.getLockersOfType(n, false);
        String string = "";
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = string + "," + enumeration.nextElement();
            }
            if (string.length() > 0) {
                string = string.substring(1);
            }
        }
        return string;
    }

    private Hashtable getLockersOfType(int n, boolean bl) {
        Integer n2 = new Integer(n);
        Hashtable hashtable = (Hashtable)this.hLockers.get(n2);
        if (hashtable == null && bl) {
            hashtable = new Hashtable();
            this.hLockers.put(n2, hashtable);
        }
        return hashtable;
    }

    public void freeLockedObjBy(User user) {
        if (this.m_bClusterStarted) {
            LockManager.instance().freeLockedObjBy(user);
            return;
        }
        if (user == null) {
            return;
        }
        try {
            Enumeration enumeration = this.hLockers.elements();
            Hashtable hashtable = null;
            Enumeration enumeration2 = null;
            Locker locker = null;
            Object var6_7 = null;
            while (enumeration.hasMoreElements()) {
                hashtable = (Hashtable)enumeration.nextElement();
                enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    var6_7 = enumeration2.nextElement();
                    locker = (Locker)hashtable.get(var6_7);
                    if (locker == null || !locker.lockUserIs(user)) continue;
                    hashtable.remove(var6_7);
                }
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)("Failed to free object locked by:" + user), (Throwable)exception);
        }
    }
}

