/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.Locker;
import com.trs.cms.content.LockerMgr;
import com.trs.cms.logger.ObjSysLogger;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;

public abstract class CMSObj
extends BaseObj {
    protected User m_oOperator = null;

    public Locker getLocker() {
        return this.getLocker(true);
    }

    protected Locker getLocker(boolean bl) {
        return this.getLocakerMgr().getLocker(this, bl);
    }

    public User getLockerUser() {
        Locker locker = this.getLocker(false);
        if (locker == null) {
            return null;
        }
        return locker.getLockUser();
    }

    public String getLockerUserName() {
        User user = this.getLockerUser();
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    public synchronized boolean isLocked() {
        Locker locker = this.getLocker(false);
        return locker == null ? false : locker.isLocked();
    }

    public synchronized boolean lock(User user, int n) {
        Locker locker = this.getLocker();
        return locker == null ? false : locker.lock(user, n);
    }

    public synchronized boolean lock(User user) {
        Locker locker = this.getLocker();
        return locker == null ? false : locker.lock(user);
    }

    public synchronized boolean unlock() {
        return this.getLocakerMgr().removeLocker(this) != null;
    }

    public String getCrUserName() {
        return (String)this.getProperty("CRUSER");
    }

    public User getCrUser() {
        String string = this.getCrUserName();
        if (CMyString.isEmpty(string)) {
            return null;
        }
        User user = User.findByName(string);
        if (user != null) {
            return user;
        }
        return DeletedUser.get(string);
    }

    public boolean setCrUser(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(CMSObj.class, "CMSObj.label1", "\u5c5e\u6027CrUser\u4e0d\u5141\u8bb8\u4fee\u6539(") + this.getClass().getName() + ".setCrUser)");
        }
        return this.setProperty("CRUSER", string);
    }

    public boolean setCrUser(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(CMSObj.class, "CMSObj.label2", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(") + this.getClass().getName() + ".setCrUser)");
        }
        return this.setCrUser(user.getName());
    }

    protected boolean setCrTime() throws WCMException {
        return this.setProperty("CRTIME", CMyDateTime.now());
    }

    public synchronized void validCanEditAndLock(User user, int n) throws WCMException {
        if (this.canEdit(user, n)) {
            return;
        }
        throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label18", "\u5bf9\u8c61\u5df2\u7ecf\u88ab{0}\u9501\u5b9a, \u60a8\u6b64\u65f6\u4e0d\u80fd\u4fee\u6539\uff01"), new Object[]{this.getLockerUser()}));
    }

    public synchronized void validCanEditAndLock(User user) throws WCMException {
        this.validCanEditAndLock(user, Locker.DEF_LOCKTIMEOUT);
    }

    public synchronized void validCanDeleteAndLock(User user) throws WCMException {
        if (this.canEdit(user, Locker.DEF_LOCKTIMEOUT)) {
            return;
        }
        if (user.isSystem()) {
            return;
        }
        throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label17", "\u5bf9\u8c61\u5df2\u7ecf\u88ab{0}\u9501\u5b9a, \u60a8\u6b64\u65f6\u4e0d\u80fd\u5c06\u5176\u5220\u9664\uff01"), new Object[]{this.getLockerUser()}));
    }

    public synchronized boolean canEdit(User user, int n) {
        return !(this.isLocked() ? !this.getLocker().lockUserIs(user) : !this.lock(user, n));
    }

    public synchronized boolean canEdit(User user) {
        return this.canEdit(user, Locker.DEF_LOCKTIMEOUT);
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode()) {
            String string = null;
            string = "CRUSER";
            if (!this.getAllProperty().containsKey(string) && this.getDBManager().getFieldInfo(this.getDbTableName(), string) != null) {
                this.setCrUser(user);
            }
            string = "CRDEPT";
            if (!this.getAllProperty().containsKey(string) && this.getDBManager().getFieldInfo(this.getDbTableName(), string) != null) {
                IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
                this.setProperty(string, iDepartmentMgr.getDepartmentInfo(user));
            }
            string = "CRTIME";
            if (!this.getAllProperty().containsKey(string) && this.getDBManager().getFieldInfo(this.getDbTableName(), string) != null) {
                this.setCrTime();
            }
        }
        int n = ObjSysLogger.instance().startLogInserting(user, this);
        try {
            this.insert();
        }
        catch (WCMException wCMException) {
            ObjSysLogger.instance().finishLog(n, wCMException);
            throw wCMException;
        }
        ObjSysLogger.instance().finishLog(n, this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void update(User user) throws WCMException {
        try {
            if (!this.isModified()) {
                Object var5_2 = null;
                Locker locker = this.getLocker(false);
                if (locker == null) return;
                if (!locker.isLocked()) return;
                if (!locker.lockUserIs(user)) return;
                this.unlock();
                return;
            }
            if (this.isLocked()) {
                if (!this.getLocker(false).lockUserIs(user)) {
                    throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label12", "\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[{0}] \u9501\u5b9a\u7684\u7528\u6237:[{1}]"), new String[]{user.getName(), this.getLockerUserName()}));
                }
            } else if (!this.lock(user)) {
                throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label14", "\u5bf9\u8c61\u4e0d\u80fd\u9501\u5b9a!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[{0}]"), new String[]{user.getName()}));
            }
            int n = ObjSysLogger.instance().startLogModifying(user, this);
            try {
                super.update();
            }
            catch (WCMException wCMException) {
                ObjSysLogger.instance().finishLog(n, wCMException);
                throw wCMException;
            }
            ObjSysLogger.instance().finishLog(n);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Locker locker = this.getLocker(false);
            if (locker == null) throw throwable;
            if (!locker.isLocked()) throw throwable;
            if (!locker.lockUserIs(user)) throw throwable;
            this.unlock();
            throw throwable;
        }
        Object var5_3 = null;
        Locker locker = this.getLocker(false);
        if (locker == null) return;
        if (!locker.isLocked()) return;
        if (!locker.lockUserIs(user)) return;
        this.unlock();
    }

    public synchronized void cancelUpdate(User user) {
        if (!this.isLocked() || !this.getLocker().lockUserIs(user)) {
            return;
        }
        this.unlock();
        this.cancelUpdate();
    }

    public int delete() throws WCMException {
        User user = User.getSystem();
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.delete(user);
    }

    public int delete(User user) throws WCMException {
        this.validCanDeleteAndLock(user);
        int n = ObjSysLogger.instance().startLogDeleting(user, this);
        try {
            int n2 = super.delete();
            ObjSysLogger.instance().finishLog(n);
            int n3 = n2;
            Object var6_6 = null;
            this.freeLockIfNeed(user);
            return n3;
        }
        catch (WCMException wCMException) {
            try {
                ObjSysLogger.instance().finishLog(n, wCMException);
                throw wCMException;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.freeLockIfNeed(user);
                throw throwable;
            }
        }
    }

    private void freeLockIfNeed(User user) {
        if (user == null) {
            return;
        }
        if (this.isLocked() && user.equals(this.getLockerUser())) {
            this.unlock();
        }
    }

    public void save(User user) throws WCMException {
        if (this.isAddMode()) {
            this.insert(user);
        } else {
            this.update(user);
        }
    }

    public void save() throws WCMException {
        User user = User.getSystem();
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.save(user);
    }

    protected LockerMgr getLocakerMgr() {
        return (LockerMgr)DreamFactory.createObjectById("LockerMgr");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(WCMTypes.getObjName(this.getWCMType(), true));
        stringBuffer.append("[Type=");
        stringBuffer.append(this.getWCMType());
        stringBuffer.append(",Id=");
        stringBuffer.append(this.getId());
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    private static class DeletedUser
    extends User {
        private String name = null;
        private static final Map CAHCE = new HashMap(10, 0.5f);

        private DeletedUser(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static User get(String string) {
            User user = (User)CAHCE.get(string);
            if (user == null) {
                user = new DeletedUser(string);
                Map map = CAHCE;
                synchronized (map) {
                    CAHCE.put(string, user);
                }
            }
            return user;
        }
    }
}

