/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RightSet {
    private Logger logger = Logger.getLogger(this.getClass());

    public boolean setRights(User user, IRightHost iRightHost, List list, boolean bl) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(RightSet.class, "RightSet.label1", "\u8bbe\u7f6e\u6743\u9650"));
        this.setRights(user, iRightHost, list, bl, reports);
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException(I18NMessage.get(RightSet.class, "RightSet.label2", "\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u6743\u9650\u5931\u8d25\uff01\n") + reports.toString());
    }

    private boolean setRights(User user, IRightHost iRightHost, List list, boolean bl, Reports reports) throws WCMException {
        if (iRightHost == null) {
            throw new WCMException(20, I18NMessage.get(RightSet.class, "RightSet.label3", "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6743\u9650\uff01"));
        }
        try {
            iRightHost.validateCanDoSetRight(user);
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(RightSet.class, "RightSet.label4", "\u6ca1\u6709\u6743\u9650\u7ed9 ") + iRightHost.getInfo() + I18NMessage.get(RightSet.class, "RightSet.label5", " \u4f20\u9012\u6743\u9650\u8bbe\u7f6e"), null);
            return false;
        }
        this.deleteRights(user, iRightHost.getSubstance(), WCMObjHelper.toIdsString(list));
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Right right = (Right)list.get(i);
                if (right == null) {
                    this.logger.error((Object)I18NMessage.get(RightSet.class, "RightSet.label6", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (right.getObjType() == 0 || right.getId() <= 0) {
                    right.setObject(iRightHost.getSubstance());
                }
                right.save(user);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(I18NMessage.get(RightSet.class, "RightSet.label7", "\u4fdd\u5b58[") + iRightHost.getSubstance() + "]right[" + i + "]\uff01<BR>"));
            }
        }
        if (!bl) {
            return true;
        }
        IRightHost[] iRightHostArray = iRightHost.getChildren();
        if (iRightHostArray == null || iRightHostArray.length == 0) {
            return true;
        }
        for (IRightHost iRightHost2 : iRightHostArray) {
            if (iRightHost2 == null) continue;
            this.setRights(user, iRightHost2, RightSet.makeNewRightList(list), true, reports);
        }
        return true;
    }

    private boolean deleteRights(User user, CMSObj cMSObj, String string) throws WCMException {
        if (cMSObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(RightSet.class, "RightSet.label8", "\u5220\u9664[") + cMSObj + "][" + string + "]rights...\n<BR>\n"));
        }
        String string2 = "OBJTYPE=? and OBJID=?";
        if (string.length() > 0) {
            string2 = string2 + " and RIGHTID not in (" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(0, cMSObj.getWCMType());
        wCMFilter.addSearchValues(1, cMSObj.getId());
        Rights rights = Rights.openWCMObjs(user, wCMFilter);
        rights.removeAll(true);
        return true;
    }

    private static List makeNewRightList(List list) throws WCMException {
        if (list == null) {
            return null;
        }
        ArrayList<Right> arrayList = new ArrayList<Right>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Right right = (Right)list.get(i);
            if (right == null) continue;
            Right right2 = new Right();
            right2.setValue(right.getValue());
            right2.setOperator(right.getOperatorType(), right.getOperatorId());
            arrayList.add(right2);
        }
        return arrayList;
    }

    public void inheritRights(User user, IRightHost iRightHost, boolean bl) throws WCMException {
        if (iRightHost == null) {
            return;
        }
        IRightHost iRightHost2 = iRightHost.getParent();
        if (iRightHost2 == null) {
            return;
        }
        IRightMgr iRightMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (bl) {
            iRightMgr.getRights(iRightHost.getSubstance()).removeAll(true);
        }
        Rights rights = iRightMgr.getRights(iRightHost2.getSubstance());
        int n = rights.size();
        for (int i = 0; i < n; ++i) {
            Right right = (Right)rights.getAt(i);
            if (right == null) continue;
            Right right2 = (Right)right.cloneToNewObj();
            right2.setObject(iRightHost.getSubstance());
            right2.setAttribute("ISINHERIT", "true");
            right2.insert(user);
        }
    }
}

