/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.util.CMyMemory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RightCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(RightCacheMgr.class);
    public static int MAX_RIGHT_CACHE_SIZE = 3000;
    private HashMap m_hRightCache = null;
    private List m_listRightObjExistsCache = null;
    private static final String HAS_OTHER_RIGHT_SQL = "select RightId from WCMRight where RightId<>? and ObjType=? and ObjId=?";
    private int m_nRightCount = 0;

    public RightValue getRightValue(int n, int n2, int n3, int n4) throws WCMException {
        if (n2 <= 0 || n4 <= 0) {
            return null;
        }
        String string = this.makeKey(n, n2, n3, n4);
        Long l = (Long)this.getRightCache().get(string);
        if (l == null) {
            return null;
        }
        return new RightValue(l);
    }

    public long getRightValue(int n, int n2, int n3, int n4, long l) throws WCMException {
        if (n2 <= 0 || n4 <= 0) {
            return l;
        }
        String string = this.makeKey(n, n2, n3, n4);
        Long l2 = (Long)this.getRightCache().get(string);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public boolean isExistsRight(int n, int n2) throws WCMException {
        if (this.m_listRightObjExistsCache == null) {
            this.init();
        }
        return this.m_listRightObjExistsCache.contains(this.makeRightExistsCacheKey(n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() throws WCMException {
        if (this.m_hRightCache != null) {
            return true;
        }
        RightCacheMgr rightCacheMgr = this;
        synchronized (rightCacheMgr) {
            if (this.m_hRightCache != null) {
                return true;
            }
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label1", "\u542f\u52a8[\u6743\u9650\u7f13\u51b2]\u524d\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label2", "\u6b63\u5728\u542f\u52a8\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668..."));
            this.m_nRightCount = DBManager.getDBManager().sqlExecuteIntQuery("select count(*) from WCMRight");
            this.initRightObjExistCache();
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label3", "\u542f\u52a8[\u6743\u9650\u662f\u5426\u8bbe\u7f6e]\u540e\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
            this.initRightCache();
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label4", "\u542f\u52a8\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668\u6210\u529f\uff01"));
            logger.info((Object)(I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label5", "\u542f\u52a8[\u6743\u9650\u7f13\u51b2]\u540e\u7cfb\u7edf\u5185\u5b58\u72b6\u51b5\uff1a") + CMyMemory.toMemoryInfo()));
        }
        return true;
    }

    private void initRightObjExistCache() throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("select distinct OBJTYPE, OBJID from WCMRight");
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>(this.m_nRightCount);
            while (resultSet.next()) {
                StringBuffer stringBuffer = new StringBuffer(18);
                stringBuffer.append(resultSet.getInt(1));
                stringBuffer.append("_");
                stringBuffer.append(resultSet.getInt(2));
                if (stringBuffer.length() > 18) {
                    logger.error((Object)(stringBuffer + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label6", "\u6ea2\u51fa")));
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer = null;
            }
            this.m_listRightObjExistsCache = arrayList;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to Desc!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close result", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label7", "\u521d\u59cb\u5316[RightObjExistCache]\u5b8c\u6210\uff01"));
        }
    }

    private void initRightCache() throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("select ObjType, ObjId, OprType, OprId, RightValue from WCMRight");
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, Long> hashMap = new HashMap<String, Long>(this.m_nRightCount + 100, 0.98f);
            StringBuffer stringBuffer = new StringBuffer(28);
            while (resultSet.next()) {
                stringBuffer.append(resultSet.getInt("ObjType"));
                stringBuffer.append("_");
                stringBuffer.append(resultSet.getInt("ObjId"));
                stringBuffer.append("_");
                stringBuffer.append(resultSet.getInt("OprType"));
                stringBuffer.append("_");
                stringBuffer.append(resultSet.getInt("OprId"));
                if (stringBuffer.length() > 28) {
                    logger.error((Object)(stringBuffer + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label6", "\u6ea2\u51fa")));
                }
                hashMap.put(stringBuffer.toString(), new Long(resultSet.getLong("RightValue")));
                stringBuffer.delete(0, stringBuffer.length());
            }
            this.m_hRightCache = hashMap;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to Desc!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close result", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label8", "\u521d\u59cb\u5316[RightCache]\u5b8c\u6210\uff01"));
        }
    }

    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return false;
    }

    public void clear() {
        logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label9", "\u6b63\u5728\u5173\u95ed\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668..."));
        if (this.m_hRightCache != null) {
            this.m_hRightCache.clear();
        }
        if (this.m_listRightObjExistsCache != null) {
            this.m_listRightObjExistsCache.clear();
        }
        logger.info((Object)I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label10", "\u5173\u95ed\u6743\u9650\u7f13\u51b2\u670d\u52a1\u5668\u6210\u529f"));
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        int n;
        Right right = (Right)baseObj;
        if (right == null) {
            return;
        }
        int n2 = right.getObjType();
        if (!this.isExistsRight(n2, n = right.getObjId())) {
            this.m_listRightObjExistsCache.add(this.makeRightExistsCacheKey(n2, n));
        }
        this.putRightInCache(right);
    }

    private String makeRightExistsCacheKey(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(18);
        stringBuffer.append(n);
        stringBuffer.append("_");
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private void putRightInCache(Right right) throws WCMException {
        String string = this.makeKey(right.getObjType(), right.getObjId(), right.getOperatorType(), right.getOperatorId());
        Object object = right.getNewProperty("RIGHTVALUE");
        Long l = null;
        if (object == null) {
            l = new Long(right.getValueAsLong());
        } else {
            long l2 = ((Number)object).longValue();
            l = new Long(l2);
        }
        this.getRightCache().put(string, l);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        Object object;
        Right right = (Right)baseObj;
        if (right == null) {
            return;
        }
        if (this.isExistsRight(right.getObjType(), right.getObjId())) {
            object = new int[]{right.getId(), right.getObjType(), right.getObjId()};
            DBManager dBManager = DBManager.getDBManager();
            if (dBManager.sqlExecuteIntQuery(HAS_OTHER_RIGHT_SQL, (int[])object) < 0) {
                this.m_listRightObjExistsCache.remove(this.makeRightExistsCacheKey(right.getObjType(), right.getObjId()));
            }
        }
        object = this.makeKey(right.getObjType(), right.getObjId(), right.getOperatorType(), right.getOperatorId());
        this.getRightCache().remove(object);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Right)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label11", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightCacheMgr.class, "RightCacheMgr.label12", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        this.putRightInCache((Right)baseObj);
    }

    protected HashMap getRightCache() throws WCMException {
        if (this.m_hRightCache == null) {
            this.init();
        }
        return this.m_hRightCache;
    }

    private String makeKey(int n, int n2, int n3, int n4) {
        return n + "_" + n2 + "_" + n3 + "_" + n4;
    }
}

