/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class DepartmentMgrImpl
implements IDepartmentMgr {
    private Group m_oRootGroup = null;

    public Groups getDeptGroups(User user) throws WCMException {
        Groups groups = user.getGroups();
        Groups groups2 = new Groups(null, groups.size(), 1);
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.isDeptGroup(group)) continue;
            groups2.addElement(group);
        }
        return groups2;
    }

    public String getDepartmentInfo(User user) throws WCMException {
        return this.getDepartmentInfo(user, null);
    }

    public String getDepartmentInfo(User user, String string) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label1", "\u6ca1\u6709\u6307\u5b9a\u7528\u6237"));
        }
        String string2 = CMyString.showNull(string, "\\");
        Groups groups = this.getDeptGroups(user);
        if (groups.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer((20 + string2.length()) * 10);
        for (Group group = (Group)groups.getAt(0); group != null && !group.equals(this.m_oRootGroup.getId()); group = group.getParent()) {
            stringBuffer.insert(0, string2);
            stringBuffer.insert(0, group.getName());
        }
        return stringBuffer.toString();
    }

    public Group getRootDepartmentGroup() throws WCMException {
        if (this.m_oRootGroup == null) {
            this.initRootDepartmentGroup();
        }
        return this.m_oRootGroup;
    }

    private synchronized void initRootDepartmentGroup() throws WCMException {
        if (this.m_oRootGroup != null) {
            return;
        }
        String string = ConfigServer.getServer().getSysConfigValue("GROUP_NAME_DEPARTMENT", I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label2", "\u7ec4\u7ec7\u673a\u6784"));
        WCMFilter wCMFilter = new WCMFilter("", "ParentId=0 and GName=?", "");
        wCMFilter.addSearchValues(string);
        Groups groups = Groups.openWCMObjs(null, wCMFilter);
        if (groups.isEmpty()) {
            Group group = Group.createNewInstance();
            group.setParent(0);
            group.setName(string);
            group.setDesc(string);
            group.setCrUser(User.getSystem());
            group.save(User.getSystem());
            this.m_oRootGroup = group;
        } else {
            this.m_oRootGroup = (Group)groups.getAt(0);
        }
        if (this.m_oRootGroup == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label3", "\u7cfb\u7edfCache\u6709\u95ee\u9898\uff0c\u6307\u5b9a\u7684\u7ec4\u7ec7[Name=") + string + I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
        }
    }

    public void reload() throws WCMException {
        this.m_oRootGroup = null;
        this.initRootDepartmentGroup();
    }

    private boolean isDeptGroup(Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        int n = group.getParentId();
        if (n == 0) {
            return false;
        }
        int n2 = this.getRootDepartmentGroup().getId();
        if (n == n2) {
            return true;
        }
        return this.isDeptGroup(Group.findById(n));
    }

    public boolean isDepartmentAdmin(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label1", "\u6ca1\u6709\u6307\u5b9a\u7528\u6237"));
        }
        Groups groups = this.getDeptGroups(user);
        if (groups.isEmpty()) {
            return false;
        }
        Group group = (Group)groups.getAt(0);
        return group.isAdministrator(user);
    }

    public Groups getDeptGroupTree(User user) throws WCMException {
        Groups groups = this.getDeptGroups(user);
        if (groups.isEmpty()) {
            return new Groups(null);
        }
        Group group = this.getRootDepartmentGroup();
        Groups groups2 = new Groups(null);
        Group group2 = (Group)groups.getAt(0);
        groups2.addElement(group2);
        Group group3 = Group.findById(group2.getParentId());
        while (group3 != null && !group3.equals(group)) {
            groups2.addElement(group3);
            group3 = Group.findById(group3.getParentId());
        }
        return groups2;
    }
}

