/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.presentation.locale.LocaleServer;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class WCMProcessServiceHelper {
    public static final String PARAM_FORCE_START = "force2start";

    public static void startDocumentInFlow(User user, Document document, MethodContext methodContext) throws WCMException {
        Object object;
        boolean bl = "true".equals(methodContext.getValue(PARAM_FORCE_START));
        if (!bl) {
            object = ConfigServer.getServer().getSysConfigValue("DOCADD_INTO_FLOW", "true");
            bl = "true".equalsIgnoreCase((String)object);
        }
        if (!bl) {
            return;
        }
        object = FlowContentFactory.makeFlowContent(605, document.getId());
        boolean bl2 = false;
        if (object != null) {
            IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            ContentProcessInfo contentProcessInfo = iFlowServer.getProcessInfoOfContent((IFlowContent)object);
            boolean bl3 = bl2 = (contentProcessInfo.canInFlow() || contentProcessInfo.canReInFlow()) && document.getStatusId() != 1028;
        }
        if (bl2) {
            WCMProcessServiceHelper.startDocumentInFlow(user, document, null, methodContext);
        }
    }

    public static void startDocumentInFlow(User user, Document document, Flow flow, MethodContext methodContext) throws WCMException {
        IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(document);
        int n = methodContext.getValue("FlowId", 0);
        if (flow == null && n > 0) {
            flow = Flow.findById(n);
            document.setAttribute("FlowId", String.valueOf(n));
            document.save();
        }
        if (flow != null) {
            iFlowContent.setFlow(flow);
        }
        FlowContext flowContext = null;
        String string = methodContext.getValue("reflow");
        String string2 = methodContext.getValue("startInFlow");
        if (methodContext.getValue("DefaultFlowModal", true)) {
            if (iFlowContent.getOwnerFlow() == null) {
                if (string != null && string.equals("true") || string2 != null && string2.equals("true")) {
                    throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label13", "\u6587\u6863\u6240\u5728\u7684\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff01"));
                }
                return;
            }
            String string3 = methodContext.getValue("ToUserIds");
            String string4 = methodContext.getValue("PostDesc");
            String string5 = methodContext.getValue("NotifyTypes");
            if (string != null && string.equals("true") || string2 != null && string2.equals("true")) {
                String[] stringArray = null;
                if (!string3.equals("")) {
                    stringArray = string3.split(",");
                }
                Users users = new Users(null);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        User user2 = User.findById(Integer.parseInt(stringArray[i]));
                        users.addElement(user2);
                    }
                }
                flowContext = new FlowContext(user, iFlowContent, string4, users, null);
                flowContext.setNotifyTypes(string5);
            } else {
                flowContext = new FlowContext(user, iFlowContent);
            }
        } else {
            throw new WCMException("Not Implement!");
        }
        flowContext.setPostDesc(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label1", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        iFlowServer.submitTo(flowContext);
    }

    public static void startDocumentInFlow(User user, Document document, boolean bl) throws WCMException {
        if (!bl) {
            throw new WCMException("Not Implement!");
        }
        WCMProcessServiceHelper.startDocumentInFlow(user, document, new HashMap(0));
    }

    public static void startDocumentInFlow(User user, Document document, Map map) throws WCMException {
        IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(document);
        FlowContext flowContext = null;
        if (map == null || map.size() == 0) {
            if (iFlowContent.getOwnerFlow() == null) {
                return;
            }
            flowContext = new FlowContext(user, iFlowContent);
            flowContext.setPostDesc(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label1", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        } else {
            flowContext = WCMProcessServiceHelper.createFlowContextFrom(map, user, iFlowContent);
        }
        iFlowServer.submitTo(flowContext);
    }

    private static FlowContext createFlowContextFrom(Map map, User user, IFlowContent iFlowContent) throws WCMException {
        Users users = null;
        String string = (String)map.get("ToUserIds");
        if (string != null && string.length() != 0) {
            users = Users.findByIds(null, string);
        }
        FlowContext flowContext = new FlowContext(user, iFlowContent);
        flowContext.setCurrUser(user);
        flowContext.setPostUser(user);
        flowContext.setPostDesc((String)map.get("PostDesc"));
        flowContext.setToUsers(users);
        flowContext.setNotifyTypes((String)map.get("NotifyTypes"));
        return flowContext;
    }

    public static void validateWorkFlowRight(User user, BaseObj baseObj, int n, int n2, String string) throws WCMException {
        FlowNode flowNode;
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label3", "\u6307\u5b9a\u7684\u8f68\u8ff9\u4e0d\u5b58\u5728\uff01[FlowDocId=") + n + "]");
        }
        if (baseObj == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label4", "\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01[FlowDocId=") + n + "]");
        }
        if (baseObj.getId() == 0) {
            baseObj = flowDoc.getFlowContent().getSubinstance();
        }
        if (flowDoc.getContentType() != baseObj.getWCMType() || flowDoc.getContentId() != baseObj.getId()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label5", "\u60a8\u662f\u641e\u9b3c\uff0c\u90a3\u662f\u4e0d\u53ef\u80fd\u7684\uff01[FlowDocId=") + flowDoc.getId() + ",Type=" + flowDoc.getContentType() + ",Id=" + flowDoc.getId() + "][ContentType=" + baseObj.getWCMType() + ", Id=" + baseObj.getId() + "]");
        }
        if (flowDoc.getToUserId() != user.getId()) {
            if (n2 >= 0) {
                throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label6", "\u4e8b\u52a1\u5df2\u7ecf\u88ab\u5904\u7406,\u60a8\u4e0d\u80fd\u518d\u8fdb\u884c\u3010") + string + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label7", "\u3011\u64cd\u4f5c"));
            }
            if (!flowDoc.getPostUserName().equals(user.getName())) {
                throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label8", "\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u662f\u60a8\u5904\u7406\u7684\uff01[") + flowDoc.getToUserId() + "]");
            }
        }
        if ((flowNode = flowDoc.getNode()) == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label9", "\u6307\u5b9a\u7684\u8282\u70b9\u4e0d\u5b58\u5728\uff01[NodeId=") + flowDoc.getNodeId() + "]");
        }
        try {
            if (flowNode.isStartNode() && baseObj.getPropertyAsString("CRUSER").equalsIgnoreCase(flowDoc.getToUserNames())) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n2 >= 0 && !flowNode.isCanDoWithDoc(n2)) {
            throw new WCMException(1002, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label10", "\u60a8\u4e0d\u80fd\u8fdb\u884c[") + string + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label11", "]\u64cd\u4f5c\uff01"));
        }
    }

    public static boolean hasFlowingActionRight(User user, int n, int n2) throws WCMException {
        FlowNode flowNode;
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null) {
            return false;
        }
        int n3 = -1;
        switch (n2) {
            case 34: {
                n3 = -1;
                break;
            }
            case 32: {
                n3 = 0;
                break;
            }
            case 33: {
                n3 = 1;
                break;
            }
            case 39: {
                n3 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (flowDoc.getToUserId() != user.getId()) {
            if (n3 >= 0) {
                return false;
            }
            if (!flowDoc.getPostUserName().equals(user.getName())) {
                return false;
            }
        }
        if ((flowNode = flowDoc.getNode()) == null) {
            return false;
        }
        return n3 < 0 || flowNode.isCanDoWithDoc(n3);
    }

    public static Map makeFlowContextInfoMap(String string) {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static String makeFlowContextInfo(Flow flow) throws WCMException {
        String string;
        Object object;
        Object object2;
        if (flow == null) {
            return "";
        }
        FlowNode flowNode = FlowNode.findByName(flow.getId(), flow.getStartNodeName());
        FlowNodes flowNodes = flowNode.getNextNodes(null);
        FlowNode flowNode2 = null;
        if (flowNodes == null || flowNodes.size() == 0 || (flowNode2 = (FlowNode)flowNodes.getAt(0)) == null) {
            throw new WCMException(flow.toString() + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label12", "\u6ca1\u6709\u7b2c\u4e00\u4e2a\u63a5\u6536\u8282\u70b9\uff0c\u6587\u6863\u65e0\u6cd5\u6295\u5165\u6d41\u8f6c\uff01"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("FirstNodeName", flowNode2.getName()));
        Users users = flowNode2.getOperUsers(null, true);
        if (users != null && users.size() > 0) {
            object2 = "";
            for (int i = 0; i < users.size(); ++i) {
                object = (User)users.getAt(i);
                object2 = (String)object2 + "<User TrueName=\"" + ((User)object).getTrueName() + "\" UserName=\"" + ((User)object).getName() + "\" UserId=\"" + ((BaseObj)object).getId() + "\"/>";
            }
            stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("Users", (String)object2, false));
        }
        if ((object2 = flowNode.getBranchTo(null, flowNode2)) != null) {
            stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("NotifyStyles", ((FlowNodeBranch)object2).getNotifyTypes()));
        }
        if (!CMyString.isEmpty(string = flowNode2.getPropertyAsString("ToUsersCreator"))) {
            stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("UsersCreator", string));
        }
        object = WCMProcessServiceHelper.makeXMLNode("FlowContextInfo", stringBuffer.toString(), false);
        stringBuffer.setLength(0);
        return object;
    }

    public static String makeXMLNode(String string, String string2) {
        return WCMProcessServiceHelper.makeXMLNode(string, string2, true);
    }

    public static String makeXMLNode(String string, String string2, boolean bl) {
        String string3 = "<" + string + ">";
        string3 = string3 + (bl ? "<![CDATA[" + CMyString.showNull(string2) + "]]>" : CMyString.showNull(string2));
        string3 = string3 + "</" + string + ">";
        return string3;
    }

    public static ContentProcessInfo makeContentProcessInfo(int n, int n2) throws WCMException {
        if (n == 0 || n2 == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u53c2\u6570\u65e0\u6548\uff01");
        }
        IFlowContent iFlowContent = FlowContentFactory.makeFlowContent(n, n2);
        if (iFlowContent == null) {
            throw new WCMException(200006, CMyString.format(LocaleServer.getString("document.detail.show.tracing", "\u6307\u5b9a\u7684\u5185\u5bb9[Type={0} , Id={1},]\u6ca1\u6709\u627e\u5230"), new String[]{WCMTypes.getLowerObjName(n), String.valueOf(n2)}));
        }
        IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        ContentProcessInfo contentProcessInfo = iFlowServer.getProcessInfoOfContent(iFlowContent);
        return contentProcessInfo;
    }

    public static boolean validCanEditProcessObject(int n, int n2, User user) throws WCMException {
        Object object;
        ContentProcessInfo contentProcessInfo = WCMProcessServiceHelper.makeContentProcessInfo(n, n2);
        if (contentProcessInfo == null || contentProcessInfo.isEnd()) {
            return true;
        }
        String string = ConfigServer.getServer().getSysConfigValue("CANEDITDOC_IF_IN_FIRST_FLOWNODE", "true");
        if ("true".equalsIgnoreCase(string)) {
            FlowNode flowNode;
            object = contentProcessInfo.getContent();
            if (object == null) {
                throw new WCMException(200006, CMyString.format(LocaleServer.getString("document.detail.show.tracing", "\u6307\u5b9a\u7684\u5185\u5bb9[Type={0} , Id={1},]\u6ca1\u6709\u627e\u5230"), new String[]{WCMTypes.getLowerObjName(n), String.valueOf(n2)}));
            }
            FlowDoc flowDoc = object.getFlowDoc();
            if (flowDoc != null && (flowNode = flowDoc.getPreNode()) != null && flowNode.isStartNode()) {
                return true;
            }
        }
        return (object = contentProcessInfo.getCurrToUses()) != null && ((BaseObjs)object).getById(user.getId()) != null;
    }
}

