/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateArgumentMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.service.ITemplateService;
import com.trs.wcag2.WCAG2Helper;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TemplateServiceProvider
implements IGlueServiceProvider {
    private TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private TemplateNestMgr m_oNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
    private TemplateArgumentMgr m_oArgumentMgr = (TemplateArgumentMgr)DreamFactory.createObjectById("TemplateArgumentMgr");
    private ITemplateService m_oTemplateService = (ITemplateService)DreamFactory.createObjectById("ITemplateService");

    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATE", "RootId=? and TempName=? and TempId<>?", "", "TempId");
        wCMFilter.addSearchValues(0, methodContext.getValue("SiteId", 0));
        wCMFilter.addSearchValues(1, methodContext.getValue("TempName"));
        wCMFilter.addSearchValues(2, methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Templates templates = Templates.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, templates, 22, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label1", "\u5220\u9664\u6a21\u677f"));
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            Templates templates2;
            Template template = (Template)templates.getAt(i);
            if (template == null || (templates2 = this.m_oNestMgr.getTemplatesNested(template)).size() > 0) continue;
            this.m_oTemplateMgr.delete(template);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter;
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        boolean bl = methodContext.getValue("ContainsChildren", false);
        this.validateRight(user, iPublishFolder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label2", "\u67e5\u770b") + iPublishFolder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label3", "\u6a21\u677f\u5217\u8868"));
        WCMFilter wCMFilter2 = new WCMFilter(methodContext.getQueryFilter());
        int n = methodContext.getValue("FilterType", 0);
        if (n != 0 && (wCMFilter = this.makeFilterByType(user, n)) != null && wCMFilter.getWhere() != null && wCMFilter.getWhere().length() > 0) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        return this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, -1, wCMFilter2, bl);
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = null;
        int n = methodContext.getObjectId();
        Template template = null;
        if (n > 0) {
            template = Template.findById(n);
            if (template == null) {
                throw new WCMException(102100, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label4", "\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728"));
            }
            iPublishFolder = template.getFolder();
        } else {
            iPublishFolder = this.findPublishFolder(methodContext);
            template = new Template();
            template.setFolder(iPublishFolder);
        }
        if (iPublishFolder == null) {
            throw new WCMException(102101, template.isAddMode() ? I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label5", "\u6307\u5b9a\u7684Host[") + methodContext.getValue("HostType") + "." + methodContext.getValue("HostId") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01") : I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label7", "\u6a21\u677f[Id=") + n + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label8", "]\u6240\u5c5e\u7684Host[") + template.getFolderType() + "." + template.getFolderId() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        if (n > 0) {
            this.validateRight(user, template, 23, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label9", "\u4fee\u6539\u6a21\u677f"));
        } else {
            this.validateRight(user, iPublishFolder, 21, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label10", "\u65b0\u589e\u6a21\u677f"));
        }
        String[] stringArray = new String[]{"ObjectId", "HostType", "HostId"};
        template = (Template)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, template, stringArray);
        if (!template.isAddMode()) {
            template.validCanEditAndLock(user);
        }
        template = this.m_oTemplateMgr.save(template, null, true, 2);
        return template.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = null;
        int n = methodContext.getObjectId();
        Template template = null;
        if (n > 0) {
            template = Template.findById(n);
            if (template == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(102)}));
            }
            iPublishFolder = template.getFolder();
        } else {
            iPublishFolder = this.findPublishFolder(methodContext);
            template = new Template();
            template.setFolder(iPublishFolder);
        }
        if (iPublishFolder == null) {
            throw new WCMException(102101, template.isAddMode() ? I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label5", "\u6307\u5b9a\u7684Host[") + methodContext.getValue("HostType") + "." + methodContext.getValue("HostId") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01") : I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label7", "\u6a21\u677f[Id=") + n + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label8", "]\u6240\u5c5e\u7684Host[") + template.getFolderType() + "." + template.getFolderId() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        if (!user.getName().equalsIgnoreCase(template.getCrUserName())) {
            this.validateRight(user, iPublishFolder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label11", "\u83b7\u53d6\u5355\u4e2a\u6a21\u677f\u4fe1\u606f"));
        }
        if (CMyString.isEmpty(template.getPropertyAsString("OUTPUTFILENAME"))) {
            template.getProperties().put("OUTPUTFILENAME", "index");
        }
        if (CMyString.isEmpty(template.getPropertyAsString("TEMPEXT"))) {
            template.getProperties().put("TEMPEXT", "htm");
        }
        return template;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Templates templates = Templates.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, templates, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label11", "\u83b7\u53d6\u5355\u4e2a\u6a21\u677f\u4fe1\u606f"));
        return templates;
    }

    public Templates getOptionalTemplates(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        if (methodContext.getObjectId() == 0) {
            return new Templates(user);
        }
        int n = methodContext.getValue("TemplateType", -1);
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext, "Object");
        IPublishFolder iPublishFolder2 = null;
        iPublishFolder2 = iPublishFolder.isFolder() ? iPublishFolder : iPublishFolder.getFolder();
        int n2 = methodContext.getValue("objectType", 101);
        switch (n2) {
            case 101: {
                object = new int[]{13, 11, 32, 31, 24};
                this.validateRight(user, iPublishFolder2, (int[])object, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
                break;
            }
            case 103: {
                int[] nArray = new int[]{1, 11, 24};
                this.validateRight(user, iPublishFolder2, nArray, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
                break;
            }
            case 605: {
                this.validateRight(user, iPublishFolder2, 32, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
            }
        }
        object = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oTemplateMgr.getOptionalTemplates(iPublishFolder2, n, (WCMFilter)object, true);
    }

    public PageOperators getOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = (IPublishFolder)this.findById(methodContext);
        int n = methodContext.getObjectId();
        if (n > 0) {
            Template template = this.findTemplateById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "template", template);
        }
        String string = methodContext.getObjectIds();
        if (string != null && string.length() > 0) {
            Templates templates = Templates.findByIds(user, string);
            if (templates.isEmpty()) {
                throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f[ObjectIds=") + string + "]\uff01");
            }
            if (templates.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "template", (CMSObj)templates.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(user, "templates", templates);
        }
        return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "templateHost", iPublishFolder.getSubstance());
    }

    public void impartTemplateConfig(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext, "Object");
        CMSObj cMSObj = iPublishFolder.getSubstance();
        if (cMSObj instanceof WebSite && ((WebSite)cMSObj).getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(cMSObj.getId()), WCMTypes.getLowerObjName(103)}));
        }
        if (cMSObj instanceof Channel && ((Channel)cMSObj).getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(cMSObj.getId()), WCMTypes.getLowerObjName(101)}));
        }
        if (!iPublishFolder.isFolder()) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + methodContext.getValue("ObjectType") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label15", "]\u4e0d\u662fFolder\uff01"));
        }
        if (!AuthServer.hasRight(user, iPublishFolder.getSubstance(), this.getSetTemplateRightIndex(iPublishFolder.getType()))) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label17", "]\u6ca1\u6709\u6743\u9650\u5728[") + iPublishFolder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label18", "]\u91cd\u65b0\u8bbe\u7f6e\u5b50\u5bf9\u8c61\u7684\u6a21\u677f\uff01"));
        }
        this.m_oEmployMgr.resetChildern(iPublishFolder);
    }

    public void synTemplates(MethodContext methodContext) throws Throwable {
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext, "Object");
        if (!iPublishFolder.isFolder()) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + methodContext.getValue("ObjectType") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label15", "]\u4e0d\u662fFolder\uff01"));
        }
        IPublishFolder iPublishFolder2 = iPublishFolder;
        String string = "0";
        Templates templates = this.m_oEmployMgr.getOutlineTemplates(iPublishFolder);
        if (!templates.isEmpty()) {
            string = templates.getIdListAsString();
        }
        if (this.m_oEmployMgr.getDefaultOutlineTemplate(iPublishFolder2) == null && !string.equals("0")) {
            string = "0," + string;
        }
        int n = 0;
        Template template = this.m_oEmployMgr.getDetailTemplate(iPublishFolder);
        if (template != null) {
            n = template.getId();
        }
        User user = this.getLoginUser();
        String string2 = methodContext.getObjectIds();
        Channels channels = Channels.findByIds(user, string2);
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            iPublishFolder2 = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            this.m_oEmployMgr.setOutlineTemplates(iPublishFolder2, string, false);
            this.m_oEmployMgr.setDetailTemplate(iPublishFolder2, n, false);
        }
    }

    public TemplateEmploys queryEmployers(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Template template = this.findTemplateById(methodContext.getObjectId());
        this.validateRight(user, template.getFolder(), 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        TemplateEmploys templateEmploys = this.m_oEmployMgr.getTemplateEmployers(template, wCMFilter);
        for (int i = templateEmploys.size() - 1; i >= 0; --i) {
            TemplateEmploy templateEmploy = (TemplateEmploy)templateEmploys.getAt(i);
            if (templateEmploy == null) {
                templateEmploys.removeAt(i, false);
                continue;
            }
            IPublishElement iPublishElement = templateEmploy.getEmployer();
            if (iPublishElement == null) {
                templateEmploys.removeAt(i, false);
                continue;
            }
            if (!iPublishElement.isFolder() || !((IPublishFolder)iPublishElement).isDeleted()) continue;
            templateEmploys.removeAt(i, false);
        }
        return templateEmploys;
    }

    public Templates queryTemplatesNested(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Template template = this.findTemplateById(methodContext.getObjectId());
        this.validateRight(user, template, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        return this.m_oNestMgr.getTemplatesNested(template);
    }

    public Templates queryNestedTemplates(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Template template = this.findTemplateById(methodContext.getObjectId());
        this.validateRight(user, template, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        return this.m_oNestMgr.getNestedTemplates(template);
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        boolean bl = methodContext.getValue("ExportAll", false);
        Templates templates = null;
        templates = bl ? (Templates)this.query(methodContext) : Templates.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, iPublishFolder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label20", "\u5bfc\u51fa\u6a21\u677f"));
        TemplateExporter templateExporter = new TemplateExporter();
        methodContext.setContentTypeIsHTML();
        return templateExporter.export(templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importTemplates(MethodContext methodContext) throws Throwable {
        String string;
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        String string2 = methodContext.getValue("ImportFile");
        int n = methodContext.getValue("ImportMode", 1);
        int n2 = methodContext.getValue("PicMode", 1);
        if (!AuthServer.hasRight(user, iPublishFolder.getSubstance(), 21)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + CMyString.format(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label42", "]\u6ca1\u6709\u6743\u9650\u6267\u884c {0} !"), new String[]{I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label21", "\u5bfc\u5165\u6a21\u677f")}));
        }
        Templates templates = null;
        if (n == 1) {
            templates = this.getTemplatesWithNoRight(iPublishFolder, string2);
        }
        if (!CMyString.isEmpty(string = methodContext.getValue("FileEncode"))) {
            ContextParameters.set(9, string);
        }
        try {
            TemplateImporter templateImporter = new TemplateImporter();
            String string3 = CMyFile.extractFileExt(string2);
            if (string3.equalsIgnoreCase("zip")) {
                String string4 = templateImporter.importFromZip(iPublishFolder, string2, n, n2, null, templates).toJSONXML();
                return string4;
            }
            String string5 = methodContext.getValue("SrcFileName");
            String string6 = templateImporter.importFromHTML(iPublishFolder, string2, n, string5).toJSONXML();
            return string6;
        }
        finally {
            if (!CMyString.isEmpty(string)) {
                ContextParameters.get(9);
            }
        }
    }

    private Templates getTemplatesWithNoRight(IPublishFolder iPublishFolder, String string) throws Throwable {
        User user = this.getLoginUser();
        int n = iPublishFolder.getId();
        int n2 = iPublishFolder.getType();
        TemplateImporter templateImporter = new TemplateImporter();
        String[] stringArray = null;
        stringArray = !CMyFile.extractFileExt(string).equalsIgnoreCase("zip") ? new String[]{CMyFile.extractMainFileName(string)} : templateImporter.extractTemplateNamesFromZip(string);
        Templates templates = this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, -1, null, true);
        Templates templates2 = this.m_oTemplateMgr.getOptionalTemplates(iPublishFolder, -1, null, true);
        templates.addWith(templates2);
        Templates templates3 = new Templates(user);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Template template = templates.findByName(string2);
            if (template == null) continue;
            int n3 = template.getFolderId();
            int n4 = template.getFolderType();
            if (n3 < 0 || n3 == n && n4 == n2 || AuthServer.hasRight(user, (CMSObj)((BaseChannel)BaseChannel.findById(n4, n3)), 21)) continue;
            templates3.addElement(template);
        }
        return templates3;
    }

    public String check(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        Templates templates = null;
        templates = !methodContext.getValue("CheckAll", false) ? Templates.findByIds(user, methodContext.getObjectIds()) : this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, -1, null, methodContext.getValue("ContainsChildren", false));
        this.validateRight(user, templates, 25, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label22", "\u6821\u9a8c\u6a21\u677f"));
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        Reports reports = new Reports(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label23", "\u6a21\u677f\u6821\u9a8c"));
        int n = 0;
        int n2 = templates.size();
        for (int i = 0; i < n2; ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            boolean bl = false;
            if (AuthServer.hasRight(user, template.getFolder().getSubstance(), 23)) {
                bl = true;
            }
            ++n;
            reports.addReport(templateParseMgr.checkTemplate(template, bl));
        }
        if (n == 0) {
            reports.addWarnedReport(I18NMessage.makeObjectNotFound(new String[]{methodContext.getObjectIds().replaceAll(",", ", "), WCMTypes.getLowerObjName(102)}), null);
        } else {
            String string = I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label25", "\u5171\u68c0\u67e5\u4e86[") + n + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label26", "]\u4e2a\u6a21\u677f\uff01\u6b63\u786e\uff1a[") + reports.getSucessedReporter().size() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label27", "]\u4e2a\uff01\u9519\u8bef\uff1a[") + reports.getFailedReporter().size() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label28", "]\u4e2a\uff01");
            reports.setTitle(string);
        }
        return reports.toJSONXML();
    }

    public String checkTemplateText(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("TemplateText");
        String string2 = methodContext.getValue("TempName");
        String string3 = methodContext.getValue("TempId");
        if (CMyString.isEmpty(string2)) {
            throw new WCMException("The template name can not be null.");
        }
        Template template = (Template)this.findById(methodContext);
        template.setText(string);
        template.setName(string2);
        template.setAttribute("tempId", " [template-" + string3 + "]");
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        return templateParseMgr.checkTemplate(template).toJSONXML();
    }

    public String checkWCAG2TemplateText(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("TemplateText");
        if (string == null) {
            int n = methodContext.getValue("TemplateId", 0);
            Template template = Template.findById(n);
            this.validateRight(user, template, 25, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label41", "\u65e0\u969c\u788d\u6821\u9a8c"));
            string = template != null ? template.getText() : "";
        }
        List list = (List)WCAG2Helper.doValid(string);
        return WCAG2Helper.toHTML(list);
    }

    public String redistributeAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        Templates templates = null;
        templates = !methodContext.getValue("RedistributeAll", false) ? Templates.findByIds(user, methodContext.getObjectIds()) : this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, -1, null, methodContext.getValue("ContainsChildren", false));
        this.validateRight(user, templates, 28, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label29", "\u540c\u6b65\u6a21\u677f\u9644\u4ef6"));
        return this.m_oTemplateMgr.redistributeAppendixes(templates).toJSONXML();
    }

    public String queryArgs(MethodContext methodContext) throws Throwable {
        Template template;
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        int n = 53;
        this.validateRight(user, iPublishFolder, n, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label30", "\u7ba1\u7406\u6a21\u677f\u53d8\u91cf"));
        TemplateArguments templateArguments = this.m_oArgumentMgr.getArguments(iPublishFolder);
        Templates templates = new Templates(this.getLoginUser());
        Templates templates2 = this.m_oEmployMgr.getOutlineTemplates(iPublishFolder);
        if (templates2 != null && !templates2.isEmpty()) {
            templates.addElements(templates2);
        }
        if ((template = this.m_oEmployMgr.getDetailTemplate(iPublishFolder)) != null) {
            templates.addElement(template);
        }
        Element element = DocumentHelper.createElement((String)"Templates");
        int n2 = templates.size();
        for (int i = 0; i < n2; ++i) {
            Template template2 = (Template)templates.getAt(i);
            if (template2 == null) continue;
            this.makeTemplateArgments(template2, element, templateArguments, null, null);
            Iterator iterator = template2.iterateNestedIdentity();
            while (iterator != null && iterator.hasNext()) {
                String string = (String)iterator.next();
                this.makeTemplateArgments(template2.getNestedTemplate(iPublishFolder, string), element, templateArguments, template2, string);
            }
        }
        return element.asXML();
    }

    private void makeTemplateArgments(Template template, Element element, TemplateArguments templateArguments, Template template2, String string) {
        if (template == null) {
            return;
        }
        TemplateParameterList templateParameterList = template.getTemplateParameters();
        if (templateParameterList == null || templateParameterList.size() == 0) {
            return;
        }
        Element element2 = element.addElement("Template");
        element2.addAttribute("ID", String.valueOf(template.getId()));
        element2.addAttribute("Name", template.getName());
        if (template2 != null) {
            element2.addAttribute("Identity", string);
            element2.addAttribute("NesterName", template2.getName());
            element2.addAttribute("NesterId", String.valueOf(template2.getId()));
        }
        Element element3 = element2.addElement("Args");
        Iterator iterator = templateParameterList.parameters();
        while (iterator.hasNext()) {
            TemplateParameter templateParameter = (TemplateParameter)iterator.next();
            Element element4 = element3.addElement("Arg");
            element4.addElement("Name").addCDATA(templateParameter.getParameterName());
            element4.addElement("Type").addCDATA(templateParameter.getParameterType().getName());
            element4.addElement("DefaultValue").addCDATA(templateParameter.getParameterDefault());
            element4.addElement("CanCustom").addText(String.valueOf(templateParameter.getCanCustom()));
            element4.addElement("EnumSplit").addText(String.valueOf(templateParameter.getEnumSplit()));
            templateParameter.getEnumValue();
            Element element5 = element4.addElement("EnumValues");
            TemplateParameter.Token[] tokenArray = templateParameter.getEnumValue();
            int n = tokenArray == null ? 0 : tokenArray.length;
            for (int i = 0; i < n; ++i) {
                Element element6 = element5.addElement("EnumValue");
                element6.addAttribute("Value", tokenArray[i].getValue());
                element6.addAttribute("Display", tokenArray[i].getDisplay());
            }
            element4.addElement("PrexName").addCDATA(CMyString.showNull(string));
            String string2 = CMyString.showNull(templateArguments.getArgumentValue(templateParameter.getParameterName(), string));
            element4.addElement("Value").addCDATA(string2);
        }
    }

    public int saveArgument(MethodContext methodContext) throws Throwable {
        IPublishFolder iPublishFolder;
        CMSObj cMSObj;
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder2 = this.findPublishFolder(methodContext);
        Template template = this.findTemplateById(methodContext.getValue("TemplateId", 0));
        String string = methodContext.getValue("ParameterName");
        String string2 = methodContext.getValue("PrexName");
        int n = 53;
        this.validateRight(user, iPublishFolder2, n, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label31", "\u8bbe\u7f6e\u6a21\u677f\u53d8\u91cf"));
        TemplateArgument templateArgument = this.findChannelTempArg(string, string2, iPublishFolder2);
        if (templateArgument == null) {
            templateArgument = new TemplateArgument();
            templateArgument.setArgumentName(string);
            templateArgument.setEmployer(iPublishFolder2);
            templateArgument.setTemplate(template);
            if (string2 != null && string2.length() > 0) {
                templateArgument.setPrefixOfName(string2);
            }
        } else {
            templateArgument.validCanEditAndLock(user);
        }
        String string3 = methodContext.getValue("ArgValue");
        templateArgument.setArgumentValue(string3);
        templateArgument.save(user);
        boolean bl = methodContext.getValue("SyncSameName", false);
        if (bl && (cMSObj = (iPublishFolder = iPublishFolder2).getSubstance()) instanceof BaseChannel) {
            BaseChannel baseChannel = (BaseChannel)cMSObj;
            this.renderChildren(user, baseChannel, string, string3, false);
        }
        return templateArgument.getId();
    }

    private TemplateArgument findChannelTempArg(String string, String string2, IPublishFolder iPublishFolder) throws WCMException {
        String string3 = null;
        string3 = CMyString.isEmpty(string2) ? "ARGUMENTNAME=? and PREFIXOFNAME is null" : "ARGUMENTNAME=? and PREFIXOFNAME=?";
        if (iPublishFolder != null) {
            string3 = string3 + " AND EMPLOYERID=? AND EMPLOYERTYPE=?";
        }
        WCMFilter wCMFilter = new WCMFilter("", string3, "");
        int n = 0;
        wCMFilter.addSearchValues(0, string);
        if (!CMyString.isEmpty(string2)) {
            wCMFilter.addSearchValues(1, string2);
            ++n;
        }
        if (iPublishFolder != null) {
            wCMFilter.addSearchValues(++n, iPublishFolder.getId());
            wCMFilter.addSearchValues(++n, iPublishFolder.getType());
        }
        wCMFilter.setMaxRowNumber(1);
        TemplateArguments templateArguments = TemplateArguments.openWCMObjs(null, wCMFilter);
        if (templateArguments.isEmpty()) {
            return null;
        }
        return (TemplateArgument)templateArguments.getAt(0);
    }

    public void cancelArgVal(MethodContext methodContext) throws Throwable {
        methodContext.setValue("ArgValue", "");
        String string = methodContext.getValue("ParameterNames");
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (CMyString.isEmpty(string2)) continue;
            methodContext.setValue("ParameterName", string2);
            this.saveArgument(methodContext);
        }
    }

    public void setDefaultTemplate(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishElement iPublishElement = this.findPublishElement(methodContext);
        if (!iPublishElement.isCanDoSave(user) && !AuthServer.hasRight(user, iPublishElement.getSubstance(), 9)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label32", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + iPublishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label33", "\u7684\u6a21\u677f\uff01"));
        }
        int n = methodContext.getValue("TemplateId", 0);
        int n2 = methodContext.getValue("TemplateType", 2);
        if (iPublishElement.isFolder()) {
            switch (n2) {
                case 2: {
                    this.m_oEmployMgr.setDetailTemplate(iPublishElement, n, false);
                    break;
                }
                case 1: {
                    this.m_oEmployMgr.setDefaultOutline((IPublishFolder)iPublishElement, n);
                    break;
                }
                case 3: {
                    WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
                    wCMFolderPublishConfig.setInfoviewPrintTemplateId(n);
                    wCMFolderPublishConfig.canEdit(user);
                    wCMFolderPublishConfig.save(user);
                }
            }
        } else {
            this.m_oEmployMgr.setDetailTemplate(iPublishElement, n, false);
        }
    }

    public void setOtherOutlineTemplates(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext, "Object");
        if (!iPublishFolder.isCanDoSave(user)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label32", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + iPublishFolder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label33", "\u7684\u6a21\u677f\uff01"));
        }
        String string = methodContext.getValue("TemplateIds");
        this.m_oEmployMgr.setOtherOutlines(user, iPublishFolder, string);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Template findTemplateById(int n) throws WCMException {
        Template template = Template.findById(n);
        if (template == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label34", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f[ID=") + n + "]\uff01");
        }
        return template;
    }

    private int getSetTemplateRightIndex(int n) {
        switch (n) {
            case 605: {
                return 32;
            }
            case 101: {
                return 13;
            }
            case 103: {
                return 1;
            }
        }
        return 64;
    }

    private boolean hasRight(User user, IPublishFolder iPublishFolder, int n, String string) throws WCMException {
        if (AuthServer.hasRight(user, iPublishFolder.getSubstance(), n)) {
            return true;
        }
        IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
        if (iPublishFolder2 == null || iPublishFolder2 == iPublishFolder) {
            return false;
        }
        return this.hasRight(user, iPublishFolder2, n, string);
    }

    private boolean hasRight(User user, IPublishFolder iPublishFolder, int[] nArray, String string) throws WCMException {
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.hasRight(user, iPublishFolder, nArray[i], string)) continue;
            return true;
        }
        return false;
    }

    private void validateRight(User user, IPublishFolder iPublishFolder, int[] nArray, String string) throws WCMException {
        if (this.hasRight(user, iPublishFolder, nArray, string)) {
            return;
        }
        throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label35", "]\u6ca1\u6709\u6743\u9650\u6267\u884c") + string + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label40", "\uff01"));
    }

    private void validateRight(User user, IPublishFolder iPublishFolder, int n, String string) throws WCMException {
        if (AuthServer.hasRight(user, iPublishFolder.getSubstance(), n)) {
            return;
        }
        IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
        if (iPublishFolder2 == null || iPublishFolder2 == iPublishFolder) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + CMyString.format(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label42", "]\u6ca1\u6709\u6743\u9650\u6267\u884c {0} !"), new String[]{string}));
        }
        this.validateRight(user, iPublishFolder2, n, string);
    }

    private void validateRight(User user, Template template, int n, String string) throws WCMException {
        if (user.getName().equalsIgnoreCase(template.getCrUserName())) {
            return;
        }
        this.validateRight(user, template.getFolder(), n, string);
    }

    private void validateRight(User user, Templates templates, int n, String string) throws WCMException {
        int n2 = templates.size();
        for (int i = 0; i < n2; ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            this.validateRight(user, template, n, string);
        }
    }

    private WCMFilter makeFilterByType(User user, int n) throws Exception {
        WCMFilter wCMFilter = new WCMFilter();
        String string = null;
        switch (n) {
            case 10: 
            case 11: 
            case 12: {
                string = "TempType=?";
                wCMFilter.addSearchValues(0, n % 10);
                break;
            }
            case 18: {
                string = "(exists( select WCMTemplateEmploy.TemplateId from wcmtemplateemploy where WCMTemplate.TempId=WCMTemplateEmploy.TemplateId and WCMTemplate.TempType<>0) or exists(select WCMTEMPLATENEST.nestedtemplateid from WCMTEMPLATENEST where WCMTemplate.TempId=WCMTEMPLATENEST.nestedtemplateid and WCMTemplate.TempType=0)) ";
                break;
            }
            case 19: {
                string = "(not exists( select WCMTemplateEmploy.TemplateId from wcmtemplateemploy where WCMTemplate.TempId=WCMTemplateEmploy.TemplateId and WCMTemplate.TempType<>0) and not exists(select WCMTEMPLATENEST.nestedtemplateid from WCMTEMPLATENEST where WCMTemplate.TempId=WCMTEMPLATENEST.nestedtemplateid and WCMTemplate.TempType=0))";
                break;
            }
            case 4: {
                string = "CrUser=?";
                wCMFilter.addSearchValues(0, user.getName());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "CrTime>=?";
                wCMFilter.addSearchValues(0, ServiceConstants.makeDateTime(n));
                break;
            }
        }
        wCMFilter.setWhere(string);
        return wCMFilter;
    }

    private IPublishFolder findPublishFolder(MethodContext methodContext) throws WCMException {
        return this.findPublishFolder(methodContext, null);
    }

    private IPublishFolder findPublishFolder(MethodContext methodContext, String string) throws WCMException {
        String string2 = string == null ? "Host" : string;
        int n = methodContext.getValue(string2 + "Type", 0);
        if (n == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + string2 + "Type]!");
        }
        int n2 = methodContext.getValue(string2 + "Id", 0);
        if (n2 == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + string2 + "Id]!");
        }
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n, n2);
        if (iPublishElement == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label37", "\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01(Type=") + n + ", Id=" + n2 + ")");
        }
        if (!(iPublishElement instanceof IPublishFolder)) {
            throw new WCMException(10, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label38", "\u6307\u5b9a\u7684\u5bf9\u8c61(") + iPublishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label39", ")\u4e0d\u662fFolder!"));
        }
        methodContext.putContextCacheData("Host", iPublishElement);
        return (IPublishFolder)iPublishElement;
    }

    private IPublishElement findPublishElement(MethodContext methodContext) throws WCMException {
        int n;
        int n2 = methodContext.getValue("ObjectType", 0);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(n2, n = methodContext.getObjectId());
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + n2 + ", Id=" + n + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishElement;
    }

    private void renderChildren(User user, BaseChannel baseChannel, String string, String string2, boolean bl) throws WCMException {
        if (bl) {
            this.changeChannelArgValue(user, baseChannel, string, string2);
        }
        List list = baseChannel.getChildren(user);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BaseChannel baseChannel2 = (BaseChannel)list.get(i);
            if (baseChannel2 == null) continue;
            this.renderChildren(user, baseChannel2, string, string2, true);
        }
    }

    private void changeChannelArgValue(User user, BaseChannel baseChannel, String string, String string2) throws WCMException {
        int n = baseChannel.getId();
        int n2 = 101;
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(n2, n);
        TemplateArguments templateArguments = this.m_oTemplateService.getTemplateArguments(iPublishFolder);
        TemplateParameterList templateParameterList = this.m_oTemplateService.getTemplateParameters(iPublishFolder);
        Iterator iterator = templateParameterList.parameters();
        HashMap hashMap = templateArguments.toHashMapForCheck();
        while (iterator.hasNext()) {
            TemplateParameter templateParameter = (TemplateParameter)iterator.next();
            if (templateParameter == null || !string.equalsIgnoreCase(templateParameter.getParameterName())) continue;
            TemplateArgument templateArgument = (TemplateArgument)hashMap.get(TemplateArgument.makeCacheKey(null, templateParameter.getParameterName()));
            if (templateArgument != null) {
                templateArgument.setArgumentValue(string2);
            } else {
                templateArgument = TemplateArgument.createNewInstance();
                templateArgument.setProperty("EMPLOYERTYPE", n2);
                templateArgument.setProperty("EMPLOYERID", n);
                templateArgument.setProperty("TEMPLATEID", templateParameter.getTemplateId());
                templateArgument.setProperty("ARGUMENTNAME", templateParameter.getParameterName());
                templateArgument.setProperty("ARGUMENTVALUE", string2);
            }
            this.m_oTemplateService.saveTemplateArgument(templateArgument);
        }
    }

    public Reports existNestedTemplate(MethodContext methodContext) throws WCMException {
        String string = methodContext.getObjectIds();
        Reports reports = new Reports("\u60a8\u8981\u5220\u9664\u7684\u6a21\u677f\u4e2d\u542b\u6709\u5df2\u88ab\u5d4c\u5957\u7684\u5d4c\u5957\u6a21\u677f");
        Templates templates = Templates.findByIds(null, string);
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            Templates templates2;
            Template template = (Template)templates.getAt(i);
            if (template == null || (templates2 = this.m_oNestMgr.getTemplatesNested(template)).size() == 0) continue;
            StringBuffer stringBuffer = new StringBuffer(256);
            int n2 = templates2.size();
            for (int j = 0; j < n2; ++j) {
                Template template2 = (Template)templates2.getAt(j);
                if (template2 == null) continue;
                stringBuffer.append("\uff0c").append(template2.getName());
            }
            if (stringBuffer.length() == 0) continue;
            reports.addWarnedReport("\u6a21\u677f [" + template.getName() + "] \u5df2\u7ecf\u88ab\u6a21\u677f [" + stringBuffer.substring(1) + "] \u5d4c\u5957\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff1b", null);
            stringBuffer.setLength(0);
        }
        return reports;
    }

    public Templates queryForSpecial(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        IPublishFolder iPublishFolder = this.findPublishFolder(methodContext);
        boolean bl = methodContext.getValue("ContainsChildren", false);
        this.validateRight(user, iPublishFolder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label2", "\u67e5\u770b") + iPublishFolder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label3", "\u6a21\u677f\u5217\u8868"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        int n = methodContext.getValue("FilterType", 0);
        int n2 = methodContext.getValue("TemplateType", -1);
        if (n != 0 && (object = this.makeFilterByType(user, n)) != null && ((WCMFilter)object).getWhere() != null && ((WCMFilter)object).getWhere().length() > 0) {
            wCMFilter.mergeWith((WCMFilter)object);
        }
        object = this.m_oTemplateMgr.getManagedTemplates(iPublishFolder, n2, wCMFilter, bl);
        boolean bl2 = methodContext.getValue("IncludingThoseInParent", true);
        Templates templates = this.m_oTemplateMgr.getOptionalTemplates(iPublishFolder, n2, wCMFilter, bl2);
        ((BaseObjs)object).addElements(templates);
        return object;
    }
}

