/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.database.DataType;
import com.trs.wcm.config.PageOperators;
import com.trs.wcm.customize.ICustomizeMgr;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class ExtendFieldServiceProvider
implements IGlueServiceProvider {
    private ContentExtFieldMgr m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private ICustomizeMgr m_oCustomizeMgr = (ICustomizeMgr)DreamFactory.createObjectById("ICustomizeMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("ContainsChildren", false);
        String string = methodContext.getObjectIds();
        CMSObj cMSObj = this.findHost(methodContext);
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label1", "\u5220\u9664"));
        ContentExtFields contentExtFields = ContentExtFields.findByIds(user, string);
        int n = contentExtFields.size();
        for (int i = 0; i < n; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            cMSObj = contentExtField.getHost();
            this.m_oExtFieldMgr.delete(cMSObj, contentExtField, bl);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("ContainsChildren", false);
        boolean bl2 = methodContext.getValue("validRight", true);
        CMSObj cMSObj = this.findHost(methodContext);
        if (bl2) {
            this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label2", "\u83b7\u53d6"));
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oExtFieldMgr.getExtFields(cMSObj, wCMFilter, bl);
    }

    public int save(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("ContainsChildren", false);
        CMSObj cMSObj = this.findHost(methodContext);
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label3", "\u4fdd\u5b58"));
        if (methodContext.getValue("FieldName") != null && (n = this.findExtfield(methodContext.getValue("FieldName"), "WCMDOCUMENT")) == 0 && !user.isAdministrator()) {
            throw new WCMException("\u975e\u7ba1\u7406\u5458\u7981\u6b62\u521b\u5efa\u7269\u7406\u5b57\u6bb5\uff0c\u53ea\u80fd\u662f\u9009\u62e9\u5df2\u6709\u5b57\u6bb5\uff01");
        }
        ContentExtField contentExtField = null;
        ExtendedField extendedField = null;
        int n2 = methodContext.getObjectId();
        String string = methodContext.getValue("DBTYPE");
        String string2 = methodContext.getValue("FIELDTYPE");
        if (n2 == 0) {
            contentExtField = ContentExtField.createNewInstance();
            contentExtField.setTableName("WCMDOCUMENT");
            contentExtField.setName(methodContext.getValue("FIELDNAME"));
            if ("FLOAT".equalsIgnoreCase(string.trim())) {
                contentExtField.setType(string, methodContext.getValue("DBLENGTH", -1), true, null, methodContext.getValue("DBSCALE", 0));
            } else {
                contentExtField.setType(string, methodContext.getValue("DBLENGTH", -1));
            }
            contentExtField.setAttribute("FIELDTYPE", string2);
            contentExtField.setExtFieldProperty("FIELDDEFAULT", methodContext.getValue("DEFAULTVALUE"));
            contentExtField.setAttribute("ENMVALUE", methodContext.getValue("ENMVALUE"));
            if (string.trim().equals("FLOAT")) {
                contentExtField.setAttribute("DBSCALE", methodContext.getValue("DBSCALE"));
            }
        } else {
            contentExtField = ContentExtField.findById(n2);
            contentExtField.validCanEditAndLock(user);
            cMSObj = contentExtField.getHost();
            extendedField = ExtendedField.findById(contentExtField.getExtFieldId());
            extendedField.setProperty("FIELDDEFAULT", methodContext.getValue("DEFAULTVALUE"));
            extendedField.setProperty("FIELDMAXLEN", methodContext.getValue("DBLENGTH", -1));
            extendedField.setAttribute("FIELDTYPE", string2);
            extendedField.setAttribute("ENMVALUE", methodContext.getValue("ENMVALUE"));
            if (string != null && string.trim().equals("FLOAT")) {
                extendedField.setAttribute("DBSCALE", methodContext.getValue("DBSCALE"));
            }
            extendedField.save();
        }
        contentExtField.setProperty("EXTORDER", methodContext.getValue("EXTORDER", 0));
        contentExtField.setDesc(methodContext.getValue("FieldDesc"));
        contentExtField = this.m_oExtFieldMgr.save(cMSObj, contentExtField, bl);
        return contentExtField.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        ContentExtField contentExtField = ContentExtField.findById(n);
        if (contentExtField == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1319922479)}));
        }
        return contentExtField;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return ContentExtFields.findByIds(null, methodContext.getObjectIds());
    }

    public DataType[] getSupportedDataTypes() {
        DataType[] dataTypeArray = DBManager.getDBManager().getDBType().getSupportedDataTypes();
        DataType[] dataTypeArray2 = new DataType[dataTypeArray.length];
        int n = 0;
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (!this.isValidateDataType(dataTypeArray[i].getType())) continue;
            dataTypeArray2[n++] = dataTypeArray[i];
        }
        return dataTypeArray2;
    }

    public PageOperators getOperators(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        User user = this.getLoginUser();
        if (!this.canMgrExtFields(user, cMSObj = this.findHost(methodContext))) {
            return new PageOperators(null);
        }
        return this.makeExtendOpertators(user, methodContext.getValue("OperatorType"));
    }

    public void impartExtendFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("ImpartAll", false);
        String string = methodContext.getValue("SiteIds");
        String string2 = methodContext.getValue("ChannelIds");
        CMSObj cMSObj = this.findHost(methodContext);
        ContentExtFields contentExtFields = ContentExtFields.findByIds(null, methodContext.getObjectIds());
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label6", "\u8bbe\u7f6e\u5b50\u5bf9\u5bf9\u8c61\u6743\u9650"));
        int n = contentExtFields.size();
        for (int i = 0; i < n; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            if (bl) {
                this.m_oExtFieldMgr.addExtFieldToChildren(cMSObj, contentExtField);
                continue;
            }
            this.m_oExtFieldMgr.addExtFieldToSpeicficChildren(string, string2, contentExtField);
        }
    }

    public void inheritExtendFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        CMSObj cMSObj = this.findHost(methodContext);
        CMSObj cMSObj2 = this.findParent(cMSObj);
        this.validateMgrExtFields(user, cMSObj2, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label2", "\u83b7\u53d6"));
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label7", "\u8bbe\u7f6e"));
        ContentExtFields contentExtFields = this.m_oExtFieldMgr.getExtFields(cMSObj2, null, false);
        if (contentExtFields != null && contentExtFields.size() > 0) {
            int n = 0;
            if (cMSObj instanceof Channel) {
                n = this.getMaxOrder(cMSObj);
            }
            for (int i = 0; i < contentExtFields.size(); ++i) {
                ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
                if (contentExtField == null) continue;
                this.m_oExtFieldMgr.addExtField(cMSObj, contentExtField, n + i);
            }
        }
    }

    public void inhertSpecificFromParent(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        CMSObj cMSObj = this.findHost(methodContext);
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label7", "\u8bbe\u7f6e"));
        ContentExtFields contentExtFields = ContentExtFields.findByIds(user, methodContext.getValue("SelectedIds"));
        if (contentExtFields != null && contentExtFields.size() > 0) {
            int n = 0;
            if (cMSObj instanceof Channel) {
                n = this.getMaxOrder(cMSObj);
            }
            for (int i = 0; i < contentExtFields.size(); ++i) {
                ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
                if (contentExtField == null) continue;
                this.m_oExtFieldMgr.addExtField(cMSObj, contentExtField, n + i);
            }
        }
    }

    public int getMaxOrder(CMSObj cMSObj) throws Throwable {
        DBManager dBManager = DBManager.getDBManager();
        String string = "SELECT MAX(extorder) FROM WCMCONTENTEXTFIELD WHERE objtype=" + cMSObj.getWCMType() + " and objid=" + cMSObj.getId();
        int n = dBManager.sqlExecuteIntQuery(string) + 1;
        return n;
    }

    public CMSObj findParent(CMSObj cMSObj) throws Throwable {
        switch (cMSObj.getWCMType()) {
            case 103: {
                return new WCMSystemObject(cMSObj.getId());
            }
            case 101: {
                Channel channel = (Channel)cMSObj;
                Channel channel2 = channel.getParent();
                if (channel2 != null) {
                    return channel2;
                }
                return channel.getSite();
            }
        }
        return null;
    }

    public ExtendedFields queryExtendFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        CMSObj cMSObj = this.findHost(methodContext);
        this.validateMgrExtFields(user, cMSObj, I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label8", "\u83b7\u53d6\u7cfb\u7edf\u73b0\u6709\u7684\u6269\u5c55\u5b57\u6bb5"));
        String string = "not exists(select ExtFieldId from WCMContentExtField where WCMExtField.ExtFieldId=WCMContentExtField.ExtFieldId and ObjType=? and ObjId=?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, cMSObj.getWCMType());
        wCMFilter.addSearchValues(1, cMSObj.getId());
        wCMFilter.mergeWith(new WCMFilter(methodContext.getQueryFilter()));
        return ExtendedFields.openWCMObjs(user, wCMFilter);
    }

    public String existsSimilarName(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("DBFieldName").toUpperCase();
        Report report = new Report(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label9", "\u6269\u5c55\u5b57\u6bb5\u53ef\u4ee5\u6dfb\u52a0"));
        if (DBManager.getDBManager().isKeywords(string)) {
            report.setType(5);
            report.setRportTitle(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label10", "\u8bbe\u7f6e\u7684\u7269\u7406\u5b57\u6bb5[") + string + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label11", "]\u4e3a\u7cfb\u7edf\u4fdd\u7559\u5b57!"));
        } else {
            String string2 = "ObjType=? and ObjId=? and ContentExtFieldId<>? and EXISTS(    select wcmextfield.EXTFIELDID from wcmextfield    where TableName='WCMDOCUMENT' AND FieldName=?    AND wcmcontentextfield.EXTFIELDID=wcmextfield.EXTFIELDID)";
            WCMFilter wCMFilter = new WCMFilter("WCMCONTENTEXTFIELD", string2, "", "LogicFieldDesc");
            wCMFilter.addSearchValues(0, methodContext.getValue("HostType", 0));
            wCMFilter.addSearchValues(1, methodContext.getValue("HostId", 0));
            wCMFilter.addSearchValues(2, methodContext.getValue("ObjectId", 0));
            wCMFilter.addSearchValues(3, string);
            ContentExtFields contentExtFields = new ContentExtFields(user);
            contentExtFields.setMaxSize(1);
            contentExtFields.open(wCMFilter);
            if (!contentExtFields.isEmpty()) {
                ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(0);
                report.setType(5);
                report.setRportTitle(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label12", "\u5b57\u6bb5[") + string + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label13", "]\u5728\u5f53\u524d\u5bf9\u8c61\u4e2d\u5df2\u7ecf\u5efa\u7acb!\u903b\u8f91\u5b57\u6bb5\u540d\u79f0\u4e3a[") + contentExtField.getDesc() + "]" + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label26", "!"));
            }
        }
        return report.toJSONXML();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findHost(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("HostType", 0);
        int n2 = methodContext.getValue("HostId", 0);
        switch (n) {
            case 103: {
                WebSite webSite = WebSite.findById(n2);
                if (webSite == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label14", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + n2 + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label15", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return webSite;
            }
            case 101: {
                Channel channel = Channel.findById(n2);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label16", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n2 + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label15", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 605: {
                int n3 = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{n2});
                Channel channel = Channel.findById(n3);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label17", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + n2 + I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label18", "]\u7684\u6240\u5c5e\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
                }
                return channel;
            }
            case 1: {
                return new WCMSystemObject(n2);
            }
        }
        throw new WCMException(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label19", "\u672a\u77e5\u7c7b\u578b[HostType=") + n + "]");
    }

    private void validateMgrExtFields(User user, CMSObj cMSObj, String string) throws Throwable {
        int n = 0;
        switch (cMSObj.getWCMType()) {
            case 103: {
                n = 19;
                break;
            }
            case 101: {
                n = 19;
                break;
            }
            case 1: {
                if (user.isAdministrator()) {
                    return;
                }
                throw new WCMException(CMyString.format(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label21", "\u60a8[{0}]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650{1}\u7cfb\u7edf\u7684\u6269\u5c55\u5b57\u6bb5\uff01"), new String[]{user.getName(), string}));
            }
        }
        if (!AuthServer.hasRight(user, cMSObj, n)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ExtendFieldServiceProvider.class, "ExtendFieldServiceProvider.label23", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650{1}{2}\u7684\u6269\u5c55\u5b57\u6bb5"), new String[]{user.getName(), string, cMSObj.toString()}));
        }
    }

    private boolean canMgrExtFields(User user, CMSObj cMSObj) throws WCMException {
        int n = 0;
        switch (cMSObj.getWCMType()) {
            case 103: {
                n = 19;
                break;
            }
            case 101: {
                n = 19;
                break;
            }
            case 1: {
                return user.isAdministrator();
            }
        }
        return AuthServer.hasRight(user, cMSObj, n);
    }

    private PageOperators makeExtendOpertators(User user, String string) throws WCMException {
        return this.m_oCustomizeMgr.getPageOpertators(user, string, new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
    }

    private boolean isValidateDataType(int n) {
        switch (n) {
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private int findExtfield(String string, String string2) throws WCMException {
        String string3 = "FieldName=? AND TableName=?";
        WCMFilter wCMFilter = new WCMFilter("", string3, "");
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(string2);
        wCMFilter.setMaxRowNumber(1);
        ExtendedFields extendedFields = new ExtendedFields(null);
        extendedFields.open(wCMFilter);
        if (extendedFields.isEmpty()) {
            return 0;
        }
        return extendedFields.getIdAt(0);
    }
}

