/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ChannelHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.special.ISpecialMgr;
import com.trs.components.special.Special;
import com.trs.components.wcm.channel.IVChannelParser;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.channel.VChannelManager;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class ChannelServiceProvider
implements IGlueServiceProvider {
    private ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channels channels = Channels.findByIds(user, methodContext.getObjectIds());
        boolean bl = methodContext.getValue("Drop", false);
        int n = 12;
        if (!AuthServer.hasRightInObjects(user, channels, n)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd9\u4e9b\u680f\u76ee[ID=") + channels.getIdListAsString() + "].");
        }
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.m_oChannelMgr.delete(channel, bl);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SiblingChannelId", 0);
        BaseChannel baseChannel = null;
        if (n > 0) {
            Channel channel = this.findChannelById(n);
            baseChannel = channel.getHost();
            if (baseChannel == null) {
                throw new WCMException(101100, I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label2", "\u6307\u5b9a\u680f\u76ee[Id=") + n + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label3", "]\u7684\u7236\u680f\u76ee\u6216\u8005\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01"));
            }
        } else {
            if (methodContext.getValue("ChannelId", 0) == 0 && methodContext.getValue("SiteId", 0) == 0) {
                return this.filterChannels(methodContext);
            }
            baseChannel = this.findBaseChannel(methodContext, "");
        }
        return this.getChildren(methodContext, user, baseChannel);
    }

    private Channels getChildren(MethodContext methodContext, User user, BaseChannel baseChannel) throws WCMException {
        int n;
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        Channels channels = ChannelHelper.getChildren(user, baseChannel, wCMFilter);
        Channel[] channelArray = new Channel[2];
        for (n = channels.size() - 1; n >= 0; --n) {
            Channel channel = (Channel)channels.getAt(n);
            if (channel == null || channel.getType() != 2 && channel.getType() != 1) continue;
            channels.removeAt(n, false);
            channelArray[channel.getType() == 2 ? 0 : 1] = channel;
        }
        if (!methodContext.getValue("ExcludeTopOrPic", false)) {
            n = 0;
            for (int i = 0; i < channelArray.length; ++i) {
                if (channelArray[i] == null) continue;
                channels.addElement(channelArray[i], n++);
            }
        }
        return channels;
    }

    public int save(MethodContext methodContext) throws Throwable {
        BaseChannel baseChannel;
        User user = this.getLoginUser();
        Channel channel = null;
        BaseChannel baseChannel2 = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            channel = new Channel();
            baseChannel2 = this.getParentChannelOrSite(methodContext);
        } else {
            channel = Channel.findById(n);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
            }
        }
        int n2 = n == 0 ? 11 : 13;
        BaseChannel baseChannel3 = baseChannel = n == 0 ? baseChannel2 : channel;
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n2)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6216\u8005\u4fee\u6539\u680f\u76ee![ObjectId=") + methodContext.getObjectId() + "][Host=" + baseChannel + "]");
        }
        String[] stringArray = new String[]{"ObjectId"};
        if ((channel = (Channel)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, channel, stringArray)).isAddMode()) {
            channel.setSite(baseChannel2.getSiteId());
        }
        if (methodContext.containsParameter("OnlySearch")) {
            channel.setOnlySearch(methodContext.getValue("OnlySearch", false));
        }
        if (methodContext.containsParameter("OnlyManager")) {
            channel.setOnlyManager(methodContext.getValue("OnlyManager", false));
        }
        if (methodContext.containsParameter("CanPub")) {
            channel.setCanPub(methodContext.getValue("CanPub", true));
        }
        if (methodContext.containsParameter("DoDeptFilter")) {
            channel.setDoDeptFilter(methodContext.getValue("DoDeptFilter", true));
        }
        this.m_oChannelMgr.save(channel);
        return channel.getId();
    }

    private BaseChannel getParentChannelOrSite(MethodContext methodContext) throws WCMException {
        BaseChannel baseChannel;
        int n = methodContext.getValue("ParentId", 0);
        if (n == 0) {
            int n2 = methodContext.getValue("SiteId", 0);
            if (n2 <= 0) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label6", "\u6ca1\u6709\u6307\u5b9aParentId\u6216\u8005SiteId    "));
            }
            baseChannel = WebSite.findById(n2);
            if (baseChannel == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(103)}));
            }
        } else {
            baseChannel = Channel.findById(n);
            if (baseChannel == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
            }
        }
        return baseChannel;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        if (methodContext.getObjectId() == 0) {
            Channel channel = new Channel();
            int n2 = methodContext.getValue("ParentId", 0);
            int n3 = methodContext.getValue("SiteId", 0);
            if (n2 > 0) {
                channel.setParent(n2);
                Channel channel2 = this.findChannelById(n2);
                channel.setSite(channel2.getSiteId());
            } else if (n3 > 0) {
                channel.setSite(methodContext.getValue("SiteId", 0));
            }
            channel.setType(methodContext.getValue("ChnlType", 0));
            channel.setCrUser(user);
            return channel;
        }
        Channel channel = this.findChannelById(methodContext.getObjectId());
        if (!AuthServer.hasRight(user, (CMSObj)channel, n = 64)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label9", "\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label10", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u680f\u76ee[Id=") + channel.getId() + "]\uff01");
        }
        return channel;
    }

    public Object filterChannels(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        Channels channels = Channels.openWCMObjs(user, wCMFilter);
        return channels;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channels channels = Channels.findByIds(user, methodContext.getObjectIds());
        ChannelHelper.removeNoRightChannel(user, channels, 64);
        return channels;
    }

    public PageOperators getOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            Channel channel = this.findChannelById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "channel", channel);
        }
        String string = methodContext.getObjectIds();
        if (string != null && string.length() > 0) {
            Channels channels = Channels.findByIds(user, string);
            if (channels.isEmpty()) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ObjectIds=") + string + "]\uff01");
            }
            if (channels.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "channel", (CMSObj)channels.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(user, "channels", channels);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getDocumentOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            Channel channel = this.findChannelById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "documentInChannel", channel);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInChannel(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            Channel channel = this.findChannelById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "ChannelHost", channel);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = null;
        if (methodContext.getValue("ParentChannelId", 0) > 0 || methodContext.getValue("ParentSiteId", 0) > 0) {
            baseChannel = this.findBaseChannel(methodContext, "Parent");
        }
        boolean bl = methodContext.getValue("ContainsChildren", true);
        boolean bl2 = methodContext.getValue("ContainsRelated", false);
        Channels channels = null;
        if (baseChannel != null) {
            channels = this.getChildren(methodContext, user, baseChannel);
        } else {
            channels = Channels.findByIds(user, methodContext.getObjectIds());
            ChannelHelper.removeNoRightChannel(user, channels, 13);
        }
        if (channels.isEmpty()) {
            return "no-available-channels";
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        methodContext.setContentTypeIsHTML();
        return channelExporter.export(channels, bl, bl2, false, true);
    }

    public String importChannels(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.findDstBaseChannel(methodContext);
        String string = methodContext.getValue("ImportFile");
        WCMAJAXServiceHelper.validateFile(string);
        String string2 = methodContext.getValue("ImportXSLFile");
        WCMAJAXServiceHelper.validateFile(string2);
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label14", "]\u6ca1\u6709\u6743\u9650\u5728[") + baseChannel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label15", "]\u5bfc\u5165\u680f\u76ee\uff01"));
        }
        ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        return channelImporter.importFromFile(string, string2, baseChannel).toJSONXML();
    }

    private BaseChannel findDstBaseChannel(MethodContext methodContext) throws WCMException {
        return this.findBaseChannel(methodContext, "Dst");
    }

    private BaseChannel findBaseChannel(MethodContext methodContext, String string) throws WCMException {
        int n = methodContext.getValue(string + "ChannelId", 0);
        int n2 = methodContext.getValue(string + "SiteId", 0);
        BaseChannel baseChannel = null;
        if (n > 0) {
            baseChannel = this.findChannelById(n);
        } else if (n2 > 0) {
            baseChannel = this.findSiteById(n2);
        } else {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label16", "\u6ca1\u6709\u6307\u5b9a") + string + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label17", "ChannelId\u6216\u8005") + string + "SiteId\uff01");
        }
        return baseChannel;
    }

    public String createFrom(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.findDstBaseChannel(methodContext);
        int n = methodContext.getValue("SrcChannelId", 0);
        Channel channel = this.findChannelById(n);
        if (channel.getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
        }
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label45", "]\u6ca1\u6709\u6743\u9650") + CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label47", "\u5728[{1}]\u4e0a\u8fdb\u884c \u7c7b\u4f3c\u521b\u5efa."), new Object[]{baseChannel}));
        }
        if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label45", "]\u6ca1\u6709\u6743\u9650") + CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label46", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]."), new Object[]{channel.getDispDesc(), baseChannel}));
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        try {
            String string = channelExporter.export(channel, true, true);
            Reports reports = channelImporter.importFromFile(string, null, baseChannel);
            List list = reports.getFailedReporter();
            List list2 = reports.getSucessedReporter();
            if (list != null && list.size() > 0) {
                reports.setTitle(I18NMessage.get(WebSiteServiceProvider.class, "ChannelServiceProvider.label42", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee"));
                String string2 = CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label44", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]\u5931\u8d25\uff01"), new Object[]{channel.getDispDesc(), baseChannel});
                ((Report)list.get(0)).setRportTitle(string2);
            } else if (list2 != null && list2.size() > 0) {
                reports.setTitle(I18NMessage.get(WebSiteServiceProvider.class, "ChannelServiceProvider.label42", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee"));
                String string3 = CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label43", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]\u6210\u529f\uff01"), new Object[]{channel.getDispDesc(), baseChannel});
                ((Report)list2.get(0)).setRportTitle(string3);
            }
            methodContext.setValue("reports", reports.getResultIds());
            return reports.toJSONXML();
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label25", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee\u5931\u8d25!"), wCMException);
        }
    }

    public void moveAsChild(MethodContext methodContext) throws Throwable {
        BaseChannel baseChannel;
        User user = this.getLoginUser();
        if (!AuthServer.hasRight(user, (CMSObj)(baseChannel = this.findDstBaseChannel(methodContext)), 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label14", "]\u6ca1\u6709\u6743\u9650\u5728[") + baseChannel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label26", "]\u4e0b\u65b0\u589e\u680f\u76ee\uff01"));
        }
        int n = methodContext.getValue("SrcChannelId", 0);
        if (n > 0) {
            Channel channel = this.findChannelById(n);
            this.moveAsChild(user, channel, baseChannel);
            return;
        }
        String string = methodContext.getValue("SrcChannelIds");
        Channels channels = Channels.findByIds(user, string);
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.moveAsChild(user, channel, baseChannel);
        }
    }

    private void moveAsChild(User user, Channel channel, BaseChannel baseChannel) throws WCMException {
        if (!AuthServer.hasRight(user, (CMSObj)channel, 12)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label27", "]\u6ca1\u6709\u6743\u9650\u79fb\u52a8\u680f\u76ee[") + channel.getDispDesc() + "]\uff01");
        }
        this.m_oChannelMgr.moveTo(channel, baseChannel, 1);
    }

    public void changeOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcChannelId", 0);
        Channel channel = this.findChannelById(n);
        int n2 = methodContext.getValue("DstChannelId", 0);
        Channel channel2 = null;
        if (n2 > 0) {
            channel2 = this.findChannelById(n2);
        }
        if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label28", "]\u6ca1\u6709\u6743\u9650\u6539\u53d8\u680f\u76ee[") + channel.getDispDesc() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label29", "]\u7684\u987a\u5e8f\uff01"));
        }
        if (!channel.canEdit(user)) {
            throw new WCMException(channel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label30", "\u5df2\u7ecf\u88ab[") + channel.getLockerUserName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label31", "]\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u505a\u4efb\u4f55\u79fb\u52a8\u64cd\u4f5c\uff01"));
        }
        int n3 = this.isToFirst(channel2) ? -1 : channel2.getOrder();
        channel.setOrder(n3);
        this.m_oChannelMgr.save(channel);
    }

    public Channels getRecycleChannels(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.findBaseChannel(methodContext, "");
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        Channels channels = this.m_oChannelMgr.getRecycleChannels(baseChannel, wCMFilter);
        if (user.isAdministrator()) {
            return channels;
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel != null && AuthServer.hasRight(user, (CMSObj)channel, 12)) continue;
            channels.removeAt(i, false);
        }
        return channels;
    }

    public void restoreChannels(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.findBaseChannel(methodContext, "");
        boolean bl = methodContext.getValue("RestoreAll", false);
        Channels channels = null;
        channels = bl ? this.m_oChannelMgr.getRecycleChannels(baseChannel, null) : Channels.findByIds(user, methodContext.getObjectIds());
        if (channels.size() == 0) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label36", "\u680f\u76ee\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u8fd8\u539f\u7684\u680f\u76ee\uff01"));
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !AuthServer.hasRight(user, (CMSObj)channel, 12)) continue;
            this.m_oChannelMgr.restore(channel);
        }
    }

    public void clearRecycle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.findBaseChannel(methodContext, "");
        Channels channels = this.m_oChannelMgr.getRecycleChannels(baseChannel, null);
        if (channels.size() == 0) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label38", "\u680f\u76ee\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u5220\u9664\u7684\u680f\u76ee\uff01"));
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !AuthServer.hasRight(user, (CMSObj)channel, 12)) continue;
            this.m_oChannelMgr.delete(channel, true);
        }
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        Cloneable cloneable;
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getObjectId();
        if (n == 0 && (cloneable = Channel.findById(n2)) != null) {
            n = ((Channel)cloneable).getSiteId();
        }
        cloneable = new WCMFilter("WCMCHANNEL", "SiteId=? and ChnlName=? and ChannelId<>?", "", "ChannelId");
        ((WCMFilter)cloneable).addSearchValues(0, n);
        ((WCMFilter)cloneable).addSearchValues(1, methodContext.getValue("ChannelName"));
        ((WCMFilter)cloneable).addSearchValues(2, n2);
        return DBManager.getDBManager().sqlExecuteIntQuery((WCMFilter)cloneable) > 0;
    }

    public Object existsSimilarDataPath(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("WCMCHANNEL", "SiteId=? and ParentId=? and ChannelId<>? and exists(select FolderId from WCMFolderPublishConfig where FolderType=101 and FolderId=WCMChannel.ChannelId and DataPath=?)", "", "ChannelId");
        int n = methodContext.getValue("SiteId", 0);
        int n2 = methodContext.getValue("ParentId", 0);
        int n3 = methodContext.getObjectId();
        if (n == 0 && n3 != 0) {
            Channel channel = Channel.findById(n3);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label39", "\u65e0\u6cd5\u83b7\u53d6\u5230[ID=") + n3 + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label40", "]\u7684\u680f\u76ee!"));
            }
            n = channel.getSiteId();
            n2 = channel.getParentId();
        }
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        wCMFilter.addSearchValues(n3);
        wCMFilter.addSearchValues(methodContext.getValue("DataPath"));
        int n4 = DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter);
        if (n4 > 0) {
            Channel channel = Channel.findById(n4);
            if (channel == null) {
                return "";
            }
            return channel.getDesc() + "-" + channel.getId();
        }
        return "";
    }

    public String checkSQLValid(MethodContext methodContext) throws WCMException {
        String string = methodContext.getValue("queryby");
        String string2 = methodContext.getValue("orderby");
        int n = methodContext.getValue("CHANNELID", 0);
        if (CMyString.isEmpty(string) && CMyString.isEmpty(string2)) {
            return "";
        }
        Channel channel = new Channel();
        channel.setQuery(string);
        channel.setOrderBy(string2);
        WCMFilter wCMFilter = new WCMFilter(null, null, null, "WCMDocument.DocId");
        wCMFilter = DocumentsGetHelper.makeChannelFilter(channel, wCMFilter, true, false, n);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        try {
            DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter);
        }
        catch (WCMException wCMException) {
            String string3 = null;
            Throwable throwable = wCMException.getRootCause();
            string3 = throwable != null && throwable instanceof SQLException ? throwable.getMessage() : wCMException.getMessage();
            hashMap.put("error", string3);
        }
        hashMap.put("sql", wCMFilter);
        methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hashMap, 0);
    }

    private Channel findChannelById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
        }
        return channel;
    }

    private WebSite findSiteById(int n) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(103)}));
        }
        return webSite;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private boolean isToFirst(Channel channel) {
        if (channel == null) {
            return true;
        }
        switch (channel.getType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void createFromFile(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ImportFile");
        string = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        BaseChannel baseChannel = this.findDstBaseChannel(methodContext);
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6216\u8005\u4fee\u6539\u680f\u76ee![ObjectId=") + methodContext.getObjectId() + "][Host=" + baseChannel + "]");
        }
        IVChannelParser iVChannelParser = (IVChannelParser)DreamFactory.createObjectById("IVChannelParser");
        VChannel vChannel = iVChannelParser.parse(string);
        VChannelManager vChannelManager = (VChannelManager)DreamFactory.createObjectById("VChannelManager");
        StringBuffer stringBuffer = methodContext.getServiceContext().getRequest().getRequestURL();
        String string2 = methodContext.getServiceContext().getRequest().getRequestURI();
        stringBuffer.replace(stringBuffer.indexOf(string2), stringBuffer.length(), "");
        ContextParameters.set1(stringBuffer.toString());
        if (baseChannel.isSite()) {
            vChannelManager.save((WebSite)baseChannel, vChannel);
        } else {
            vChannelManager.save((Channel)baseChannel, vChannel);
        }
        ContextParameters.get1();
    }

    public String createChannelTreeHTMLOfIds(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label39", "\u65e0\u6cd5\u83b7\u53d6\u5230[ID=") + n + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label40", "]\u7684\u680f\u76ee!"));
        }
        StringBuffer stringBuffer = new StringBuffer(4096);
        Channels channels = ChannelHelper.getChildren(user, channel, new WCMFilter());
        if (channels.size() <= 0) {
            return "";
        }
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel2 = (Channel)channels.getAt(i);
            if (channel2 == null) continue;
            this.makeChannelHTML(stringBuffer, channel2);
        }
        return stringBuffer.toString();
    }

    private void makeChannelHTML(StringBuffer stringBuffer, Channel channel) throws WCMException {
        if (channel == null) {
            return;
        }
        this.appendOneChannelHTML(stringBuffer, channel);
        int n = DBManager.getDBManager().sqlExecuteIntQuery("Select ChannelId from WCMChannel Where ParentId=?", new int[]{channel.getId()});
        if (n > 0) {
            stringBuffer.append("<ul></ul>\n");
        }
    }

    private void appendOneChannelHTML(StringBuffer stringBuffer, Channel channel) throws WCMException {
        int n = DBManager.getDBManager().sqlExecuteIntQuery("Select ChannelId from WCMChannel Where ParentId=?", new int[]{channel.getId()});
        boolean bl = false;
        if (n > 0) {
            bl = true;
        }
        stringBuffer.append("<div objectId=");
        stringBuffer.append("'");
        stringBuffer.append(channel.getId());
        stringBuffer.append("'");
        stringBuffer.append(" id=");
        stringBuffer.append("'");
        stringBuffer.append("node_");
        stringBuffer.append(channel.getId());
        stringBuffer.append("'");
        if (bl) {
            stringBuffer.append(" onlyNode='true'");
        }
        stringBuffer.append(" title=");
        stringBuffer.append("'");
        stringBuffer.append("ID:");
        stringBuffer.append(channel.getId());
        stringBuffer.append("'");
        stringBuffer.append(" chnlOrder=");
        stringBuffer.append("'");
        stringBuffer.append(channel.getOrder());
        stringBuffer.append("'");
        stringBuffer.append(">");
        stringBuffer.append("<a href=#>");
        stringBuffer.append(CMyString.transDisplay(channel.getDesc()));
        stringBuffer.append("</a></div>");
    }

    public int saveForSpecial(MethodContext methodContext) throws Throwable {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        int n2 = Integer.valueOf(methodContext.getValue("PARENTID"));
        BaseChannel baseChannel = null;
        if (n2 != 0) {
            baseChannel = (BaseChannel)BaseChannel.findById(101, n2);
            if (baseChannel == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + n2 + "]");
            }
        } else {
            object4 = new WCMFilter();
            ((WCMFilter)object4).setWhere("SiteName = ?");
            ((WCMFilter)object4).addSearchValues(0, "\u4e13\u9898\u5e93");
            object3 = WebSites.openWCMObjs(ContextHelper.getLoginUser(), (WCMFilter)object4);
            if (((BaseObjs)object3).size() > 0) {
                baseChannel = (WebSite)((BaseObjs)object3).getAt(0);
            }
        }
        if (baseChannel != null) {
            object4 = methodContext.getValue("CHNLNAME");
            methodContext.setValue("CHNLNAME", this.getNewChnlName((String)object4, baseChannel));
        }
        if ((object3 = Channel.findById(n = this.save(methodContext))) == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + n + "]");
        }
        int n3 = methodContext.getValue("SPECIALID", 0);
        boolean bl = methodContext.getValue("bDataOper4Chnl", false);
        if (bl) {
            object2 = (ISpecialMgr)DreamFactory.createObjectById("ISpecialMgr");
            object = object2.findSpecialByChnlId(this.getLoginUser(), n2);
            if (object == null) {
                return n;
            }
            n3 = ((BaseObj)object).getId();
        }
        if ((object2 = Special.findById(n3)) == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728![ObjectId=") + n3 + "]");
        }
        object = PublishElementFactory.lookupElement(101, n);
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)object);
        wCMFolderPublishConfig.setFolderType(101, n);
        wCMFolderPublishConfig.setDataPath(n + "");
        wCMFolderPublishConfig.canEdit(this.getLoginUser());
        this.setTemplate((Channel)object3, wCMFolderPublishConfig);
        wCMFolderPublishConfig.save(this.getLoginUser());
        return n;
    }

    private void setTemplate(Channel channel, WCMFolderPublishConfig wCMFolderPublishConfig) throws WCMException {
        Channel channel2 = channel.getParent();
        if (channel2 == null) {
            return;
        }
        boolean bl = channel2.getParentId() == 0;
        int n = channel2.getId();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, n);
        WCMFolderPublishConfig wCMFolderPublishConfig2 = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
        int n2 = 0;
        if (bl) {
            TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
            String string = "VISUAL=1 and TEMPNAME like '\u5206\u7c7b\u9996\u9875\u6a21\u677f%'";
            WCMFilter wCMFilter = new WCMFilter("", string, "CRTIME asc");
            Templates templates = templateMgr.getManagedTemplates((IPublishFolder)iPublishElement, 1, wCMFilter, false);
            int n3 = templates.size();
            for (int i = 0; i < n3; ++i) {
                Template template = (Template)templates.getAt(i);
                if (template == null) continue;
                n2 = template.getId();
                break;
            }
            if (n2 == 0) {
                n2 = this.findTemplateOfSite(channel, 1);
            }
        } else {
            n2 = wCMFolderPublishConfig2.getDefaultOutlineTemplateId();
            if (n2 == 0) {
                n2 = this.findTemplateOfSite(channel, 1);
            }
        }
        if (n2 != 0) {
            wCMFolderPublishConfig.setOutlineTemplateId(n2 + "");
        }
        int n4 = 0;
        n4 = wCMFolderPublishConfig2.getDetailTemplateId();
        if (n4 == 0) {
            n4 = this.findTemplateOfSite(channel, 2);
        }
        if (n4 != 0) {
            wCMFolderPublishConfig.setDetailTemplateId(n4);
        }
    }

    private int findTemplateOfSite(Channel channel, int n) throws WCMException {
        Template template;
        if (channel == null) {
            return 0;
        }
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(103, channel.getSiteId());
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        if (n == 1) {
            Templates templates = templateEmployMgr.getOtherOutlineTemplates((IPublishFolder)iPublishElement);
            if (templates.size() > 0) {
                Template template2 = (Template)templates.getAt(0);
                return template2.getId();
            }
        } else if (n == 2 && (template = templateEmployMgr.getDetailTemplate((IPublishFolder)iPublishElement)) != null) {
            return template.getId();
        }
        return 0;
    }

    private String getNewChnlName(String string, BaseChannel baseChannel) throws Throwable {
        String string2 = string;
        if (!this.existsChnlName(string2, baseChannel)) {
            return string2;
        }
        String string3 = string2 = string2.replaceAll("(_\\d+)+", "");
        int n = DBManager.getDBManager().sqlExecuteIntQuery("select max(channelid) from wcmchannel", new int[0]);
        while (this.existsChnlName(string3, baseChannel)) {
            string3 = string2 + "_" + n;
            ++n;
        }
        return string3;
    }

    private boolean existsChnlName(String string, BaseChannel baseChannel) {
        if (baseChannel instanceof Channel) {
            return Channel.findByName(baseChannel.getSiteId(), string) != null;
        }
        if (baseChannel instanceof WebSite) {
            return Channel.findByName(baseChannel.getId(), string) != null;
        }
        return false;
    }

    public Object findChannelByPath(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ChnlPath");
        Channel channel = this.m_oChannelMgr.getChannelByPath(string);
        if (channel == null) {
            return channel;
        }
        int n = 64;
        if (!AuthServer.hasRight(user, (CMSObj)channel, n)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label9", "\u60a8[") + user.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label10", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u680f\u76ee[Id=") + channel.getId() + "]\uff01");
        }
        return channel;
    }
}

