/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import weibo4j.Weibo;
import weibo4j.http.ImageItem;
import weibo4j.model.Emotion;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timeline {
    public StatusWapper getPublicTimeline() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/public_timeline.json"));
    }

    public StatusWapper getPublicTimeline(int count, int baseApp) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/public_timeline.json", new PostParameter[]{new PostParameter("count", count), new PostParameter("base_app", baseApp)}));
    }

    public StatusWapper getFriendsTimeline() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline.json"));
    }

    public StatusWapper getFriendsTimeline(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging));
    }

    public JSONObject getFriendsTimelineIds() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline/ids.json").asJSONObject();
    }

    public JSONObject getFriendsTimelineIds(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/friends_timeline/ids.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging).asJSONObject();
    }

    public StatusWapper getHomeTimeline() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/home_timeline.json"));
    }

    public StatusWapper getHomeTimeline(Integer baseAPP, Integer feature, Paging paging) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/home_timeline.json", new PostParameter[]{new PostParameter("base_app", baseAPP.toString()), new PostParameter("feature", feature.toString())}, paging));
    }

    public StatusWapper getUserTimeline() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json"));
    }

    public StatusWapper getUserTimelineByUid(String uid) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public StatusWapper getUserTimelineByName(String screen_name) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}));
    }

    public StatusWapper getUserTimelineByUid(String uid, Paging page, Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("base_app", base_app.toString()), new PostParameter("feature", feature.toString())}, page));
    }

    public StatusWapper getUserTimelineByName(String screen_name, Paging page, Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("base_app", base_app.toString()), new PostParameter("feature", feature.toString())}, page));
    }

    public JSONObject getUserTimelineIdsByUid(String uid) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline/ids.json", new PostParameter[]{new PostParameter("uid", uid)}).asJSONObject();
    }

    public JSONObject getUserTimelineIdsByName(String screen_name) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/user_timeline/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}).asJSONObject();
    }

    public StatusWapper getRepostTimeline(String id) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public StatusWapper getRepostTimeline(String id, Paging page) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline.json", new PostParameter[]{new PostParameter("id", id)}, page));
    }

    public JSONObject getRepostTimelineIds(String id) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_timeline/ids.json", new PostParameter[]{new PostParameter("id", id)}).asJSONObject();
    }

    public StatusWapper getRepostByMe() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_by_me.json"));
    }

    public StatusWapper getRepostByMe(Paging page) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost_by_me.json", null, page));
    }

    public StatusWapper getMentions() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions.json"));
    }

    public StatusWapper getMentions(Paging page, Integer filter_by_author, Integer filter_by_source, Integer filter_by_type) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_author.toString()), new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_type", filter_by_type.toString())}, page));
    }

    public JSONObject getMentionsIds() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions/ids.json").asJSONObject();
    }

    public JSONObject getMentionsIds(Paging page, Integer filter_by_author, Integer filter_by_source, Integer filter_by_type) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/mentions/ids.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_author.toString()), new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_type", filter_by_type.toString())}, page).asJSONObject();
    }

    public StatusWapper getBilateralTimeline() throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/bilateral_timeline.json"));
    }

    public StatusWapper getBilateralTimeline(Integer base_app, Integer feature) throws WeiboException {
        return Status.constructWapperStatus(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/bilateral_timeline.json", new PostParameter[]{new PostParameter("base_app", base_app), new PostParameter("feature", feature)}));
    }

    public Status showStatus(String id) throws WeiboException {
        return new Status(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/show.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public JSONObject QueryMid(Integer type, String id) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/querymid.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("type", type.toString())}).asJSONObject();
    }

    public JSONObject QueryMid(Integer type, String id, int is_batch) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/querymid.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("type", type.toString()), new PostParameter("is_batch", is_batch)}).asJSONObject();
    }

    public JSONObject QueryId(String mid, Integer type, int isBase62) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/queryid.json", new PostParameter[]{new PostParameter("mid", mid), new PostParameter("type", type.toString()), new PostParameter("isBase62", isBase62)}).asJSONObject();
    }

    public JSONObject QueryId(String mid, Integer type, Integer isBatch, Integer isBase62) throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/queryid.json", new PostParameter[]{new PostParameter("mid", mid), new PostParameter("type", type.toString()), new PostParameter("is_batch", isBatch.toString()), new PostParameter("isBase62", isBase62.toString())}).asJSONObject();
    }

    public JSONArray getRepostDaily() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/hot/repost_daily.json").asJSONArray();
    }

    public JSONArray getRepostWeekly() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/hot/repost_weekly.json").asJSONArray();
    }

    public JSONArray getCommentsDaily() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/hot/comments_daily.json").asJSONArray();
    }

    public JSONArray getCommentsWeekly() throws WeiboException {
        return Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/hot/comments_weekly.json").asJSONArray();
    }

    public Status Repost(String id) throws WeiboException {
        return new Status(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public Status Repost(String id, String status, Integer is_comment) throws WeiboException {
        return new Status(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("status", status), new PostParameter("is_comment", is_comment.toString())}));
    }

    public Status Destroy(String id) throws WeiboException {
        return new Status(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/destroy.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public Status UpdateStatus(String status) throws WeiboException {
        return new Status(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status)}));
    }

    public Status UpdateStatus(String status, Float lat, Float longs, String annotations) throws WeiboException {
        return new Status(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", lat.toString()), new PostParameter("long", longs.toString()), new PostParameter("annotations", annotations)}));
    }

    public Status UploadStatus(String status, ImageItem item) throws WeiboException {
        return new Status(Weibo.client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status)}, item));
    }

    public Status UploadStatus(String status, ImageItem item, Float lat, Float longs) throws WeiboException {
        return new Status(Weibo.client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "statuses/upload.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", lat.toString()), new PostParameter("long", longs.toString())}, item));
    }

    public List<Emotion> getEmotions() throws WeiboException {
        return Emotion.constructEmotions(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "emotions.json"));
    }

    public List<Emotion> getEmotions(String type, String language) throws WeiboException {
        return Emotion.constructEmotions(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "emotions.json", new PostParameter[]{new PostParameter("type", type), new PostParameter("language", language)}));
    }
}

