/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import weibo4j.Weibo;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Tag;
import weibo4j.model.TagWapper;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tags {
    public List<Tag> getTags(String uid) throws WeiboException {
        return Tag.constructTags(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public List<Tag> getTags(String uid, Paging page) throws WeiboException {
        return Tag.constructTags(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags.json", new PostParameter[]{new PostParameter("uid", uid)}, page));
    }

    public TagWapper getTagsBatch(String uids) throws WeiboException {
        return Tag.constructTagWapper(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/tags_batch.json", new PostParameter[]{new PostParameter("uids", uids)}));
    }

    public List<Tag> getTagsSuggestions() throws WeiboException {
        return Tag.constructTags(Weibo.client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/suggestions.json"));
    }

    public JSONArray createTags(String tags) throws WeiboException {
        return Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/create.json", new PostParameter[]{new PostParameter("tags", tags)}).asJSONArray();
    }

    public JSONObject destoryTag(Integer tag_id) throws WeiboException {
        return Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/destroy.json", new PostParameter[]{new PostParameter("tag_id", tag_id.toString())}).asJSONObject();
    }

    public List<Tag> destroyTagsBatch(String ids) throws WeiboException {
        return Tag.constructTags(Weibo.client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}));
    }
}

