/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.Field;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.JdbcBlackHole;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class KbDatabaseMetaData
implements DatabaseMetaData {
    private static final String keywords = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    protected final KbConnection connection;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final Map<String, Map<String, String>> tableTypeClauses = new HashMap<String, Map<String, String>>();

    public KbDatabaseMetaData(KbConnection conn) {
        this.connection = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            String sql = "SELECT setting FROM sys_catalog.sys_settings WHERE name='max_index_keys'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    stmt.close();
                    throw new KSQLException(GT.tr("Unable to determine a value for MaxIndexKeys due to missing system catalog data.", new Object[0]), KSQLState.UNEXPECTED_ERROR);
                }
                this.INDEX_MAX_KEYS = rs.getInt(1);
            }
            finally {
                JdbcBlackHole.close(rs);
                JdbcBlackHole.close(stmt);
            }
        }
        return this.INDEX_MAX_KEYS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = "SELECT t.typlen FROM sys_catalog.sys_type t, sys_catalog.sys_namespace n WHERE t.typnamespace=n.oid AND t.typname='NAME' AND n.nspname='SYS_CATALOG'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    throw new KSQLException(GT.tr("Unable to find name datatype in the system catalogs.", new Object[0]), KSQLState.UNEXPECTED_ERROR);
                }
                this.NAMEDATALEN = rs.getInt("typlen");
            }
            finally {
                JdbcBlackHole.close(rs);
                JdbcBlackHole.close(stmt);
            }
        }
        return this.NAMEDATALEN - 1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "KingbaseES";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDBVersionNumber();
    }

    @Override
    public String getDriverName() {
        return "Kingbase8 JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "V008R002B0001.jre6";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,round,sign,sin,sqrt,tan,truncate";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String funcs = "ascii,CHAR,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase";
        funcs = funcs + ",replace";
        return funcs;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String timeDateFuncs = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
        timeDateFuncs = timeDateFuncs + ",timestampadd";
        return timeDateFuncs;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected String escapeQuotes(String s) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (!this.connection.getStandardConformingStrings()) {
            sb.append("E");
        }
        sb.append("'");
        sb.append(this.connection.escapeString(s));
        sb.append("'");
        return sb.toString();
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE,  p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM sys_catalog.sys_namespace n, sys_catalog.sys_proc p  LEFT JOIN sys_catalog.sys_description d ON (p.oid=d.objoid)  LEFT JOIN sys_catalog.sys_class c ON (d.classoid=c.oid AND c.relname='SYS_PROC')  LEFT JOIN sys_catalog.sys_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='SYS_CATALOG')  WHERE p.pronamespace=n.oid ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            sql = sql + " AND p.proname LIKE " + this.escapeQuotes(procedureNamePattern);
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.oid::text ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        int columns = 20;
        Field[] f = new Field[columns];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("PROCEDURE_CAT", 1043);
        f[1] = new Field("PROCEDURE_SCHEM", 1043);
        f[2] = new Field("PROCEDURE_NAME", 1043);
        f[3] = new Field("COLUMN_NAME", 1043);
        f[4] = new Field("COLUMN_TYPE", 21);
        f[5] = new Field("DATA_TYPE", 21);
        f[6] = new Field("TYPE_NAME", 1043);
        f[7] = new Field("PRECISION", 23);
        f[8] = new Field("LENGTH", 23);
        f[9] = new Field("SCALE", 21);
        f[10] = new Field("RADIX", 21);
        f[11] = new Field("NULLABLE", 21);
        f[12] = new Field("REMARKS", 1043);
        f[13] = new Field("COLUMN_DEF", 1043);
        f[14] = new Field("SQL_DATA_TYPE", 23);
        f[15] = new Field("SQL_DATETIME_SUB", 23);
        f[16] = new Field("CHAR_OCTECT_LENGTH", 23);
        f[17] = new Field("ORDINAL_POSITION", 23);
        f[18] = new Field("IS_NULLABLE", 1043);
        f[19] = new Field("SPECIFIC_NAME", 1043);
        String sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid,  p.proargnames, p.proargmodes, p.proallargtypes, p.oid  FROM sys_catalog.sys_proc p, sys_catalog.sys_namespace n, sys_catalog.sys_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (procedureNamePattern != null && !procedureNamePattern.isEmpty()) {
            sql = sql + " AND p.proname LIKE " + this.escapeQuotes(procedureNamePattern);
        }
        sql = sql + " ORDER BY n.nspname, p.proname, p.oid::text ";
        byte[] isnullableUnknown = new byte[]{};
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] procedureName = rs.getBytes("proname");
            byte[] specificName = this.connection.encodeString(rs.getString("proname") + "_" + rs.getString("OID"));
            int returnType = (int)rs.getLong("prorettype");
            String returnTypeType = rs.getString("typtype");
            int returnTypeRelid = (int)rs.getLong("typrelid");
            String strArgTypes = rs.getString("proargtypes");
            StringTokenizer st = new StringTokenizer(strArgTypes);
            ArrayList<Long> argTypes = new ArrayList<Long>();
            while (st.hasMoreTokens()) {
                argTypes.add(Long.valueOf(st.nextToken()));
            }
            String[] argNames = null;
            Array argNamesArray = rs.getArray("proargnames");
            if (argNamesArray != null) {
                argNames = (String[])argNamesArray.getArray();
            }
            String[] argModes = null;
            Array argModesArray = rs.getArray("proargmodes");
            if (argModesArray != null) {
                argModes = (String[])argModesArray.getArray();
            }
            int numArgs = argTypes.size();
            Long[] allArgTypes = null;
            Array allArgTypesArray = rs.getArray("proallargtypes");
            if (allArgTypesArray != null) {
                allArgTypes = (Long[])allArgTypesArray.getArray();
                numArgs = allArgTypes.length;
            }
            if (returnTypeType.equals("b") || returnTypeType.equals("d") || returnTypeType.equals("e") || returnTypeType.equals("p") && argModesArray == null) {
                byte[][] tuple = new byte[columns][];
                tuple[0] = null;
                tuple[1] = schema;
                tuple[2] = procedureName;
                tuple[3] = this.connection.encodeString("returnValue");
                tuple[4] = this.connection.encodeString(Integer.toString(5));
                tuple[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(returnType)));
                tuple[6] = this.connection.encodeString(this.connection.getTypeInfo().getKBType(returnType));
                tuple[7] = null;
                tuple[8] = null;
                tuple[9] = null;
                tuple[10] = null;
                tuple[11] = this.connection.encodeString(Integer.toString(2));
                tuple[12] = null;
                tuple[17] = this.connection.encodeString(Integer.toString(0));
                tuple[18] = isnullableUnknown;
                tuple[19] = specificName;
                v.add(tuple);
            }
            for (int i = 0; i < numArgs; ++i) {
                byte[][] tuple = new byte[columns][];
                tuple[0] = null;
                tuple[1] = schema;
                tuple[2] = procedureName;
                tuple[3] = argNames != null ? this.connection.encodeString(argNames[i]) : this.connection.encodeString("$" + (i + 1));
                int columnMode = 1;
                if (argModes != null && argModes[i].equals("o")) {
                    columnMode = 4;
                } else if (argModes != null && argModes[i].equals("b")) {
                    columnMode = 2;
                } else if (argModes != null && argModes[i].equals("t")) {
                    columnMode = 5;
                }
                tuple[4] = this.connection.encodeString(Integer.toString(columnMode));
                int argOid = allArgTypes != null ? allArgTypes[i].intValue() : ((Long)argTypes.get(i)).intValue();
                tuple[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(argOid)));
                tuple[6] = this.connection.encodeString(this.connection.getTypeInfo().getKBType(argOid));
                tuple[7] = null;
                tuple[8] = null;
                tuple[9] = null;
                tuple[10] = null;
                tuple[11] = this.connection.encodeString(Integer.toString(2));
                tuple[12] = null;
                tuple[17] = this.connection.encodeString(Integer.toString(i + 1));
                tuple[18] = isnullableUnknown;
                tuple[19] = specificName;
                v.add(tuple);
            }
            if (!returnTypeType.equals("c") && (!returnTypeType.equals("p") || argModesArray == null)) continue;
            String columnsql = "SELECT a.attname,a.atttypid FROM sys_catalog.sys_attribute a  WHERE a.attrelid = " + returnTypeRelid + " AND a.attnum > 0 ORDER BY a.attnum ";
            Statement columnstmt = this.connection.createStatement();
            ResultSet columnrs = columnstmt.executeQuery(columnsql);
            while (columnrs.next()) {
                int columnTypeOid = (int)columnrs.getLong("atttypid");
                byte[][] tuple = new byte[columns][];
                tuple[0] = null;
                tuple[1] = schema;
                tuple[2] = procedureName;
                tuple[3] = columnrs.getBytes("attname");
                tuple[4] = this.connection.encodeString(Integer.toString(3));
                tuple[5] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(columnTypeOid)));
                tuple[6] = this.connection.encodeString(this.connection.getTypeInfo().getKBType(columnTypeOid));
                tuple[7] = null;
                tuple[8] = null;
                tuple[9] = null;
                tuple[10] = null;
                tuple[11] = this.connection.encodeString(Integer.toString(2));
                tuple[12] = null;
                tuple[17] = this.connection.encodeString(Integer.toString(0));
                tuple[18] = isnullableUnknown;
                tuple[19] = specificName;
                v.add(tuple);
            }
            columnrs.close();
            columnstmt.close();
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String useSchemas = "SCHEMAS";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname ~ '^SYS_' OR n.nspname = 'INFORMATION_SCHEMA'  WHEN true THEN CASE  WHEN n.nspname = 'SYS_CATALOG' OR n.nspname = 'INFORMATION_SCHEMA' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'SYS_TOAST' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   WHEN 'S' THEN 'TEMPORARY SEQUENCE'   WHEN 'v' THEN 'TEMPORARY VIEW'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  WHEN 'c' THEN 'TYPE'  WHEN 'f' THEN 'FOREIGN TABLE'  WHEN 'm' THEN 'MATERIALIZED VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c  LEFT JOIN sys_catalog.sys_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN sys_catalog.sys_class dc ON (d.classoid=dc.oid AND dc.relname='SYS_CLASS')  LEFT JOIN sys_catalog.sys_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='SYS_CATALOG')  WHERE c.relnamespace = n.oid ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            select = select + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            select = select + " AND c.relname LIKE " + this.escapeQuotes(tableNamePattern);
        }
        if (types != null) {
            select = select + " AND (false ";
            StringBuilder orclause = new StringBuilder();
            for (String type : types) {
                Map<String, String> clauses = tableTypeClauses.get(type);
                if (clauses == null) continue;
                String clause = clauses.get(useSchemas);
                orclause.append(" OR ( ").append(clause).append(" ) ");
            }
            select = select + orclause.toString() + ") ";
        }
        String sql = select + orderby;
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String sql = "SELECT nspname AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM sys_catalog.sys_namespace  WHERE nspname <> 'SYS_TOAST' AND (nspname !~ '^SYS_TEMP_'  OR nspname = (sys_catalog.current_schemas(true))[1]) AND (nspname !~ '^SYS_TOAST_TEMP_'  OR nspname = replace((sys_catalog.current_schemas(true))[1], 'SYS_TEMP_', 'SYS_TOAST_TEMP_')) ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        sql = sql + " ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Field[] f = new Field[1];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TABLE_CAT", 1043);
        byte[][] tuple = new byte[][]{this.connection.encodeString(this.connection.getCatalog())};
        v.add(tuple);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Object[] types = tableTypeClauses.keySet().toArray(new String[0]);
        Arrays.sort(types);
        Field[] f = new Field[1];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TABLE_TYPE", 1043);
        for (Object type : types) {
            byte[][] tuple = new byte[][]{this.connection.encodeString((String)type)};
            v.add(tuple);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        int numberOfFields = 23;
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        Field[] f = new Field[numberOfFields];
        f[0] = new Field("TABLE_CAT", 1043);
        f[1] = new Field("TABLE_SCHEM", 1043);
        f[2] = new Field("TABLE_NAME", 1043);
        f[3] = new Field("COLUMN_NAME", 1043);
        f[4] = new Field("DATA_TYPE", 21);
        f[5] = new Field("TYPE_NAME", 1043);
        f[6] = new Field("COLUMN_SIZE", 23);
        f[7] = new Field("BUFFER_LENGTH", 1043);
        f[8] = new Field("DECIMAL_DIGITS", 23);
        f[9] = new Field("NUM_PREC_RADIX", 23);
        f[10] = new Field("NULLABLE", 23);
        f[11] = new Field("REMARKS", 1043);
        f[12] = new Field("COLUMN_DEF", 1043);
        f[13] = new Field("SQL_DATA_TYPE", 23);
        f[14] = new Field("SQL_DATETIME_SUB", 23);
        f[15] = new Field("CHAR_OCTET_LENGTH", 1043);
        f[16] = new Field("ORDINAL_POSITION", 23);
        f[17] = new Field("IS_NULLABLE", 1043);
        f[18] = new Field("SCOPE_CATLOG", 1043);
        f[19] = new Field("SCOPE_SCHEMA", 1043);
        f[20] = new Field("SCOPE_TABLE", 1043);
        f[21] = new Field("SOURCE_DATA_TYPE", 21);
        f[22] = new Field("IS_AUTOINCREMENT", 1043);
        String sql = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "SELECT * FROM (" : "";
        sql = sql + "SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,a.atttypmod,a.attlen,";
        sql = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? sql + "row_number() OVER (PARTITION BY a.attrelid ORDER BY a.attnum) AS attnum, " : sql + "a.attnum,";
        sql = sql + "sys_catalog.sys_get_expr(def.adbin, def.adrelid) AS adsrc,dsc.description,t.typbasetype,t.typtype  FROM sys_catalog.sys_namespace n  JOIN sys_catalog.sys_class c ON (c.relnamespace = n.oid)  JOIN sys_catalog.sys_attribute a ON (a.attrelid=c.oid)  JOIN sys_catalog.sys_type t ON (a.atttypid = t.oid)  LEFT JOIN sys_catalog.sys_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN sys_catalog.sys_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN sys_catalog.sys_class dc ON (dc.oid=dsc.classoid AND dc.relname='SYS_CLASS')  LEFT JOIN sys_catalog.sys_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='SYS_CATALOG')  WHERE c.relkind in ('r','v','f','m') and a.attnum > 0 AND NOT a.attisdropped ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            sql = sql + " AND c.relname LIKE " + this.escapeQuotes(tableNamePattern);
        }
        if (this.connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
            sql = sql + ") c WHERE true ";
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            sql = sql + " AND attname LIKE " + this.escapeQuotes(columnNamePattern);
        }
        sql = sql + " ORDER BY nspname,c.relname,attnum ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[numberOfFields][];
            int typeOid = (int)rs.getLong("atttypid");
            int typeMod = rs.getInt("atttypmod");
            tuple[0] = null;
            tuple[1] = rs.getBytes("nspname");
            tuple[2] = rs.getBytes("relname");
            tuple[3] = rs.getBytes("attname");
            String typtype = rs.getString("typtype");
            int sqlType = "c".equals(typtype) ? 2002 : ("d".equals(typtype) ? 2001 : ("e".equals(typtype) ? 12 : this.connection.getTypeInfo().getSQLType(typeOid)));
            if (typeOid == 11659 || typeOid == 11658) {
                sqlType = this.connection.getTypeInfo().getSQLType(typeOid);
            }
            tuple[4] = this.connection.encodeString(Integer.toString(sqlType));
            String pgType = this.connection.getTypeInfo().getKBType(typeOid);
            tuple[5] = this.connection.encodeString(pgType);
            tuple[7] = null;
            String defval = rs.getString("adsrc");
            if (defval != null) {
                if (pgType.equals("INT4")) {
                    if (defval.contains("NEXTVAL(")) {
                        tuple[5] = this.connection.encodeString("SERIAL");
                    }
                } else if (pgType.equals("INT8") && defval.contains("NEXTVAL(")) {
                    tuple[5] = this.connection.encodeString("BIGSERIAL");
                }
            }
            int decimalDigits = this.connection.getTypeInfo().getScale(typeOid, typeMod);
            int columnSize = this.connection.getTypeInfo().getPrecision(typeOid, typeMod);
            if (columnSize == 0) {
                columnSize = this.connection.getTypeInfo().getDisplaySize(typeOid, typeMod);
            }
            tuple[6] = this.connection.encodeString(Integer.toString(columnSize));
            tuple[8] = this.connection.encodeString(Integer.toString(decimalDigits));
            tuple[9] = this.connection.encodeString("10");
            if (pgType.equals("BIT") || pgType.equals("VARBIT")) {
                tuple[9] = this.connection.encodeString("2");
            }
            tuple[10] = this.connection.encodeString(Integer.toString(rs.getBoolean("attnotnull") ? 0 : 1));
            tuple[11] = rs.getBytes("description");
            tuple[12] = rs.getBytes("adsrc");
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = this.connection.encodeString(String.valueOf(rs.getInt("attnum")));
            tuple[17] = this.connection.encodeString(rs.getBoolean("attnotnull") ? "NO" : "YES");
            int baseTypeOid = (int)rs.getLong("typbasetype");
            tuple[18] = null;
            tuple[19] = null;
            tuple[20] = null;
            tuple[21] = baseTypeOid == 0 ? null : this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(baseTypeOid)));
            String autoinc = "NO";
            if (defval != null && defval.contains("NEXTVAL(")) {
                autoinc = "YES";
            }
            tuple[22] = this.connection.encodeString(autoinc);
            v.add(tuple);
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TABLE_CAT", 1043);
        f[1] = new Field("TABLE_SCHEM", 1043);
        f[2] = new Field("TABLE_NAME", 1043);
        f[3] = new Field("COLUMN_NAME", 1043);
        f[4] = new Field("GRANTOR", 1043);
        f[5] = new Field("GRANTEE", 1043);
        f[6] = new Field("PRIVILEGE", 1043);
        f[7] = new Field("IS_GRANTABLE", 1043);
        String sql = "SELECT n.nspname,c.relname,r.rolname,c.relacl, " + (this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "a.attacl, " : "") + " a.attname " + " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c, " + " sys_catalog.sys_roles r, sys_catalog.sys_attribute a " + " WHERE c.relnamespace = n.oid " + " AND c.relowner = r.oid " + " AND c.oid = a.attrelid " + " AND c.relkind = 'r' " + " AND a.attnum > 0 AND NOT a.attisdropped ";
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            sql = sql + " AND c.relname = " + this.escapeQuotes(table);
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            sql = sql + " AND a.attname LIKE " + this.escapeQuotes(columnNamePattern);
        }
        sql = sql + " ORDER BY attname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schemaName = rs.getBytes("nspname");
            byte[] tableName = rs.getBytes("relname");
            byte[] column = rs.getBytes("attname");
            String owner = rs.getString("rolname");
            String relAcl = rs.getString("relacl");
            Map<String, Map<String, List<String[]>>> permissions = this.parseACL(relAcl, owner);
            if (this.connection.haveMinimumServerVersion(ServerVersion.v8_4)) {
                String acl = rs.getString("attacl");
                Map<String, Map<String, List<String[]>>> relPermissions = this.parseACL(acl, owner);
                permissions.putAll(relPermissions);
            }
            Object[] permNames = permissions.keySet().toArray(new String[0]);
            Arrays.sort(permNames);
            for (Object permName : permNames) {
                byte[] privilege = this.connection.encodeString((String)permName);
                Map<String, List<String[]>> grantees = permissions.get(permName);
                for (Map.Entry<String, List<String[]>> userToGrantable : grantees.entrySet()) {
                    List<String[]> grantor = userToGrantable.getValue();
                    String grantee = userToGrantable.getKey();
                    for (String[] grants : grantor) {
                        String grantable = owner.equals(grantee) ? "YES" : grants[1];
                        byte[][] tuple = new byte[][]{null, schemaName, tableName, column, this.connection.encodeString(grants[0]), this.connection.encodeString(grantee), privilege, this.connection.encodeString(grantable)};
                        v.add(tuple);
                    }
                }
            }
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] f = new Field[7];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TABLE_CAT", 1043);
        f[1] = new Field("TABLE_SCHEM", 1043);
        f[2] = new Field("TABLE_NAME", 1043);
        f[3] = new Field("GRANTOR", 1043);
        f[4] = new Field("GRANTEE", 1043);
        f[5] = new Field("PRIVILEGE", 1043);
        f[6] = new Field("IS_GRANTABLE", 1043);
        String sql = "SELECT n.nspname,c.relname,r.rolname,c.relacl  FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c, sys_catalog.sys_roles r  WHERE c.relnamespace = n.oid  AND c.relowner = r.oid  AND c.relkind = 'r' ";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            sql = sql + " AND n.nspname LIKE " + this.escapeQuotes(schemaPattern);
        }
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            sql = sql + " AND c.relname LIKE " + this.escapeQuotes(tableNamePattern);
        }
        sql = sql + " ORDER BY nspname, relname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] table = rs.getBytes("relname");
            String owner = rs.getString("rolname");
            String acl = rs.getString("relacl");
            Map<String, Map<String, List<String[]>>> permissions = this.parseACL(acl, owner);
            Object[] permNames = permissions.keySet().toArray(new String[0]);
            Arrays.sort(permNames);
            for (Object permName : permNames) {
                byte[] privilege = this.connection.encodeString((String)permName);
                Map<String, List<String[]>> grantees = permissions.get(permName);
                for (Map.Entry<String, List<String[]>> userToGrantable : grantees.entrySet()) {
                    List<String[]> grants = userToGrantable.getValue();
                    String granteeUser = userToGrantable.getKey();
                    for (String[] grantTuple : grants) {
                        String grantor = grantTuple[0] == null ? owner : grantTuple[0];
                        String grantable = owner.equals(granteeUser) ? "YES" : grantTuple[1];
                        byte[][] tuple = new byte[][]{null, schema, table, this.connection.encodeString(grantor), this.connection.encodeString(granteeUser), privilege, this.connection.encodeString(grantable)};
                        v.add(tuple);
                    }
                }
            }
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    private static List<String> parseACLArray(String aclString) {
        int i;
        ArrayList<String> acls = new ArrayList<String>();
        if (aclString == null || aclString.isEmpty()) {
            return acls;
        }
        boolean inQuotes = false;
        int beginIndex = 1;
        int prevChar = 32;
        for (i = beginIndex; i < aclString.length(); ++i) {
            char c = aclString.charAt(i);
            if (c == '\"' && prevChar != 92) {
                inQuotes = !inQuotes;
            } else if (c == ',' && !inQuotes) {
                acls.add(aclString.substring(beginIndex, i));
                beginIndex = i + 1;
            }
            prevChar = c;
        }
        acls.add(aclString.substring(beginIndex, aclString.length() - 1));
        for (i = 0; i < acls.size(); ++i) {
            String acl = (String)acls.get(i);
            if (!acl.startsWith("\"") || !acl.endsWith("\"")) continue;
            acl = acl.substring(1, acl.length() - 1);
            acls.set(i, acl);
        }
        return acls;
    }

    private static void addACLPrivileges(String acl, Map<String, Map<String, List<String[]>>> privileges) {
        String privs;
        int equalIndex = acl.lastIndexOf("=");
        int slashIndex = acl.lastIndexOf("/");
        if (equalIndex == -1) {
            return;
        }
        String user = acl.substring(0, equalIndex);
        String grantor = null;
        if (user.isEmpty()) {
            user = "PUBLIC";
        }
        if (slashIndex != -1) {
            privs = acl.substring(equalIndex + 1, slashIndex);
            grantor = acl.substring(slashIndex + 1, acl.length());
        } else {
            privs = acl.substring(equalIndex + 1, acl.length());
        }
        for (int i = 0; i < privs.length(); ++i) {
            List<String[]> permissionByGrantor;
            String sqlpriv;
            char c = privs.charAt(i);
            if (c == '*') continue;
            String grantable = i < privs.length() - 1 && privs.charAt(i + 1) == '*' ? "YES" : "NO";
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'D': {
                    sqlpriv = "TRUNCATE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            Map<String, List<String[]>> usersWithPermission = privileges.get(sqlpriv);
            String[] grant = new String[]{grantor, grantable};
            if (usersWithPermission == null) {
                usersWithPermission = new HashMap<String, List<String[]>>();
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                privileges.put(sqlpriv, usersWithPermission);
                continue;
            }
            permissionByGrantor = usersWithPermission.get(user);
            if (permissionByGrantor == null) {
                permissionByGrantor = new ArrayList<String[]>();
                permissionByGrantor.add(grant);
                usersWithPermission.put(user, permissionByGrantor);
                continue;
            }
            permissionByGrantor.add(grant);
        }
    }

    public Map<String, Map<String, List<String[]>>> parseACL(String aclArray, String owner) {
        if (aclArray == null) {
            String perms = this.connection.haveMinimumServerVersion(ServerVersion.v8_4) ? "arwdDxt" : "arwdxt";
            aclArray = "{" + owner + "=" + perms + "/" + owner + "}";
        }
        List<String> acls = KbDatabaseMetaData.parseACLArray(aclArray);
        HashMap<String, Map<String, List<String[]>>> privileges = new HashMap<String, Map<String, List<String[]>>>();
        for (String acl : acls) {
            KbDatabaseMetaData.addACLPrivileges(acl, privileges);
        }
        return privileges;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("SCOPE", 21);
        f[1] = new Field("COLUMN_NAME", 1043);
        f[2] = new Field("DATA_TYPE", 21);
        f[3] = new Field("TYPE_NAME", 1043);
        f[4] = new Field("COLUMN_SIZE", 23);
        f[5] = new Field("BUFFER_LENGTH", 23);
        f[6] = new Field("DECIMAL_DIGITS", 21);
        f[7] = new Field("PSEUDO_COLUMN", 21);
        String sql = "SELECT a.attname, a.atttypid, atttypmod FROM sys_catalog.sys_class ct   JOIN sys_catalog.sys_attribute a ON (ct.oid = a.attrelid)   JOIN sys_catalog.sys_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              INFORMATION_SCHEMA._sys_expandarray(i.indkey) AS keys         FROM sys_catalog.sys_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid) WHERE true ";
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        sql = sql + " AND ct.relname = " + this.escapeQuotes(table) + " AND i.indisprimary " + " ORDER BY a.attnum ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[8][];
            int typeOid = (int)rs.getLong("atttypid");
            int typeMod = rs.getInt("atttypmod");
            int decimalDigits = this.connection.getTypeInfo().getScale(typeOid, typeMod);
            int columnSize = this.connection.getTypeInfo().getPrecision(typeOid, typeMod);
            if (columnSize == 0) {
                columnSize = this.connection.getTypeInfo().getDisplaySize(typeOid, typeMod);
            }
            tuple[0] = this.connection.encodeString(Integer.toString(scope));
            tuple[1] = rs.getBytes("attname");
            tuple[2] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType(typeOid)));
            tuple[3] = this.connection.encodeString(this.connection.getTypeInfo().getKBType(typeOid));
            tuple[4] = this.connection.encodeString(Integer.toString(columnSize));
            tuple[5] = null;
            tuple[6] = this.connection.encodeString(Integer.toString(decimalDigits));
            tuple[7] = this.connection.encodeString(Integer.toString(1));
            v.add(tuple);
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] f = new Field[8];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("SCOPE", 21);
        f[1] = new Field("COLUMN_NAME", 1043);
        f[2] = new Field("DATA_TYPE", 21);
        f[3] = new Field("TYPE_NAME", 1043);
        f[4] = new Field("COLUMN_SIZE", 23);
        f[5] = new Field("BUFFER_LENGTH", 23);
        f[6] = new Field("DECIMAL_DIGITS", 21);
        f[7] = new Field("PSEUDO_COLUMN", 21);
        byte[][] tuple = new byte[][]{null, this.connection.encodeString("ctid"), this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getSQLType("tid"))), this.connection.encodeString("tid"), null, null, null, this.connection.encodeString(Integer.toString(2))};
        v.add(tuple);
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, a.attname AS COLUMN_NAME,   (i.keys).n AS KEY_SEQ, ci.relname AS PK_NAME FROM sys_catalog.sys_class ct   JOIN sys_catalog.sys_attribute a ON (ct.oid = a.attrelid)   JOIN sys_catalog.sys_namespace n ON (ct.relnamespace = n.oid)   JOIN (SELECT i.indexrelid, i.indrelid, i.indisprimary,              INFORMATION_SCHEMA._sys_expandarray(i.indkey) AS keys         FROM sys_catalog.sys_index i) i     ON (a.attnum = (i.keys).x AND a.attrelid = i.indrelid)   JOIN sys_catalog.sys_class ci ON (ci.oid = i.indexrelid) WHERE true ";
        if (schema != null && !schema.isEmpty()) {
            sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
        }
        if (table != null && !table.isEmpty()) {
            sql = sql + " AND ct.relname = " + this.escapeQuotes(table);
        }
        sql = sql + " AND i.indisprimary  ORDER BY table_name, pk_name, key_seq";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String sql = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  sys_catalog.sys_namespace pkn, sys_catalog.sys_class pkc, sys_catalog.sys_attribute pka,  sys_catalog.sys_namespace fkn, sys_catalog.sys_class fkc, sys_catalog.sys_attribute fka,  sys_catalog.sys_constraint con,  sys_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n), " + " sys_catalog.sys_class pkic";
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            sql = sql + ", sys_catalog.sys_depend dep ";
        }
        sql = sql + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' AND pkic.relkind = 'i' ";
        sql = !this.connection.haveMinimumServerVersion(ServerVersion.v9_0) ? sql + " AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND dep.classid = 'SYS_CONSTRAINT'::regclass::oid AND dep.refclassid = 'SYS_CLASS'::regclass::oid " : sql + " AND pkic.oid = con.conindid ";
        if (primarySchema != null && !primarySchema.isEmpty()) {
            sql = sql + " AND pkn.nspname = " + this.escapeQuotes(primarySchema);
        }
        if (foreignSchema != null && !foreignSchema.isEmpty()) {
            sql = sql + " AND fkn.nspname = " + this.escapeQuotes(foreignSchema);
        }
        if (primaryTable != null && !primaryTable.isEmpty()) {
            sql = sql + " AND pkc.relname = " + this.escapeQuotes(primaryTable);
        }
        if (foreignTable != null && !foreignTable.isEmpty()) {
            sql = sql + " AND fkc.relname = " + this.escapeQuotes(foreignTable);
        }
        sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,con.conname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname, con.conname,pos.n";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Field[] f = new Field[18];
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        f[0] = new Field("TYPE_NAME", 1043);
        f[1] = new Field("DATA_TYPE", 21);
        f[2] = new Field("PRECISION", 23);
        f[3] = new Field("LITERAL_PREFIX", 1043);
        f[4] = new Field("LITERAL_SUFFIX", 1043);
        f[5] = new Field("CREATE_PARAMS", 1043);
        f[6] = new Field("NULLABLE", 21);
        f[7] = new Field("CASE_SENSITIVE", 16);
        f[8] = new Field("SEARCHABLE", 21);
        f[9] = new Field("UNSIGNED_ATTRIBUTE", 16);
        f[10] = new Field("FIXED_PREC_SCALE", 16);
        f[11] = new Field("AUTO_INCREMENT", 16);
        f[12] = new Field("LOCAL_TYPE_NAME", 1043);
        f[13] = new Field("MINIMUM_SCALE", 21);
        f[14] = new Field("MAXIMUM_SCALE", 21);
        f[15] = new Field("SQL_DATA_TYPE", 23);
        f[16] = new Field("SQL_DATETIME_SUB", 23);
        f[17] = new Field("NUM_PREC_RADIX", 23);
        String sql = "SELECT t.typname,t.oid FROM sys_catalog.sys_type t JOIN sys_catalog.sys_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname  != 'SYS_TOAST'";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        byte[] bZero = this.connection.encodeString("0");
        byte[] b10 = this.connection.encodeString("10");
        byte[] bf = this.connection.encodeString("f");
        byte[] bt = this.connection.encodeString("t");
        byte[] bliteral = this.connection.encodeString("'");
        byte[] bNullable = this.connection.encodeString(Integer.toString(1));
        byte[] bSearchable = this.connection.encodeString(Integer.toString(3));
        while (rs.next()) {
            byte[][] tuple1;
            byte[][] tuple = new byte[18][];
            String typname = rs.getString(1);
            int typeOid = (int)rs.getLong(2);
            tuple[0] = this.connection.encodeString(typname);
            int sqlType = this.connection.getTypeInfo().getSQLType(typname);
            tuple[1] = this.connection.encodeString(Integer.toString(sqlType));
            tuple[2] = this.connection.encodeString(Integer.toString(this.connection.getTypeInfo().getMaximumPrecision(typeOid)));
            if (this.connection.getTypeInfo().requiresQuotingSqlType(sqlType)) {
                tuple[3] = bliteral;
                tuple[4] = bliteral;
            }
            tuple[6] = bNullable;
            tuple[7] = this.connection.getTypeInfo().isCaseSensitive(typeOid) ? bt : bf;
            tuple[8] = bSearchable;
            tuple[9] = this.connection.getTypeInfo().isSigned(typeOid) ? bf : bt;
            tuple[10] = bf;
            tuple[11] = bf;
            tuple[13] = bZero;
            tuple[14] = typeOid == 1700 ? this.connection.encodeString("1000") : bZero;
            tuple[17] = b10;
            v.add(tuple);
            if (typname.equals("INT4")) {
                tuple1 = (byte[][])tuple.clone();
                tuple1[0] = this.connection.encodeString("SERIAL");
                tuple1[11] = bt;
                v.add(tuple1);
                continue;
            }
            if (!typname.equals("INT8")) continue;
            tuple1 = (byte[][])tuple.clone();
            tuple1[0] = this.connection.encodeString("BIGSERIAL");
            tuple1[11] = bt;
            v.add(tuple1);
        }
        rs.close();
        stmt.close();
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String sql;
        if (this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            sql = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM,   ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE,   NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME,   CASE i.indisclustered     WHEN true THEN 1    ELSE CASE am.amname       WHEN 'HASH' THEN 2      ELSE 3    END   END AS TYPE,   (i.keys).n AS ORDINAL_POSITION,   trim(both '\"' from sys_catalog.sys_get_indexdef(ci.oid, (i.keys).n, false)) AS COLUMN_NAME, " + (this.connection.haveMinimumServerVersion(ServerVersion.v9_6) ? "  CASE am.amname     WHEN 'BTREE' THEN CASE i.indoption[(i.keys).n - 1] & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, " : "  CASE am.amcanorder     WHEN true THEN CASE i.indoption[(i.keys).n - 1] & 1       WHEN 1 THEN 'D'       ELSE 'A'     END     ELSE NULL   END AS ASC_OR_DESC, ") + "  ci.reltuples AS CARDINALITY, " + "  ci.relpages AS PAGES, " + "  sys_catalog.sys_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION " + "FROM sys_catalog.sys_class ct " + "  JOIN sys_catalog.sys_namespace n ON (ct.relnamespace = n.oid) " + "  JOIN (SELECT i.indexrelid, i.indrelid, i.indoption, " + "          i.indisunique, i.indisclustered, i.indpred, " + "          i.indexprs, " + "          INFORMATION_SCHEMA._sys_expandarray(i.indkey) AS keys " + "        FROM sys_catalog.sys_index i) i " + "    ON (ct.oid = i.indrelid) " + "  JOIN sys_catalog.sys_class ci ON (ci.oid = i.indexrelid) " + "  JOIN sys_catalog.sys_am am ON (ci.relam = am.oid) " + "WHERE true ";
            if (schema != null && !schema.isEmpty()) {
                sql = sql + " AND n.nspname = " + this.escapeQuotes(schema);
            }
        } else {
            String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
            String from = " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class ct, sys_catalog.sys_class ci,  sys_catalog.sys_attribute a, sys_catalog.sys_am am ";
            String where = " AND n.oid = ct.relnamespace ";
            from = from + ", sys_catalog.sys_index i ";
            if (schema != null && !schema.isEmpty()) {
                where = where + " AND n.nspname = " + this.escapeQuotes(schema);
            }
            sql = select + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME, " + " CASE i.indisclustered " + " WHEN true THEN " + 1 + " ELSE CASE am.amname " + " WHEN 'HASH' THEN " + 2 + " ELSE " + 3 + " END " + " END AS TYPE, " + " a.attnum AS ORDINAL_POSITION, " + " CASE WHEN i.indexprs IS NULL THEN a.attname " + " ELSE sys_catalog.sys_get_indexdef(ci.oid,a.attnum,false) END AS COLUMN_NAME, " + " NULL AS ASC_OR_DESC, " + " ci.reltuples AS CARDINALITY, " + " ci.relpages AS PAGES, " + " sys_catalog.sys_get_expr(i.indpred, i.indrelid) AS FILTER_CONDITION " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + where;
        }
        sql = sql + " AND ct.relname = " + this.escapeQuotes(tableName);
        if (unique) {
            sql = sql + " AND i.indisunique ";
        }
        sql = sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        if (concurrency == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "select null as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, sys_catalog.obj_description(t.oid, 'SYS_TYPE')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        StringBuilder sqlwhen = new StringBuilder();
        Iterator<String> i = this.connection.getTypeInfo().getKBTypeNamesWithSQLTypes();
        while (i.hasNext()) {
            String pgType = i.next();
            int sqlType = this.connection.getTypeInfo().getSQLType(pgType);
            sqlwhen.append(" when typname = ").append(this.escapeQuotes(pgType)).append(" then ").append(sqlType);
        }
        sql = sql + sqlwhen.toString();
        sql = sql + " else 1111 end from sys_type where oid=t.typbasetype) else null end as base_type from sys_catalog.sys_type t, sys_catalog.sys_namespace n where t.typnamespace = n.oid and n.nspname != 'SYS_CATALOG' and n.nspname != 'SYS_TOAST'";
        StringBuilder toAdd = new StringBuilder();
        if (types != null) {
            toAdd.append(" and (false ");
            block5: for (int type : types) {
                switch (type) {
                    case 2002: {
                        toAdd.append(" or t.typtype = 'c'");
                        continue block5;
                    }
                    case 2001: {
                        toAdd.append(" or t.typtype = 'd'");
                    }
                }
            }
            toAdd.append(" ) ");
        } else {
            toAdd.append(" and t.typtype IN ('c','d') ");
        }
        if (typeNamePattern != null) {
            int firstQualifier = typeNamePattern.indexOf(46);
            int secondQualifier = typeNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                schemaPattern = firstQualifier != secondQualifier ? typeNamePattern.substring(firstQualifier + 1, secondQualifier) : typeNamePattern.substring(0, firstQualifier);
                typeNamePattern = typeNamePattern.substring(secondQualifier + 1);
            }
            toAdd.append(" and t.typname like ").append(this.escapeQuotes(typeNamePattern));
        }
        if (schemaPattern != null) {
            toAdd.append(" and n.nspname like ").append(this.escapeQuotes(schemaPattern));
        }
        sql = sql + toAdd.toString();
        sql = sql + " order by data_type, type_schem, type_name";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Field[] f = new Field[]{new Field("NAME", 1043), new Field("MAX_LEN", 23), new Field("DEFAULT_VALUE", 1043), new Field("DESCRIPTION", 1043)};
        ArrayList<byte[][]> v = new ArrayList<byte[][]>();
        if (this.connection.haveMinimumServerVersion(ServerVersion.v9_0)) {
            byte[][] tuple = new byte[][]{this.connection.encodeString("ApplicationName"), this.connection.encodeString(Integer.toString(this.getMaxNameLength())), this.connection.encodeString(""), this.connection.encodeString("The name of the application currently utilizing the connection.")};
            v.add(tuple);
        }
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(f, v);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getProcedures(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getProcedureColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getPseudoColumns(String, String, String, String)");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTypes(String,String,String)");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTables(String,String,String,String)");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes(String,String,String,String)");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getServerMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getServerMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    static {
        HashMap<String, String> ht = new HashMap<String, String>();
        tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname !~ '^SYS_' AND n.nspname <> 'INFORMATION_SCHEMA'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname !~ '^SYS_'");
        ht = new HashMap();
        tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'SYS_CATALOG' AND n.nspname <> 'INFORMATION_SCHEMA'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname !~ '^SYS_'");
        ht = new HashMap();
        tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname !~ '^SYS_' AND n.nspname <> 'INFORMATION_SCHEMA'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname !~ '^SYS_'");
        ht = new HashMap();
        tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new HashMap();
        tableTypeClauses.put("TYPE", ht);
        ht.put("SCHEMAS", "c.relkind = 'c' AND n.nspname !~ '^SYS_' AND n.nspname <> 'INFORMATION_SCHEMA'");
        ht.put("NOSCHEMAS", "c.relkind = 'c' AND c.relname !~ '^SYS_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'SYS_CATALOG' OR n.nspname = 'INFORMATION_SCHEMA')");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^SYS_' AND c.relname !~ '^SYS_TOAST_' AND c.relname !~ '^SYS_TEMP_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'SYS_TOAST'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^SYS_TOAST_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'SYS_TOAST'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^SYS_TOAST_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'SYS_CATALOG' OR n.nspname = 'INFORMATION_SCHEMA') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^SYS_'");
        ht = new HashMap();
        tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'SYS_CATALOG' OR n.nspname = 'INFORMATION_SCHEMA') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^SYS_' AND c.relname !~ '^SYS_TOAST_' AND c.relname !~ '^SYS_TEMP_'");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname ~ '^SYS_TEMP_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname ~ '^SYS_TEMP_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname ~ '^SYS_TEMP_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname ~ '^SYS_TEMP_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname ~ '^SYS_TEMP_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname ~ '^SYS_TEMP_' ");
        ht = new HashMap();
        tableTypeClauses.put("TEMPORARY SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S' AND n.nspname ~ '^SYS_TEMP_' ");
        ht.put("NOSCHEMAS", "c.relkind = 'S' AND c.relname ~ '^SYS_TEMP_' ");
        ht = new HashMap();
        tableTypeClauses.put("FOREIGN TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'f'");
        ht.put("NOSCHEMAS", "c.relkind = 'f'");
        ht = new HashMap();
        tableTypeClauses.put("MATERIALIZED VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'm'");
        ht.put("NOSCHEMAS", "c.relkind = 'm'");
    }
}

