/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;

public class RegionRightUpdater {
    private static Logger logger = Logger.getLogger(RegionRightUpdater.class);
    private User m_oCurrUser = null;

    public RegionRightUpdater(User user) {
        this.m_oCurrUser = user;
    }

    public void updateRegionRight() throws WCMException {
        logger.warn((Object)"The system begin to add region right....");
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        Rights rights = Rights.openWCMObjs(this.m_oCurrUser, null);
        int n = rights.size();
        for (int i = 0; i < n; ++i) {
            Right right = (Right)rights.getAt(i);
            if (right == null) continue;
            RightValue rightValue = right.getValue();
            long l = right.getValueAsLong();
            int n2 = right.getObjType();
            if (AuthServer.hasRight(l, 48) || (n2 != 103 || !AuthServer.hasRight(l, 1)) && (n2 != 101 || !AuthServer.hasRight(l, 13))) continue;
            rightValue.setBit(48, true);
            right.setValue(rightValue);
            right.save(this.m_oCurrUser);
            logger.info((Object)(right.getOperator() + "\u5728" + BaseChannel.findById(n2, right.getObjId()) + "\u4e0a\u7684\u6743\u9650\u503c\u6539\u53d8\u3002\u6539\u53d8\u524d\uff1a" + l + "; \u6539\u53d8\u540e\uff1a" + rightValue.getValue()));
        }
        WCMFilter wCMFilter = new WCMFilter("WCMROLE", "ROLETYPE=?", "");
        wCMFilter.addSearchValues(-1);
        Roles roles = Roles.openWCMObjs(this.m_oCurrUser, wCMFilter);
        int n3 = roles.size();
        for (int i = 0; i < n3; ++i) {
            long l;
            Role role = (Role)roles.getAt(i);
            if (role == null || AuthServer.hasRight(l = role.getRightValue(), 48) || !AuthServer.hasRight(l, 1) && !AuthServer.hasRight(l, 13)) continue;
            CMyBitsValue cMyBitsValue = new CMyBitsValue();
            cMyBitsValue.setValue(l);
            cMyBitsValue.setBit(48, true);
            role.setRightValue(cMyBitsValue.getValue());
            role.save(this.m_oCurrUser);
            logger.info((Object)(role + "\u7684\u6743\u9650\u503c\u6539\u53d8\uff0c\u6539\u53d8\u524d\uff1a" + l + "; \u6539\u53d8\u540e\uff1a" + cMyBitsValue.getValue()));
        }
        debugTimer.stop();
        logger.warn((Object)("The system end to add region right!use[" + debugTimer.getTime() + "]ms"));
    }

    public static void main(String[] stringArray) {
        try {
            RegionRightUpdater regionRightUpdater = new RegionRightUpdater(User.findByName("admin"));
            regionRightUpdater.updateRegionRight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

