/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class InheritCaculatorByWCM52RightMode {
    private static Logger logger = Logger.getLogger(InheritCaculatorByWCM52RightMode.class);
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private HashMap m_hDefineRightCacheForChannel = new HashMap();
    private HashMap m_hDefineRightCacheForSite = new HashMap();
    private Channels m_oLeafChannels = null;

    public List makeInheritInfo(Channels channels) throws WCMException {
        Object object;
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        Channels channels2 = channels;
        if (channels2 == null) {
            object = new WCMFilter("WCMChannel a", "status>=0 and not exists(select 1 from WCMChannel b where a.ChannelId=b.ParentId)", "ParentId", "");
            channels2 = Channels.openWCMObjs(null, (WCMFilter)object);
        }
        this.m_oLeafChannels = channels2;
        object = Users.openWCMObjs(null, null);
        debugTimer.start();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<InheritInfo> arrayList2 = new ArrayList<InheritInfo>(channels2.size() * 10);
        int n = channels2.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels2.getAt(i);
            if (channel == null) continue;
            while (channel != null) {
                int n2;
                Users users = new Users(null);
                DebugTimer debugTimer2 = new DebugTimer();
                debugTimer2.start();
                int n3 = ((BaseObjs)object).size();
                for (n2 = 0; n2 < n3; ++n2) {
                    User user = (User)((BaseObjs)object).getAt(n2);
                    if (user == null || user.isAdministrator()) continue;
                    user.setCacheGroupsAndRoles(true);
                    if (!this.hasInheritFromParent(user, channel)) continue;
                    users.addElement(user);
                }
                debugTimer2.stop();
                if (debugTimer2.getTime() > 1000L) {
                    logger.debug((Object)("HasInheritFromParent once use [" + debugTimer2.getTime() + "]ms!"));
                }
                if (!users.isEmpty()) {
                    arrayList2.add(new InheritInfo(channel, users));
                }
                if ((n2 = channel.getParentId()) == 0 || arrayList.indexOf(new Integer(n2)) >= 0) break;
                arrayList.add(new Integer(n2));
                channel = channel.getParent();
            }
            debugTimer.stop();
            if (debugTimer.getTime() > 1000L) {
                logger.debug((Object)("Dowith channel[" + channels2.getAt(i) + "] use [" + debugTimer.getTime() + "]ms!"));
            }
            debugTimer.start();
        }
        return arrayList2;
    }

    private boolean hasInheritFromParent(User user, Channel channel) throws WCMException {
        boolean bl = this.hasDefineRightOnCurrObjFromCache(user, channel);
        if (bl) {
            return false;
        }
        for (BaseChannel baseChannel = channel.getHost(); baseChannel != null; baseChannel = baseChannel.getHost()) {
            bl = this.hasDefineRightOnCurrObjFromCache(user, baseChannel);
            if (bl) {
                return true;
            }
            if (!baseChannel.isSite()) continue;
            return false;
        }
        return false;
    }

    private boolean hasDefineRightOnCurrObjFromCache(User user, BaseChannel baseChannel) throws WCMException {
        HashMap hashMap = null;
        if (baseChannel.isSite()) {
            hashMap = this.m_hDefineRightCacheForSite;
        } else {
            if (this.m_oLeafChannels.indexOf(baseChannel.getId()) >= 0) {
                return this.hasDefineRightOnCurrObj(user, baseChannel);
            }
            hashMap = this.m_hDefineRightCacheForChannel;
        }
        String string = user.getId() + "." + baseChannel.getId();
        Boolean bl = (Boolean)hashMap.get(string);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.hasDefineRightOnCurrObj(user, baseChannel);
        hashMap.put(string, new Boolean(bl2));
        return bl2;
    }

    private boolean hasDefineRightOnCurrObj(User user, BaseChannel baseChannel) throws WCMException {
        long l;
        CMSObj cMSObj;
        int n;
        Roles roles = null;
        Groups groups = null;
        int n2 = baseChannel.getWCMType();
        int n3 = baseChannel.getId();
        long l2 = this.rightCacheMgr.getRightValue(baseChannel.getWCMType(), baseChannel.getId(), 204, user.getId(), -1L);
        if (l2 != -1L) {
            return true;
        }
        roles = user.getRoles();
        l2 = l2 > 0L ? l2 : 0L;
        for (n = 0; n < roles.size(); ++n) {
            cMSObj = (Role)roles.getAt(n);
            if (cMSObj == null || cMSObj.isSystemRole() || (l = this.rightCacheMgr.getRightValue(n2, n3, 203, roles.getIdAt(n), -1L)) == -1L) continue;
            return true;
        }
        groups = user.getGroups();
        for (n = 0; n < groups.size(); ++n) {
            cMSObj = (Group)groups.getAt(n);
            if (cMSObj == null || (l = this.makeGroupRightValueOfObject((Group)cMSObj, n2, n3)) == -1L) continue;
            return true;
        }
        return false;
    }

    private long makeGroupRightValueOfObject(Group group, int n, int n2) throws WCMException {
        long l = -1L;
        if (group == null) {
            return l;
        }
        long l2 = this.rightCacheMgr.getRightValue(n, n2, 201, group.getId(), l);
        if (l2 != l) {
            return l2;
        }
        return this.makeGroupRightValueOfObject(group.getParent(), n, n2);
    }

    public static void main(String[] stringArray) {
    }
}

