/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.infra.I18NMessage;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.wcm.photo.ImageLibConstants;
import java.awt.Dimension;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import magick.CompositeOperator;
import magick.ImageInfo;
import magick.MagickApiException;
import magick.MagickException;
import magick.MagickImage;
import org.apache.log4j.Logger;

public class JImageMarkUtil {
    private static final Logger LOG = Logger.getLogger(JImageMarkUtil.class);
    private static int COMPOSITEOPERATOR_TYPE = 3;

    public static void setCompositeOp(int n) {
        COMPOSITEOPERATOR_TYPE = n;
    }

    private static MagickImage addWaterMarkS(ImageInfo imageInfo, ImageInfo imageInfo2, ImageInfo imageInfo3, int[] nArray) throws MagickApiException, MagickException {
        int n;
        int n2;
        MagickImage magickImage = new MagickImage(imageInfo);
        Dimension dimension = magickImage.getDimension();
        MagickImage magickImage2 = new MagickImage(imageInfo2);
        Dimension dimension2 = magickImage2.getDimension();
        if (JImageMarkUtil.isSelfDefinePosition(nArray, ImageLibConstants.MARKPOS_SELF_DEFIND)) {
            Float f = new Float((float)nArray[2] / (float)nArray[3] * (float)dimension.width);
            int n3 = f.intValue();
            f = new Float((float)nArray[1] / (float)nArray[4] * (float)dimension.height);
            int n4 = f.intValue();
            magickImage.compositeImage(COMPOSITEOPERATOR_TYPE, magickImage2, n3, n4);
            return magickImage;
        }
        if (JImageMarkUtil.isPostion(nArray, ImageLibConstants.MARKPOS_LEFT_TOP)) {
            n2 = 0;
            n = 0;
            magickImage.compositeImage(COMPOSITEOPERATOR_TYPE, magickImage2, n2, n);
        }
        if (JImageMarkUtil.isPostion(nArray, ImageLibConstants.MARKPOS_RIGHT_BOTTOM)) {
            n = dimension.height - dimension2.height;
            n2 = dimension.width - dimension2.width;
            magickImage.compositeImage(COMPOSITEOPERATOR_TYPE, magickImage2, n2, n);
        }
        if (JImageMarkUtil.isPostion(nArray, ImageLibConstants.MARKPOS_CENTER_MIDDLE)) {
            magickImage2 = new MagickImage(imageInfo3);
            dimension2 = magickImage2.getDimension();
            n2 = (dimension.width - dimension2.width) / 2;
            n = (dimension.height - dimension2.height) / 2;
            magickImage.compositeImage(COMPOSITEOPERATOR_TYPE, magickImage2, n2, n);
        }
        return magickImage;
    }

    private static boolean isSelfDefinePosition(int[] nArray, int n) {
        if (nArray == null || nArray.length < 5) {
            return false;
        }
        return nArray[0] == n;
    }

    private static boolean isPostion(int[] nArray, int n) {
        if (nArray == null) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private static String createRandomFile(String string) throws Exception {
        String string2 = FilesMan.getFilesMan().getNextFileName("ST", string);
        return FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
    }

    private static File EmbedVisibleWaterMark(String string, String string2, int[] nArray) throws Exception {
        ImageInfo imageInfo = new ImageInfo(string);
        ImageInfo imageInfo2 = new ImageInfo(string2);
        MagickImage magickImage = new MagickImage();
        magickImage = JImageMarkUtil.addWaterMarkS(imageInfo, imageInfo2, imageInfo2, nArray);
        String string3 = JImageMarkUtil.createRandomFile(CMyFile.extractFileExt(string));
        magickImage.setFileName(string3);
        magickImage.writeImage(imageInfo);
        return new File(string3);
    }

    public static synchronized byte[] addImageMark(String string, String string2) throws Exception {
        return JImageMarkUtil.addImageMark(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] addImageMark(String string, String string2, int[] nArray) throws Exception {
        Exception exception4;
        byte[] byArray;
        ByteBuffer byteBuffer;
        FileChannel fileChannel;
        RandomAccessFile randomAccessFile;
        block31: {
            File file;
            block26: {
                Exception exception22;
                byte[] byArray2;
                block27: {
                    if (!CMyFile.fileExists(string)) {
                        throw new Exception(I18NMessage.get(JImageMarkUtil.class, "JImageMarkUtil.label1", "\u6e90\u56fe\u7247\u4e0d\u5b58\u5728\uff01") + string);
                    }
                    if (!CMyFile.fileExists(string2)) {
                        throw new Exception(I18NMessage.get(JImageMarkUtil.class, "JImageMarkUtil.label2", "\u6c34\u5370\u56fe\u7247\u4e0d\u5b58\u5728\uff01") + string2);
                    }
                    file = JImageMarkUtil.EmbedVisibleWaterMark(string, string2, nArray);
                    randomAccessFile = null;
                    fileChannel = null;
                    byteBuffer = null;
                    try {
                        randomAccessFile = new RandomAccessFile(file, "rw");
                        byteBuffer = ByteBuffer.allocate((int)randomAccessFile.length());
                        fileChannel = randomAccessFile.getChannel();
                        fileChannel.read(byteBuffer);
                        if (!byteBuffer.hasArray()) break block26;
                        byArray2 = byteBuffer.array();
                        Object var9_9 = null;
                        if (file == null) break block27;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        block35: {
                            Exception exception32;
                            Object var9_11 = null;
                            if (file != null) {
                                file.delete();
                            }
                            if (randomAccessFile != null) {
                                try {
                                    randomAccessFile.close();
                                }
                                catch (Exception exception32) {
                                    // empty catch block
                                }
                            }
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                }
                                catch (Exception exception32) {
                                    // empty catch block
                                }
                            }
                            if (byteBuffer == null) break block35;
                            try {
                                byteBuffer.clear();
                            }
                            catch (Exception exception32) {}
                        }
                        throw throwable;
                    }
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (byteBuffer != null) {
                    try {
                        byteBuffer.clear();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                return byArray2;
            }
            byArray = new byte[]{};
            Object var9_10 = null;
            if (file == null) break block31;
            file.delete();
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        if (byteBuffer != null) {
            try {
                byteBuffer.clear();
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        return byArray;
    }

    static {
        try {
            Field field;
            String string = ConfigServer.getServer().getInitProperty("PHOTOWATERMARK_COMPOSITEOPERATOR");
            if (string != null && string.trim().length() != 0 && (field = CompositeOperator.class.getField(string)) != null) {
                COMPOSITEOPERATOR_TYPE = field.getInt(null);
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)"init COMPOSITEOPERATOR with exception!", (Throwable)exception);
        }
    }
}

