/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyFile;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ImportDocsContext {
    private int m_nImportCount = 0;
    private int m_nUnImportCount = 0;
    private User m_oCurrUser = null;
    private Channel m_oCurrChannel = null;
    private Hashtable m_hAppendix = new Hashtable();
    private String m_sCurrImportFile = null;
    private ArrayList m_arNeedImportFile = new ArrayList();
    private String m_sCurrTrueFileName = null;
    private static Logger m_oLogger = Logger.getLogger(ImportDocsContext.class);
    private ArrayList m_arSuccessInfo = new ArrayList();
    private ArrayList m_arErrorInfo = new ArrayList();

    public void clearCurrInfo() {
        this.m_hAppendix.clear();
        this.m_arNeedImportFile.clear();
    }

    public void clear() {
        this.m_hAppendix.clear();
        this.m_arNeedImportFile.clear();
        this.m_arSuccessInfo.clear();
        this.m_arErrorInfo.clear();
    }

    public String getAbsoluteAppFileName(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return null;
        }
        return (String)this.m_hAppendix.get(string.toUpperCase());
    }

    public void putAbsoluteAppFileName(String string, String string2) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return;
        }
        this.m_hAppendix.put(string.toUpperCase(), string2);
    }

    public Channel getCurrChannel() {
        return this.m_oCurrChannel;
    }

    public void setCurrChannel(Channel channel) {
        this.m_oCurrChannel = channel;
    }

    public User getCurrUser() {
        return this.m_oCurrUser;
    }

    public void setCurrUser(User user) {
        this.m_oCurrUser = user;
    }

    public boolean isValid() {
        if (!CMyFile.fileExists(this.getCurrImportFile())) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label1", "\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label2", "]\u5bfc\u5165\u5931\u8d25:\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u4ef6[") + this.getCurrImportFile() + "]!"));
            return false;
        }
        if (this.getCurrUser() == null) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label1", "\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label3", "]\u5bfc\u5165\u5931\u8d25:\u6ca1\u6709\u627e\u5230\u5bfc\u5165\u7528\u6237!")));
            return false;
        }
        if (this.getCurrChannel() != null && this.getCurrChannel().isDeleted()) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label4", "\u5bfc\u5165\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label5", "]\u5931\u8d25\uff1a\u6307\u5b9a\u7684\u5f53\u524d\u680f\u76ee\u65e0\u6548\uff01")));
        }
        return true;
    }

    public String getCurrImportFile() {
        return this.m_sCurrImportFile;
    }

    public void setCurrImportFile(String string) {
        this.m_sCurrImportFile = string;
    }

    public String getNeedImportFileAt(int n) {
        return (String)this.m_arNeedImportFile.get(n);
    }

    public int getNeedImportSize() {
        return this.m_arNeedImportFile.size();
    }

    public void addNeedImportFile(String string) {
        this.m_arNeedImportFile.add(string);
    }

    public static void main(String[] stringArray) {
    }

    public int getImportCount() {
        return this.m_nImportCount;
    }

    public synchronized void addImportCount(int n) {
        this.m_nImportCount += n;
    }

    public synchronized void addImportCount() {
        this.addImportCount(1);
    }

    public int getUnImportCount() {
        return this.m_nUnImportCount;
    }

    public synchronized void addUnImportCount(int n) {
        this.m_nUnImportCount += n;
    }

    public synchronized void addUnImportCount() {
        this.addUnImportCount(1);
    }

    public ArrayList getSuccessInfo() {
        return this.m_arSuccessInfo;
    }

    protected void addSuccessInfo(String string) {
        this.m_arSuccessInfo.add(string);
    }

    public ArrayList getErrorInfo() {
        return this.m_arErrorInfo;
    }

    protected void addErrorInfo(String string) {
        this.addErrorInfo(string, null);
    }

    protected void addErrorInfo(String string, Exception exception) {
        this.m_arErrorInfo.add(string);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public String getResult() {
        int n;
        String string = I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label6", "\u672c\u6b21\u5bfc\u5165\u4fe1\u606f:\u6210\u529f\u5bfc\u5165[") + this.getImportCount() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label7", "]\u7bc7\u6587\u6863![") + this.getUnImportCount() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label8", "]\u7bc7\u6587\u6863\u6ca1\u6709\u88ab\u5bfc\u5165!\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b:\n");
        if (this.getSuccessInfo().size() > 0) {
            string = string + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label9", "\u6210\u529f\u4fe1\u606f:\n");
            for (n = 0; n < this.getSuccessInfo().size(); ++n) {
                string = string + this.getSuccessInfo().get(n) + "\n";
            }
        }
        if (this.getErrorInfo().size() > 0) {
            string = string + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label10", "\u9519\u8bef\u4fe1\u606f:\n");
            for (n = 0; n < this.getErrorInfo().size(); ++n) {
                string = string + this.getErrorInfo().get(n) + "\n";
            }
        }
        return string;
    }

    public String getCurrTrueFileName() {
        return this.m_sCurrTrueFileName;
    }

    public void setCurrTrueFileName(String string) {
        this.m_sCurrTrueFileName = string;
    }
}

