/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.tools.JSLocaleProperties;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JSLocaleTranslator {
    private static Logger logger = Logger.getLogger(JSLocaleTranslator.class);
    private Pattern m_scriptRegExp = Pattern.compile("(?is)(<script[^>]*>)(.*?)(</script>)");
    private Pattern m_chineseJSRegExp = Pattern.compile("(?im)('|\")((?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*[\\u4e00-\\u9fbb]+(?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*)\\1");
    private Pattern m_tagInChineseRegExp = Pattern.compile("(?im)[\\u4e00-\\u9fbb]+.*[<>].*[\\u4e00-\\u9fbb]+");
    private Pattern m_noTagInChineseRegExp = Pattern.compile("[^<>]*[\\u4e00-\\u9fbb]+[^<>]*");
    private String m_sRootPath;
    private String m_sPrefixRootPath;
    private String[] m_aAcceptFileExt = new String[]{".jsp", ".html", ".htm", ".js"};
    private Map m_mapResult;
    private String m_sOutputPath;

    public JSLocaleTranslator(String string, String string2, String string3, String string4) throws CMyException {
        this.m_sRootPath = CMyString.setStrEndWith(string.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sPrefixRootPath = CMyString.setStrEndWith(string2.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sOutputPath = CMyString.setStrEndWith(string4.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_mapResult = JSLocaleProperties.load(string3);
    }

    public static void main(String[] stringArray) throws CMyException {
        if (stringArray.length < 4) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u56db\u4e2a\u53c2\u6570\n");
            stringBuffer.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u8fdb\u884cjs\u4e2d\u6587\u66ff\u6362\u7684\u6839\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app/");
            stringBuffer.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u6839\u8def\u5f84\u524d\u7f00\u8def\u5f84\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/");
            stringBuffer.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\u6307\u5b9a\u66ff\u6362\u8fc7\u7a0b\u4e2d\u9700\u8981\u7528\u5230\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en.properties");
            stringBuffer.append("\n\u7b2c\u56db\u4e2a\u53c2\u6570\u6307\u5b9a\u66ff\u6362\u540e\u6587\u4ef6\u5b58\u653e\u7684\u6839\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/wcm65-en/");
            logger.error((Object)stringBuffer);
            return;
        }
        JSLocaleTranslator jSLocaleTranslator = new JSLocaleTranslator(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        jSLocaleTranslator.analyze();
    }

    public void analyze() throws CMyException {
        File file = new File(this.m_sRootPath);
        this.analyzeDir(file);
    }

    private void analyzeDir(File file) throws CMyException {
        if (!this.isAccept(file)) {
            return;
        }
        if (file.isFile()) {
            this.analyzeFile(file);
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.analyzeDir(fileArray[i]);
        }
    }

    private boolean isAccept(File file) {
        int n;
        String string = file.getName();
        if (file.isDirectory()) {
            String[] stringArray = new String[]{".svn", "CVS", "editor", "runtime"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                return false;
            }
            return true;
        }
        String[] stringArray = new String[]{"_cn.js", "_en.js", "jquery"};
        for (n = 0; n < stringArray.length; ++n) {
            if (string.indexOf(stringArray[n]) < 0) continue;
            return false;
        }
        for (n = 0; n < this.m_aAcceptFileExt.length; ++n) {
            if (!string.endsWith(this.m_aAcceptFileExt[n])) continue;
            return true;
        }
        return false;
    }

    private void analyzeFile(File file) throws CMyException {
        String string = file.getAbsolutePath();
        String string2 = CharsetDetector.detect(string);
        String string3 = CMyFile.readFile(string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        logger.info((Object)("\u5f00\u59cb\u5206\u6790\u6587\u4ef6\uff1a" + string));
        if (string.endsWith(".js")) {
            stringBuffer.append(this.analyzeContent(string3));
        } else {
            Matcher matcher = this.m_scriptRegExp.matcher(string3);
            int n = 0;
            int n2 = 0;
            while (matcher.find()) {
                n = matcher.start();
                stringBuffer.append(string3.substring(n2, n));
                n2 = matcher.end();
                stringBuffer.append(matcher.group(1));
                String string4 = matcher.group(2);
                if (string4.length() > 0) {
                    stringBuffer.append(this.analyzeContent(string4));
                }
                stringBuffer.append(matcher.group(3));
            }
            if (n2 < string3.length()) {
                stringBuffer.append(string3.substring(n2));
            }
        }
        this.writeFile(file, stringBuffer.toString());
    }

    private void writeFile(File file, String string) throws CMyException {
        String string2 = file.getAbsolutePath();
        String string3 = CharsetDetector.detect(string2);
        String string4 = string2.substring(this.m_sPrefixRootPath.length());
        String string5 = this.m_sOutputPath + string4;
        CMyFile.writeFile(string5, string, string3);
    }

    private String analyzeContent(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Matcher matcher = this.m_chineseJSRegExp.matcher(string);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            n = matcher.start();
            stringBuffer.append(string.substring(n2, n));
            n2 = matcher.end();
            String string2 = matcher.group();
            String string3 = matcher.group(2);
            String string4 = this.getOptimizeKey(string3);
            String string5 = (String)this.m_mapResult.get(string4);
            if (string5 != null && !this.isInComment(string, n, n2)) {
                if (!string3.equals(string4)) {
                    string5 = CMyString.replaceStr(string3, string4, string5);
                }
                string2 = matcher.group(1) + string5 + matcher.group(1);
            }
            stringBuffer.append(string2);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private String getOptimizeKey(String string) {
        Matcher matcher = this.m_tagInChineseRegExp.matcher(string);
        if (matcher.find()) {
            return string;
        }
        matcher = this.m_noTagInChineseRegExp.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            if (!matcher.find()) {
                return string2;
            }
        }
        return string;
    }

    private boolean isInComment(String string, int n, int n2) {
        int n3;
        int n4;
        int n5 = string.lastIndexOf("//", n);
        if (n5 > (n4 = string.lastIndexOf(10, n))) {
            return true;
        }
        int n6 = string.lastIndexOf("/*", n);
        if (n6 < 0) {
            return false;
        }
        if (n6 != 0) {
            while (string.charAt(n6 - 1) == '/') {
                if ((n6 = string.lastIndexOf("/*", n6 - 1)) != -1) continue;
                return false;
            }
        }
        return n6 > (n3 = string.lastIndexOf("*/", n));
    }
}

