/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CharsetDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JSLocaleLoader {
    private static Logger logger = Logger.getLogger(JSLocaleLoader.class);
    private Map m_mapCNLocales = new HashMap();
    private String[] m_sRootPaths = new String[]{"D:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app", "D:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/wcm_locales"};
    private Map m_mapENLocales = new HashMap();

    public static void main(String[] stringArray) throws Exception {
        new JSLocaleLoader().loadLocales();
    }

    public void loadLocales() throws CMyException {
        for (int i = 0; i < this.m_sRootPaths.length; ++i) {
            this.loadLocalesInDir(new File(this.m_sRootPaths[i]));
        }
    }

    private void loadLocalesInDir(File file) throws CMyException {
        if (!this.isAccept(file)) {
            return;
        }
        if (file.isFile()) {
            this.loadLocalesInFile(file);
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.loadLocalesInDir(fileArray[i]);
        }
    }

    private boolean isAccept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith(".js")) {
            return false;
        }
        if (string.endsWith("localeimg.js")) {
            return false;
        }
        if (string.indexOf("\\locale") >= 0) {
            return true;
        }
        if (string.indexOf("lang") >= 0) {
            return true;
        }
        return string.endsWith("cn.js") || string.endsWith("en.js");
    }

    private void loadLocalesInFile(File file) throws CMyException {
        logger.info((Object)("loader\u52a0\u8f7d\u6587\u4ef6:" + file.getAbsolutePath()));
        boolean bl = this.isCN(file);
        this.toMap(file.getAbsolutePath(), bl ? this.m_mapCNLocales : this.m_mapENLocales, bl);
    }

    private boolean isCN(File file) {
        String string = file.getAbsolutePath();
        if (string.endsWith("cn.js")) {
            return true;
        }
        if (string.endsWith("en.js")) {
            return false;
        }
        return string.indexOf("wcm_locales") < 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map toMap(String string, Map map, boolean bl) throws CMyException {
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        String string3 = CharsetDetector.detect(string);
        try {
            try {
                String string2;
                fileInputStream = new FileInputStream(string);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3));
                String string4 = "";
                String string5 = "";
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string6 = string2;
                    if ((string2 = string2.trim()).startsWith("+") && string4.length() > 0) {
                        string5 = string5 + "\n" + string6;
                        map.put(string4, string5);
                        continue;
                    }
                    int n = string2.indexOf(58);
                    if (n < 0 || string2.startsWith("*") || string2.startsWith("//")) continue;
                    string4 = string2.substring(0, n).trim();
                    string5 = string2.substring(n + 1).trim();
                    string5 = string5.substring(1);
                    try {
                        string5 = string5.endsWith("',") || string5.endsWith("\",") ? string5.substring(0, string5.length() - 2) : string5.substring(0, string5.length() - 1);
                    }
                    catch (Exception exception) {
                        System.out.println("------------" + string);
                        throw new CMyException("\u8bfb\u53d6js\u6587\u4ef6\u4e2d\u7684\u884c\u4fe1\u606f\u5931\u8d25", exception);
                    }
                    if (bl) {
                        map.put(string5, string4);
                        continue;
                    }
                    map.put(string4, string5);
                }
                Object var15_16 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (fileInputStream == null) return map;
        fileInputStream.close();
        return map;
    }

    public String getLableByCN(String string) {
        return (String)this.m_mapCNLocales.get(string);
    }

    public String getENByLabel(String string) {
        return (String)this.m_mapENLocales.get(string);
    }
}

