/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.template.TemplateRemoteException;
import com.trs.template.domain.TemplateXmlGenerator;
import com.trs.template.domain.XTemplateExporter;
import com.trs.template.domain.setting.ITemplateSetting;
import com.trs.template.domain.setting.TemplateSettingFactory;
import com.trs.template.service.ITemplateService;
import com.trs.template.service.impl.Exporter;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;

public class TemplateServiceImpl
implements ITemplateService {
    private static Logger s_logger = Logger.getLogger(TemplateServiceImpl.class);
    private static Hashtable m_htSession = new Hashtable();
    private static Map s_hmUserLockedTemplates = null;
    private User m_currLoginUser;

    public String login(String string, String string2, String string3, String string4) throws TemplateRemoteException {
        User user = User.findByName(string);
        if (user == null) {
            throw new TemplateRemoteException(1, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label1", "\u6ca1\u6709\u627e\u5230\u7528\u6237\u540d\u4e3a[") + string + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label2", "]\u7684\u7528\u6237\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        if (user.isDeleted() || user.isForbidden()) {
            throw new TemplateRemoteException(2, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label4", "\u7528\u6237[") + string + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label5", "]\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u7981\u7528\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        if (!CMyString.isEmpty(string3)) {
            if (string3.compareToIgnoreCase("Base64") != 0) {
                throw new TemplateRemoteException(8, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label6", "\u4e0d\u652f\u6301\u7684\u53e3\u4ee4\u7f16\u7801\u65b9\u5f0f[") + string3 + "]!", I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label7", "\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u53e3\u4ee4\u7f16\u7801\u65b9\u5f0f\uff01"));
            }
            string2 = new String(Base64.decode((String)string2));
        }
        if (!user.passwordIs(string2)) {
            throw new TemplateRemoteException(3, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label4", "\u7528\u6237[") + string + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label8", "]\u5bc6\u7801\u4e0d\u6b63\u786e\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        String string5 = Base64.encode((byte[])(string + CMyDateTime.now().toString()).getBytes());
        m_htSession.put(string5, user);
        ContextHelper.setLoginUser(user);
        return string5;
    }

    public boolean logout(String string) throws TemplateRemoteException {
        if (string == null) {
            throw new TemplateRemoteException(0, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label9", "\u4f20\u5165SessionId\u4e3a\u7a7a\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label10", "\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        if (!m_htSession.containsKey(string)) {
            throw new TemplateRemoteException(4, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label11", "\u7528\u6237\u5c1a\u672a\u767b\u5f55\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label10", "\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        m_htSession.remove(string);
        this.logoutUserLockedTemplates(string);
        return true;
    }

    public boolean checkin(String string, String string2, String string3, byte[] byArray) throws TemplateRemoteException {
        this.validateUser(string, "checkin");
        String string4 = "";
        IPublishFolder iPublishFolder = null;
        Template template = null;
        try {
            TemplateImporter templateImporter;
            Reports reports;
            string4 = TemplateServiceImpl.writeFile(byArray, "zip");
            int n = Integer.parseInt(string2.startsWith("S") ? string2.substring(1) : string2);
            iPublishFolder = this.makeTemplateFolder(string3, WebSite.findById(n));
            if (iPublishFolder == null) {
                throw new WCMException("Cannot find the template folder with BaseChannelID[" + string2 + "]");
            }
            if (!CMyString.isEmpty(string3) && !(string3 = string3.trim()).equals("0")) {
                template = this.getEditableTemplate(string3);
            }
            if (!(reports = (templateImporter = new TemplateImporter()).importFromZip(iPublishFolder, CMyFile.extractFileName(string4), 1, 1, null)).getFailedReporter().isEmpty()) {
                s_logger.warn((Object)reports.getFailedReporter().toString());
                return false;
            }
            this.checkinUserLockedTemplates(string, template);
        }
        catch (Throwable throwable) {
            throw new TemplateRemoteException(6, throwable.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(byArray, "checkin_" + (template == null ? "" : template.getName()));
        }
        return true;
    }

    public byte[] checkout(String string, String string2, String string3) throws TemplateRemoteException {
        this.validateUser(string, "checkout");
        User user = (User)m_htSession.get(string);
        Template template = null;
        try {
            template = this.getEditableTemplate(Integer.parseInt(string3));
            Exporter exporter = new Exporter(user);
            byte[] byArray = exporter.export(template);
            if (s_logger.isDebugEnabled()) {
                this.debugByteWrite(byArray, "checkout");
            }
            this.checkoutUserLockedTemplates(string, template);
            return byArray;
        }
        catch (Throwable throwable) {
            throw new TemplateRemoteException(5, throwable.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
    }

    protected byte[] checkoutOld(String string, String string2, String string3) throws TemplateRemoteException {
        this.validateUser(string, "checkout");
        User user = (User)m_htSession.get(string);
        Template template = null;
        byte[] byArray = null;
        try {
            template = this.getEditableTemplate(Integer.parseInt(string3));
            XTemplateExporter xTemplateExporter = new XTemplateExporter();
            Templates templates = new Templates(user);
            templates.addElement(template);
            String string4 = xTemplateExporter.export(templates);
            FilesMan filesMan = FilesMan.getFilesMan();
            String string5 = filesMan.mapFilePath(string4, 0) + string4;
            byArray = CMyFile.readBytesFromFile(string5);
        }
        catch (Throwable throwable) {
            throw new TemplateRemoteException(5, throwable.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(byArray, "checkout");
        }
        this.checkoutUserLockedTemplates(string, template);
        return byArray;
    }

    public String preview(String string, String string2, String string3, byte[] byArray, String string4) {
        return null;
    }

    public byte[] getAllSettings(String string) throws TemplateRemoteException {
        this.validateUser(string, "getAllSettings");
        byte[] byArray = null;
        try {
            ITemplateSetting[] iTemplateSettingArray = TemplateSettingFactory.getInstance().makeAllSettings();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < iTemplateSettingArray.length; ++i) {
                arrayList.addAll(iTemplateSettingArray[i].getContentFiles());
            }
            byArray = TemplateXmlGenerator.zipFiles(arrayList);
        }
        catch (Throwable throwable) {
            throw new TemplateRemoteException(20, CMyException.getStackTraceText(throwable), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(byArray, "getAllSettings");
        }
        return byArray;
    }

    public byte[] getSettingByType(String string, String string2) throws TemplateRemoteException {
        this.validateUser(string, "getSettingByType");
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)("getSettingByType...[" + string2 + "]"));
        }
        ITemplateSetting iTemplateSetting = null;
        byte[] byArray = null;
        try {
            iTemplateSetting = TemplateSettingFactory.getInstance().makeSettingByType(string2);
            byArray = iTemplateSetting.getContent();
        }
        catch (Throwable throwable) {
            if (s_logger.isDebugEnabled()) {
                s_logger.info((Object)"get settings failed!", throwable);
            }
            throw new TemplateRemoteException(20, throwable.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(byArray, "getSettingByType");
        }
        return byArray;
    }

    public boolean confirm(String string, String string2, String string3) {
        return false;
    }

    public String[] getSettingTypeList(String string) {
        String[] stringArray = TemplateSettingFactory.getInstance().getSettingTypes();
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)"the types list is :");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
        return stringArray;
    }

    public String[] getAllSites(String string) {
        return null;
    }

    protected void validateUser(String string, String string2) throws TemplateRemoteException {
        String string3 = "Validating User with[SID=" + string + "]";
        string3 = string3 + (CMyString.isEmpty(string2) ? "" : " When '" + string2 + "'");
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)string3);
        }
        if (!m_htSession.containsKey(string)) {
            throw new TemplateRemoteException(4, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label11", "\u7528\u6237\u5c1a\u672a\u767b\u5f55\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label13", "\u8bf7\u5148\u767b\u5f55\u5230\u670d\u52a1\u5668\uff01"));
        }
        this.m_currLoginUser = (User)m_htSession.get(string);
        ContextHelper.setLoginUser(this.m_currLoginUser);
    }

    protected void validateUser(String string) throws TemplateRemoteException {
        this.validateUser(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(byte[] byArray, String string) throws Throwable {
        String string2;
        FileOutputStream fileOutputStream = null;
        try {
            String string3 = FilesMan.getFilesMan().getNextFilePathName("ST", string);
            fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(byArray);
            string2 = string3;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Throwable throwable2) {
                throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), throwable2);
            }
            throw throwable;
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), throwable);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeSpecFile(byte[] byArray, String string) throws Throwable {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), throwable2);
            }
        }
        try {
            if (fileOutputStream == null) return;
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), throwable);
        }
    }

    public IPublishFolder makeTemplateFolder(String string, WebSite webSite) throws WCMException {
        Object object;
        if (CMyString.isEmpty(string)) {
            throw new WCMException("The Formatted Template Name is dimmy!");
        }
        String string2 = "";
        boolean bl = false;
        try {
            if (string.indexOf("/") == -1) {
                bl = true;
            } else {
                object = string.split("/");
                string2 = object[((String[])object).length - 2];
            }
        }
        catch (Exception exception) {
            throw new WCMException("The subfix of template name with[" + string + "] is invalid, for it's neither site or channel id without 'S' or 'C' flag!", exception);
        }
        try {
            object = (IPublishFolder)PublishElementFactory.makeElementFrom(webSite);
            if (bl) {
                return object;
            }
            Channel channel = Channel.findByName(webSite.getId(), string2);
            if (channel == null) {
                return object;
            }
            return (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        }
        catch (Exception exception) {
            throw new WCMException("Failed to Parse the Formatted template name[" + string + "] for making template folder!", exception);
        }
    }

    private Template getEditableTemplate(int n) throws WCMException {
        Template template = null;
        template = Template.findById(n);
        if (template == null) {
            throw new WCMException("Failed to find the template with [ID=" + n + "]");
        }
        if (!template.canEdit(this.m_currLoginUser)) {
            throw new WCMException("The template[" + n + "] you're going to update is looked by User[" + template.getLockerUserName() + "]");
        }
        return template;
    }

    private Template getEditableTemplate(String string) throws WCMException {
        String[] stringArray = string.split("/");
        int n = (string = stringArray[stringArray.length - 1]).indexOf(46);
        string = n == -1 ? string : string.substring(0, n);
        Template template = null;
        Templates templates = Templates.openWCMObjs(this.m_currLoginUser, new WCMFilter(null, "", null));
        if (templates.size() == 0 || templates.getAt(0) == null) {
            throw new WCMException("Failed to find the template with [Name=" + string + "]");
        }
        template = (Template)templates.getAt(0);
        if (!template.canEdit(this.m_currLoginUser)) {
            throw new WCMException("The template[" + string + "] you're going to update is looked by User[" + template.getLockerUserName() + "]");
        }
        return template;
    }

    private void debugByteWrite(byte[] byArray, String string) {
        s_logger.info((Object)("begin to write file for '" + string + "'"));
        String string2 = "c:\\TE_" + string + "_" + CMyDateTime.now().toString("yyyy-MM-dd") + ".zip";
        try {
            TemplateServiceImpl.writeSpecFile(byArray, string2);
        }
        catch (Throwable throwable) {
            s_logger.info((Object)("ERROR!!!: failed to write file to [" + string2 + "] : " + throwable.getLocalizedMessage()));
        }
        s_logger.info((Object)("end to write file to [" + string2 + "]"));
        s_logger.info((Object)"--------------------------------------------");
    }

    private void checkoutUserLockedTemplates(String string, Template template) {
        if (!this.getUserLockedTemplates().containsKey(string)) {
            ArrayList<Template> arrayList = new ArrayList<Template>(1);
            arrayList.add(template);
            this.getUserLockedTemplates().put(string, arrayList);
        } else {
            ArrayList arrayList = (ArrayList)this.getUserLockedTemplates().get(string);
            if (arrayList != null) {
                arrayList.add(template);
            }
        }
    }

    private void checkinUserLockedTemplates(String string, Template template) {
        ArrayList arrayList;
        template.unlock();
        if (this.getUserLockedTemplates().containsKey(string) && (arrayList = (ArrayList)this.getUserLockedTemplates().get(string)) != null && arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Template template2 = (Template)arrayList.get(i);
                if (template.getId() != template2.getId()) continue;
                arrayList.remove(template2);
                break;
            }
        }
    }

    private void logoutUserLockedTemplates(String string) {
        ArrayList arrayList;
        if (this.getUserLockedTemplates().containsKey(string) && (arrayList = (ArrayList)this.getUserLockedTemplates().get(string)) != null && arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Template template = (Template)arrayList.get(i);
                template.unlock();
            }
            arrayList.clear();
        }
    }

    private Map getUserLockedTemplates() {
        if (s_hmUserLockedTemplates == null) {
            s_hmUserLockedTemplates = new HashMap(5);
        }
        return s_hmUserLockedTemplates;
    }
}

