/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.util.List;

public class NetSnapTool {
    private static final char BLANK = ' ';
    private static final String ENCODING = "GBK";

    public static String getTreeInfo2(String string, int n, int n2, boolean bl) throws Exception {
        User user = User.findByName(string);
        if (user == null) {
            throw new WCMException(200006, "user not found!usernmae=" + string);
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(ENCODING);
        stringBuffer.append("\"?>");
        if (bl) {
            stringBuffer.append("<ss>");
        }
        WebSites webSites = new WebSites(user);
        WCMFilter wCMFilter = new WCMFilter("", "SITETYPE=" + n2, "");
        webSites.open(wCMFilter);
        int n3 = webSites.size();
        for (int i = 0; i < n3; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || webSite.isDeleted()) continue;
            stringBuffer.append("<s n=\"").append(CMyString.filterForXML(webSite.getName())).append("\" id=\"");
            stringBuffer.append(webSite.getId()).append("\">");
            NetSnapTool.appendVisibleChildren(stringBuffer, user, webSite, n);
            stringBuffer.append("</s>");
        }
        if (bl) {
            stringBuffer.append("</ss>");
        }
        return stringBuffer.toString();
    }

    public static String getTreeInfo(String string, int n, int n2, boolean bl) throws Exception {
        User user = User.findByName(string);
        if (user == null) {
            throw new WCMException(200006, "user not found!usernmae=" + string);
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        stringBuffer.append(ENCODING);
        stringBuffer.append("\"?>");
        if (bl) {
            stringBuffer.append("<ss>");
        }
        WebSites webSites = new WebSites(user);
        WCMFilter wCMFilter = new WCMFilter("", "SITETYPE=" + n2, "");
        webSites.open(wCMFilter);
        int n3 = webSites.size();
        for (int i = 0; i < n3; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || webSite.isDeleted()) continue;
            stringBuffer.append("<s n=\"").append(CMyString.filterForXML(webSite.getName())).append("\" id=\"");
            stringBuffer.append(webSite.getId()).append("\">");
            NetSnapTool.appendVisibleChildren(stringBuffer, user, webSite, n);
            stringBuffer.append("</s>");
        }
        if (bl) {
            stringBuffer.append("</ss>");
        }
        return NetSnapTool.encode(stringBuffer.toString());
    }

    private static final void appendVisibleChildren(StringBuffer stringBuffer, User user, BaseChannel baseChannel, int n) throws WCMException {
        List list = baseChannel.getChildren(null, 0);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            List list2;
            boolean bl;
            Channel channel = (Channel)list.get(i);
            if (channel == null || channel.isDeleted() || !AuthServer.hasRight(user, (CMSObj)channel, 64) || !(bl = AuthServer.hasRight(user, (CMSObj)channel, n)) && ((list2 = channel.getChildren(null, 0)) == null || list2.isEmpty())) continue;
            stringBuffer.append("<c n=\"");
            stringBuffer.append(CMyString.filterForXML(channel.getDesc()));
            stringBuffer.append("\" id=\"");
            stringBuffer.append(channel.getId());
            stringBuffer.append("\" addable=\"");
            stringBuffer.append(bl);
            stringBuffer.append("\">");
            NetSnapTool.appendVisibleChildren(stringBuffer, user, channel, n);
            stringBuffer.append("</c>");
        }
    }

    static String encode(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("no need to encode an empty string?");
        }
        byte[] byArray = string.getBytes(ENCODING);
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        byte[] byArray2 = new byte[3];
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            int n2;
            for (n2 = 0; n2 < 3 && i + n2 < n; ++n2) {
                byArray2[n2] = byArray[i + n2];
            }
            n2 = (byArray2[0] >>> 2 & 0x3F) + 32;
            int n3 = (byArray2[0] << 4 & 0x30 | byArray2[1] >>> 4 & 0xF) + 32;
            int n4 = (byArray2[1] << 2 & 0x3C | byArray2[2] >>> 6 & 3) + 32;
            int n5 = (byArray2[2] & 0x3F) + 32;
            stringBuffer.append((char)n2);
            stringBuffer.append((char)n3);
            stringBuffer.append((char)n4);
            stringBuffer.append((char)n5);
            for (int j = 0; j < 3; ++j) {
                byArray2[j] = 0;
            }
        }
        return stringBuffer.toString();
    }

    String standardEncode(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 5);
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += 45) {
            int n3 = 0;
            n3 = i + 45 > n2 ? n2 - i : 45;
            stringBuffer.append((char)(n3 + 32));
            for (int j = 0; j < n3 && n < n2; j += 3) {
                byte by = 0;
                byte by2 = 0;
                byte by3 = 0;
                by = byArray[n++];
                if (n < n2) {
                    by2 = byArray[n++];
                }
                if (n < n2) {
                    by3 = byArray[n++];
                }
                int n4 = by >>> 2 & 0x3F;
                int n5 = by << 4 & 0x30 | by2 >>> 4 & 0xF;
                int n6 = by2 << 2 & 0x3C | by3 >>> 6 & 3;
                int n7 = by3 & 0x3F;
                stringBuffer.append((char)(n4 + 32));
                stringBuffer.append((char)(n5 + 32));
                stringBuffer.append((char)(n6 + 32));
                stringBuffer.append((char)(n7 + 32));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    static String decode(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("no need to decode an empty string?");
        }
        byte[] byArray = string.getBytes();
        if (byArray.length % 4 > 0) {
            throw new IllegalArgumentException("Bad data!");
        }
        byte[] byArray2 = new byte[4];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = byArray.length;
        for (int i = 0; i < n; i += 4) {
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                byArray2[n2] = (byte)(byArray[i + n2] - 32);
            }
            n2 = (byArray2[0] << 2 & 0xFC | byArray2[1] >>> 4 & 3) & 0xFF;
            int n3 = (byArray2[1] << 4 & 0xF0 | byArray2[2] >>> 2 & 0xF) & 0xFF;
            int n4 = (byArray2[2] << 6 & 0xC0 | byArray2[3] & 0x3F) & 0xFF;
            byteArrayOutputStream.write(n2);
            if (n3 > 0) {
                byteArrayOutputStream.write(n3);
            }
            if (n4 <= 0) continue;
            byteArrayOutputStream.write(n4);
        }
        return new String(byteArrayOutputStream.toByteArray(), ENCODING);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(URLEncoder.encode(";&IW", "ISO8859-1"));
    }
}

